package com.jhscale.common.utils;

import com.jhscale.common.em.NumberType;
import com.jhscale.common.model.device.UnitType;
import com.jhscale.common.ysscale.UnitEnum;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author 王列
 * @Package com.ysscale.common.util
 * @Description: common
 * @date 2018/5/22 17:16
 */
public class BigDecimalUtils {

    private BigDecimalUtils() {
    }

    private static BigDecimal base = new BigDecimal(100);

    private static Map<String, BigDecimal> unitConvert = new HashMap<>();

    static {
        unitConvert.put("重量", new BigDecimal("1000"));
        unitConvert.put("g", new BigDecimal("1"));
        unitConvert.put("kg", new BigDecimal("1000"));
        unitConvert.put("ton", new BigDecimal("1000000"));
        unitConvert.put("t", new BigDecimal("1000000"));
        unitConvert.put("lb", new BigDecimal("453.59237"));
        unitConvert.put("b", new BigDecimal("453.59237"));
        unitConvert.put("500g", new BigDecimal("500"));
        unitConvert.put("100g", new BigDecimal("100"));
        unitConvert.put("1/4lb", new BigDecimal("113.39809"));
        unitConvert.put("1/4b", new BigDecimal("113.39809"));
    }

    /**
     * @Description: RMB 分转元
     */
    public static BigDecimal getYuanMoney(BigDecimal bigDecimal) {
        return bigDecimal.divide(base);
    }

    public static BigDecimal centToYuan(int cent) {
        return new BigDecimal(cent).divide(base);
    }

    public static String centToYuanStr(int cent) {
        return new BigDecimal(cent).divide(base).toString();
    }

    /**
     * @description: 默认最小金额小数点转换 point 不传默认2
     **/
    public static BigDecimal getMinMoney(BigDecimal normalMoney, Integer point) {
        if (normalMoney == null) return new BigDecimal(0);
        point = Objects.isNull(point) ? 2 : point;
        BigDecimal pointVal = new BigDecimal(1);
        for (int i = 0; i < point; i++) {
            pointVal = pointVal.multiply(new BigDecimal(10));
        }
        return normalMoney.divide(pointVal);
    }

    public static BigDecimal getMinBigMoney(Integer normalMoney, Integer point) {
        if (normalMoney == null) return new BigDecimal(0);
        point = Objects.isNull(point) ? 2 : point;
        BigDecimal pointVal = new BigDecimal(1);
        for (int i = 0; i < point; i++) {
            pointVal = pointVal.multiply(new BigDecimal(10));
        }
        return new BigDecimal(normalMoney).divide(pointVal);
    }

    public static double getMinMoney(Integer normalMoney, Integer point) {
        if (normalMoney == null) return new BigDecimal(0).doubleValue();
        point = Objects.isNull(point) ? 2 : point;
        BigDecimal pointVal = new BigDecimal(1);
        for (int i = 0; i < point; i++) {
            pointVal = pointVal.multiply(new BigDecimal(10));
        }
        return new BigDecimal(normalMoney).divide(pointVal).doubleValue();
    }

    /**
     * @description: 正常金额转最小整数金额 point 不传默认2
     **/
    public static BigDecimal getNormalMoney(BigDecimal minMoney, Integer point) {
        if (minMoney == null) return new BigDecimal(0);
        point = Objects.isNull(point) ? 2 : point;
        BigDecimal pointVal = new BigDecimal(1);
        for (int i = 0; i < point; i++) {
            pointVal = pointVal.multiply(new BigDecimal(10));
        }
        BigDecimal multiply = minMoney.multiply(pointVal);
        return multiply.setScale(0, BigDecimal.ROUND_DOWN);
    }

    public static Integer getNormalMoney(Double minMoney, Integer point) {
        if (minMoney == null) return 0;
        point = Objects.isNull(point) ? 2 : point;
        BigDecimal pointVal = new BigDecimal(1);
        for (int i = 0; i < point; i++) {
            pointVal = pointVal.multiply(new BigDecimal(10));
        }
        BigDecimal multiply = new BigDecimal(minMoney).multiply(pointVal);
        return multiply.setScale(0, BigDecimal.ROUND_DOWN).intValue();
    }

    /**
     * @Description: RMB 元转分
     */
    public static BigDecimal getDivideMoney(BigDecimal bigDecimal) {
        BigDecimal multiply = bigDecimal.multiply(base);
        return multiply.setScale(0, BigDecimal.ROUND_DOWN);
    }

    public static int yuanToCent(BigDecimal yuan) {
        return yuan.multiply(base).intValue();
    }

    public static int strYuanToCent(String yuan) {
        return new BigDecimal(yuan).multiply(base).intValue();
    }

    /**
     * @Description 比较值
     */
    public static int compareValue(BigDecimal val1, BigDecimal val2) {
        return val1.compareTo(val2);
    }

    /**
     * @description: 比较两个值相等
     **/
    public static boolean compareEqual(BigDecimal val1, BigDecimal val2) {
        return compareValue(val1, val2) == 0;
    }

    /**
     * @Description >0 true else false
     */
    public static boolean compareMoreZeroValue(BigDecimal val1) {
        return compareValue(val1, BigDecimal.ZERO) == 1;
    }

    /**
     * @description: <0 true else false
     **/
    public static boolean compareLessZeroValue(BigDecimal val1) {
        return compareValue(val1, BigDecimal.ZERO) == -1;
    }

    /**
     * @Description 与0比较 >0或者<0 true =0 false
     */
    public static boolean compareZeroValue(BigDecimal val1) {
        return compareValue(val1, BigDecimal.ZERO) == 0;
    }

    /**
     * @Description 40 == > -40    -40 ==> 40
     */
    public static BigDecimal changeSgin(BigDecimal bigDecimal) {
        return bigDecimal.negate();
    }

    /**
     * @description: 反数 40 == > -40    -40 ==> 40
     **/
    public static BigDecimal reverse(BigDecimal val) {
        return val.negate();
    }

    /**
     * @Description 计算分佣金额
     */
    public static BigDecimal getValue(BigDecimal val1, BigDecimal val2) {
        val2 = val2.divide(new BigDecimal(100));
        return val1.multiply(val2);
    }

    /**
     * @description: true long
     **/
    public static NumberType compareNumber(BigDecimal number) {
        if (Objects.isNull(number)) {
            return NumberType.UNKNOW;
        } else if (new BigDecimal(number.byteValue()).compareTo(number) == 0 && number.byteValue() >= (byte) -128 && number.byteValue() <= (byte) 127) {
            return NumberType.BYTE;
        } else if (new BigDecimal(number.shortValue()).compareTo(number) == 0 && number.shortValue() >= (short) -32768 && number.shortValue() <= (short) 32767) {
            return NumberType.SHORT;
        } else if (new BigDecimal(number.intValue()).compareTo(number) == 0 && number.intValue() >= (int) -2147483648 && number.intValue() <= (int) 2147483647) {
            return NumberType.INTEGER;
        } else if (new BigDecimal(number.longValue()).compareTo(number) == 0) {
            return NumberType.LONG;
        } else if (BigDecimal.valueOf(number.floatValue()).compareTo(number) == 0) {
            return NumberType.FLOAT;
        } else {
            return NumberType.DOUBLIE;
        }
    }

    /**
     * @param secondWeight 原重量
     * @param master       目标重量单位
     * @param second       原重量单位
     * @description: 重量转换
     **/
    public static BigDecimal secondWeight(BigDecimal secondWeight, UnitEnum master, UnitEnum second, int scale, int round) {
        return (master.equals(second) ? secondWeight : secondWeight.multiply(unitConvert.get(second.getName()))
                .divide(unitConvert.get(master.getName()))
                .setScale(scale, round))
                .setScale(scale, round);
    }

    /**
     * @param secondWeight 原重量
     * @param master       目标重量单位
     * @param second       原重量单位
     * @description: 重量转换
     **/
    public static BigDecimal secondWeight(BigDecimal secondWeight, UnitEnum master, UnitEnum second) {
        return secondWeight(secondWeight, master, second, 2, BigDecimal.ROUND_HALF_UP);
    }

    /**
     * @param masterWeight 原重量
     * @param master       目标重量单位
     * @param second       原重量单位
     * @description: 重量转换
     **/
    public static BigDecimal masterWeight(BigDecimal masterWeight, UnitEnum master, UnitEnum second, int scale, int round) {
        return (master.equals(second) ? masterWeight : masterWeight.multiply(unitConvert.get(master.getName()))
                .divide(unitConvert.get(second.getName()))
                .setScale(scale, round))
                .setScale(scale, round);
    }

    // public static void main(String[] args) {
    //     System.out.println(masterWeight(BigDecimal.valueOf(1), UnitEnum.kg, UnitEnum.g, 3, BigDecimal.ROUND_HALF_UP));
    // }

    /**
     * @param masterWeight 原重量
     * @param master       目标重量单位
     * @param second       原重量单位
     * @description: 重量转换
     **/
    public static BigDecimal masterWeight(BigDecimal masterWeight, UnitEnum master, UnitEnum second) {
        return masterWeight(masterWeight, master, second, 2, BigDecimal.ROUND_HALF_UP);
    }

    /**
     * @description: 计重转换
     **/
    public static BigDecimal[] weight(BigDecimal masterWeigh, BigDecimal secondWeight, UnitEnum master, UnitEnum second) {
        BigDecimal _secondWeight = reverse(secondWeight(secondWeight, master, second));
        BigDecimal masterAdd, secondAdd;
        if (compareValue(masterWeigh, _secondWeight) == 1) {
            masterAdd = reverse(_secondWeight);
            secondAdd = reverse(secondWeight(secondWeight, second, second));
        } else if (compareValue(masterWeigh, _secondWeight) == 0) {
            masterAdd = reverse(masterWeight(masterWeigh, master, master));
            secondAdd = reverse(secondWeight(secondWeight, second, second));
        } else {
            masterAdd = reverse(masterWeight(masterWeigh, master, master));
            secondAdd = masterWeight(masterWeigh, master, second);
        }
        return new BigDecimal[]{masterAdd, secondAdd};
    }

    /**
     * @param masterAmount 主数重量
     * @param secondAmount 从数重量
     * @param ratio        比例
     * @description: 计数转换
     **/
    public static BigDecimal[] amount(BigDecimal masterAmount, BigDecimal secondAmount, BigDecimal ratio) {
        BigDecimal _masterAmount = masterAmount.multiply(ratio);
        BigDecimal _secondAmount = reverse(secondAmount);
        BigDecimal masterAdd, secondAdd;
        if (compareValue(_masterAmount, _secondAmount) == 1) {
            BigDecimal[] result = _secondAmount.divideAndRemainder(ratio);
            masterAdd = reverse(result[0].add(BigDecimal.ONE));
            secondAdd = result[0].add(BigDecimal.ONE).multiply(ratio);
        } else if (compareValue(_masterAmount, _secondAmount) == 0) {
            masterAdd = reverse(masterAmount);
            secondAdd = _masterAmount;
        } else {
            masterAdd = reverse(masterAmount);
            secondAdd = _masterAmount;
        }
        return new BigDecimal[]{masterAdd, secondAdd};
    }

    /**
     * @description: 单位直接的比例
     **/
    public static BigDecimal unitToUnitRatio(UnitEnum master, UnitEnum second) {
        if (Objects.isNull(master) || Objects.isNull(second)) return BigDecimal.ONE;
        if (master.equals(second)) {
            return BigDecimal.ONE;
        } else if (master.getType().equals(second.getType())) {
            if (UnitType.计件.equals(master.getType())) {
                return BigDecimal.ONE;
            } else {
                BigDecimal masterBigDecimal = unitConvert.get(master.getName());
                BigDecimal secondBigDecimal = unitConvert.get(second.getName());
                return masterBigDecimal.divide(secondBigDecimal, 4, BigDecimal.ROUND_HALF_UP);
            }
        } else {
            return BigDecimal.ONE;
        }
    }

    /**
     * @description: bigDecimal 位数 1.0 => 10,1
     **/
    public static int getNumberOfDecimalPlace(BigDecimal bigDecimal) {
        final String s = bigDecimal.toPlainString();
        final int index = s.indexOf('.');
        return index < 0 ? 0 : (s.length() - 1 - index);
    }

    /**
     * @description: bigDecimal 位数 1.0 => 1,0
     **/
    public static int getNumberOfDecimalPlace2(BigDecimal bigDecimal) {
        final String s = bigDecimal.toPlainString();
        final int index = s.indexOf('.');
        if (index == -1) {
            return 0;
        } else {
            if (Integer.parseInt(s.substring(index + 1)) == 0) {
                return 0;
            } else {
                return s.length() - 1 - index;
            }
        }
    }

    public static int getNumberOfDecimalPlace(double value) {
        final BigDecimal bigDecimal = new BigDecimal("" + value);
        final String s = bigDecimal.toPlainString();
        System.out.println(s);
        final int index = s.indexOf('.');
        if (index < 0) {
            return 0;
        }
        return s.length() - 1 - index;
    }

    /**
     * @description: BigDecimal To String
     **/
    public static String bigDecimalToString(BigDecimal bigDecimal) {
        try {
            int point = getNumberOfDecimalPlace(bigDecimal);
            BigDecimal pointVal = BigDecimal.ONE;
            for (int i = 0; i < point; i++) {
                pointVal = pointVal.divide(BigDecimal.TEN);
            }
            return bigDecimal.divide(pointVal).intValue() + "," + point;
        } catch (Exception e) {
            return "";
        }
    }

    /**
     * @description: String To BigDecimal
     **/
    public static BigDecimal stringToBigDecimal(String str) {
        try {
            String[] split = str.split(",");
            int point = Integer.parseInt(split[1]);
            BigDecimal pointVal = BigDecimal.ONE;
            for (int i = 0; i < point; i++) {
                pointVal = pointVal.divide(BigDecimal.TEN);
            }
            return new BigDecimal(split[0]).multiply(pointVal).setScale(point, BigDecimal.ROUND_HALF_UP);
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * @description: String To BigDecimal
     **/
    public static BigDecimal stringToBigDecimalDefaultZero(String str) {
        BigDecimal result = stringToBigDecimal(str);
        return Objects.isNull(result) ? BigDecimal.ZERO : result;
    }

//    public static void main(String[] args) {
//        String str = bigDeciamToString(new BigDecimal("2.3"));
//        System.out.println(str);
//        BigDecimal bigDecimal = stringToBigDecimal(str);
//        System.out.println(bigDecimal.toString());
//
//        System.out.println(secondWeight(new BigDecimal(2), UnitEnum.kg, UnitEnum.g500));
//        System.out.println(secondWeight(new BigDecimal(2), UnitEnum.kg, UnitEnum.kg));
//
//        BigDecimal[] amount = amount(new BigDecimal(4), new BigDecimal(-28), new BigDecimal(6));
//        System.out.println(amount[0]);
//        System.out.println(amount[1]);
//
//        BigDecimal[] weight = weight(new BigDecimal(2), new BigDecimal(-2), UnitEnum.kg, UnitEnum.kg);
//        System.out.println(weight[0]);
//        System.out.println(weight[1]);
//    }
}
