package com.jhscale.common.utils;

import com.jhscale.common.model.device.DConstant;
import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Objects;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author Loveven
 * @title: ByteUtils
 * @projectName jhscale-agreement
 * @description: TODO
 * @date 2019/9/216:36
 */
public class ByteUtils {

    private final static short UNSIGNED_MAX_VALUE = (Byte.MAX_VALUE * 2) + 1;

    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    /**
     * @description: HEX 转 ASCII
     **/
    public static String hex2Ascii(String hexStr) {
        StringBuilder output = new StringBuilder("");
        for (int i = 0; i < hexStr.length(); i += 2) {
            String str = hexStr.substring(i, i + 2);
            output.append((char) Integer.parseInt(str, 16));
        }
        return output.toString();
    }

    /**
     * @description: ASCII 转 HEX
     **/
    public static String ascii2Hex(String asciiStr) {
        char[] chars = asciiStr.toCharArray();
        StringBuilder hex = new StringBuilder();
        for (char ch : chars) {
            hex.append(Integer.toHexString((int) ch));
        }
        return hex.toString();
    }

    /**
     * 解析
     *
     * @param mark
     * @return
     */
    public static String formatMark(String mark) {
        String binaryStr = Integer.toBinaryString(Integer.parseInt(mark, 16));
        int lg = binaryStr.length();
        if (lg < 8) {
            int cn = 8 - lg;
            String str = "";
            for (int i = 0; i < cn; i++) {
                str += "0";
            }
            return str + binaryStr;
        }
        return binaryStr;
    }

    /**
     * @description: 10进制转2进制 前置补充长度
     **/
    public static String ten2two(int val, int length) {
        String binaryStr = Integer.toBinaryString(val);
        int lg = binaryStr.length();
        if (lg < length) {
            int cn = length - lg;
            String str = "";
            for (int i = 0; i < cn; i++) {
                str += "0";
            }
            return str + binaryStr;
        }
        return binaryStr;
    }

    /**
     * @description: 指定下坐标添加字符
     **/
    public static String inserE(String targe, int index, String str) {
        String res = "";
        for (int i = targe.length(); i > 0; i--) {
            if ((targe.length() - i) == index)
                res = str + res;
            res = targe.charAt(i - 1) + res;
        }
        return res;
    }

    /**
     * HEX 二进制反转
     *
     * @param mark
     * @return
     */
    public static String formatData(String mark) {
        String binaryStr = Integer.toBinaryString(Integer.parseInt(mark, 16));
        int lg = binaryStr.length();
        if (lg < 8) {
            int cn = 8 - lg;
            String str = "";
            for (int i = 0; i < cn; i++) {
                str += "0";
            }
            binaryStr = str + binaryStr;
        }
        return new StringBuffer(binaryStr).reverse().toString();
    }

    /**
     * HEX TO ASCII 字节数组
     *
     * @param s
     * @return
     * @throws NumberFormatException
     */
    public static byte[] fromHexAscii(String s) throws NumberFormatException {
        try {
            int len = s.length();
            if ((len % 2) != 0)
                throw new NumberFormatException("Hex ascii must be exactly two digits per byte.");

            int out_len = len / 2;
            byte[] out = new byte[out_len];
            int i = 0;
            StringReader sr = new StringReader(s);
            while (i < out_len) {
                int val = (16 * fromHexDigit(sr.read())) + fromHexDigit(sr.read());
                out[i++] = (byte) val;
            }
            return out;
        } catch (IOException e) {
            throw new InternalError("IOException reading from StringReader?!?!");
        }
    }

    public static String toBinary(int length) {
        String str = Integer.toBinaryString(length);
        if (str.length() < 2) {
            if (length == 0) {
                str = "01";
            } else {
                str = "0" + str;
            }
        }
        return str;
    }

    private static int fromHexDigit(int c) throws NumberFormatException {
        if (c >= 0x30 && c < 0x3A)
            return c - 0x30;
        else if (c >= 0x41 && c < 0x47)
            return c - 0x37;
        else if (c >= 0x61 && c < 0x67)
            return c - 0x57;
        else
            throw new NumberFormatException('\'' + c + "' is not a valid hexadecimal digit.");
    }

    public static String covert102Hex(String data) {
        Integer dInt = Integer.parseInt(data);
        String hexString = dInt.toHexString(dInt);
        if (hexString.length() % 2 != 0) {
            hexString = "0" + hexString;
        }
        return convert(hexString);
    }

    public static String convert(String hex) {
        return toHexAscii(reverse(fromHexAscii(hex)));
    }

    public static String toHexAscii(byte[] bytes) {
        int len = bytes.length;
        StringWriter sw = new StringWriter(len * 2);
        for (int i = 0; i < len; ++i)
            addHexAscii(bytes[i], sw);
        return sw.toString();
    }

    public static String toHexAscii(byte b) {
        StringWriter sw = new StringWriter(2);
        addHexAscii(b, sw);
        return sw.toString();
    }

    private static void addHexAscii(byte b, StringWriter sw) {
        short ub = toUnsigned(b);
        int h1 = ub / 16;
        int h2 = ub % 16;
        sw.write(toHexDigit(h1));
        sw.write(toHexDigit(h2));
    }

    private static short toUnsigned(byte b) {
        return (short) (b < 0 ? (UNSIGNED_MAX_VALUE + 1) + b : b);
    }

    private static char toHexDigit(int h) {
        char out;
        if (h <= 9) out = (char) (h + 0x30);
        else out = (char) (h + 0x37);
        //System.err.println(h + ": " + out);
        return out;
    }

    public static byte[] reverse(byte[] bytes) {
        int len = bytes.length;
        byte[] newBytes = new byte[len];
        for (int i = 0; i < len; i++) {
            newBytes[i] = bytes[len - 1 - i];
        }
        return newBytes;
    }

    public static int[] reverse(int[] ints) {
        int len = ints.length;
        int[] newInts = new int[len];
        for (int i = 0; i < len; i++) {
            newInts[i] = ints[len - 1 - i];
        }
        return newInts;
    }

    /**
     * @description: 数值转HEX 并补充长度到 length
     **/
    public static String int2HexWithPush(int val, int length) {
        return ByteUtils.convert(int2HexWithPush_nr(val, length));
    }

    /**
     * @description: FID HEX值计算
     **/
    public static String fid(int fid) {
        return ByteUtils.int2HexWithPush(fid, 8);
    }

    /**
     * @description: 数值转HEX 并补充长度到 length
     **/
    public static String int2HexWithPush_nr(int val, int length) {
        String hex = Integer.toHexString(val);
        int hexLength = hex.length();
        if (hexLength < length) {
            int padding = length - hexLength;
            for (int i = 0; i < padding; i++) {
                hex = "0" + hex;
            }
        } else {
            hex = hex.substring(0, length);
        }
        return hex;
    }

    public static String long2Hex(long val, int length) {
        return ByteUtils.convert(long2HexWithPush_nr(val, length));
    }

    public static String long2HexWithPush_nr(long val, int length) {
        String hex = Long.toHexString(val);
        int hexLength = hex.length();
        if (hexLength < length) {
            int padding = length - hexLength;
            for (int i = 0; i < padding; i++) {
                hex = "0" + hex;
            }
        } else {
            hex = hex.substring(0, length);
        }
        return hex;
    }

    /**
     * @description: 数值转HEX 并补充长度到 length
     **/
    public static String int2Hex(int val) {
        String hex = Integer.toHexString(val);
        if (hex.length() % 2 != 0) hex = "0" + hex;
        hex = ByteUtils.convert(hex);
        return hex;
    }

    /**
     * @description: 浮动值获取
     **/
    public static String dataFormat(String data) {
        String hexString = Integer.toHexString(Integer.parseInt(data, 2));
        if (hexString.length() % 2 != 0) {
            hexString = "0" + hexString;
        }
        return hexString;
    }

    /**
     * @description: 字符转换
     **/
    public static String a_text(String text) {
        text = StringUtils.isBlank(text) ? "" : text;
        byte[] bytes = text.getBytes(StandardCharsets.UTF_8);
        return ByteUtils.toHexAscii(bytes) + "00";
    }

    /**
     * @description: 字符解析
     **/
    public static String p_text(String content) {
        int index = ByteUtils.indexOf(content, "00");
        if (index == -1) return null;
        String text = new String(ByteUtils.fromHexAscii(content.substring(0, index + 2)), StandardCharsets.UTF_8).trim();
        return StringUtils.isNotBlank(text) ? text : null;
    }

    /**
     * @param strPart 字符串
     * @return 16进制字符串
     * @throws
     * @Title:string2HexUTF8
     * @Description:字符UTF8串转16进制字符串
     */
    public static String string2HexUTF8(String strPart) {
        return string2HexString(strPart, "UTF-8");
    }

    /**
     * @param strPart    字符串
     * @param tochartype hex目标编码
     * @return 16进制字符串
     * @throws
     * @Title:string2HexString
     * @Description:字符串转16进制字符串
     */
    public static String string2HexString(String strPart, String tochartype) {
        try {
            return bytes2HexString(strPart.getBytes(tochartype));
        } catch (Exception e) {
            return "";
        }
    }

    /**
     * @param b 字节数组
     * @return 16进制字符串
     * @Title:bytes2HexString
     * @Description:字节数组转16进制字符串
     */
    public static String bytes2HexString(byte[] b) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < b.length; i++) {
            result.append(String.format("%02X", b[i]));
        }
        return result.toString();
    }

    public static String toHexString(byte[] var0) {
        String var1 = "";

        for (int var2 = 0; var2 < var0.length; ++var2) {
            var1 = var1 + HEX_CHARS[var0[var2] >>> 4 & 15];
            var1 = var1 + HEX_CHARS[var0[var2] & 15];
        }
        return var1.toUpperCase();
    }

    /**
     * @description: 字节截取获取指定字符串下坐标
     **/
    public static int indexOf(String content, String str) {
        int index = -1;
        char[] chars = content.toCharArray();
        for (int i = 0; i < content.length() / 2; i++) {
            String st = String.valueOf(chars[i * 2]) + String.valueOf(chars[i * 2 + 1]);
            if (st.equals(str)) {
                index = i * 2;
                break;
            }
        }
        return index;
    }

    /**
     * @description: 字节截取获取指定字符串下坐标
     **/
    public static int indexOfWithStr(String content, String str) {
        int index = -1;
        char[] chars = content.toCharArray();
        for (int i = 0; i < content.length() / 2; i++) {
            String st = String.valueOf(chars[i * 2]) + String.valueOf(chars[i * 2 + 1]);
            if (st.equals(str)) {
                index = i * 2;
                break;
            }
        }
        return index == -1 ? index : (index + str.length());
    }

    /**
     * HEX 2 BigDeciamal
     *
     * @param hexString
     * @return
     */
    public static BigDecimal hexBigDecimal(String hexString) {
        int floa = Integer.parseInt(hexString.substring(6, 8), 16);
        int val = Integer.parseInt(hexString.substring(0, 6), 16);
        int floatVal = floatVal(floa);
        return BigDecimal.valueOf(val).divide(BigDecimal.valueOf(floatVal), floa, RoundingMode.HALF_UP);
    }

    /**
     * @description: 获取10的倍数
     **/
    public static int floatVal(int floa) {
        int floaVal = 1;
        for (int i = 0; i < floa; i++) {
            floaVal = floaVal * 10;
        }
        return floaVal;
    }

    /**
     * HEX 2 BigDeciamal
     *
     * @param hexString
     * @return
     */
    public static BigDecimal convertBigDecimal(String hexString) {
        String convert = convert(hexString);
        int money = Integer.parseUnsignedInt(convert, 16);
        // System.out.println(String.format("unscaledVal:[%s],scale:[%s]", money >> 3, money & 0x07));
        return BigDecimal.valueOf(money >> 3, money & 0x07);
    }

    /**
     * HEX 2 BigDeciamal
     *
     * @param hexString
     * @return
     */
    public static BigDecimal convertBigDecimalNone(String hexString) {
        if (BD_VALID_FILED.equals(hexString)) return null;
        String convert = convert(hexString);
        int money = Integer.parseUnsignedInt(convert, 16);
        // System.out.println(String.format("unscaledVal:[%s],scale:[%s]", money >> 3, money & 0x07));
        return BigDecimal.valueOf(money >> 3, money & 0x07);
    }

    public static String toSPFStr(BigDecimal d) {
        return ByteUtils.completeBytes(Long.toHexString(toSPF2(d)), 8);
    }

    public static String toSPFStrNone(BigDecimal d) {
        return Objects.nonNull(d) ? ByteUtils.completeBytes(Long.toHexString(toSPF2(d)), 8) : BD_VALID_FILED;
    }

    public static int toSPF(BigDecimal d) {
        long A;
        int B;
        A = d.multiply(new BigDecimal(10000000)).add(BigDecimal.valueOf(BigDecimalUtils.compareLessZeroValue(d) ? -0.5 : 0.5)).longValue();
        B = 7;
        while (true) {
            if (B == 0) {
                if (A >= 268435456)
                    A = 268435455;
                else if (A < -268435456)
                    A = -268435456;
                break;
            }
            if ((A >= 268435456) || (A < -268435456)) {
                if (A > 0)
                    A = (A + 5) / 10;
                else
                    A = (A - 5) / 10;
                B--;
            } else if (((int) (A / 10)) * 10 == A) {
                A = A / 10;
                B--;
            } else {
                break;
            }
        }
        // System.out.println(String.format("A:[%s],B:[%s]", A, B));
        return (int) ((A << 3) | B);
    }

    /**
     * @description: 浮动小数
     **/
    public static int toSPF2(BigDecimal d) {
        int flot = BigDecimalUtils.getNumberOfDecimalPlace(d);
        int fv = 1;
        for (int i = 0; i < flot; i++) {
            fv *= 10;
        }
        long A;
        int B;
        A = d.multiply(BigDecimal.valueOf(fv)).add(BigDecimal.valueOf(BigDecimalUtils.compareLessZeroValue(d) ? -0.5 : 0.5)).longValue();
        B = flot;
        // System.out.printf("A:[%s],B:[%s]%n", A, B);
        return (int) ((A << 3) | B);
    }

    public static byte[] fromHexString(String var0) {
        char[] var1 = var0.toUpperCase().toCharArray();
        int var2 = 0;

        for (int var3 = 0; var3 < var1.length; ++var3) {
            if (var1[var3] >= 48 && var1[var3] <= 57 || var1[var3] >= 65 && var1[var3] <= 70) {
                ++var2;
            }
        }
        byte[] var6 = new byte[var2 + 1 >> 1];
        int var4 = var2 & 1;
        for (int var5 = 0; var5 < var1.length; ++var5) {
            if (var1[var5] >= 48 && var1[var5] <= 57) {
                var6[var4 >> 1] = (byte) (var6[var4 >> 1] << 4);
                var6[var4 >> 1] = (byte) (var6[var4 >> 1] | var1[var5] - 48);
            } else {
                if (var1[var5] < 65 || var1[var5] > 70) {
                    continue;
                }
                var6[var4 >> 1] = (byte) (var6[var4 >> 1] << 4);
                var6[var4 >> 1] = (byte) (var6[var4 >> 1] | var1[var5] - 65 + 10);
            }
            ++var4;
        }
        return var6;
    }

    public static byte[] byteMerger(byte[] byte_1, byte[] byte_2) {
        byte[] byte_3 = new byte[byte_1.length + byte_2.length];
        System.arraycopy(byte_1, 0, byte_3, 0, byte_1.length);
        System.arraycopy(byte_2, 0, byte_3, byte_1.length, byte_2.length);
        return byte_3;
    }

    public static int[] byteMerger(int[] int_1, int[] int_2) {
        int[] int_3 = new int[int_1.length + int_2.length];
        System.arraycopy(int_1, 0, int_3, 0, int_1.length);
        System.arraycopy(int_2, 0, int_3, int_1.length, int_2.length);
        return int_3;
    }

    public static String[] byteMerger(String[] str_1, String[] str_2) {
        String[] str_3 = new String[str_1.length + str_2.length];
        System.arraycopy(str_1, 0, str_3, 0, str_1.length);
        System.arraycopy(str_2, 0, str_3, str_1.length, str_2.length);
        return str_3;
    }

    public static int[] removeMerger(int[] arr, int index) {
        if (arr == null || index < 0 || index >= arr.length) {
            return arr;
        }
        int[] newArr = new int[arr.length - 1];
        int j = 0;
        for (int i = 0; i < arr.length; i++) {
            if (i != index) {
                newArr[j] = arr[i];
                j++;
            }
        }
        return newArr;
    }

    public static String[] removeMerger(String[] arr, int index) {
        if (arr == null || index < 0 || index >= arr.length) {
            return arr;
        }
        String[] newArr = new String[arr.length - 1];
        int j = 0;
        for (int i = 0; i < arr.length; i++) {
            if (i != index) {
                newArr[j] = arr[i];
                j++;
            }
        }
        return newArr;
    }

    public static float[][] removeMerger(float[][] arr, int index) {
        if (arr == null || index < 0 || index >= arr.length) {
            return arr;
        }
        float[][] newArr = new float[arr.length - 1][];
        int j = 0;
        for (int i = 0; i < arr.length; i++) {
            if (i != index) {
                newArr[j] = arr[i];
                j++;
            }
        }
        return newArr;
    }

    public static float[] removeMerger(float[] arr, int index) {
        if (arr == null || index < 0 || index >= arr.length) {
            return arr;
        }
        float[] newArr = new float[arr.length - 1];
        int j = 0;
        for (int i = 0; i < arr.length; i++) {
            if (i != index) {
                newArr[j] = arr[i];
                j++;
            }
        }
        return newArr;
    }

    /**
     * @description: HEX转换
     **/
    public static String convertHex(String hex) {
        return toHexAscii(reverse(fromHexString(hex)));
    }

    /**
     * @description: INT 转 字节长度HEX
     **/
    public static String completeBytes(Integer num, int length) {
        String hexNum = Integer.toHexString(num);
        return completeBytes(hexNum, length * 2).toUpperCase();
    }

    /**
     * @Description: 字节长度补充
     */
    public static String completeBytes(String content, int length) {
        if (content.length() % 2 != 0) {
            content = "0" + content;
        }

        content = ByteUtils.toHexString(ByteUtils.reverse(ByteUtils.fromHexString(content)));

        int contenLength = content.length();

        if (length < contenLength) return content.substring(0, length);

        for (int i = 0; i < length - contenLength; i++) {
            content += "0";
        }
        return content;
    }

    public static final LocalDateTime getStartTime() {
        return LocalDateTime.of(2000, 1, 1, 0, 0, 0, 0);
    }

    public static String appendFill(String content) {
        String res = content;
        int lg = content.length() / 2;
        if (lg % 16 == 0) {
            return content;
        }
        int appendBit = 16 - (lg % 16);
        if (appendBit != 0) {
            for (int i = 0; i < appendBit; i++) {
                if (i == 0) {
                    res = res + "F0";
                } else {
                    res = res + "00";
                }
            }
        }
        return res;
    }

    /**
     * @description: 头添加补充长度
     **/
    public static String appendFill(String hexString, int length) {
        if (StringUtils.isBlank(hexString)) return "";
        if (length == -1) {
            if (hexString.length() % 2 != 0) {
                hexString = "0" + hexString;
            }
            return hexString;
        }
        if (hexString.length() >= length) return hexString.substring(0, length);
        int pantting = length - hexString.length();// 补充长度
        for (int i = 0; i < pantting; i++) {
            hexString = "0" + hexString;
        }
        return hexString;
    }

    /**
     * @description: 头添加补充长度
     **/
    public static String appendFill(String hexString, char append, int length) {
        if (StringUtils.isBlank(hexString)) return "";
        if (hexString.length() >= length) return hexString.substring(0, length);
        int pantting = length - hexString.length();// 补充长度
        for (int i = 0; i < pantting; i++) {
            hexString = append + hexString;
        }
        return hexString;
    }

    /**
     * 将整数转换为byte数组并指定长度
     */
    public static byte[] intToBytes(int a, int length) {
        byte[] bs = new byte[length];
        for (int i = bs.length - 1; i >= 0; i--) {
            bs[i] = (byte) (a % 0xFF);
            a = a / 0xFF;
        }
        return bs;
    }

    /**
     * @description: 将整数转换为byte数组并1长度
     **/
    public static byte[] intToBytes(int a) {
        return intToBytes(a, 1);
    }

    /**
     * 将byte数组转换为整数
     */
    public static int bytesToInt(byte[] bs) {
        int a = 0;
        for (int i = bs.length - 1; i >= 0; i--) {
            a += bs[i] * Math.pow(0xFF, bs.length - i - 1);
        }
        return a;
    }

    /**
     * 将二进制转换成16进制
     *
     * @param buf
     * @return
     */
    public static String parseByte2HexStr(byte buf[]) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; i++) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    /**
     * 将16进制转换为二进制
     *
     * @param hexStr
     * @return
     */
    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1)
            return null;
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; i++) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte) (high * 16 + low);
        }
        return result;
    }

    /**
     * @description: Long 转 HEX 值 convert 值
     **/
    public static String long2Hex(long val) {
        String hex = Long.toHexString(val);
        if (hex.length() % 2 != 0) hex = "0" + hex;
        hex = ByteUtils.convert(hex);
        return hex;
    }

    /**
     * @description: BigDecimal 转 整数
     **/
    public static Integer pointToInteger(BigDecimal val, int point) {
        BigDecimal standby = BigDecimal.ONE;
        for (int i = 0; i < point; i++) {
            standby = standby.multiply(BigDecimal.TEN);
        }
        return val.multiply(standby).intValue();
    }

    /**
     * @description: BigDecimal 转 整数
     **/
    public static Long pointToLong(BigDecimal val, int point) {
        BigDecimal standby = BigDecimal.ONE;
        for (int i = 0; i < point; i++) {
            standby = standby.multiply(BigDecimal.TEN);
        }
        return val.multiply(standby).longValue();
    }

    /**
     * @description: 整数 转 BigDecimal
     **/
    public static BigDecimal integerToPoint(Integer val, boolean lessZero, int point) {
        BigDecimal standby = BigDecimal.ONE;
        for (int i = 0; i < point; i++) {
            standby = standby.multiply(BigDecimal.TEN);
        }
        BigDecimal result = new BigDecimal(val.toString()).divide(standby);
        return lessZero ? BigDecimalUtils.reverse(result) : result;
    }

    /**
     * @description: 整数 转 BigDecimal
     **/
    public static BigDecimal longToPoint(Long val, boolean lessZero, int point) {
        BigDecimal standby = BigDecimal.ONE;
        for (int i = 0; i < point; i++) {
            standby = standby.multiply(BigDecimal.TEN);
        }
        BigDecimal result = new BigDecimal(val.toString()).divide(standby);
        return lessZero ? BigDecimalUtils.reverse(result) : result;
    }

    /**
     * @description: 金额转字符
     **/
    public static String bigDecimalToStr(BigDecimal amount) {
        try {
            boolean lessZeroValue = BigDecimalUtils.compareLessZeroValue(amount);
            if (lessZeroValue) amount = BigDecimalUtils.reverse(amount);
            double v = amount.setScale(4, BigDecimal.ROUND_HALF_UP).doubleValue();
            String vs = String.valueOf(v);
            int point = 0;
            if (v != 0) {
                point = vs.length() - vs.lastIndexOf(".") - 1;
            }
            return Integer.toHexString(point) +
                    (lessZeroValue ? '1' : '0')
                    + ByteUtils.appendFill(Integer.toHexString(ByteUtils.pointToInteger(new BigDecimal(vs), point)), 6);
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    /**
     * @description: 金额转字符
     **/
    public static String bigDecimalToStr2(BigDecimal amount) {
        try {
            boolean lessZeroValue = BigDecimalUtils.compareLessZeroValue(amount);
            if (lessZeroValue) amount = BigDecimalUtils.reverse(amount);
            StringBuilder builder = new StringBuilder();

            if (isInteger(amount)) {
                builder.append(0)
                        .append(lessZeroValue ? '1' : '0')
                        .append(ByteUtils.appendFill(amount.toBigInteger().toString(16), 14));
            } else {
                builder.append(amount.scale())
                        .append(lessZeroValue ? '1' : '0')
                        .append(ByteUtils.appendFill(Long.toHexString(ByteUtils.pointToLong(new BigDecimal(amount.toPlainString()), amount.scale())), 14));
            }
            return builder.toString();
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean isInteger(BigDecimal value) {
        return value.scale() <= 0 || value.stripTrailingZeros().scale() <= 0;
    }

    /**
     * @description: 字符转金额
     **/
    public static BigDecimal strToBigDecimal(String str) {
        try {
            return longToPoint(
                    Long.parseLong(str.substring(2), 16),
                    '1' == str.charAt(1),
                    Integer.parseInt(String.valueOf(str.charAt(0)), 16));
        } catch (Exception e) {
            return BigDecimal.ZERO;
        }
    }

    /**
     * @description: 时间 转 字符串
     **/
    public static String timeToStrNoConvert(Date date) {
        return timeToStr((Objects.isNull(date) ? new Date() : date).getTime());
    }

    public static String timeToStr(Date date) {
        return convert(timeToStr((Objects.isNull(date) ? new Date() : date).getTime()));
    }

    public static String timeToStrNone(Date date) {
        return Objects.nonNull(date) ? convert(timeToStr(date.getTime())) : DT_VALID_FILED;
    }

    public static String timeToStr(long time) {
        long sys_time = DateUtils.getDefaultTime().getTime();
        time = Math.max(time, sys_time);
        time = (time - sys_time) / 1000;
        return appendFill(Long.toHexString(time), 8);
    }

    /**
     * @description: 时间转换
     **/
    public static Date convertTime(String hexString) {
        long time = Long.parseLong(convert(hexString), 16);
        return new Date((time + 946656000) * 1000);
    }

    /**
     * @description: 时间转换
     **/
    public static Date convertTimeNone(String hexString) {
        if (DT_VALID_FILED.equals(hexString)) return null;
        long time = Long.parseLong(convert(hexString), 16);
        return new Date((time + 946656000) * 1000);
    }

    /**
     * @description: 时间转换
     **/
    public static Date convertTime_nr(String hexString) {
        long time = Long.parseLong(hexString, 16);
        return new Date((time + 946656000) * 1000);
    }

    /**
     * @description: 字符转时间
     **/
    public static long strToTimeMillis(String str) {
        long sys_time = DateUtils.getDefaultTime().getTime();
        return Long.parseLong(str, 16) * 1000 + sys_time;
    }

    public static Date strToDate(String str) {
        return new Date(strToTimeMillis(str));
    }

    /**
     * @description: 文本转字符
     **/
    public static String txtToStr(String txt) {
        String str = "";
        if (StringUtils.isNotBlank(txt)) {
            str = ByteUtils.toHexAscii(txt.getBytes(DConstant.DEFAULT_CHARSET));
        }
        return str;
    }

    /**
     * @description: 文本转字符
     **/
    public static String txtToStr_UTF8(String txt) {
        String str = "";
        if (StringUtils.isNotBlank(txt)) {
            str = ByteUtils.toHexAscii(txt.getBytes(DConstant.UTF_8));
        }
        return str;
    }

    /**
     * @description: 字符转文本
     **/
    public static String strToTxt(String str) {
        String txt = "";
        if (StringUtils.isNotBlank(str)) {
            str = str.endsWith(TXT_END) ? str.substring(0, str.length() - 2) : str;
            txt = new String(ByteUtils.fromHexAscii(str), DConstant.DEFAULT_CHARSET);
        }
        return txt;
    }

    /**
     * @description: 字符转文本
     **/
    public static String strToTxt_UTF8(String str) {
        String txt = "";
        if (StringUtils.isNotBlank(str)) {
            str = str.endsWith(TXT_END) ? str.substring(0, str.length() - 2) : str;
            txt = new String(ByteUtils.fromHexAscii(str), DConstant.UTF_8);
        }
        return txt;
    }

    /**
     * @description: 二进制 转 16 进制
     **/
    public static String binaryToHex(String binary) {
        return int2Hex(Integer.parseInt(binary, 2));
    }

    public static String binary2Hex(String binary) {
        BigInteger binaryVal = new BigInteger(binary, 2);
        String hex = binaryVal.toString(16);
        if (hex.length() % 2 != 0) hex = "0" + hex;
        return ByteUtils.convert(hex);
    }

    public static String binaryToHex(String binary, int length) {
        return int2HexWithPush(Integer.parseInt(binary, 2), length);
    }

    /**
     * @description: 16进制 转 二进制
     **/
    public static String hexToBinary(String hex) {
        return ten2two(Integer.parseInt(ByteUtils.convert(hex), 16), 8);
    }

    public static String hex2Binary(String hex) {
        BigInteger hexVal = new BigInteger(ByteUtils.convert(hex), 16);
        return hexVal.toString(2);
    }

    /**
     * @description: 16进制 转 二进制
     **/
    public static String hexToBinary(String hex, int length) {
        return ten2two(Integer.parseInt(ByteUtils.convert(hex), 16), length);
    }

    /**
     * @description: 特殊字符转义
     **/
    public static String tryParseToString(String toParse) {
        return StringUtils.isNotBlank(toParse)
                ?
                toParse.replace('\n', '\013')
                // .replace('#', '\012')
                // .replace('~', '\014')
                // .replace('&', '\015')
                // .replace('!', '\016')
                // .replace('@', '\017')
                :
                "";
    }

    /**
     * @description: 转义字符 反转
     **/
    public static String tryParseFromString(String toParse) {
        return StringUtils.isNotBlank(toParse)
                ?
                toParse.replace('\013', '\n')
                // .replace('\012', '#')
                // .replace('\014', '~')
                // .replace('\015', '&')
                // .replace('\016', '!')
                // .replace('\017', '@')
                :
                "";
    }

    /**
     * @description: 字符串最大长度
     **/
    public static String strMaxLength(String str, int length) {
        if (StringUtils.isBlank(str)) {
            return "";
        } else if (str.length() <= length) {
            return str;
        } else {
            return str.substring(0, length);
        }
    }

    /**
     * @description: 字符串颠倒
     **/
    public static String stringInvert(String source) {
        if (StringUtils.isNotBlank(source)) {
            String target = "";
            for (int i = source.length(); i > 0; i--) {
                target += source.charAt(i - 1);
            }
            return target;
        }
        return source;
    }

    /**
     * @description: 判断是不是HEX
     **/
    public static boolean isHex(String hex) {
        try {
            return StringUtils.isNotBlank(hex) && Long.parseLong(hex, 16) > -1;
        } catch (NumberFormatException e) {
            return false;
        }
    }

    /**
     * @description: hex to ten
     **/
    public static int hex2Ten(String hex) {
        return Integer.parseInt(ByteUtils.convert(hex), 16);
    }

    /**
     * @description: hex to ten
     **/
    public static long hex2Long(String hex) {
        return Long.parseLong(ByteUtils.convert(hex), 16);
    }

    /**
     * @description: String 后置长度补全
     **/
    public static String completeEnd(String content, int length) {
        content = StringUtils.isNotBlank(content) ? content : "";
        int append = length - content.length();
        if (append > 0) {
            for (int i = 0; i < append; i++) {
                content += "0";
            }
            return content;
        } else {
            return content.substring(0, length);
        }
    }

    /**
     * @description: 赠送时间是否永久
     **/
    public static boolean isGiveForever(BigDecimal giveBalance, Date giveTime) {
        return Objects.nonNull(giveBalance) && BigDecimalUtils.compareMoreZeroValue(giveBalance)
                && (Objects.isNull(giveTime) || DateUtils.TIME_2000_1_1_0_0_0 == giveTime.getTime());
    }

    // public static void main(String[] args) {
    //     // String str = "苹果";
    //     // String s1 = txtToStr(str);
    //     // System.out.println(s1);
    //     // String s2 = strToTxt(s1);
    //     // System.out.println(s2);
    //     // String s3 = strToTxt2(s1);
    //     // System.out.println(s3);

    //     String binary_str = "10000000000000111111111111111111100000";
    //     String hex = binary2Hex(binary_str);
    //     System.out.println(hex);
    //     String binary = hex2Binary(hex);
    //     System.out.println(binary);
    //     System.out.println(binary_str.equals(binary));
    // }

    /**
     * @description: 字符转文本
     **/
    public static String strToTxt2(String str) {
        String txt = "";
        if (StringUtils.isNotBlank(str)) {
            str = str.endsWith(TXT_END) ? str.substring(0, str.length() - 2) : str;
            txt = new String(ByteUtils.fromHexAscii(str), DConstant.UTF_8);
        }
        return txt;
    }

    /**
     * @description: 时间转Hex
     * @date: 2024-10-10 15:15:43
     **/
    public static String timeToHex(Date date) {
        long timeDefault = DateUtils.TIME_2000_1_1_0_0_0;
        long timeLong = date.getTime();
        long seconds = (timeLong - timeDefault) / 1000;
        return ByteUtils.completeBytes(Long.toHexString(seconds), 8).toUpperCase();
    }

    /**
     * @description: 时间转Hex
     * @date: 2024-10-10 15:15:43
     **/
    public static Date hexToTime(String hex) {
        long seconds = Long.parseLong(ByteUtils.convert(hex), 16) * 1000;
        long timeDefault = DateUtils.TIME_2000_1_1_0_0_0;
        long timeLong = seconds + timeDefault;
        return new Date(timeLong);
    }
}
