package com.jhscale.common.utils;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author lie_w
 * @title: ClazzUtils
 * @projectName ysscale-base
 * @description: TODO
 * @date 2020/2/1315:57
 */
public class ClazzUtils {

    private ClazzUtils() {
    }

    /**
     * @description: 获取对象中所有私有属性，包括父类中的
     **/
    public static Map<String, Field> getAllFields(Class clazz) {
        Map<String, Field> fieldMap = new HashMap<>();

        Field[] selfFields = clazz.getDeclaredFields();
        if (selfFields != null && selfFields.length > 0)
            for (Field field : selfFields) {
                fieldMap.put(field.getName(), field);
            }

        for (; clazz != Object.class; clazz = clazz.getSuperclass()) {//向上循环  遍历父类
            Field[] fields = clazz.getDeclaredFields();
            for (Field field : fields) {
                fieldMap.put(field.getName(), field);
            }
        }
        return fieldMap;
    }

    /**
     * @description: 获取对象中指定对象属性的值
     **/
    public static <T> T getObjectVal(Object obj, Class<T> clazz) {
        if (clazz == null) return null;
        try {
            Field[] declaredFields = obj.getClass().getDeclaredFields();
            if (declaredFields != null && declaredFields.length > 0) {
                for (Field declaredField : declaredFields) {
                    if (declaredField.getType().equals(clazz)) {
                        declaredField.setAccessible(true);
                        return (T) declaredField.get(obj);
                    }
                }
            }
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * @description: 获取对象中指定对象中的属性
     **/
    public static Field getObjectField(Object obj, Class clazz) {
        if (clazz == null) return null;
        Field[] declaredFields = obj.getClass().getDeclaredFields();
        if (declaredFields != null && declaredFields.length > 0) {
            for (Field declaredField : declaredFields) {
                if (declaredField.getType().equals(clazz)) {
                    return declaredField;
                }
            }
        }
        return null;
    }

    /**
     * @description: 获取对象中指定字段的值
     **/
    public static <T> T getObjectVal(Object obj, String name, Class<T> clazz) {
        try {
            if (clazz == null) return null;
            Field declaredField = obj.getClass().getDeclaredField(name);
            declaredField.setAccessible(true);
            return (T) declaredField.get(obj);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * @description: 获取本类全部kv
     **/
    public static Map<String, Object> getKeyVal(Object obj) {
        Map<String, Object> map = null;
        if (Objects.nonNull(obj)) {
            map = new HashMap<>();
            Field[] fields = obj.getClass().getDeclaredFields();
            if (fields != null && fields.length > 0) {
                for (Field field : fields) {
                    try {
                        field.setAccessible(true);
                        map.put(field.getName(), field.get(obj));
                    } catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return map;
    }
}
