package com.jhscale.common.utils;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.exception.GeneralInternational;
import com.jhscale.common.exception.ProfessionalException;
import com.jhscale.common.model.device._inner.*;
import com.jhscale.common.model.device.ai_feature.DAIFeatureV1;
import com.jhscale.common.model.device.barcode_format.DBarcodeFormatV1;
import com.jhscale.common.model.device.bitmap.DBitMapV1;
import com.jhscale.common.model.device.category.DCategoryV1;
import com.jhscale.common.model.device.data_parameter.DDataParameterV1;
import com.jhscale.common.model.device.font.DFontV1;
import com.jhscale.common.model.device.info.DDeviceInfo;
import com.jhscale.common.model.device.info.DDeviceInfoV1;
import com.jhscale.common.model.device.info.DTIM;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INA;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INF;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INI;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INM;
import com.jhscale.common.model.device.label_format.DLabelFormatV1;
import com.jhscale.common.model.device.log.DLOGV1;
import com.jhscale.common.model.device.other.DSpDWL;
import com.jhscale.common.model.device.other.DSpDWLV1;
import com.jhscale.common.model.device.plu.DPLUV5;
import com.jhscale.common.model.device.plu.inner.DAutoDiscount;
import com.jhscale.common.model.device.plu.inner.DManualDiscount;
import com.jhscale.common.model.device.salejob.DSaleJobV1;
import com.jhscale.common.model.device.saleman.DSaleManV1;
import com.jhscale.common.model.device.shortkey.DShortKeyV1;
import com.jhscale.common.model.device.shortpage.DShortPageV1;
import com.jhscale.common.model.device.shortpage_formwork.DShortPageFormworkV1;
import com.jhscale.common.model.device.text_parameter.DTextParameterV1;
import com.jhscale.common.model.inter.DataJSONModel;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author lie_w
 * @title: DPLUUtils
 * @projectName common
 * @description: TODO
 * @date 2022/7/1519:34
 */
public class DDataUtils {

    private static DDataExecute dataExecute = null;

    private DDataUtils() {
    }

    public static void setDataExecute(DDataExecute dataExecute) {
        DDataUtils.dataExecute = dataExecute;
    }

    public static DDataExecute getDataExecute() {
        return dataExecute;
    }

    public static Integer getSpDWL(String key) {
        return getDataExecute() != null ? getDataExecute().getSpDWL(key) : null;
    }

    /**
     * 判断字符串是否为空，如果不为空将,则直接转化为Integer类型
     *
     * @param t
     * @param <T>
     * @return
     */
    @Deprecated
    public static <T> Integer getResultInteger(T t) {
        return (Objects.isNull(t)) ? null : Integer.parseInt(String.valueOf(t));
    }

    /**
     * @param t
     * @param <T>
     * @return
     */
    @Deprecated
    public static <T> BigDecimal getResultBigDecimal(T t) {
        return (Objects.isNull(t)) ? null : new BigDecimal(String.valueOf(t));
    }

    /**
     * 获取手动折扣对象
     *
     * @param manualDiscount 手动折扣字符串
     * @return
     */
    @Deprecated
    @SuppressWarnings("all")
    public static List<DManualDiscount> getDManualDiscount(String manualDiscount) {
        List<DManualDiscount> manualDiscountList = new ArrayList<>();
        if (StringUtils.isBlank(manualDiscount)) {
            return null;
        }
        String[] split = StringUtils.split(manualDiscount, "|");
        if (Objects.isNull(split) && split.length <= 0) {
            return null;
        }
        // 手动折扣限制
        String dmanualDiscounts = split[0];
        String[] dmanualDiscountss = dmanualDiscounts.split("#");
        // 上限
        String upperLimit = dmanualDiscountss[0];
        // 下限
        String lowerLimit = dmanualDiscountss[1];
        // 上下限折扣类型
        String manualDiscountTypes = split[1];
        String[] manualDiscountTypess = manualDiscountTypes.split("#");
        // 上限折扣类型
        String upperDiscountType = manualDiscountTypess[0];
        // 下限折扣类型
        String lowerDiscountType = manualDiscountTypess[1];
        // 值
        String discounts = split[2];
        String[] discountss = discounts.split("#");
        //  上限值 # 下限值
        // 上限值
        String upperValue = discountss[0];
        // 下限值
        String lowerValue = discountss[1];
        // 添加上限值
        manualDiscountList.add(new DManualDiscount()
                .setDiscount(getResultInteger(upperLimit),
                        getResultInteger(upperDiscountType),
                        getResultBigDecimal(upperValue)));
        // 添加下限值
        manualDiscountList.add(new DManualDiscount()
                .setDiscount(getResultInteger(lowerLimit),
                        getResultInteger(lowerDiscountType),
                        getResultBigDecimal(lowerValue)));
        return manualDiscountList;
    }

    /**
     * 获取自动折扣对象
     *
     * @param autoDiscount 自动折扣字符串
     * @return
     */
    @Deprecated
    @SuppressWarnings("all")
    public static DAutoDiscount getAutoDiscount(String autoDiscount) {
        if (StringUtils.isBlank(autoDiscount)) {
            return null;
        }
        DAutoDiscount dAutoDiscount = new DAutoDiscount();
        // 折扣类型 # 激活日 # 折扣值 # 区间值最小值 # 区间值最大值 #区间类型
        String[] split = StringUtils.split(autoDiscount, "#");
        //折扣类型
        String discountType = split[0];
        //激活日
        String activation = split[1];
        //区间值最小值
        String min = split[2];
        //区间值最大值
        String max = split[3];
        //折扣值
        String discountValue = split[4];
        //区间类型
        String intervalType = null;
        if (split.length > 5) {
            intervalType = split[5];
        }
        return dAutoDiscount.setType(getResultInteger(discountType))
                .setDate(getResultInteger(activation))
                .setLower(getResultBigDecimal(min))
                .setUpper(getResultBigDecimal(max))
                .setDiscount(getResultBigDecimal(discountValue))
                .setIntervalType(getResultInteger(intervalType));
    }

    /**
     * @param autoDiscount
     * @return
     * @description 获取自动折扣信息
     */
    @Deprecated
    private static List<DAutoDiscount> getAutoDiscount(String... autoDiscount) {
        if (Objects.isNull(autoDiscount) || autoDiscount.length == 0) return null;
        List<DAutoDiscount> autoDiscountList = new ArrayList<>();
        Arrays.stream(autoDiscount).forEach(i -> autoDiscountList.add(getAutoDiscount(i)));
        return autoDiscountList;
    }

    /**
     * @description: 数据组装
     **/
    @Deprecated
    public static <T extends DataJSONModel> String gzip(T... models) {
        return gzip(models);
    }

    /**
     * @description: 数据组装
     **/
    @Deprecated
    public static <T extends DataJSONModel> String gzip(List<T> models) {
        return GZIPUtils.compress(JSONUtils.objectToJSON(models));
    }

    /**
     * @description: 数据内容解析
     **/
    @Deprecated
    public static <T extends DataJSONModel> List<T> ungzip(String content, Class<T> clazz) {
        return JSONUtils.jsonToList(GZIPUtils.uncompress(content), clazz);
    }

    /**
     * @description: 数据组装
     **/
    @Deprecated
    public static <T extends DataJSONModel> String assemble(T... models) {
        return assemble(true, models);
    }

    /**
     * @description: 数据组装
     **/
    @Deprecated
    public static <T extends DataJSONModel> String assemble(List<T> models) {
        return assemble(true, models);
    }

    /**
     * @description: 数据组装
     **/
    @Deprecated
    public static <T extends DataJSONModel> String assemble(boolean base64, T... models) {
        return assemble(base64, Arrays.asList(models));
    }

    /**
     * @description: 组装数组
     **/
    @Deprecated
    public static <T extends DataJSONModel> List<String> assembleArr(T... models) {
        return assembleArr(true, Arrays.asList(models));
    }

    /**
     * @description: 组装数组
     **/
    @Deprecated
    public static <T extends DataJSONModel> List<String> assembleArr(List<T> models) {
        return assembleArr(true, models);
    }

    /**
     * @description: 组装数组
     **/
    @Deprecated
    public static <T extends DataJSONModel> List<String> assembleArr(boolean base64, T... models) {
        return assembleArr(base64, Arrays.asList(models));
    }

    /**
     * @description: 组装数组
     **/
    @Deprecated
    public static <T extends DataJSONModel> List<String> assembleArr(boolean base64, List<T> models) {
        return Optional.ofNullable(models)
                .orElse(Collections.emptyList())
                .stream().map(model -> {
                    return assemble(base64, model);
                }).collect(Collectors.toList());
    }

    /**
     * @description: 数据组装
     **/
    @Deprecated
    public static <T extends DataJSONModel> String assemble(boolean base64, List<T> models) {
        if (models != null && !models.isEmpty()) {
            StringBuffer buffer = new StringBuffer()
                    .append(models.get(0).getClass().getName())
                    .append(CLASS_PREFIX);
            for (T model : models) {
                buffer.append(model.assemble(false))
                        .append(ARRAY_SPLIT);
            }
            String result = buffer.substring(0, buffer.length() - ARRAY_SPLIT.length());
            return base64 ? Base64Utils.gzipString(result) : result;
        }
        return null;
    }

    /**
     * @description: 数据内容解析
     **/
    public static <T extends DataJSONModel> List<T> analyze(String content) throws ProfessionalException {
        return analyze(content, true);
    }

    /**
     * @description: 数据内容解析
     **/
    @SuppressWarnings("all")
    public static <T extends DataJSONModel> List<T> analyze(String content, boolean base64) throws ProfessionalException {
        if (StringUtils.isNotBlank(content)) {
            content = base64 ? Base64Utils.ungzipString(content) : content;
            if (content.contains(CLASS_PREFIX)) {
                String[] contentArr = content.split(CLASS_PREFIX);
                Class<?> aClass = null;
                try {
                    aClass = Class.forName(contentArr[0]);
                } catch (Exception e) {
                }
                if (aClass == null)
                    throw new ProfessionalException(GeneralInternational.未找到对象信息);

                List<T> dataList = new ArrayList<>();
                String[] strArr = contentArr[1].split(ARRAY_SPLIT);
                for (String str : strArr) {
                    Object data = null;
                    try {
                        data = aClass.newInstance();
                    } catch (Exception e) {
                    }
                    dataList.add((T) ((DataJSONModel) data).parse(str, false));
                }
                return dataList;
            }
        }
        return null;
    }

    /**
     * @description: 新结构
     **/
    public static boolean isNew(String data, boolean base64) {
        if (StringUtils.isNotBlank(data)) {
            data = base64 ? Base64Utils.ungzipString(data) : data;
            return data.contains(CLASS_PREFIX);
        }
        return false;
    }

    /**
     * @description: 数据格式解析
     **/
    public static <T extends DataJSONModel> T analyze(String content, boolean uncompress, Class<T> clazz) {
        return uncompress ? JSONUtils.jsonToObject(GZIPUtils.uncompress(content), clazz) : JSONUtils.jsonToObject(content, clazz);
    }

    /**
     * @description: 数据格式解析
     **/
    public static <T extends DataJSONModel> T analyze(String content, Class<T> clazz) {
        return analyze(content, true, clazz);
    }

    /**
     * 1 下发
     * 2 删除
     * 3 回收
     * 4 事件
     *
     * @description: 公开协议前缀
     **/
    public static String Public_Start(DataJSONModel jsonModel, int mark) {
        StringBuffer buffer = new StringBuffer();
        if (jsonModel != null) {
            DataClass annotation = jsonModel.getClass().getAnnotation(DataClass.class);
            if (annotation != null) {
                switch (mark) {
                    case 1:
                        buffer.append(PUBLIC_MDF)
                                .append(annotation.separator())
                                .append(annotation.mark())
                                .append(annotation.line());
                        break;
                    case 2:
                        buffer.append(PUBLIC_CLR)
                                .append(annotation.separator())
                                .append(annotation.mark())
                                .append(annotation.line());
                        break;
                    case 3:
                        buffer.append(PUBLIC_UPL)
                                .append(annotation.separator())
                                .append(annotation.mark())
                                .append(annotation.line());
                        break;
                    case 4:
                        if (annotation.ask())
                            buffer.append(PUBLIC_ASK)
                                    .append(annotation.separator())
                                    .append(annotation.mark())
                                    .append(annotation.line());
                        break;
                }
            }
        }
        return buffer.toString();
    }

    /**
     * @description: 公开协议结尾
     **/
    public static String Public_End(DataJSONModel jsonModel) {
        StringBuffer buffer = new StringBuffer();
        if (jsonModel != null) {
            DataClass annotation = jsonModel.getClass().getAnnotation(DataClass.class);
            if (annotation != null) {
                return buffer
                        .append(PUBLIC_END)
                        .append(annotation.separator())
                        .append(annotation.mark())
                        .append(annotation.separator())
                        .toString();
            }
        }
        return buffer.toString();
    }

    /**
     * @description: 有效字段开头
     **/
    private static final List<String> Valid_Field_Top = Arrays.asList(
            PUBLIC_MDF, PUBLIC_CLR, PUBLIC_UPL, PUBLIC_ASK
    );

    /**
     * @description: 公开协议拆包
     **/
    public static List<PublicExecute> Public_UnPackage(String all_package) {
        return Public_UnPackage_Reflex(all_package, false);
    }

    /**
     * @description: 公开协议拆包
     **/
    public static List<PublicExecute> Public_UnPackage_Reflex(String all_package, boolean reflex) {
        List<PublicExecute> publicExecutes = new ArrayList<>();
        String[] lines = all_package.split(PUBLIC_LINE_SPLIT);
        PublicExecute execute = null;
        int serial = 0;
        for (String line : lines) {
            // System.out.println(line);
            if (StringUtils.isNotBlank(line)) {
                String[] all_fields = (line + PUBLIC_LINE_SPLIT).split(PUBLIC_FIELD_SPLIT);
                if (Valid_Field_Top.contains(all_fields[0])) {

                    if (execute != null && !all_fields[0].equals(execute.getExecute())) {
                        publicExecutes.add(execute);
                        execute = null;
                    }

                    switch (all_fields[0]) {
                        case PUBLIC_MDF:
                            execute = new PublicExecuteModify(all_fields[1]);
                            break;
                        case PUBLIC_CLR:
                            if (execute != null && execute.valid() && !execute.getType().equals(all_fields[1])) {
                                execute.setSerial(serial);
                                publicExecutes.add(execute);
                                execute = null;
                            }
                            execute = execute == null ? new PublicExecuteDelete(all_fields[1]) : execute;
                            if (all_fields.length == 4 && StringUtils.isNotBlank(all_fields[2]))
                                ((PublicExecuteDelete) execute).add(Integer.parseInt(all_fields[2]));
                            break;
                        case PUBLIC_UPL:
                            if (execute != null && execute.valid() && !execute.getType().equals(all_fields[1])) {
                                execute.setSerial(serial);
                                publicExecutes.add(execute);
                                execute = null;
                            }
                            execute = execute == null ? new PublicExecuteRecovery(all_fields[1]) : execute;
                            if (all_fields.length == 4 && StringUtils.isNotBlank(all_fields[2]))
                                ((PublicExecuteRecovery) execute).add(Integer.parseInt(all_fields[2]));
                            switch (execute.getType()) {
                                case INF:
                                    publicExecutes.add(new PublicExecuteRecovery(all_fields[1]));
                                    execute = null;
                                    break;
                                case MAC:
                                    publicExecutes.add(new PublicExecuteRecovery(all_fields[1]));
                                    execute = null;
                                    break;
                                case TIM:
                                    publicExecutes.add(new PublicExecuteRecovery(all_fields[1]));
                                    execute = null;
                                    break;
                            }
                            break;
                        case PUBLIC_ASK:
                            execute = new PublicExecuteAsk(all_fields[1]);
                            break;
                    }
                } else if (PUBLIC_END.equals(all_fields[0])
                        || ((all_fields.length > 1) && PUBLIC_END.equals(all_fields[1]))) {
                    if (execute != null && execute.valid()) {
                        execute.setSerial(serial);
                        publicExecutes.add(execute);
                    }
                    if (execute != null) execute = null;
                } else {
                    if (execute != null) {
                        DataJSONModel model = null;
                        switch (all_fields[0]) {
                            case INF_INA:
                                model = execute.remove_first(DDeviceInfoV1.class);
                                DDeviceInfo_INA ina = new DDeviceInfo_INA<>().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                                ((DDeviceInfo) model).setIna(ina);
                                break;
                            case INF_INM:
                                model = execute.remove_first(DDeviceInfoV1.class);
                                DDeviceInfo_INM inm = new DDeviceInfo_INM<>().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                                ((DDeviceInfo) model).setInm(inm);
                                break;
                            case INF_INF:
                                model = execute.remove_first(DDeviceInfoV1.class);
                                DDeviceInfo_INF inf = new DDeviceInfo_INF<>().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                                ((DDeviceInfo) model).setInf(inf);
                                break;
                            case INF_INI:
                                model = execute.remove_first(DDeviceInfoV1.class);
                                DDeviceInfo_INI ini = new DDeviceInfo_INI<>().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                                ((DDeviceInfo) model).setIni(ini);
                                break;
                            case TIM:
                                model = new DTIM().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                                break;
                            default:
                                serial = all_fields.length;
                                if (reflex) {
                                    model = Public_UnPackage(all_fields);
                                } else {
                                    model = typeToModel(all_fields[0]);
                                    if (model != null) {
                                        model.Public_UnPackage_No_Reflex(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                                    }
                                }
                                break;
                        }
                        if (model != null) {
                            if (execute instanceof PublicExecuteModify) {
                                ((PublicExecuteModify) execute).add(model);
                            }
                        }
                    } else {
                        execute = Public_UnPackage_Line(line);
                    }
                }
            }
        }
        if (execute != null) publicExecutes.add(execute);
        return publicExecutes;
    }

    /**
     * @description: 公开协议拆包
     **/
    public static List<PublicExecute> Public_UnPackage_Lines(String all_package) {
        List<PublicExecute> executes = new ArrayList<>();
        if (StringUtils.isNotBlank(all_package)) {
            String[] lines = all_package.split(PUBLIC_LINE_SPLIT);
            for (String line : lines) {
                PublicExecute execute = Public_UnPackage_Line(line);
                if (execute != null) {
                    executes.add(execute);
                }
            }
        }
        return executes;
    }

    /**
     * @description: 公开协议拆包 行模式 拆解 保留剩余
     **/
    public static UnPackageResponse Public_UnPackage_End_Lines(String all_package) {
        return Public_UnPackage_End_Lines(all_package, false);
    }

    /**
     * @description: 公开协议拆包 行模式 拆解 保留剩余
     **/
    public static UnPackageResponse Public_UnPackage_End_Lines(String all_package, boolean log) {
        List<PublicExecute> executes = new ArrayList<>();
        String surplus = "";
        if (StringUtils.isNotBlank(all_package)) {
            int index = 0;
            while (index != -1) {
                long start = System.currentTimeMillis();
                index = all_package.indexOf(PUBLIC_LINE_SPLIT);
                long index_time = System.currentTimeMillis();
                if (index != -1) {
                    String line = all_package.substring(0, index);
                    long split_time = System.currentTimeMillis();
                    long un_package_time = split_time;
                    if (StringUtils.isNotBlank(line)) {
                        PublicExecute execute = Public_UnPackage_Line(line);
                        un_package_time = System.currentTimeMillis();
                        if (execute != null) executes.add(execute);
                    }
                    all_package = all_package.substring(index + PUBLIC_LINE_SPLIT.length());
                    long surplus_time = System.currentTimeMillis();

                    if (log)
                        System.out.println(String.format("All:[%s], index:[%s], split:[%s], un_package:[%s], surplus:[%s]",
                                (surplus_time - start),
                                (index_time - start),
                                (split_time - index_time),
                                (un_package_time - split_time),
                                (surplus_time - un_package_time)));
                } else {
                    surplus = StringUtils.isNotBlank(all_package) ? all_package : "";
                }
            }
        }
        return new UnPackageResponse(executes, surplus);
    }

    /**
     * @description: 公开协议拆包
     **/
    public static PublicExecute Public_UnPackage_Line(String line) {
        PublicExecute execute = null;
        int serial = 0;
        if (StringUtils.isNotBlank(line)) {
            String[] all_fields = line.split(PUBLIC_FIELD_SPLIT);
            serial = all_fields.length;
            switch (all_fields[0]) {
                case PUBLIC_MDF:
                    break;
                case PUBLIC_CLR:
                    if (!PUBLIC_END.equals(all_fields[1])) {
                        execute = all_fields.length == 3 ? new PublicExecuteDelete(all_fields[1], Integer.parseInt(all_fields[2])) : new PublicExecuteDelete(all_fields[1]);
                    } else {
                        execute = new PublicExecuteEnd(all_fields[0]);
                    }
                    break;
                case PUBLIC_UPL:
                    if (!PUBLIC_END.equals(all_fields[1])) {
                        execute = all_fields.length == 3 ? new PublicExecuteRecovery(all_fields[1], Integer.parseInt(all_fields[2])) : new PublicExecuteRecovery(all_fields[1]);
                    } else {
                        execute = new PublicExecuteEnd(all_fields[0]);
                    }
                    break;
                case PUBLIC_ASK:
                    if (!PUBLIC_END.equals(all_fields[1])) {
                        execute = new PublicExecuteAsk(all_fields[1]);
                        ((PublicExecuteAsk) execute).add(Arrays.copyOfRange(all_fields, 2, all_fields.length));
                    } else {
                        execute = new PublicExecuteEnd(all_fields[0]);
                    }
                    break;
                case PUBLIC_END:
                    execute = new PublicExecuteEnd(all_fields[1]);
                    break;
                case INF_INA:
                    DDeviceInfo_INA ina = new DDeviceInfo_INA<>().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                    execute = new PublicExecuteModify(INF_INA, ina);
                    break;
                case INF_INM:
                    DDeviceInfo_INM inm = new DDeviceInfo_INM<>().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                    execute = new PublicExecuteModify(INF_INM, inm);
                    break;
                case INF_INF:
                    DDeviceInfo_INF inf = new DDeviceInfo_INF<>().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                    execute = new PublicExecuteModify(INF_INM, inf);
                    break;
                case INF_INI:
                    DDeviceInfo_INI ini = new DDeviceInfo_INI<>().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                    execute = new PublicExecuteModify(INF_INI, ini);
                    break;
                case TIM:
                    DTIM tim = new DTIM<>().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                    execute = new PublicExecuteModify(TIM, tim);
                    break;
                default:
                    DataJSONModel jsonModel = Public_UnPackage(all_fields);
                    if (jsonModel != null) {
                        if (jsonModel instanceof DSpDWL) {
                            execute = new PublicExecuteModify(((DSpDWL<?>) jsonModel).getKey(), jsonModel);
                        } else {
                            DataClass annotation = jsonModel.getClass().getAnnotation(DataClass.class);
                            execute = new PublicExecuteModify(annotation.mark(), jsonModel);
                        }
                    }
                    break;
            }
        }
        if (execute != null) execute.setSerial(serial);
        return execute;
    }

    /**
     * @description: 数组解包
     **/
    public static DataJSONModel Public_UnPackage(String[] all_fields) {
        DataJSONModel model = null;
        switch (all_fields[0]) {
            case TMS:
                model = new DDataParameterV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            case TMT:
                model = new DTextParameterV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            case CLS:
                model = new DCategoryV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            case PLU:
                model = new DPLUV5().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            case BAR:
                model = new DBarcodeFormatV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            case LAT:
                model = new DLabelFormatV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            case SAJ:
                model = new DSaleJobV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            case SAL:
                model = new DSaleManV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            case SCP:
                model = new DShortKeyV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            case SCG:
                model = new DShortPageV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            case SGF:
                model = new DShortPageFormworkV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            case BMP:
                model = new DBitMapV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            case FNT:
                model = new DFontV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            case REP:
                model = new DLOGV1().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                break;
            default:
                if (dataExecute != null) {
                    Integer spDWL = dataExecute.getSpDWL(all_fields[0]);
                    if (spDWL != null) {
                        model = new DSpDWLV1();
                        model.Public_UnPackage_No_Reflex(all_fields);
                    }
                }
        }
        return model;
    }


    /**
     * @description: 公开协议解包
     **/
    public static String Public_Package(PublicExecute... executes) {
        return Public_Package(Arrays.asList(executes));
    }

    public static String Public_Package(List<PublicExecute> executes) {
        return Public_Package_Reflex(executes, false);
    }

    /**
     * @description: 公开协议解包
     **/
    public static String Public_Package_Reflex(List<PublicExecute> executes, boolean reflex) {
        StringBuffer buffer = new StringBuffer();
        if (executes != null && !executes.isEmpty()) {
            for (PublicExecute execute : executes) {
                if (reflex) {
                    buffer.append(execute.Package());
                } else {
                    buffer.append(execute.Package_No_Reflex());
                }
            }
        }
        return buffer.toString();
    }

    /**
     * @description: 公开协议解包
     **/
    public static String Public_Package_No_Reflex(List<PublicExecute> executes) {
        StringBuffer buffer = new StringBuffer();
        if (executes != null && !executes.isEmpty()) {
            for (PublicExecute execute : executes) {
                buffer.append(execute.Package_No_Reflex());
            }
        }
        return buffer.toString();
    }

    /**
     * @description: 公开协议解包
     **/
    public static String Public_Package_No_Reflex(PublicExecute... executes) {
        return executes != null && executes.length > 0 ? Public_Package_No_Reflex(Arrays.asList(executes)) : "";
    }

    /**
     * @description: 公开协议拆包 行模式 分布拆解
     **/
    public static UnPackageResponse Public_UnPackage_Lines_Distribute(String all_package) {
        return Public_UnPackage_Lines_Distribute(all_package, false);
    }

    /**
     * @description: 公开协议拆包 行模式 分布拆解
     **/
    public static UnPackageResponse Public_UnPackage_Lines_Distribute(String all_package, boolean log) {
        List<PublicExecute> executes = new ArrayList<>();
        String surplus = "";
        if (StringUtils.isNotBlank(all_package)) {
            int index = 0;
            while (index != -1) {
                long start = System.currentTimeMillis();
                int len = PUBLIC_LINE_SPLIT.length();
                index = -1;// all_package.indexOf(PUBLIC_LINE_SPLIT);
                if (index == -1) {
                    len = PUBLIC_LINE_SPLIT_1.length();
                    index = all_package.indexOf(PUBLIC_LINE_SPLIT_1);
                }
                long index_time = System.currentTimeMillis();
                if (index != -1) {
                    String line = all_package.substring(0, index + len);
                    long split_time = System.currentTimeMillis();
                    long un_package_time = split_time;
                    if (StringUtils.isNotBlank(line)) {
                        PublicExecute execute = Public_UnPackage_Line_Distribute(line);
                        un_package_time = System.currentTimeMillis();
                        if (execute != null) executes.add(execute);
                    }
                    all_package = all_package.substring(index + len);
                    long surplus_time = System.currentTimeMillis();

                    if (log)
                        System.out.printf("Distribute All:[%s], index:[%s], split:[%s], un_package:[%s], surplus:[%s]%n",
                                (surplus_time - start),
                                (index_time - start),
                                (split_time - index_time),
                                (un_package_time - split_time),
                                (surplus_time - un_package_time));
                } else {
                    surplus = StringUtils.isNotBlank(all_package) ? all_package : "";
                }
            }
        }
        return new UnPackageResponse(executes, surplus);
    }

    /**
     * @description: 公开协议拆包
     **/
    public static PublicExecute Public_UnPackage_Line_Distribute(String line) {
        PublicExecute execute = null;
        int serial = 0;
        if (StringUtils.isNotBlank(line)) {
            String[] all_fields = line.split(PUBLIC_FIELD_SPLIT);
            serial = all_fields.length;
            switch (all_fields[0]) {
                case PUBLIC_MDF:
                    break;
                case PUBLIC_CLR:
                    if (!PUBLIC_END.equals(all_fields[1])) {
                        execute = all_fields.length == 4 ? new PublicExecuteDelete(all_fields[1], Integer.parseInt(all_fields[2])) : new PublicExecuteDelete(all_fields[1]);
                    } else {
                        execute = new PublicExecuteEnd(all_fields[0]);
                    }
                    break;
                case PUBLIC_UPL:
                    if (!PUBLIC_END.equals(all_fields[1])) {
                        execute = all_fields.length == 4 ? new PublicExecuteRecovery(all_fields[1], Integer.parseInt(all_fields[2])) : new PublicExecuteRecovery(all_fields[1]);
                    } else {
                        execute = new PublicExecuteEnd(all_fields[0]);
                    }
                    break;
                case PUBLIC_ASK:
                    if (!PUBLIC_END.equals(all_fields[1])) {
                        execute = new PublicExecuteAsk(all_fields[1]);
                        ((PublicExecuteAsk) execute).add(Arrays.copyOfRange(all_fields, 2, all_fields.length));
                    } else {
                        execute = new PublicExecuteEnd(all_fields[0]);
                    }
                    break;
                case PUBLIC_END:
                    execute = new PublicExecuteEnd(all_fields[1]);
                    break;
                case INF_INA:
                    DDeviceInfo_INA ina = new DDeviceInfo_INA<>().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                    execute = new PublicExecuteModify(INF_INA, ina);
                    break;
                case INF_INM:
                    DDeviceInfo_INM inm = new DDeviceInfo_INM<>().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                    execute = new PublicExecuteModify(INF_INM, inm);
                    break;
                case INF_INF:
                    DDeviceInfo_INF inf = new DDeviceInfo_INF<>().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                    execute = new PublicExecuteModify(INF_INM, inf);
                    break;
                case INF_INI:
                    DDeviceInfo_INI ini = new DDeviceInfo_INI<>().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                    execute = new PublicExecuteModify(INF_INI, ini);
                    break;
                case TIM:
                    DTIM tim = new DTIM<>().Public_UnPackage_This(Arrays.copyOfRange(all_fields, 1, all_fields.length));
                    execute = new PublicExecuteModify(TIM, tim);
                    break;
                default:
                    DataJSONModel jsonModel = typeToModel(all_fields[0]);
                    if (jsonModel != null) {
                        if (dataExecute != null && dataExecute.getSpDWL(all_fields[0]) != null) {
                            execute = new PublicExecuteModifyCache(all_fields[0], all_fields);
                        } else {
                            execute = new PublicExecuteModifyCache(all_fields[0], Arrays.copyOfRange(all_fields, 1, all_fields.length));
                        }
                    }
                    break;
            }
        }
        if (execute != null) execute.setSerial(serial);
        return execute;
    }

    /**
     * @description: 公开协议拆包
     **/
    public static PublicExecuteModify Public_UnPackage_ModifyCache_To_Modify(PublicExecuteModifyCache modifyCache) {
        return Public_UnPackage_ModifyCache_To_Modify(modifyCache, false);
    }

    /**
     * @description: 公开协议拆包
     **/
    public static PublicExecuteModify Public_UnPackage_ModifyCache_To_Modify(PublicExecuteModifyCache modifyCache, boolean log) {
        PublicExecuteModify modify = new PublicExecuteModify();
        modify.setExecute(modifyCache.getExecute());
        modify.setType(modifyCache.getType());
        modify.setSerial(modifyCache.getSerial());
        if (modifyCache.size() > 0) {
            Class clazz = typeToClazz(modifyCache.getType());
            if (clazz != null) {
                List<Field> fields = null;
                long start = System.currentTimeMillis();
                for (int i = 0; i < modifyCache.getLines().size(); i++) {
                    String[] all_fields = modifyCache.getLines().get(i);
                    if (all_fields != null && all_fields.length > 0) {
                        DataJSONModel jsonModel = null;
                        try {
                            jsonModel = (DataJSONModel) clazz.newInstance();
                        } catch (InstantiationException | IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        if (jsonModel == null) continue;

                        // if (fields == null) fields = jsonModel.Public_Fields();

                        long line_start = System.currentTimeMillis();
                        jsonModel.Public_UnPackage(all_fields, fields);
                        long line_end = System.currentTimeMillis();
                        if (log)
                            System.out.println(String.format("ModifyCache_To_Modify Line Length: [%s] Time: [%s]",
                                    all_fields.length, (line_end - line_start)));
                        modify.add(jsonModel);
                    }
                }
                long end = System.currentTimeMillis();
                if (log)
                    System.out.println(String.format("ModifyCache_To_Modify Size: [%s] Time: [%s]",
                            modifyCache.size(), (end - start)));
            }
        }
        return modify;
    }

    /**
     * @description: 公开协议拆包 不使用反射
     **/
    public static PublicExecuteModify Public_UnPackage_ModifyCache_To_Modify_No_Reflex(PublicExecuteModifyCache modifyCache) {
        return Public_UnPackage_ModifyCache_To_Modify_No_Reflex(modifyCache, false);
    }

    /**
     * @description: 公开协议拆包 不使用反射
     **/
    public static PublicExecuteModify Public_UnPackage_ModifyCache_To_Modify_No_Reflex(PublicExecuteModifyCache modifyCache, boolean log) {
        PublicExecuteModify modify = new PublicExecuteModify();
        modify.setExecute(modifyCache.getExecute());
        modify.setType(modifyCache.getType());
        modify.setSerial(modifyCache.getSerial());
        if (modifyCache.size() > 0) {
            long start = System.currentTimeMillis();
            for (int i = 0; i < modifyCache.getLines().size(); i++) {
                DataJSONModel jsonModel = typeToModel(modifyCache.getType());
                if (jsonModel != null) {
                    String[] all_fields = modifyCache.getLines().get(i);
                    if (all_fields != null && all_fields.length > 0) {

                        long line_start = System.currentTimeMillis();
                        jsonModel.Public_UnPackage_No_Reflex(all_fields);
                        long line_end = System.currentTimeMillis();
                        if (log)
                            System.out.println(String.format("ModifyCache_To_Modify Line Length: [%s] Time: [%s]",
                                    all_fields.length, (line_end - line_start)));
                        modify.add(jsonModel);
                    }
                }
            }
            long end = System.currentTimeMillis();
            if (log)
                System.out.println(String.format("ModifyCache_To_Modify Size: [%s] Time: [%s]",
                        modifyCache.size(), (end - start)));
        }
        return modify;
    }

    /**
     * @description: Type 转 Class
     **/
    private static DataJSONModel typeToModel(String type) {
        DataJSONModel model = null;
        if (StringUtils.isNotBlank(type)) {
            switch (type) {
                case TMS:
                    model = new DDataParameterV1();
                    break;
                case TMT:
                    model = new DTextParameterV1();
                    break;
                case CLS:
                    model = new DCategoryV1();
                    break;
                case PLU:
                    model = new DPLUV5();
                    break;
                case BAR:
                    model = new DBarcodeFormatV1();
                    break;
                case LAT:
                    model = new DLabelFormatV1();
                    break;
                case SAJ:
                    model = new DSaleJobV1();
                    break;
                case SAL:
                    model = new DSaleManV1();
                    break;
                case SCP:
                    model = new DShortKeyV1();
                    break;
                case SCG:
                    model = new DShortPageV1();
                    break;
                case SGF:
                    model = new DShortPageFormworkV1();
                    break;
                case AIF:
                    model = new DAIFeatureV1();
                    break;
                case BMP:
                    model = new DBitMapV1();
                    break;
                case FNT:
                    model = new DFontV1();
                    break;
                case REP:
                    model = new DLOGV1();
                    break;
                default:
                    if (dataExecute != null) {
                        Integer spDWL = dataExecute.getSpDWL(type);
                        if (spDWL != null) {
                            model = new DSpDWLV1();
                        }
                    }
                    break;
            }
        }
        return model;
    }

    /**
     * @description: Type 转 Class
     **/
    private static Class typeToClazz(String type) {
        Class clazz = null;
        if (StringUtils.isNotBlank(type)) {
            switch (type) {
                case TMS:
                    clazz = DDataParameterV1.class;
                    break;
                case TMT:
                    clazz = DTextParameterV1.class;
                    break;
                case CLS:
                    clazz = DCategoryV1.class;
                    break;
                case PLU:
                    clazz = DPLUV5.class;
                    break;
                case BAR:
                    clazz = DBarcodeFormatV1.class;
                    break;
                case LAT:
                    clazz = DLabelFormatV1.class;
                    break;
                case SAJ:
                    clazz = DSaleJobV1.class;
                    break;
                case SAL:
                    clazz = DSaleManV1.class;
                    break;
                case SCP:
                    clazz = DShortKeyV1.class;
                    break;
                case SCG:
                    clazz = DShortPageV1.class;
                    break;
                case AIF:
                    clazz = DAIFeatureV1.class;
                    break;
                case SGF:
                    clazz = DShortPageFormworkV1.class;
                    break;
                case BMP:
                    clazz = DBitMapV1.class;
                    break;
                case FNT:
                    clazz = DFontV1.class;
                    break;
                case REP:
                    clazz = DLOGV1.class;
                    break;
            }
        }
        return clazz;
    }

    /**
     * @description: Class Field 对象缓冲区
     **/
    private static Map<Class<? extends DataJSONModel>, List<Field>> DataJSONModelFieldMap = new HashMap<>();

    /**
     * @description: 公开协议字段获取
     **/
    public static List<Field> Public_Fields(Class<? extends DataJSONModel> clazz) {
        List<Field> fields = DataJSONModelFieldMap.get(clazz);
        if (fields != null) {
            return fields;
        } else {
            fields = new ArrayList<>();
            try {
                DataClass class_annotation = clazz.getAnnotation(DataClass.class);
                if (class_annotation != null) {
                    List<String> ignorePublicFields = StringUtils.isNotBlank(class_annotation.ignorePublicField())
                            ?
                            Arrays.asList(class_annotation.ignorePublicField().split(","))
                            : new ArrayList<>();

                    DataJSONModel dataJSONModel = clazz.newInstance();

                    Map<String, Field> fieldMap = dataJSONModel.allAndroidField();

                    for (Field field : fieldMap.values()) {
                        if (!ignorePublicFields.contains(field.getName())) {
                            PublicField annotation = field.getAnnotation(PublicField.class);
                            if (annotation != null) {
                                fields.add(field);
                            }
                        }
                    }

                    Collections.sort(fields, new Comparator<Field>() {
                        @Override
                        public int compare(Field o1, Field o2) {
                            PublicField oa1 = o1.getAnnotation(PublicField.class);
                            PublicField oa2 = o2.getAnnotation(PublicField.class);
                            return oa1.index() - oa2.index();
                        }
                    });
                }
            } catch (InstantiationException | IllegalAccessException e) {
                e.printStackTrace();
            }
            DataJSONModelFieldMap.put(clazz, fields);
        }
        return fields;
    }

    /**
     * @description: 根据权限值计算条码秤权限值
     **/
    public static long disPowersToDisPower(List<Integer> disPowers) {
        if (disPowers == null || disPowers.isEmpty()) return 0;
        String binary = "";
        for (int i = 1; i <= BAR_SCALE_AUTH_LENGTH; i++) {
            binary = (disPowers.contains(i) ? '1' : '0') + binary;
        }
        return Long.parseLong(binary, 2);
    }

    public static List<Integer> disPowerToDisPowers(long disPower) {
        String binary = Long.toBinaryString(disPower);
        List<Integer> disPowers = new ArrayList<>();
        int dp = 1;
        for (int i = binary.length() - 1; i >= 0; i--) {
            if (binary.charAt(i) == '1') disPowers.add(dp);
            dp++;
        }
        return disPowers;
    }

    public static List<Integer> disPowerToDisPowers(String disPowerStr) {
        long disPower = 0;
        try {
            disPower = Long.parseLong(disPowerStr);
        } catch (Exception e) {
        }
        return disPowerToDisPowers(disPower);
    }

    /**
     * @param board_v  主板型号 PB1 PB2 YSB1/YSB2 => 自动转换成 PB1 PB2 PB0 没有配置文件
     * @param config_v 配置文件版本信息 SA001    S/T 国内/国外 A/C 条码/收银 001~099 标准版本 100+ 客户定制版本
     * @param app_v    应用版本信息
     * @description: 版本信息
     **/
    public static String version(String config_v, String board_v, String app_v) {
        board_v = StringUtils.isNotBlank(board_v) ? board_v : "YSB0";
        board_v = board_v.replace("YS", "P")
                .replace("ys", "P");
        config_v = StringUtils.isNotBlank(config_v) ? config_v : "DL000";
        app_v = StringUtils.isNotBlank(app_v) ? app_v : "V3.0.0";
        return String.format(VERSION_FORMAT, board_v, config_v, app_v);
    }

    /**
     * @param board_v  主板型号 PB1 PB2 YSB1/YSB2 => 自动转换成 PB1 PB2 PB0 没有配置文件
     * @param config_v 配置文件版本信息 SA001    S/T 国内/国外 A/C 条码/收银 001~099 标准版本 100+ 客户定制版本
     * @param app_v    应用版本信息
     * @param ai_v     R/D.原id.训练id.小版本.本地状态.服务器状态
     *                 R/D：正式/测试
     *                 原ID: 申请表ID
     *                 训练ID：训练完成表ID
     *                 小版本：小版本优化迭代
     *                 状态：1-关闭  0-开启
     * @description: 版本信息
     **/
    public static String version(String config_v, String board_v, String app_v, String ai_v) {
        return StringUtils.isNotBlank(ai_v) ?
                String.format("%s %s", version(config_v, board_v, app_v), ai_v)
                : version(config_v, board_v, app_v);
    }
}
