package com.jhscale.common.utils;

import com.jhscale.common.exception.GeneralInternational;
import com.jhscale.common.exception.ProfessionalException;
import com.jhscale.common.model.device.plu.DPLU;
import com.jhscale.common.model.device.plu.inner.DAutoDiscount;
import com.jhscale.common.model.device.plu.inner.DManualDiscount;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

import static com.jhscale.common.model.device.DConstant.ARRAY_SPLIT;
import static com.jhscale.common.model.device.DConstant.CLASS_PREFIX;

/**
 * @author lie_w
 * @title: DPLUUtils
 * @projectName common
 * @description: TODO
 * @date 2022/7/1519:34
 */
@Deprecated
public class DPLUUtils {

    /**
     * 判断字符串是否为空，如果不为空将,则直接转化为Integer类型
     *
     * @param t
     * @param <T>
     * @return
     */
    public static <T> Integer getResultInteger(T t) {
        return (Objects.isNull(t)) ? null : Integer.parseInt(String.valueOf(t));
    }

    /**
     * @param t
     * @param <T>
     * @return
     */
    public static <T> BigDecimal getResultBigDecimal(T t) {
        return (Objects.isNull(t)) ? null : new BigDecimal(String.valueOf(t));
    }

    /**
     * 获取手动折扣对象
     *
     * @param manualDiscount 手动折扣字符串
     * @return
     */
    @SuppressWarnings("all")
    public static List<DManualDiscount> getDManualDiscount(String manualDiscount) {
        List<DManualDiscount> manualDiscountList = new ArrayList<>();
        if (StringUtils.isBlank(manualDiscount)) {
            return null;
        }
        String[] split = StringUtils.split(manualDiscount, "|");
        if (Objects.isNull(split) && split.length <= 0) {
            return null;
        }
        // 手动折扣限制
        String dmanualDiscounts = split[0];
        String[] dmanualDiscountss = dmanualDiscounts.split("#");
        // 上限
        String upperLimit = dmanualDiscountss[0];
        // 下限
        String lowerLimit = dmanualDiscountss[1];
        // 上下限折扣类型
        String manualDiscountTypes = split[1];
        String[] manualDiscountTypess = manualDiscountTypes.split("#");
        // 上限折扣类型
        String upperDiscountType = manualDiscountTypess[0];
        // 下限折扣类型
        String lowerDiscountType = manualDiscountTypess[1];
        // 值
        String discounts = split[2];
        String[] discountss = discounts.split("#");
        //  上限值 # 下限值
        // 上限值
        String upperValue = discountss[0];
        // 下限值
        String lowerValue = discountss[1];
        // 添加上限值
        manualDiscountList.add(new DManualDiscount()
                .setDiscount(getResultInteger(upperLimit),
                        getResultInteger(upperDiscountType),
                        getResultBigDecimal(upperValue)));
        // 添加下限值
        manualDiscountList.add(new DManualDiscount()
                .setDiscount(getResultInteger(lowerLimit),
                        getResultInteger(lowerDiscountType),
                        getResultBigDecimal(lowerValue)));
        return manualDiscountList;
    }

    /**
     * 获取自动折扣对象
     *
     * @param autoDiscount 自动折扣字符串
     * @return
     */
    @SuppressWarnings("all")
    public static DAutoDiscount getAutoDiscount(String autoDiscount) {
        if (StringUtils.isBlank(autoDiscount)) {
            return null;
        }
        DAutoDiscount dAutoDiscount = new DAutoDiscount();
        // 折扣类型 # 激活日 # 折扣值 # 区间值最小值 # 区间值最大值 #区间类型
        String[] split = StringUtils.split(autoDiscount, "#");
        //折扣类型
        String discountType = split[0];
        //激活日
        String activation = split[1];
        //区间值最小值
        String min = split[2];
        //区间值最大值
        String max = split[3];
        //折扣值
        String discountValue = split[4];
        //区间类型
        String intervalType = null;
        if (split.length > 5) {
            intervalType = split[5];
        }
        return dAutoDiscount.setType(getResultInteger(discountType))
                .setDate(getResultInteger(activation))
                .setLower(getResultBigDecimal(min))
                .setUpper(getResultBigDecimal(max))
                .setDiscount(getResultBigDecimal(discountValue))
                .setIntervalType(getResultInteger(intervalType));
    }

    /**
     * @param autoDiscount
     * @return
     * @description 获取自动折扣信息
     */
    @SuppressWarnings("all")
    private static List<DAutoDiscount> getAutoDiscount(String... autoDiscount) {
        if (Objects.isNull(autoDiscount)) {
            return null;
        }
        if (autoDiscount.length <= 0) {
            return null;
        }
        List<DAutoDiscount> autoDiscountList = new ArrayList<>();
        Arrays.stream(autoDiscount).forEach(i -> autoDiscountList.add(getAutoDiscount(i)));
        return autoDiscountList;
    }

    /**
     * @description: 数据组装
     **/
    public static String assemble(DPLU... plus) {
        return assemble(true, plus);
    }

    /**
     * @description: 数据组装
     **/
    public static String assemble(List<DPLU> plus) {
        return assemble(true, plus);
    }

    /**
     * @description: 数据组装
     **/
    public static String assemble(boolean base64, DPLU... plus) {
        return assemble(base64, Arrays.asList(plus));
    }

    /**
     * @description: 数据组装
     **/
    @SuppressWarnings("all")
    public static String assemble(boolean base64, List<DPLU> plus) {
        if (plus != null && !plus.isEmpty()) {
            StringBuffer buffer = new StringBuffer()
                    .append(plus.get(0).getClass().getName())
                    .append(CLASS_PREFIX);
            for (DPLU dplu : plus) {
                buffer.append(dplu.assemble(false))
                        .append(ARRAY_SPLIT);
            }
            String result = buffer.substring(0, buffer.length() - ARRAY_SPLIT.length());
            return base64 ? Base64Utils.gzipString(result) : result;
        }
        return null;
    }

    /**
     * @description: 数据内容解析
     **/
    public static List<DPLU> analyze(String content) throws ProfessionalException {
        return analyze(content, true);
    }

    /**
     * @description: 数据内容解析
     **/
    @SuppressWarnings("all")
    public static List<DPLU> analyze(String content, boolean base64) throws ProfessionalException {
        if (StringUtils.isNotBlank(content)) {
            content = base64 ? Base64Utils.ungzipString(content) : content;
            if (content.contains(CLASS_PREFIX)) {
                String[] contentArr = content.split(CLASS_PREFIX);
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(contentArr[0]);
                } catch (Exception e) {
                }
                if (clazz == null)
                    throw new ProfessionalException(GeneralInternational.未找到对象信息);

                List<DPLU> plus = new ArrayList<>();
                String[] pluStrArr = contentArr[1].split(ARRAY_SPLIT);
                for (String pluStr : pluStrArr) {
                    DPLU dplu = null;
                    try {
                        dplu = (DPLU) clazz.newInstance();
                    } catch (Exception e) {
                    }
                    plus.add((DPLU) dplu.parse(pluStr, false));
                }
                return plus;
            }
        }
        return null;
    }
}
