package com.jhscale.common.utils;

import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;

import java.io.*;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/**
 * @author lie_w
 * @title: GZIPUtils
 * @projectName common
 * @description: TODO
 * @date 2022/10/818:27
 */
public class GZIPUtils {

    // 默认字符集
    private static final String CHARSET = "ISO-8859-1";

    private GZIPUtils() {
    }

//    /**
//     * 使用gzip进行压缩
//     */
//    public static String gzip(String primStr) {
//        if (primStr == null || primStr.length() == 0) {
//            return primStr;
//        }
//
//        ByteArrayOutputStream out = new ByteArrayOutputStream();
//
//        GZIPOutputStream gzip = null;
//        try {
//            gzip = new GZIPOutputStream(out);
//            gzip.write(primStr.getBytes());
//        } catch (IOException e) {
//            e.printStackTrace();
//        } finally {
//            if (gzip != null) {
//                try {
//                    gzip.close();
//                } catch (IOException e) {
//                    e.printStackTrace();
//                }
//            }
//        }
//        return new sun.misc.BASE64Encoder().encode(out.toByteArray());
//    }
//
//    /**
//     * <p>Description:使用gzip进行解压缩</p>
//     *
//     * @param compressedStr
//     * @return
//     */
//    public static String gunzip(String compressedStr) {
//        if (compressedStr == null) {
//            return null;
//        }
//
//        ByteArrayOutputStream out = new ByteArrayOutputStream();
//        ByteArrayInputStream in = null;
//        GZIPInputStream ginzip = null;
//        byte[] compressed = null;
//        String decompressed = null;
//        try {
//            compressed = new sun.misc.BASE64Decoder().decodeBuffer(compressedStr);
//            in = new ByteArrayInputStream(compressed);
//            ginzip = new GZIPInputStream(in);
//
//            byte[] buffer = new byte[1024];
//            int offset = -1;
//            while ((offset = ginzip.read(buffer)) != -1) {
//                out.write(buffer, 0, offset);
//            }
//            decompressed = out.toString();
//        } catch (IOException e) {
//            e.printStackTrace();
//        } finally {
//            if (ginzip != null) {
//                try {
//                    ginzip.close();
//                } catch (IOException e) {
//                }
//            }
//            if (in != null) {
//                try {
//                    in.close();
//                } catch (IOException e) {
//                }
//            }
//            if (out != null) {
//                try {
//                    out.close();
//                } catch (IOException e) {
//                }
//            }
//        }
//        return decompressed;
//    }
//
//    /**
//     * 使用zip进行压缩
//     *
//     * @param str 压缩前的文本
//     * @return 返回压缩后的文本
//     */
//    public static final String zip(String str) {
//        if (str == null)
//            return null;
//        byte[] compressed;
//        ByteArrayOutputStream out = null;
//        ZipOutputStream zout = null;
//        String compressedStr = null;
//        try {
//            out = new ByteArrayOutputStream();
//            zout = new ZipOutputStream(out);
//            zout.putNextEntry(new ZipEntry("0"));
//            zout.write(str.getBytes());
//            zout.closeEntry();
//            compressed = out.toByteArray();
//            compressedStr = new sun.misc.BASE64Encoder().encodeBuffer(compressed);
//        } catch (IOException e) {
//            compressed = null;
//        } finally {
//            if (zout != null) {
//                try {
//                    zout.close();
//                } catch (IOException e) {
//                }
//            }
//            if (out != null) {
//                try {
//                    out.close();
//                } catch (IOException e) {
//                }
//            }
//        }
//        return compressedStr;
//    }
//
//    /**
//     * 使用zip进行解压缩
//     *
//     * @param compressedStr 压缩后的文本
//     * @return 解压后的字符串
//     */
//    public static final String unzip(String compressedStr) {
//        if (compressedStr == null) {
//            return null;
//        }
//
//        ByteArrayOutputStream out = null;
//        ByteArrayInputStream in = null;
//        ZipInputStream zin = null;
//        String decompressed = null;
//        try {
//            byte[] compressed = new sun.misc.BASE64Decoder().decodeBuffer(compressedStr);
//            out = new ByteArrayOutputStream();
//            in = new ByteArrayInputStream(compressed);
//            zin = new ZipInputStream(in);
//            zin.getNextEntry();
//            byte[] buffer = new byte[1024];
//            int offset = -1;
//            while ((offset = zin.read(buffer)) != -1) {
//                out.write(buffer, 0, offset);
//            }
//            decompressed = out.toString();
//        } catch (IOException e) {
//            decompressed = null;
//        } finally {
//            if (zin != null) {
//                try {
//                    zin.close();
//                } catch (IOException e) {
//                }
//            }
//            if (in != null) {
//                try {
//                    in.close();
//                } catch (IOException e) {
//                }
//            }
//            if (out != null) {
//                try {
//                    out.close();
//                } catch (IOException e) {
//                }
//            }
//        }
//        return decompressed;
//    }

    /**
     * @description: 压缩
     **/
    public static String compress(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        ByteArrayOutputStream out = null;
        GZIPOutputStream gzip = null;
        try {
            out = new ByteArrayOutputStream();
            gzip = new GZIPOutputStream(out);
            gzip.write(str.getBytes());
            gzip.close();
            return out.toString(CHARSET);
//            return rsaEncryptDecrypt.encode(out.toByteArray());
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (gzip != null) {
                try {
                    gzip.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }

            if (out != null) {
                try {
                    out.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /**
     * @description: 解压缩
     **/
    public static String uncompress(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }

        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        GZIPInputStream gunzip = null;
        try {
            out = new ByteArrayOutputStream();
            in = new ByteArrayInputStream(str.getBytes(CHARSET));
//            in = new ByteArrayInputStream(rsaEncryptDecrypt.decode(str));
            gunzip = new GZIPInputStream(in);
            byte[] buffer = new byte[256];
            int n;
            while ((n = gunzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
            // toString()使用平台默认编码，也可以显式的指定如toString("GBK")
            return out.toString();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (gunzip != null) {
                try {
                    gunzip.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (in != null) {
                try {
                    in.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (out != null) {
                try {
                    out.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /**
     * @description: 解压缩 7z
     **/
    public static File unzip7z(File source, File target) {
        if (source == null || !source.exists()) return target;
        if (target == null) {
            target = new File(source.getAbsolutePath().substring(0, source.getAbsolutePath().lastIndexOf(".7z")));
        }
        if (!target.exists()) target.mkdirs();

        SevenZFile sevenZFile = null;
        try {
            sevenZFile = new SevenZFile(source);
            SevenZArchiveEntry entry = null;
            while ((entry = sevenZFile.getNextEntry()) != null) {
                if (!entry.isDirectory()) {
                    OutputStream out = null;
                    BufferedOutputStream bos = null;
                    try {
                        File file = new File(target, entry.getName());
                        if (!file.exists()) {
                            new File(file.getParent()).mkdirs();   //创建此文件的上层目录
                        }
                        out = new FileOutputStream(file);
                        bos = new BufferedOutputStream(out);
                        int len = -1;
                        byte[] buf = new byte[(int) entry.getSize()];
                        while ((len = sevenZFile.read(buf)) != -1) {
                            bos.write(buf, 0, len);
                        }
                        bos.flush();
                    } catch (IOException e) {
                        e.printStackTrace();
                    } finally {
                        if (out != null) {
                            try {
                                out.close();
                            } catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        if (bos != null) {
                            try {
                                bos.close();
                            } catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (sevenZFile != null) {
                try {
                    sevenZFile.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return target;
    }

    /**
     * @description: 7z压缩（目录）
     **/
    public static File zip7z(File source, File target) {
        if (target == null) {
            target = new File(source.getParent(), source.getName() + ".7z");
        }
        SevenZOutputFile sevenZOutputFile = null;
        try {
            if (!target.exists()) target.createNewFile();
            sevenZOutputFile = new SevenZOutputFile(target);
            for (File file : source.listFiles()) {
                SevenZArchiveEntry entry = sevenZOutputFile.createArchiveEntry(file, file.getName());
                sevenZOutputFile.putArchiveEntry(entry);
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file);
                    byte[] b = new byte[1024];
                    int count = 0;
                    while ((count = in.read(b)) > 0) {
                        sevenZOutputFile.write(b, 0, count);
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                } finally {
                    if (in != null) in.close();
                }
                sevenZOutputFile.closeArchiveEntry();
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (sevenZOutputFile != null) {
                try {
                    sevenZOutputFile.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return target;
    }

//    public static void main(String[] args) {
//        File unzipNull = null;
//        unzipNull = unzip7z(new File("F:\\JHScale\\Rely\\common\\1.7z"), unzipNull);
//        File unzip = new File("F:\\JHScale\\Rely\\common\\456");
//        unzip = unzip7z(new File("F:\\JHScale\\Rely\\common\\1.7z"), unzip);
//        File z7zipFile = zip7z(unzipNull, new File("F:\\JHScale\\Rely\\common\\11.7z"));
//        zip7z(unzip, null);
//    }
}
