package com.jhscale.common.utils;

import com.jhscale.common.em.ServerExp;
import com.jhscale.common.exception.TechnologyException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;

/**
 * @author lie_w
 * @title: HttpUtils
 * @projectName common
 * @description: TODO
 * @date 2020-11-153:08
 */
public class HttpUtils {

    private final static Logger LOGGER = LoggerFactory.getLogger(HttpUtils.class);

    private static CloseableHttpClient httpClient;

    static {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(100);
        cm.setDefaultMaxPerRoute(20);
        cm.setDefaultMaxPerRoute(50);
        httpClient = HttpClients.custom().setConnectionManager(cm).build();
    }

    /**
     * @Description HTTP Get 请求
     * @Author wanglie
     * @Date 12:55 2018/12/20
     **/
    public static String get(String url) throws TechnologyException {
        CloseableHttpResponse response = null;
        BufferedReader in = null;
        String result = "";
        try {
            HttpGet httpGet = new HttpGet(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpGet.setConfig(requestConfig);
            httpGet.setConfig(requestConfig);
            httpGet.addHeader("Content-type", "application/json; charset=utf-8");
            httpGet.setHeader("Accept", "application/json");
            response = httpClient.execute(httpGet);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer sb = new StringBuffer("");
            String line = "";
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line + NL);
            }
            result = sb.toString();
        } catch (IOException e) {
            LOGGER.error("HTTP Get Error,exp:{}", e.getMessage(), e);
            throw new TechnologyException(e, ServerExp.IO异常);
        } finally {
            try {
                if (null != response) {
                    response.close();
                }
            } catch (IOException e) {
            }
            try {
                if (null != in) {
                    in.close();
                }
            } catch (IOException e) {
            }
        }
        return result.trim();
    }

    /**
     * @Description HTTP Get 请求
     * @Author wanglie
     * @Date 12:55 2018/12/20
     **/
    public static String get(String url, Map<String, String> heads) {
        CloseableHttpResponse response = null;
        BufferedReader in = null;
        String result = "";
        try {
            HttpGet httpGet = new HttpGet(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpGet.setConfig(requestConfig);
            httpGet.setConfig(requestConfig);
            httpGet.addHeader("Content-type", "application/json; charset=utf-8");
            if (heads != null && !heads.isEmpty()) {
                heads.forEach((k, v) -> {
                    httpGet.addHeader(k, v);
                });
            }
            httpGet.setHeader("Accept", "application/json");
            response = httpClient.execute(httpGet);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer sb = new StringBuffer("");
            String line = "";
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line + NL);
            }
            result = sb.toString();
        } catch (IOException e) {
            LOGGER.error("HTTP Get Error,exp:{}", e.getMessage(), e);
        } finally {
            try {
                if (null != response) {
                    response.close();
                }
            } catch (IOException e) {
            }
            try {
                if (null != in) {
                    in.close();
                }
            } catch (IOException e) {
            }
        }
        return result.trim();
    }

    /**
     * @Description HTTP Post 请求
     * @Author wanglie
     * @Date 12:56 2018/12/20
     **/
    public static String post(String url, String jsonString) {
        CloseableHttpResponse response = null;
        BufferedReader in = null;
        String result = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            httpPost.setConfig(requestConfig);
            httpPost.addHeader("Content-type", "application/json; charset=utf-8");
            httpPost.setHeader("Accept", "application/json");
            httpPost.setEntity(new StringEntity(jsonString, Charset.forName("UTF-8")));
            response = httpClient.execute(httpPost);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer sb = new StringBuffer("");
            String line = "";
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line + NL);
            }
            result = sb.toString();
        } catch (IOException e) {
            LOGGER.error("HTTP Post Error,exp:{}", e.getMessage(), e);
        } finally {
            try {
                if (null != response) {
                    response.close();
                }
            } catch (IOException e) {
            }
            try {
                if (null != in) {
                    in.close();
                }
            } catch (IOException e) {
            }
        }
        return result.trim();
    }

    /**
     * @Description HTTP Post 请求
     * @Author wanglie
     * @Date 12:56 2018/12/20
     **/
    public static String post(String url, String jsonString, Map<String, String> heads) {
        CloseableHttpResponse response = null;
        BufferedReader in = null;
        String result = "";
        try {
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            httpPost.setConfig(requestConfig);
            httpPost.addHeader("Content-type", "application/json; charset=utf-8");
            if (heads != null && !heads.isEmpty()) {
                heads.forEach((k, v) -> {
                    httpPost.addHeader(k, v);
                });
            }
            httpPost.setHeader("Accept", "application/json");
            httpPost.setEntity(new StringEntity(jsonString, Charset.forName("UTF-8")));
            response = httpClient.execute(httpPost);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer sb = new StringBuffer("");
            String line = "";
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line + NL);
            }
            result = sb.toString();
        } catch (IOException e) {
            LOGGER.error("HTTP Post Error,exp:{}", e.getMessage(), e);
        } finally {
            try {
                if (null != response) {
                    response.close();
                }
            } catch (IOException e) {
            }
            try {
                if (null != in) {
                    in.close();
                }
            } catch (IOException e) {
            }
        }
        return result.trim();
    }

    /**
     * @Description HTTP Post 请求
     * @Author wanglie
     * @Date 12:56 2018/12/20
     **/
    public static String upload(String url, File file) throws TechnologyException {
        return upload(url, FileUtils.getFileBytes(file));
    }

    /**
     * @Description HTTP Post 请求
     * @Author wanglie
     * @Date 12:56 2018/12/20
     **/
    public static String upload(String url, InputStream inputStream) throws TechnologyException {
        return upload(url, FileUtils.inputStreamToBytes(inputStream));
    }

    /**
     * @Description HTTP Post 请求
     * @Author wanglie
     * @Date 12:56 2018/12/20
     **/
    public static String upload(String url, byte[] bytes) {
        CloseableHttpResponse response = null;
        BufferedReader in = null;
        String result = "";
        try {
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create()
                    .addBinaryBody("media", bytes)
                    .setMode(HttpMultipartMode.RFC6532);

            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity(multipartEntityBuilder.build());
            httpPost.setHeader("Content-Type", ContentType.MULTIPART_FORM_DATA.toString());
            response = httpClient.execute(httpPost);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer sb = new StringBuffer("");
            String line = "";
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line + NL);
            }
            result = sb.toString();
        } catch (IOException e) {
            LOGGER.error("HTTP Post Upload byte[] Error,exp:{}", e.getMessage(), e);
        } finally {
            try {
                if (null != response) {
                    response.close();
                }
            } catch (IOException e) {
            }
            try {
                if (null != in) {
                    in.close();
                }
            } catch (IOException e) {
            }
        }
        return result.trim();
    }

    /**
     * @description: 文件Get 下载
     **/
    public static void download(String url, File file) {
        download(url, file, "GET");
    }

    /**
     * @description: 文件下载
     **/
    public static void download(String url, File file, String method) {
        if (file == null) return;
        // try {
        if (!file.exists()) {
            File parentFile = file.getParentFile();
            if (!parentFile.exists()) parentFile.mkdirs();
            //  file.createNewFile();
        }
        // } catch (IOException e) {
        //     LOGGER.error("File Create Fail,exp:{}", e.getMessage(), e);
        // }
        FileOutputStream fileOut = null;
        HttpURLConnection conn = null;
        InputStream inputStream = null;
        BufferedOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            // 建立链接
            URL httpUrl = new URL(url);
            conn = (HttpURLConnection) httpUrl.openConnection();
            //以Post方式提交表单，默认get方式
            conn.setRequestMethod(method);
            conn.setDoInput(true);
            conn.setDoOutput(true);
            // post方式不能使用缓存
            conn.setUseCaches(false);
            //连接指定的资源
            conn.connect();
            //获取网络输入流
            inputStream = conn.getInputStream();
            bis = new BufferedInputStream(inputStream);
            //写入到文件（注意文件保存路径的后面一定要加上文件的名称）
            fileOut = new FileOutputStream(file);
            bos = new BufferedOutputStream(fileOut);
            byte[] buf = new byte[4096];
            int length = bis.read(buf);
            //保存文件
            while (length != -1) {
                bos.write(buf, 0, length);
                length = bis.read(buf);
            }
        } catch (FileNotFoundException e) {
            LOGGER.debug("File Download Fail,Url {} Not Found:{}", url, e.getMessage(), e);
        } catch (Exception e) {
            LOGGER.error("File Download Fail {},exp:{}", url, e.getMessage(), e);
        } finally {
            try {
                if (bos != null) bos.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (bis != null) bis.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (fileOut != null) fileOut.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (inputStream != null) inputStream.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
            if (conn != null) conn.disconnect();
        }
    }
}
