package com.jhscale.common.utils;

import com.jhscale.common.model.inter.GJSONModel;
import com.jhscale.common.model.simple.JSONModel;

import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.*;

/**
 * @author lie_w
 * @title: MD5Utils
 * @projectName common
 * @description: TODO
 * @date 2020-10-2215:16
 */
public class MD5Utils {

    private static final String hexDigits[] = {"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    private MD5Utils() {
    }

    /**
     * @description: MD5加密
     **/
    public static String stringToMD5(String plainText) {
        //定义一个字节数组
        byte[] secretBytes = null;
        try {
            // 生成一个MD5加密计算摘要
            MessageDigest md = MessageDigest.getInstance("MD5");
            //对字符串进行加密
            md.update(plainText.getBytes());
            //获得加密后的数据
            secretBytes = md.digest();
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("没有md5这个算法！");
        }
        //将加密后的数据转换为16进制数字
        String md5code = new BigInteger(1, secretBytes).toString(16);
        // 如果生成数字未满32位，需要前面补0
        for (int i = 0; i < 32 - md5code.length(); i++) {
            md5code = "0" + md5code;
        }
        return md5code;
    }

    /**
     * @description: 带中文字符串转MD5
     **/
    public static String str2MD5(String plainText) {
        byte[] hash;
        try {
            hash = MessageDigest.getInstance("MD5").digest(plainText.getBytes("UTF-8"));
        } catch (NoSuchAlgorithmException var7) {
            throw new RuntimeException("MD5 should be supported?", var7);
        } catch (UnsupportedEncodingException var8) {
            throw new RuntimeException("UTF-8 should be supported?", var8);
        }

        StringBuilder hex = new StringBuilder(hash.length * 2);
        byte[] var6 = hash;
        int var5 = hash.length;

        for (int var4 = 0; var4 < var5; ++var4) {
            byte b = var6[var4];
            if ((b & 255) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 255));
        }
        return hex.toString();
    }

    public static String convertMD5(String inStr) {
        char[] a = inStr.toCharArray();
        for (int i = 0; i < a.length; i++) {
            a[i] = (char) (a[i] ^ 't');
        }
        return new String(a);
    }

    public static String string2MD5(String inStr) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        char[] charArray = inStr.toCharArray();
        byte[] byteArray = new byte[charArray.length];

        for (int i = 0; i < charArray.length; i++)
            byteArray[i] = (byte) charArray[i];
        byte[] md5Bytes = md5.digest(byteArray);
        StringBuffer hexValue = new StringBuffer();
        for (int i = 0; i < md5Bytes.length; i++) {
            int val = ((int) md5Bytes[i]) & 0xff;
            if (val < 16)
                hexValue.append("0");
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }


    public static String md5(File file) {
        try {
            MessageDigest msgDigest = null;
            try {
                msgDigest = MessageDigest.getInstance("MD5");
            } catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(
                        "System doesn't support MD5 algorithm.");
            }

            FileInputStream fileInputStream = new FileInputStream(file);

            byte[] bs = new byte[1024];
            while (fileInputStream.read(bs) != -1) {
                msgDigest.update(bs);
            }
            byte[] bytes = msgDigest.digest();
            if (fileInputStream != null)
                fileInputStream.close();
            return byteToString(bytes);
        } catch (java.io.IOException e) {
            e.printStackTrace();
            return null;
        }
    }


    private static String byteToString(byte[] bytes) {
        byte tb;
        char low;
        char high;
        char tmpChar;
        String md5Str = "";
        for (int i = 0; i < bytes.length; i++) {
            tb = bytes[i];
            tmpChar = (char) ((tb >>> 4) & 0x000f);
            if (tmpChar >= 10) {
                high = (char) (('a' + tmpChar) - 10);
            } else {
                high = (char) ('0' + tmpChar);
            }
            md5Str += high;
            tmpChar = (char) (tb & 0x000f);
            if (tmpChar >= 10) {
                low = (char) (('a' + tmpChar) - 10);
            } else {
                low = (char) ('0' + tmpChar);
            }
            md5Str += low;
        }
        return md5Str;
    }

    public static String md5(byte[] bs) {
        MessageDigest msgDigest = null;
        try {
            msgDigest = MessageDigest.getInstance("MD5");
        } catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(
                    "System doesn't support MD5 algorithm.");
        }
        msgDigest.update(bs);
        byte[] bytes = msgDigest.digest();
        return byteToString(bytes);
    }

    public static byte[] md5Byte(String str) {
        byte[] utfBytes;
        try {
            utfBytes = str.getBytes("UTF-8");
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(utfBytes);
            return mdTemp.digest();
        } catch (Exception e) {
            e.printStackTrace();
            e.printStackTrace();
            return null;
        }
    }

    /**
     * @description: MD5加密
     **/
    public static String MD5Encode(String origin, String charsetname) {
        String resultString = null;
        try {
            resultString = new String(origin);
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (charsetname == null || "".equals(charsetname))
                resultString = byteArrayToHexString(md.digest(resultString.getBytes()));
            else
                resultString = byteArrayToHexString(md.digest(resultString.getBytes(charsetname)));
        } catch (Exception exception) {
        }
        return resultString;
    }

    private static String byteArrayToHexString(byte b[]) {
        StringBuffer resultSb = new StringBuffer();
        for (int i = 0; i < b.length; i++)
            resultSb.append(byteToHexString(b[i]));

        return resultSb.toString();
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0)
            n += 256;
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }

    /**
     * @description: 构建MD5签名源信息信息
     **/
    public static String bulidSourceSignature(Map map, String key) {
        if (map != null && !map.isEmpty()) {
            List<String> list = new ArrayList<>();
            map.forEach((k, v) -> {
                if (!"sign".equalsIgnoreCase(k.toString()) && Objects.nonNull(v)) {
                    String val = k + "=";
                    if (v instanceof String || v instanceof Boolean || v instanceof Integer || v instanceof Double || v instanceof Long) {
                        val += (v + "&");
                    } else if (v instanceof Date) {
                        val += (DateUtils.getString((Date) v) + "&");
                    } else if (v instanceof BigDecimal) {
                        val += (((BigDecimal) v).doubleValue() + "&");
                    } else if (v instanceof JSONModel) {
                        val += (((JSONModel) v).toJSON() + "&");
                    } else if (v instanceof List || v instanceof Map) {
                        val += JSONUtils.objectToJSON(v) + "&";
                    } else {
                        String str = v.toString();
                        if (str.contains("@")) {
                            val += (JSONUtils.objectToJSON(v) + "&");
                        } else {
                            val += (str + "&");
                        }
                    }
                    list.add(val);
                }
            });

            int size = list.size();
            String[] arrayToSort = list.toArray(new String[size]);
            Arrays.sort(arrayToSort, String.CASE_INSENSITIVE_ORDER);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < size; i++) {
                sb.append(arrayToSort[i]);
            }
            String result = sb + "key=" + key;
            // System.out.println(result);
            return result;
        }
        return "";
    }

    /**
     * @description: 构建MD5签名源信息信息
     **/
    public static String bulidSourceSignature_date(Map map, String key) {
        if (map != null && !map.isEmpty()) {
            List<String> list = new ArrayList<>();
            map.forEach((k, v) -> {
                if (!"sign".equalsIgnoreCase(k.toString()) && Objects.nonNull(v)) {
                    String val = k + "=";
                    if (v instanceof String || v instanceof Boolean || v instanceof Integer || v instanceof Double || v instanceof Long) {
                        val += (v + "&");
                    } else if (v instanceof Date) {
                        val += (DateUtils.getString((Date) v) + "&");
                    } else if (v instanceof BigDecimal) {
                        val += (((BigDecimal) v).doubleValue() + "&");
                    } else if (v instanceof JSONModel) {
                        val += (((JSONModel) v).toJSON() + "&");
                    } else if (v instanceof List || v instanceof Map) {
                        val += JSONUtils.objectToJSON(v) + "&";
                    } else {
                        String str = v.toString();
                        if (str.contains("@")) {
                            val += (JSONUtils.objectToJSON(v) + "&");
                        } else {
                            val += (str + "&");
                        }
                    }
                    list.add(val);
                }
            });

            int size = list.size();
            String[] arrayToSort = list.toArray(new String[size]);
            Arrays.sort(arrayToSort, String.CASE_INSENSITIVE_ORDER);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < size; i++) {
                sb.append(arrayToSort[i]);
            }
            String result = sb + "key=" + key;
            // System.out.println(result);
            return result;
        }
        return "";
    }

    /**
     * @description: 构建MD5签名源信息信息
     **/
    public static String bulidSourceSignature_ad(Map map, String key) {
        if (map != null && !map.isEmpty()) {
            List<String> list = new ArrayList<>();
            map.forEach((k, v) -> {
                if (!"sign".equalsIgnoreCase(k.toString()) && Objects.nonNull(v)) {
                    String val = k + "=";
                    if (v instanceof String || v instanceof Boolean || v instanceof Integer || v instanceof Double || v instanceof Long) {
                        val += (v + "&");
                    } else if (v instanceof Date) {
                        val += (DateUtils.getString((Date) v) + "&");
                    } else if (v instanceof BigDecimal) {
                        val += (((BigDecimal) v).doubleValue() + "&");
                    } else if (v instanceof GJSONModel) {
                        val += (((GJSONModel) v).toJSON() + "&");
                    } else if (v instanceof JSONModel || v instanceof com.jhscale.common.model.inter.JSONModel) {
                        val += GJSONUtils.objectToJSON(v) + "&";
                    } else if (v instanceof List || v instanceof Map) {
                        val += GJSONUtils.objectToJSON(v) + "&";
                    } else {
                        String str = v.toString();
                        if (str.contains("@")) {
                            val += (GJSONUtils.objectToJSON(v) + "&");
                        } else {
                            val += (str + "&");
                        }
                    }
                    list.add(val);
                }
            });

            int size = list.size();
            String[] arrayToSort = list.toArray(new String[size]);
            Arrays.sort(arrayToSort, String.CASE_INSENSITIVE_ORDER);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < size; i++) {
                sb.append(arrayToSort[i]);
            }
            String result = sb + "key=" + key;
            // System.out.println(result);
            return result;
        }
        return "";
    }

    /**
     * @description: 构建MD5签名
     **/
    public static String bulidMD5Signature(String result) {
        return MD5Utils.str2MD5(result).toUpperCase();
    }

    /**
     * @description: 构建MD5签名信息
     **/
    public static String bulidMD5Signature(Map map, String key) {
        return bulidMD5Signature(bulidSourceSignature(map, key));
    }

    /**
     * @description: 构建MD5签名信息
     **/
    public static String bulidMD5Signature_ad(Map map, String key) {
        return bulidMD5Signature(bulidSourceSignature_ad(map, key));
    }
}
