package com.jhscale.common.utils;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

/**
 * @author lie_w
 * @title: PinyinUtils
 * @projectName ysscale-base
 * @description: TODO
 * @date 2019/8/115:33
 */
public class PinyinUtils {

    /**
     * 得到 全拼
     *
     * @param src
     * @return
     */
    public static String getPingYin(String src) {
        char[] t1 = null;
        t1 = src.toCharArray();
        String[] t2 = new String[t1.length];
        HanyuPinyinOutputFormat t3 = new HanyuPinyinOutputFormat();
        t3.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        t3.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        t3.setVCharType(HanyuPinyinVCharType.WITH_V);
        String t4 = "";
        int t0 = t1.length;
        try {
            for (int i = 0; i < t0; i++) {
                // 判断是否为汉字字符
                if (Character.toString(t1[i]).matches("[\\u4E00-\\u9FA5]+")) {
                    t2 = PinyinHelper.toHanyuPinyinStringArray(t1[i], t3);
                    t4 += t2[0];
                } else {
                    t4 += Character.toString(t1[i]);
                }
            }
            return t4;
        } catch (BadHanyuPinyinOutputFormatCombination e1) {
            e1.printStackTrace();
        }
        return t4;
    }

    /**
     * 得到 全拼（不包括特殊符号）
     *
     * @param src
     * @return
     */
    public static String getPingYinNoMark(String src) {
        String convert = src.replaceAll("[^0-9a-zA-Z\u4e00-\u9fa5.，,。？“”]+", "");
        return getPingYin(convert);
    }

    /**
     * 得到中文首字母（包括字符串中字母）
     *
     * @param str
     * @return
     */
    public static String getPinYinHeadChar(String str) {

        String convert = "";
        for (int j = 0; j < str.length(); j++) {
            char word = str.charAt(j);
            String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray(word);
            if (pinyinArray != null) {
                convert += pinyinArray[0].charAt(0);
            } else {
                convert += word;
            }
        }
        return convert;
    }

    /**
     * 得到中文首字母（包括字符串中字母）
     *
     * @param str
     * @return
     */
    public static String getPinYinHeadCharUpperCase(String str) {
        return getPinYinHeadChar(str).toUpperCase();
    }

    /**
     * 得到中文首字母（包括字符串中字母数字,不包括特殊符号）
     *
     * @param str
     * @return
     */
    public static String getPinYinHeadCharNoMark(String str) {
        String convert = str.replaceAll("[^0-9a-zA-Z\u4e00-\u9fa5.，,。？“”]+", "");
        return getPinYinHeadChar(convert);
    }


    /**
     * 将字符串转移为ASCII码
     *
     * @param cnStr
     * @return
     */
    public static String getCnASCII(String cnStr) {
        StringBuffer strBuf = new StringBuffer();
        byte[] bGBK = cnStr.getBytes();
        for (int i = 0; i < bGBK.length; i++) {
            // System.out.println(Integer.toHexString(bGBK[i]&0xff));
            strBuf.append(Integer.toHexString(bGBK[i] & 0xff));
        }
        return strBuf.toString();
    }


//    public static void main(String[] args) {
//        String cnStr = "知A鲜到?市-场!方2商_户";
//        System.out.println(getPingYinNoMark(cnStr));
//        System.out.println(getPingYinNoMark(cnStr).toUpperCase());
//        System.out.println(getPingYinNoMark(cnStr).replaceAll("[^a-z^A-Z^]", ""));
//        String str = getPingYinNoMark(cnStr).replaceAll("[^a-z^A-Z^]", "");
//        if (StringUtils.isNoneBlank(str)) {//判断是否有首字母
//            str = str.substring(0, 1).toUpperCase();//转换为大写
//        }
//        System.out.println(str);
//        if (StringUtils.isNoneBlank(str)) {
//            str = str.substring(0, 1).toLowerCase();//转换为小写
//        }
//        System.out.println(str);
//    }
}
