package com.jhscale.common.utils;

import com.jhscale.common.content.JHContents;
import com.jhscale.common.em.BusinessData;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.*;
import java.util.Date;

/**
 * @author lie_w
 * @title: PojoUtils
 * @projectName common
 * @description: TODO
 * @date 2020-11-2015:09
 */
public class PojoUtils {

    // private static final Logger LOGGER = LoggerFactory.getLogger(PojoUtils.class);

    private PojoUtils() {
    }

    /**
     * @Description 初始化使用默认值
     * @Author wanglie
     * @Date 15:03 2018/11/10
     **/
    public static final <T> void init(T entity) {
        init(entity, JHContents.DEFAULT_INVENT_CODE);
    }

    /**
     * @Description 初始化使用指定值
     * @Author wanglie
     * @Date 15:03 2018/11/10
     **/
    public static final <T> void init(T entity, Long createMan) {
        Class<?> entityClass = entity.getClass();
        try {
            PropertyDescriptor[] descriptors = Introspector.getBeanInfo(entityClass).getPropertyDescriptors();
            for (PropertyDescriptor descriptor : descriptors) {
                try {
                    switch (descriptor.getName()) {
                        case "state":
                            descriptor.getWriteMethod().invoke(entity, BusinessData.正常.getType());
                            break;
                        case "createMan":
                            descriptor.getWriteMethod().invoke(entity, createMan);
                            break;
                        case "createTime":
                            descriptor.getWriteMethod().invoke(entity, new Date());
                            break;
                        default:
                            break;
                    }
                } catch (Exception e) {
                    System.err.println(String.format("初始化[%s]异常:%s", descriptor.getName(), e.getMessage()));
                    e.printStackTrace();
                }
            }
        } catch (Exception e) {
            System.err.println(String.format("初始化异常:%s", e.getMessage()));
            e.printStackTrace();
        }
    }

    /**
     * @Description 初始化使用默认值
     * @Author wanglie
     * @Date 15:03 2018/11/10
     **/
    public static final <T> void initAll(T entity) {
        initAll(entity, JHContents.DEFAULT_INVENT_CODE);
    }

    /**
     * @Description 初始化使用指定值
     * @Author wanglie
     * @Date 15:03 2018/11/10
     **/
    public static final <T> void initAll(T entity, Long createMan) {
        Class<?> entityClass = entity.getClass();
        try {
            PropertyDescriptor[] descriptors = Introspector.getBeanInfo(entityClass).getPropertyDescriptors();
            Date initDate = new Date();
            for (PropertyDescriptor descriptor : descriptors) {
                try {
                    switch (descriptor.getName()) {
                        case "state":
                            descriptor.getWriteMethod().invoke(entity, BusinessData.正常.getType());
                            break;
                        case "createMan":
                            descriptor.getWriteMethod().invoke(entity, createMan);
                            break;
                        case "createTime":
                            descriptor.getWriteMethod().invoke(entity, initDate);
                            break;
                        case "lastupdateMan":
                            descriptor.getWriteMethod().invoke(entity, createMan);
                            break;
                        case "lastupdateTime":
                            descriptor.getWriteMethod().invoke(entity, initDate);
                            break;
                        default:
                            break;
                    }
                } catch (Exception e) {
                    System.err.println(String.format("初始化[%s]异常:%s", descriptor.getName(), e.getMessage()));
                    e.printStackTrace();
                }
            }
        } catch (Exception e) {
            System.err.println(String.format("初始化异常:%s", e.getMessage()));
            e.printStackTrace();
        }
    }

    /**
     * @Description 初始化使用默认值
     * @Author wanglie
     * @Date 15:03 2018/11/10
     **/
    public static final <T> void initUpdate(T entity) {
        initUpdate(entity, JHContents.DEFAULT_INVENT_CODE);
    }

    /**
     * @Description 初始化使用指定值
     * @Author wanglie
     * @Date 15:03 2018/11/10
     **/
    public static final <T> void initUpdate(T entity, Long lastUpdateMan) {
        Class<?> entityClass = entity.getClass();
        try {
            PropertyDescriptor[] descriptors = Introspector.getBeanInfo(entityClass).getPropertyDescriptors();
            for (PropertyDescriptor descriptor : descriptors) {
                try {
                    switch (descriptor.getName()) {
                        case "lastupdateMan":
                            descriptor.getWriteMethod().invoke(entity, lastUpdateMan);
                            break;
                        case "lastupdateTime":
                            descriptor.getWriteMethod().invoke(entity, new Date());
                            break;
                        default:
                            break;
                    }
                } catch (Exception e) {
                    System.err.println(String.format("更新初始化[%s]异常:%s", descriptor.getName(), e.getMessage()));
                    e.printStackTrace();
                }
            }

        } catch (IntrospectionException e) {
            System.err.println(String.format("更新初始化异常:%s", e.getMessage()));
            e.printStackTrace();
        }
    }

    /**
     * @description: 深度拷贝
     **/
    public static <T> T clone(T src) {
        T result = null;
        try (
                // 1，开启io字节输出流
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                // 2，装配对象输出流程
                ObjectOutputStream oos = new ObjectOutputStream(baos);
        ) {
            // 3，把src原对象写入输出流中
            oos.writeObject(src);
            // 4，刷新输出流
            oos.flush();
            try (
                    // 5，开启io字节输入流
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    // 6，装配对象输入流
                    ObjectInputStream ois = new ObjectInputStream(bais);
            ) {
                // 7，读取输入流中对象数据
                result = (T) ois.readObject();
            }
        } catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        return result;
    }
}
