package com.jhscale.common.utils;

import org.apache.commons.lang3.StringUtils;

/**
 * @ClassName: PrivacyUtils
 * @Desprition: 隐私保护工具
 * @Auth: lie_w
 * @Date: 2018/11/12 20:03
 * @Version: V1.0.0
 */
public class PrivacyUtils {

    /**
     * @Description 手机号码隐私保护
     * @Author wanglie
     * @Date 20:04 2018/11/12
     **/
    public static final String vagueMobile(String mobile) {
        int len = mobile.length();
        if (len != 11) {
            if (len <= 8) {
                return mobile;
            }
            return mobile.substring(0, 8);
        }
        return mobile.substring(0, 3) + "***" + mobile.substring(mobile.length() - 4);
    }

    /**
     * @Description 实名隐私保护
     * @Author wanglie
     * @Date 20:04 2018/11/12
     **/
    public static String vagueRealName(String str) {
        if (str.length() == 1) {
            return str;
        } else if (str.length() == 2) {
            return str.charAt(0) + "*";
        } else {
            return str.charAt(0) + "*" + str.charAt(str.length() - 1);
        }
    }

    /**
     * @Description 实名隐私保护
     * @Author wanglie
     * @Date 20:04 2018/11/12
     **/
    public static String vague(String str, int prefix, int suffix) {
        if (StringUtils.isNotBlank(str)) {
            prefix = Math.max(0, prefix);
            suffix = Math.max(0, suffix);
            int total = prefix + suffix;
            if (total != 0 && total < str.length()) {
                return String.format("%s**%s", str.substring(0, prefix), str.substring(str.length() - suffix));
            }
        }
        return str;
    }

}
