package com.jhscale.common.utils;

import java.security.SecureRandom;
import java.util.Base64;
import java.util.Random;
import java.util.UUID;

/**
 * @author lie_w
 * @title: RandomUtils
 * @projectName common
 * @description: 随机数工具类
 * @date 2020-10-2213:01
 */
public class RandomUtils {

    private RandomUtils() {
    }

    /**
     * @description: 获取16位随机数
     **/
    public static String getGUID() {
        StringBuilder uid = new StringBuilder();
        //产生16位的强随机数
        Random rd = new SecureRandom();
        for (int i = 0; i < 16; i++) {
            //产生0-2的3位随机数
            int type = rd.nextInt(3);
            switch (type) {
                case 0:
                    //0-9的随机数
                    uid.append(rd.nextInt(10));
                    break;
                case 1:
                    //ASCII在65-90之间为大写,获取大写随机
                    uid.append((char) (rd.nextInt(25) + 65));
                    break;
                case 2:
                    //ASCII在97-122之间为小写，获取小写随机
                    uid.append((char) (rd.nextInt(25) + 97));
                    break;
                default:
                    break;
            }
        }
        return uid.toString();
    }

    /**
     * 获取（一定长度 + 8）的随机字符串可用于加密的字符串
     *
     * @param length 指定字符串长度
     * @return 一定长度的字符串
     */
    public static String getEncryptRandomStrByLength(int length) {
        String base1 = "0123456789";
        String base2 = "abcdefghijklmnopqrstuvwxyz" + base1;
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 8; i++) {
            sb.append(base1.charAt(random.nextInt(base1.length())));
        }
        for (int i = 0; i < length; i++) {
            sb.append(base2.charAt(random.nextInt(base2.length())));
        }
        return sb.toString();
    }

    /**
     * 获取一定长度的随机字符串
     *
     * @param length 指定字符串长度
     * @return 一定长度的字符串
     */
    public static String getRandomStringByLength(int length) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; i++) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    /**
     * @description: 字节随机数
     **/
    public static String getRandomHex(int length) {
        byte[] content = new byte[length];
        for (int i = 0; i < length; i++) {
            content[i] = (byte) (Math.random() * 255);
        }
        return ByteUtils.toHexString(content);
    }

    /**
     * @description: 字节随机数
     **/
    public static String getRandomHexUpper(int length) {
        return getRandomHex(length).toUpperCase();
    }

    /**
     * @description: 随机码
     **/
    public static String integer(int length) {
        String base = "0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; i++) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }


    /**
     * @description: 指定长度随机数
     **/
    public static int integer_random(int max) {
        // 创建Random对象
        Random random = new Random();
        // 生成0到65535之间的随机数
        return random.nextInt(max);
    }

    // 生成自定义的 accessKeyId
    public static String generateAccessKeyId() {
        return UUID.randomUUID().toString().replace("-", "").substring(0, 16); // 生成 16 位的随机字符串
    }

    // 生成自定义的 accessKeySecret
    public static String generateAccessKeySecret() {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[32]; // 生成 32 字节的随机值
        random.nextBytes(bytes);
        return Base64.getEncoder().encodeToString(bytes); // 转换为 Base64 字符串
    }

}
