package com.jhscale.common.utils;

import com.jhscale.common.exception.ProfessionalException;
import com.jhscale.common.ysscale.YsscaleContents;
import org.apache.commons.lang3.StringUtils;

import java.util.regex.Pattern;

/**
 * @ProjectName: ysscale
 * @Package: com.ysscale.common.utils
 * @ClassName: RegixUtil
 * @Description: java类作用描述 校验工具类
 * @Author: 王列
 * @CreateDate: 2018/3/30 13:36
 * @UpdateUser: 更新者
 * @UpdateDate: 2018/3/30 13:36
 * @UpdateRemark: 更新说明
 * @Version: 1.0
 */
public class RegexUtil {

    private RegexUtil() {
    }

    // "[1]"代表第1位为数字1，"[358]"代表第二位可以为3、5、8中的一个，"\\d{9}"代表后面是可以是0～9的数字，有9位。
    public static final String TELREGEX = "^1[3456789][0-9]{9}$";

    // 管理员密码必须第一个字母，密码长度6-16
    public static final String PWDREGEX = "^[a-zA-Z][a-zA-Z0-9_]{5,15}$";

    // 邮箱正则表达式
    public static final String EMAILREGEX = "^([a-zA-Z0-9]+[-|_|\\_|\\.]?)*[a-zA-Z0-9]+@([a-zA-Z0-9]+[_|\\_|\\.]?)*[a-zA-Z0-9]+\\.[a-zA-Z]{2,3}$";

    // 友声MAC正则表达
    public static final String MACREGEX = "0023F0[a-zA-Z0-9]{6}$";

    // 设备唯一识别码正则
    public static final String EQUIPMENT_UNIQUE_REGEX = "^[A-Za-z0-9]{12,30}$";

    // 统一社会信用代码
    public static final String BUSINESS_IDENTIFY = "^[^_IOZSVa-z\\W]{2}\\d{6}[^_IOZSVa-z\\W]{10}$";

    /**
     * @description: 统一社会信用代码 检查
     **/
    public static boolean regexBusinessIdentify(String identify) {
        Pattern pattern = Pattern.compile(BUSINESS_IDENTIFY);
        return pattern.matcher(identify).matches();
    }

    public static boolean regexPhoneNum(String telNum) throws ProfessionalException {
        Pattern pattern = Pattern.compile(TELREGEX);
        if (!pattern.matcher(telNum).matches())
            throw new ProfessionalException("手机号码不匹配规则");
        return true;
    }

    public static boolean regexPhoneNumResult(String telNum) {
        Pattern pattern = Pattern.compile(TELREGEX);
        return pattern.matcher(telNum).matches();
    }

    public static boolean regexPwd(String passwd) throws ProfessionalException {
        Pattern pattern = Pattern.compile(PWDREGEX);
        if (!pattern.matcher(passwd).matches())
            throw new ProfessionalException("密码规则[字母 + 5到15位字母或数字]");
        return true;
    }

    public static boolean regexEmail(String email) throws ProfessionalException {
        Pattern pattern = Pattern.compile(EMAILREGEX);
        if (!pattern.matcher(email).matches())
            throw new ProfessionalException("邮箱不匹配规则");
        return true;
    }

    public static boolean regexEmailResult(String email) {
        Pattern pattern = Pattern.compile(EMAILREGEX);
        return pattern.matcher(email).matches();
    }

    /**
     * @Description: 校验是否满足正则表达
     */
    public static boolean matcher(String source, String regexp) {
        Pattern pattern = Pattern.compile(regexp);
        return pattern.matcher(source).matches();
    }

    /**
     * @Description: 校验字符串是否为数字
     */
    public static boolean isNumber(String numStr) {
        return matcher(numStr, "^[0-9]*[1-9][0-9]*$");
    }

    /**
     * @Description: 判断是手机还是邮箱 手机号校验
     */
    public static String isNumOrEmail(String account, String areaCode) throws ProfessionalException {
        Pattern pPattern = Pattern.compile(TELREGEX);
        Pattern ePattern = Pattern.compile(EMAILREGEX);
        if (ePattern.matcher(account).matches()) {
            return YsscaleContents.EMAIN_SIGN;
        } else if (isNumber(account) && (
                (StringUtils.isNotBlank(areaCode) && !YsscaleContents.CHINA_AREA_CODE.equals(areaCode))
                        || ((StringUtils.isBlank(areaCode) || YsscaleContents.CHINA_AREA_CODE.equals(areaCode)) && pPattern.matcher(account).matches()))) {
            return YsscaleContents.PHONE_SIGN;
        } else {
            throw new ProfessionalException("账号非手机号码或邮箱");
        }
    }

    /**
     * @Description: 判断是手机还是邮箱 不带校验手机号
     */
    public static String isNumOrEmail(String account) {
        Pattern ePattern = Pattern.compile(EMAILREGEX);
        if (ePattern.matcher(account).matches()) {
            return YsscaleContents.EMAIN_SIGN;
        } else {
            return YsscaleContents.PHONE_SIGN;
        }
    }

    /**
     * @Description: 检查用户名是否为手机号码或者邮箱
     */
    public static boolean checkMoblieAndEmail(String userName) {
        Pattern ePattern = Pattern.compile(EMAILREGEX);
        if (isNumber(userName) || ePattern.matcher(userName).matches()) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * @Description 有声MAC正则表达校验
     */
    public static boolean checkMac(String mac) {
        Pattern mPaggern = Pattern.compile(MACREGEX);
        if (mPaggern.matcher(mac).matches()) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * @description: 设备唯一识别码正则
     **/
    public static boolean checkUnique(String unique) {
        Pattern mPaggern = Pattern.compile(EQUIPMENT_UNIQUE_REGEX);
        if (mPaggern.matcher(unique).matches()) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * @Description 本系统流水号校验
     */
    public static boolean checkOrderNo(String orderNo) {
        if (isNumber(orderNo) && orderNo.length() == 25) {
            return true;
        } else {
            return false;
        }
    }

    private static final String PACKAGE_REGEX = "^([a-zA-Z]+[.][a-zA-Z]+)[.]*.*";

    /**
     * @Description JAVA包路径正则校验
     **/
    public static boolean checkJavaPackage(String packageStr) {
        return Pattern.compile(PACKAGE_REGEX).matcher(packageStr).matches();
    }
}
