package com.jhscale.common.utils;

import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: StringUtils
 * @projectName ysscale-base
 * @description: TODO
 * @date 2020/2/1314:06
 */
public class StringUtil {

    private StringUtil() {
    }

    /**
     * @description: 首字母小写
     **/
    public static String firstToLowerCase(String str) {
        if (StringUtils.isBlank(str)) return str;
        String first = String.valueOf(str.charAt(0));
        return str.replaceFirst(first, first.toLowerCase());
    }

    /**
     * @description: 首字符大写
     **/
    public static String firstToUpperCase(String str) {
        if (StringUtils.isBlank(str)) return str;
        String first = String.valueOf(str.charAt(0));
        return str.replaceFirst(first, first.toUpperCase());
    }

    /**
     * @param str     原始字符串
     * @param top     头保留长度
     * @param botton  尾保留长度
     * @param replace 替换的字符串
     * @description: 字符串隐私保护
     **/
    public static String privacy(String str, int top, int botton, String replace) {
        if (StringUtils.isBlank(str)) return str;
        int length = str.length();
        if (top > length || length < top + botton) return str;
        return str.substring(0, top) + replace + str.substring(length - botton, length);
    }

    /**
     * @description: 字符串隐私保护
     **/
    public static String privacy(String str, int top, int botton) {
        return privacy(str, top, botton, "******");
    }

    /**
     * @description: 字符串隐私保护
     **/
    public static String privacyWithlength(String str, int top, int botton, String replace) {
        if (replace.length() > 0) {
            String privacy = "";
            int length = str.length() - top - botton;
            for (int i = 0; i < length; i++) {
                privacy += replace;
            }
            return privacy(str, top, botton, privacy);
        } else {
            return privacy(str, top, botton, replace);
        }
    }

    /**
     * @description: 字符串隐私保护
     **/
    public static String privacyWithlength(String str, int top, int botton) {
        String replace = "";
        int length = str.length() - top - botton;
        for (int i = 0; i < length; i++) {
            replace += "*";
        }
        return privacy(str, top, botton, replace);
    }

    /**
     * @description: 字符串前置补充长度
     **/
    public static String completeTString(String data, int length) {
        if (StringUtils.isBlank(data)) data = "";
        if (data.length() > length) {
            return data.substring(0, length);
        } else {
            for (int i = 0; i <= (length - data.length()); i++) {
                data = "0" + data;
            }
            return data;
        }
    }

    /**
     * @description: 字符串后置补充长度
     **/
    public static String completeEString(String data, int length) {
        if (StringUtils.isBlank(data)) data = "";
        if (data.length() > length) {
            return data.substring(0, length);
        } else {
            for (int i = 0; i <= (length - data.length()); i++) {
                data += "0";
            }
            return data;
        }
    }

    /**
     * @description: 指定字符替换
     **/
    public static String replace(String data, int index, char c) {
        try {
            return data.substring(0, index) + c + data.substring(index + 1);
        } catch (Exception e) {
            return data;
        }
    }
}
