package com.jhscale.common.utils.paycode;

import com.jhscale.common.model.simple.JSONModel;

/**
 * @author lie_w
 * @title: Dectyption
 * @projectName common
 * @description: 解密对象信息
 * @date 2021/7/300:14
 */
public class Dectyption extends JSONModel {

    // 前缀
    private String prefix;

    // 版本号
    private String sysversion;

    // 加密文本
    private int[][] encryptDictionaries;

    // 解密文本
    private int[][] decryptDictionaries;

    // UNIX 时间戳
    private long unix;

    // 付款码有效哦时间
    private long invalid = 5;

    // 分钟最大允许付款码
    private long minMax = 20;

    // 标识长度
    private int signLen = 6;

    public Dectyption() {
    }

    public Dectyption(String prefix, String sysversion, int[][] decryptDictionaries, long unix) {
        this.prefix = prefix;
        this.sysversion = sysversion;
        this.decryptDictionaries = decryptDictionaries;
        this.unix = unix;
    }

    public Dectyption(String prefix, String sysversion, int[][] encryptDictionaries, int[][] decryptDictionaries, long unix) {
        this(prefix, sysversion, decryptDictionaries, unix);
        this.encryptDictionaries = encryptDictionaries;
    }

    public Dectyption(String prefix, String sysversion, int[][] encryptDictionaries, int[][] decryptDictionaries, long unix, int invalid) {
        this(prefix, sysversion, encryptDictionaries, decryptDictionaries, unix);
        this.invalid = invalid;
    }

    public Dectyption(String prefix, String sysversion, int[][] encryptDictionaries, int[][] decryptDictionaries, long unix, int invalid, int minMax) {
        this(prefix, sysversion, encryptDictionaries, decryptDictionaries, unix, invalid);
        this.minMax = minMax;
    }

    public Dectyption(String prefix, String sysversion, int[][] encryptDictionaries, int[][] decryptDictionaries, long unix, int invalid, int minMax, int signLen) {
        this(prefix, sysversion, encryptDictionaries, decryptDictionaries, unix, invalid, minMax);
        this.signLen = signLen;
    }

    public String getPrefix() {
        return prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSysversion() {
        return sysversion;
    }

    public void setSysversion(String sysversion) {
        this.sysversion = sysversion;
    }

    public int[][] getEncryptDictionaries() {
        return encryptDictionaries;
    }

    public void setEncryptDictionaries(int[][] encryptDictionaries) {
        this.encryptDictionaries = encryptDictionaries;
    }

    public int[][] getDecryptDictionaries() {
        return decryptDictionaries;
    }

    public void setDecryptDictionaries(int[][] decryptDictionaries) {
        this.decryptDictionaries = decryptDictionaries;
    }

    public long getUnix() {
        return unix;
    }

    public void setUnix(long unix) {
        this.unix = unix;
    }

    public long getInvalid() {
        return invalid;
    }

    public void setInvalid(long invalid) {
        this.invalid = invalid;
    }

    public long getMinMax() {
        return minMax;
    }

    public void setMinMax(long minMax) {
        this.minMax = minMax;
    }

    public int getSignLen() {
        return signLen;
    }

    public void setSignLen(int signLen) {
        this.signLen = signLen;
    }
}
