package com.jhscale.common.utils.paycode;

import com.jhscale.common.model.simple.JSONModel;

/**
 * @author lie_w
 * @title: Enctyption
 * @projectName common
 * @description: 加密参数对象
 * @date 2021/7/300:11
 */
public class Enctyption extends JSONModel {

    // 前缀
    private String prefix;

    // 版本号
    private String sysversion;

    // 加密文本
    private int[][] encryptDictionaries;

    // UNIX 时间戳
    private long unix;

    // 标识长度
    private int signLen = 6;

    public Enctyption() {
    }

    public Enctyption(String prefix, String sysversion, int[][] encryptDictionaries, long unix) {
        this.prefix = prefix;
        this.sysversion = sysversion;
        this.encryptDictionaries = encryptDictionaries;
        this.unix = unix;
    }

    public Enctyption(String prefix, String sysversion, int[][] encryptDictionaries, long unix, int signLen) {
        this(prefix, sysversion, encryptDictionaries, unix);
        this.signLen = signLen;
    }

    /**
     * @description: 系统协议版本号
     **/
    public int sysversion() {
        return Integer.parseInt(sysversion);
    }

    public String getPrefix() {
        return prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSysversion() {
        return sysversion;
    }

    public void setSysversion(String sysversion) {
        this.sysversion = sysversion;
    }

    public int[][] getEncryptDictionaries() {
        return encryptDictionaries;
    }

    public void setEncryptDictionaries(int[][] encryptDictionaries) {
        this.encryptDictionaries = encryptDictionaries;
    }

    public long getUnix() {
        return unix;
    }

    public void setUnix(long unix) {
        this.unix = unix;
    }

    public int getSignLen() {
        return signLen;
    }

    public void setSignLen(int signLen) {
        this.signLen = signLen;
    }
}
