package com.jhscale.common.utils.paycode;

import com.jhscale.common.model.simple.JSONModel;

/**
 * @author lie_w
 * @title: PWDDictionary
 * @projectName common
 * @description: 加密文本信息
 * @date 2021/7/2923:54
 */
public class PWDDictionary extends JSONModel {

    // 前缀
    private String prefix;

    // 版本号
    private String version;

    // 加密文本
    private int[][] encryptDictionaries;

    // 解密文本
    private int[][] decryptDictionaries;

    // UNIX 时间戳
    private Long unix;

    public String getPrefix() {
        return prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public int[][] getEncryptDictionaries() {
        return encryptDictionaries;
    }

    public void setEncryptDictionaries(int[][] encryptDictionaries) {
        this.encryptDictionaries = encryptDictionaries;
    }

    public int[][] getDecryptDictionaries() {
        return decryptDictionaries;
    }

    public void setDecryptDictionaries(int[][] decryptDictionaries) {
        this.decryptDictionaries = decryptDictionaries;
    }

    public Long getUnix() {
        return unix;
    }

    public void setUnix(Long unix) {
        this.unix = unix;
    }

    /**
     * @description: 系统密码版本号
     **/
    public int version() {
        return Integer.parseInt(this.version);
    }
}
