package com.jhscale.common.utils.paycode;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jhscale.common.utils.JSONUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author lie_w
 * @title: PaycodeUtils
 * @projectName common
 * @description: 密码本工具类
 * @date 2021/7/2621:45
 */
public class PWDDictionaryUtils {

    private PWDDictionaryUtils() {
    }

    /**
     * @description: 密码源本
     **/
    public static final int[] dictionary = {
            0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
            10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
            20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
            30, 31, 32, 33, 34, 35, 36, 37, 38, 39,
            40, 41, 42, 43, 44, 45, 46, 47, 48, 49,
            50, 51, 52, 53, 54, 55, 56, 57, 58, 59,
            60, 61, 62, 63, 64, 65, 66, 67, 68, 69,
            70, 71, 72, 73, 74, 75, 76, 77, 78, 79,
            80, 81, 82, 83, 84, 85, 86, 87, 88, 89,
            90, 91, 92, 93, 94, 95, 96, 97, 98, 99
    };

    /**
     * @description: 获取指定长度字典
     **/
    public static int[][] getEncryptDictionaries(int[] dictionary, int length) {
        int[][] arr = new int[length][100];
        for (int i = 0; i < length; i++) {
            arr[i] = getEncryptDictionary(dictionary);
        }
        return arr;
    }

    /**
     * @description: 获取固定长度解密密钥
     **/
    public static int[][] getDecryptDictionaries(int[][] encryptDictionaries) {
        int[][] arr = new int[encryptDictionaries.length][100];
        for (int i = 0; i < encryptDictionaries.length; i++) {
            arr[i] = getDecryptDictionary(encryptDictionaries[i]);
        }
        return arr;
    }

    /**
     * @description: 生成加密字典
     **/
    public static int[] getEncryptDictionary(int[] dictionary) {
        List<Integer> dictionaryList = getDictionary(dictionary);
        Collections.shuffle(dictionaryList);
        return getDictionary(dictionaryList);
    }

    /**
     * @description: 加密字典获取解密字典
     **/
    public static int[] getDecryptDictionary(int[] encryptDictionary) {
        int[] arr = new int[100];
        for (int i = 0; i < 100; i++) {
            arr[encryptDictionary[i]] = i;
        }
        return arr;
    }

    /**
     * @description: 字符转字典
     **/
    public static int[][] getDictionary(String dictionaryStr) {
        JSONArray jsonArray = JSONObject.parseArray(dictionaryStr);
        int[][] dictionaries = new int[jsonArray.size()][];
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONArray inner = (JSONArray) jsonArray.get(i);
            int[] innerDictionaries = new int[inner.size()];
            for (int j = 0; j < inner.size(); j++) {
                innerDictionaries[j] = Integer.parseInt(inner.get(j).toString());
            }
            dictionaries[i] = innerDictionaries;
        }
        return dictionaries;
    }

    /**
     * @description: 字符转字典
     **/
    public static String getDictionary(int[][] dictionaries) {
        return JSONUtils.objectToJSON(dictionaries);
    }

    /**
     * @description: 字典集合
     **/
    public static List<Integer> getDictionary(int[] dictionary) {
        return Arrays.stream(dictionary).boxed().collect(Collectors.toList());
    }

    /**
     * @description: 字典数组
     **/
    public static int[] getDictionary(List<Integer> dictionary) {
        return dictionary.stream().mapToInt(Integer::intValue).toArray();
    }

    /**
     * @description: 字典格式化
     **/
    public static String formatDictionary(int[] dictionary) {
        StringBuffer buffer = new StringBuffer("{\n");
        for (int i = 0; i < dictionary.length; i++) {
            buffer.append(dictionary[i]).append(",");
            if (String.valueOf(i).endsWith("9")) {
                buffer.append("\n");
            }
        }
        buffer = new StringBuffer(buffer.substring(0, buffer.length() - 2)).append("\n}");
        return buffer.toString();
    }
}
