package com.jhscale.common.utils.paycode;

import java.util.ArrayList;
import java.util.List;

/**
 * @author lie_w
 * @title: PaycodeBulid
 * @projectName common
 * @description: TODO
 * @date 2021/7/279:19
 */
public class PWDDictionayBulid {

    // 字典
    private int[] source = PWDDictionaryUtils.dictionary;

    // 前缀
    private String prefix;

    // 起始标志
    private int offset;

    // 密钥长度
    private int length = 100;

    // 文本密码数量
    private int size;

    // 版本长度
    private int version_length = 2;

    /**
     * @description: 获取对象信息
     **/
    public static PWDDictionayBulid getInstance() {
        return new PWDDictionayBulid();
    }

    /**
     * @description: 添加字典 默认通用字符字典
     **/
    public PWDDictionayBulid addSource(int[] source) {
        this.source = source;
        return this;
    }

    /**
     * @description: 添加前缀
     **/
    public PWDDictionayBulid addPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    /**
     * @description: 添加起始坐标 长度
     **/
    public PWDDictionayBulid addOffset(int offset, int size) {
        this.offset = offset;
        this.size = size;
        return this;
    }

    /**
     * @description: 添加起始坐标 长度
     **/
    public PWDDictionayBulid addOffset(String sysversion, int size) {
        this.offset = Integer.parseInt(sysversion);
        this.size = size;
        return this;
    }

    /**
     * @description: 密码文本长度
     **/
    public PWDDictionayBulid addPWDLength(int length) {
        this.length = length;
        return this;
    }

    /**
     * @description: 版本长度 默认2
     **/
    public PWDDictionayBulid addVersionLength(int version_length) {
        this.version_length = version_length;
        return this;
    }

    /**
     * @description: 存在没有取完的密码本
     **/
    public boolean hasNext() {
        return this.size != 0;
    }

    /**
     * @description: 获取下一个加密文本
     **/
    public synchronized PWDDictionary next() {
        PWDDictionary dictionary = new PWDDictionary();
        dictionary.setPrefix(this.prefix);
        dictionary.setUnix(Long.parseLong(String.valueOf(System.currentTimeMillis() / 60000L)));
        dictionary.setEncryptDictionaries(PWDDictionaryUtils.getEncryptDictionaries(this.source, this.length));
        dictionary.setDecryptDictionaries(PWDDictionaryUtils.getDecryptDictionaries(dictionary.getEncryptDictionaries()));
        String version = String.valueOf(this.offset());
        if (version.length() == 1) version = "0" + version;
        dictionary.setVersion(version);
        this.offset++;
        this.size--;
//        System.out.println(dictionary.toJSON());
        return dictionary;
    }

    /**
     * @description: 获取全部加密文本
     **/
    public List<PWDDictionary> bulid() {
        List<PWDDictionary> dictionaries = new ArrayList<>();
        while (this.hasNext()) {
            PWDDictionary next = this.next();
            if (next != null)
                dictionaries.add(next);
        }
        return dictionaries;
    }

    /**
     * @description: 获取最后的Offset
     **/
    public int offset() {
        return this.offset >= 100 ? this.offset - 100 : this.offset;
    }
}
