package com.jhscale.common.utils.paycode;

import com.jhscale.common.em.SequenceRule;
import com.jhscale.common.exception.GeneralException;
import com.jhscale.common.exception.GeneralInternational;
import com.jhscale.common.exception.ProfessionalException;
import com.jhscale.common.exception.TechnologyException;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author lie_w
 * @title: PaycodeManage
 * @projectName common
 * @description: TODO
 * @date 2021/7/300:20
 */
public class PaycodeManager {

    // 加密文本信息
    private Enctyption enctyption;

    // 解密文本信息
    private Dectyption dectyption;

    private Map<Long, Integer> uninMap;

    public PaycodeManager() {
        this.uninMap = new ConcurrentHashMap<>();
    }

    private static class Singleton {
        private static PaycodeManager paycodeManager = new PaycodeManager();
    }

    public static PaycodeManager getInstance() {
        return Singleton.paycodeManager;
    }

    /**
     * @description: 添加加密密钥信息
     **/
    public PaycodeManager addEnctyption(Enctyption enctyption) {
        this.enctyption = enctyption;
        return this;
    }

    /**
     * @description: 添加解密密钥信息
     **/
    public PaycodeManager addDectyption(Dectyption dectyption) {
        this.dectyption = dectyption;
        return this;
    }

    /**
     * @description: 用户标识获取付款码
     **/
    public String bulidPaycode(long sign) throws ProfessionalException {
        if (Objects.isNull(this.enctyption))
            throw new ProfessionalException(GeneralInternational.加密字典不存在);

        int encryptIndex = (int) (Math.random() * this.enctyption.getEncryptDictionaries().length); // 密钥索引
        int[] encryptDictionary = this.enctyption.getEncryptDictionaries()[encryptIndex]; // 加密密钥

        int frame = (int) (Math.random() * 100);// 帧号
//        System.out.println("帧号：" + frame);
        String frameStr = String.valueOf(frame);
        if (frameStr.length() == 1) frameStr = "0" + frameStr;

        // 系统版本号
//        System.out.println("系统版本号：" + this.enctyption.sysversion());
        int sysversion = this.enctyption.sysversion() + frame;
        if (sysversion >= 100) sysversion = sysversion - 100;
        String sysversionStr = String.valueOf(sysversion);
        if (sysversionStr.length() == 1) sysversionStr = "0" + sysversionStr;

        // 密码本版本号
//        System.out.println("密码本版本号：" + encryptIndex);
        int pwdversion = encryptIndex + frame;
        if (pwdversion >= 100) pwdversion = pwdversion - 100;
        String pwdversionStr = String.valueOf(pwdversion);
        if (pwdversionStr.length() == 1) pwdversionStr = "0" + pwdversionStr;

        // 业务标识
//        System.out.println("业务标识：" + sign);
        String signStr = String.valueOf(Integer.parseInt(String.valueOf(sign).substring(4)));
        int appentLen = this.enctyption.getSignLen() - signStr.length();

        if (appentLen < 0)
            throw new ProfessionalException(GeneralInternational.标识长度超长);

        for (int i = 0; i < appentLen; i++) {
            signStr = i + signStr;
        }
        signStr = appentLen + signStr;

        StringBuffer buffer = new StringBuffer()
                .append(this.enctyption.getPrefix())
                .append(frameStr)
                .append(sysversionStr)
                .append(pwdversionStr)
                .append(signStr)
                .append(this.bulidTimestamp(frame));
//        System.out.println("付款码：" + buffer.toString());
        return buffer.toString();
    }

    /**
     * @description: 用户标识获取付款码并加密
     **/
    public String bulidPaycodeWithEncryption(long sign) throws ProfessionalException {
        String paycode = this.bulidPaycode(sign);
        return this.enctyptionAndDectyption(paycode, this.enctyption.getEncryptDictionaries()[this.paycodePwdversion(paycode)]);
    }

    /**
     * @description: 加解密
     **/
    public String enctyptionAndDectyption(String paycode, int[] dictionary) {
        String content = paycode.substring(8);
        StringBuffer buffer = new StringBuffer(paycode.substring(0, 8));
        for (int i = 0; i < (content.length() / 2); i++) {
            int val = Integer.parseInt(content.substring(i * 2, i * 2 + 2));
            String part = String.valueOf(dictionary[val]);
            if (part.length() % 2 != 0) part = "0" + part;
            buffer.append(part);
        }
        return buffer.toString();
    }

    /**
     * @description: 时间戳
     **/
    public synchronized String bulidTimestamp(int frame) throws ProfessionalException {
        if (Objects.isNull(this.enctyption))
            throw new ProfessionalException(GeneralInternational.加密字典不存在);

        long min = Long.parseLong(String.valueOf(System.currentTimeMillis() / 60000L));
//        System.out.println("付款码时间：" + min);

        long unix = min - this.enctyption.getUnix();
//        System.out.println("付款码有效分钟数：" + unix);

        Integer counter = uninMap.get(unix);
        if (counter == null) {
            counter = 1;
            this.uninMap.clear();
            uninMap.put(unix, counter);
        } else {
            counter = counter + 1;
            uninMap.put(unix, counter);
        }
//        System.out.println("付款码分钟次数：" + counter);

        String unixStr = String.valueOf(unix);
        int appentLen = 6 - unixStr.length();
        for (int i = 0; i < appentLen; i++) {
            unixStr = i + unixStr;
        }
        unixStr = appentLen + unixStr;

        int counterval = counter + frame;
        if (counterval >= 100) counterval = counterval - 100;
        String counterStr = String.valueOf(counterval);
        if (counterStr.length() == 1) counterStr = "0" + counterStr;
        return unixStr + counterStr;
    }

    /**
     * @description: 系统版本号
     **/
    public String paycodeSysversion(String paycode) throws ProfessionalException {
        if (StringUtils.isBlank(paycode))
            throw new ProfessionalException(GeneralInternational.付款码不存在);

        // 帧号
        int frame = Integer.parseInt(paycode.substring(2, 4));
        // 系统版本号
        int version = Integer.parseInt(paycode.substring(4, 6)) - frame;
        if (version < 0) version += 100;
        String sysversion = String.valueOf(version);
        if (sysversion.length() == 1) sysversion = "0" + sysversion;
        return sysversion;
    }

    /**
     * @description: 密码版本号获取
     **/
    public int paycodePwdversion(String paycode) throws ProfessionalException {
        if (StringUtils.isBlank(paycode))
            throw new ProfessionalException(GeneralInternational.付款码不存在);

        // 帧号
        int frame = Integer.parseInt(paycode.substring(2, 4));

        // 密码本版本号
        int pwdversion = Integer.parseInt(paycode.substring(6, 8)) - frame;
        if (pwdversion < 0) pwdversion += 100;
        return pwdversion;
    }

    /**
     * @description:
     **/
    public long unpackPaycodeWithDncryption(String paycode) throws ProfessionalException {
        if (StringUtils.isBlank(paycode))
            throw new ProfessionalException(GeneralInternational.付款码不存在);
        if (Objects.isNull(this.dectyption))
            throw new ProfessionalException(GeneralInternational.解密字典不存在);
        paycode = this.enctyptionAndDectyption(paycode, this.dectyption.getDecryptDictionaries()[this.paycodePwdversion(paycode)]);
        return this.unpackPaycode(paycode);
    }

    /**
     * @description: 付款码解包获取用户编码
     **/
    public long unpackPaycode(String paycode) throws ProfessionalException {
        if (StringUtils.isBlank(paycode))
            throw new ProfessionalException(GeneralInternational.付款码不存在);
        if (Objects.isNull(this.dectyption))
            throw new ProfessionalException(GeneralInternational.解密字典不存在);
        if (!paycode.startsWith(this.dectyption.getPrefix()))
            throw new ProfessionalException(GeneralInternational.付款码前缀不正确);

        // 帧号
        int frame = Integer.parseInt(paycode.substring(2, 4));

        // 系统版本号
        int sysversion = Integer.parseInt(paycode.substring(4, 6)) - frame;
        if (sysversion < 0) sysversion += 100;

        // 密码本版本号
        int pwdversion = Integer.parseInt(paycode.substring(6, 8)) - frame;
        if (pwdversion < 0) pwdversion += 100;

        // 标识补充长度
        int signAppentLen = Integer.parseInt(paycode.substring(8, 9));

        // 业务标识
        String signStr = paycode.substring(9, 9 + this.dectyption.getSignLen());

        // 时间戳
        String timestamp = paycode.substring(9 + this.dectyption.getSignLen());
        this.unpackTimestamp(timestamp, frame);

        signStr = signStr.substring(signAppentLen);
        signAppentLen = 12 - signStr.length();
        for (int i = 0; i < signAppentLen; i++) {
            signStr = "0" + signStr;
        }
        signStr = SequenceRule.客户编号.getPrefix() + signStr;
        return Long.parseLong(signStr);
    }

    /**
     * @description: 付款码解包获取用户编码
     **/
    public long unpackPaycode(IDectyptionActuator actuator, String paycode) throws GeneralException {
        try {
            if (StringUtils.isBlank(paycode))
                throw new ProfessionalException(GeneralInternational.付款码不存在);
            if (Objects.isNull(actuator))
                throw new ProfessionalException(GeneralInternational.加载字典执行器不存在);

            // 帧号
            int frame = Integer.parseInt(paycode.substring(2, 4));

            // 系统版本号
            int sysversion = Integer.parseInt(paycode.substring(4, 6)) - frame;
            if (sysversion < 0) sysversion += 100;
            String sysversionStr = String.valueOf(sysversion);
            if (sysversionStr.length() == 1) sysversionStr = "0" + sysversionStr;

            // 加载加解密字典
            Dectyption dectyption = actuator.getDictionary(sysversionStr);

            if (Objects.isNull(dectyption))
                throw new ProfessionalException(GeneralInternational.解密字典不存在);
            if (!paycode.startsWith(dectyption.getPrefix()))
                throw new ProfessionalException(GeneralInternational.付款码前缀不正确);

            // 密码本版本号
            int pwdversion = Integer.parseInt(paycode.substring(6, 8)) - frame;
            if (pwdversion < 0) pwdversion += 100;

            paycode = this.enctyptionAndDectyption(paycode, dectyption.getDecryptDictionaries()[pwdversion]);

            // 标识补充长度
            int signAppentLen = Integer.parseInt(paycode.substring(8, 9));

            // 业务标识
            String signStr = paycode.substring(9, 9 + dectyption.getSignLen());

            // 时间戳
            String timestamp = paycode.substring(9 + dectyption.getSignLen());
            this.unpackTimestamp(dectyption, timestamp, frame);

            signStr = signStr.substring(signAppentLen);
            signAppentLen = 12 - signStr.length();
            for (int i = 0; i < signAppentLen; i++) {
                signStr = "0" + signStr;
            }
            signStr = SequenceRule.客户编号.getPrefix() + signStr;

            long usSign = Long.parseLong(signStr);

            actuator.otherCheck(dectyption, paycode, usSign);

            return usSign;
        } catch (ProfessionalException e) {
            throw e;
        } catch (Exception e) {
            throw new TechnologyException(e, GeneralInternational.付款码解析失败);
        }
    }

    /**
     * @description: 付款码解包获取用户编码
     **/
    public long unpackPaycode(Dectyption dectyption, String paycode) throws ProfessionalException {
        if (StringUtils.isBlank(paycode))
            throw new ProfessionalException(GeneralInternational.付款码不存在);
        if (Objects.isNull(dectyption))
            throw new ProfessionalException(GeneralInternational.解密字典不存在);
        if (!paycode.startsWith(dectyption.getPrefix()))
            throw new ProfessionalException(GeneralInternational.付款码前缀不正确);

        // 帧号
        int frame = Integer.parseInt(paycode.substring(2, 4));

        // 系统版本号
        int sysversion = Integer.parseInt(paycode.substring(4, 6)) - frame;
        if (sysversion < 0) sysversion += 100;

        // 密码本版本号
        int pwdversion = Integer.parseInt(paycode.substring(6, 8)) - frame;
        if (pwdversion < 0) pwdversion += 100;

        // 标识补充长度
        int signAppentLen = Integer.parseInt(paycode.substring(8, 9));

        // 业务标识
        String signStr = paycode.substring(9, 9 + dectyption.getSignLen());

        // 时间戳
        String timestamp = paycode.substring(9 + dectyption.getSignLen());
        this.unpackTimestamp(dectyption, timestamp, frame);

        signStr = signStr.substring(signAppentLen);
        signAppentLen = 12 - signStr.length();
        for (int i = 0; i < signAppentLen; i++) {
            signStr = "0" + signStr;
        }
        signStr = SequenceRule.客户编号.getPrefix() + signStr;
        return Long.parseLong(signStr);
    }

    /**
     * @description: 支付密码时间戳
     **/
    public long unpackTimestamp(String timestamp, int frame) throws ProfessionalException {
        if (StringUtils.isBlank(timestamp))
            throw new ProfessionalException(GeneralInternational.付款码不存在);
        if (Objects.isNull(this.dectyption))
            throw new ProfessionalException(GeneralInternational.解密字典不存在);

        // 标识补充长度
        int timestampAppentLen = Integer.parseInt(timestamp.substring(0, 1));
        String timestampPart = timestamp.substring(timestampAppentLen + 1, timestamp.length() - 2);

        int counter = Integer.parseInt(timestamp.substring(timestamp.length() - 2));
        counter = counter - frame;
        if (counter < 0) counter += 100;
        if (counter > this.dectyption.getMinMax())
            throw new ProfessionalException(GeneralInternational.付款码频率超限);

        long paytimestamp = Long.parseLong(timestampPart) + this.dectyption.getUnix();
        long nowtimestamp = Long.parseLong(String.valueOf(System.currentTimeMillis() / 60000L));
        long timeDiff = nowtimestamp - paytimestamp;// 时间差
        if (timeDiff < 0)
            throw new ProfessionalException(GeneralInternational.付款码无效);

        if (timeDiff > this.dectyption.getInvalid())
            throw new ProfessionalException(GeneralInternational.付款码过期);
        return paytimestamp;
    }

    /**
     * @description: 支付密码时间戳
     **/
    public long unpackTimestamp(Dectyption dectyption, String timestamp, int frame) throws ProfessionalException {
        if (StringUtils.isBlank(timestamp))
            throw new ProfessionalException(GeneralInternational.付款码不存在);
        if (Objects.isNull(dectyption))
            throw new ProfessionalException(GeneralInternational.解密字典不存在);

        // 标识补充长度
        int timestampAppentLen = Integer.parseInt(timestamp.substring(0, 1));
        String timestampPart = timestamp.substring(timestampAppentLen + 1, timestamp.length() - 2);

        int counter = Integer.parseInt(timestamp.substring(timestamp.length() - 2));
        counter = counter - frame;
        if (counter < 0) counter += 100;
        if (counter > dectyption.getMinMax())
            throw new ProfessionalException(GeneralInternational.付款码频率超限);

        long paytimestamp = Long.parseLong(timestampPart) + dectyption.getUnix();
        long nowtimestamp = Long.parseLong(String.valueOf(System.currentTimeMillis() / 60000L));
        long timeDiff = nowtimestamp - paytimestamp;// 时间差
        if (timeDiff < 0)
            throw new ProfessionalException(GeneralInternational.付款码无效);

        if (timeDiff > dectyption.getInvalid())
            throw new ProfessionalException(GeneralInternational.付款码过期);
        return paytimestamp;
    }
}
