package com.jhscale.common.utils.weather;

import com.jhscale.common.exception.TechnologyException;
import com.jhscale.common.utils.HttpUtils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author lie_w
 * @title: WeatherUtils
 * @projectName common
 * @description: TODO
 * @date 2021/4/150:35
 */
public class WeatherUtils {

    public static void main(String[] args) throws TechnologyException {
        String cityCode = "101020200";
        System.out.println(get7dWeather(cityCode));
    }

    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM月dd");
    private static SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /**
     * @description: 获取 近7天 天气
     **/
    public static List<Weather> get7dWeather(String cityCode) throws TechnologyException {
        String data7D = HttpUtils.get("http://www.weather.com.cn/weather/" + cityCode + ".shtml");

        List<Weather> weathers = new ArrayList<Weather>();
        String ul = data7D.split("<ul class=\"t clearfix\">")[1];
        String innerUl = ul.split("</ul>")[0];
        String[] strings = innerUl.split("</li>");
        for (int i = 0; i < strings.length - 1; i++) {
            String s = strings[i];
            Weather wea = s.contains("今天") ? new TodayWeather() : new FutureWeather();
            String str1 = s.split("<h1>")[1];
            String ieDate = str1.split("日")[0];

            Date date = new Date();
            String format = sdf.format(date);
            String month = format.split("月")[0];
            if (i == 0) {
                wea.setDate(month + "-" + ieDate);
            } else {
                if (Integer.parseInt(ieDate) > Integer.parseInt(strings[i - 1].split("<h1>")[1].split("日")[0])) {
                    wea.setDate(month + "-" + ieDate);
                } else {
//                    month = String.valueOf(Integer.parseInt(month) + 1);
                    wea.setDate(month + "-" + ieDate);
                }
            }

            String str2 = s.split("<p title=\"")[1];
            wea.setWeather(str2.split("\"")[0]);
            if (s.contains("今天")) {
                String str3 = s.split("<i>")[1];
                ((TodayWeather) wea).setNow(str3.split("</i>")[0]);
            } else {
                String str3 = s.split("<span>")[1];
                ((FutureWeather) wea).setHigh(str3.split("</span>")[0]);
                String str4 = s.split("<i>")[1];
                ((FutureWeather) wea).setLow(str4.split("℃</i>")[0]);
            }
            String str5 = s.split("<span title=\"")[1];
            wea.setWind(str5.split("\"")[0]);
            wea.setCreateTime(sdf2.format(date));
            weathers.add(wea);
            wea = null;
        }
        return weathers;
    }
}
