package com.jhscale.common.ysscale;

import java.util.Objects;

/**
 * @author lie_w
 * @title: InventoryType
 * @projectName common
 * @description: TODO
 * @date 2022/9/1918:26
 */
public enum InventoryType {

    未知库存商品(-1, "未知库存商品"),
    库存商品(0, "库存商品"),
    非库存商品(1, "非库存商品");

    private Integer type;

    private String description;

    InventoryType(Integer type, String description) {
        this.type = type;
        this.description = description;
    }

    public static InventoryType type(Integer type) {
        if (Objects.nonNull(type)) {
            for (InventoryType inventoryType : InventoryType.values()) {
                if (type.equals(inventoryType.getType())) return inventoryType;
            }
        }
        return InventoryType.库存商品;
    }

    public Integer getType() {
        return type;
    }

    public String getDescription() {
        return description;
    }
}
