package com.jhscale.common.ysscale;

import com.jhscale.common.model.device.UnitType;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;

/**
 * @author lie_w
 * @title: UnitType
 * @projectName ysscale-base
 * @description: 单位枚举
 * @date 2020-08-0515:54
 */
public enum UnitEnum {

    计重("1", UnitType.计重, "重量"),
    计件("2", UnitType.计件, "件"),
    kg("3", UnitType.计重, "kg"),
    g("4", UnitType.计重, "g"),
    ton("5", UnitType.计重, "ton"),
    lb("6", UnitType.计重, "lb"),
    g500("7", UnitType.计重, "500g"),
    g100("8", UnitType.计重, "100g"),
    lb1_4("9", UnitType.计重, "1/4lb"),
    ;

    // 值
    private final String val;

    // 计重类型
    private final UnitType type;

    // 别名
    private final String name;

    UnitEnum(String val, UnitType type, String name) {
        this.val = val;
        this.type = type;
        this.name = name;
    }

    public static UnitEnum unit(Integer unit) {
        if (Objects.nonNull(unit)) {
            for (UnitEnum unitEnum : UnitEnum.values()) {
                if (unit.equals(Integer.parseInt(unitEnum.getVal()))) return unitEnum;
            }
        }
        return UnitEnum.计件;
    }

    public static UnitEnum unit(String unit) {
        if (StringUtils.isNotBlank(unit)) {
            for (UnitEnum unitEnum : UnitEnum.values()) {
                if (unitEnum.getVal().equals(unit)) return unitEnum;
            }
        }
        return UnitEnum.计件;
    }

    public static UnitEnum name(String name) {
        if (StringUtils.isNotBlank(name)) {
            for (UnitEnum unitEnum : UnitEnum.values()) {
                if (unitEnum.getName().equalsIgnoreCase(name)) return unitEnum;
            }
        }
        return UnitEnum.计件;
    }

    /**
     * @description: 单位数重量转换
     * @date: 2024-11-18 13:05:19
     **/
    public static BigDecimal EcsCal_Unit_Value_Kg_Convert(BigDecimal value, UnitEnum oldUnit) {
        UnitEnum newUnit = UnitType.计件.equals(oldUnit.getType()) ? UnitEnum.计件 : UnitEnum.kg;
        BigDecimal val = EcsCal_Unit_ValueConvert(value, oldUnit, newUnit);
        if (UnitType.计件.equals(newUnit.getType())) {
            return val.setScale(0, RoundingMode.HALF_UP);
        } else {
            return val.setScale(3, RoundingMode.HALF_UP);
        }
    }

    /**
     * @description: 单位数重量转换
     * @date: 2024-11-18 13:05:19
     **/
    public static BigDecimal EcsCal_Unit_ValueConvert_Format(BigDecimal value, UnitEnum oldUnit, UnitEnum newUnit) {
        BigDecimal val = EcsCal_Unit_ValueConvert(value, oldUnit, newUnit);
        if (UnitType.计件.equals(newUnit.getType())) {
            return val.setScale(0, RoundingMode.HALF_UP);
        } else {
            return val.setScale(3, RoundingMode.HALF_UP);
        }
    }

    /**
     * @description: 单位数重量转换
     * @date: 2024-11-18 13:05:19
     **/
    public static BigDecimal EcsCal_Unit_ValueConvert(BigDecimal value, UnitEnum oldUnit, UnitEnum newUnit) {
        if (Objects.isNull(oldUnit) || Objects.isNull(newUnit))
            return value;

        if (oldUnit.equals(newUnit))
            return value;
        if ((UnitEnum.计重.equals(oldUnit)) || (UnitEnum.计重.equals(newUnit)))
            return value;
        BigDecimal oldpack = EcsCal_Unit_LoadPack(oldUnit);
        if (oldpack.compareTo(BigDecimal.ZERO) == 0)
            return value;
        BigDecimal newpack = EcsCal_Unit_LoadPack(newUnit);
        if (newpack.compareTo(BigDecimal.ZERO) == 0)
            return value;
        return value.multiply(oldpack).divide(newpack, 7, RoundingMode.HALF_UP);
    }

    private static BigDecimal EcsCal_Unit_LoadPack(UnitEnum unit)     //return 1 for not weight unit
    {
        if (UnitEnum.计件.equals(unit))     //计件商品按照1000计算，为了与常用的kg单位匹配
            return new BigDecimal(1000);
        if ((unit.val() < 2) || (unit.val() > 9))     //位置单位也按kg单位匹配
            return new BigDecimal(1000);

        if (unit.val() == 3)         //kg
            return new BigDecimal("1000");
        else if (unit.val() == 4)         //g
            return new BigDecimal("1");
        else if (unit.val() == 5)         //ton
            return new BigDecimal("1000000");
        else if (unit.val() == 6)         //lb
            return new BigDecimal("453.592");
        else if (unit.val() == 7)         //500g
            return new BigDecimal("500");
        else if (unit.val() == 8)         //100g
            return new BigDecimal("100");
        else if (unit.val() == 9)         //lb/4
            return new BigDecimal("113.398");
        else    //如果系统单位不正确，按照kg计算
            return new BigDecimal(1000);
    }

    public String getVal() {
        return val;
    }

    public Integer val() {
        return Integer.valueOf(this.val);
    }

    public UnitType getType() {
        return type;
    }

    public String getName() {
        return name;
    }
}
