package com.jhscale.test.biz;

import com.alibaba.fastjson.JSONObject;
import com.jhscale.common.exception.GeneralException;
import com.jhscale.common.model.http.JRequest;
import com.jhscale.common.utils.MD5Utils;
import com.jhscale.common.ysscale.YsscaleContents;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.*;

/**
 * @author lie_w
 * @title: TestMain
 * @projectName common
 * @description: TODO
 * @date 2020-10-2214:55
 */
public class TestSignature3Main {

    private static final String KEY = "5AD7084DD00601F212103E77795BB031";

    public static void main(String[] args) throws GeneralException {
        TestSignature testSignature = new TestSignature();
        testSignature.defaultInit();
        testSignature.setSign_type("MD5");
        testSignature.setLockId("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF");
        testSignature.setFid("1");
        testSignature.setTitle("0023F0148E3A");
        testSignature.setStored(new BigDecimal(4.5));
        testSignature.setCash(new BigDecimal(4.5));
        testSignature.setCount(1);
        testSignature.setStr(Arrays.asList("1", "2"));
        testSignature.setSign(testSignature.bulidSign(KEY));
//        System.out.println(testSignature.toString());
//        System.out.println(new BigDecimal(4.5).toString());
//        System.out.println(String.valueOf(testSignature));
//        System.out.println(new Test().toString());
//        System.out.println(Arrays.asList("1").toString());
//        System.out.println(Arrays.asList("1").toArray().toString());
//        Map map = new HashMap();
//        map.put("1", "1");
//        map.put("2", "2");
//        System.out.println(map.toString());

        System.out.println(JSONObject.toJSONString(testSignature));
    }

    public static class TestSignature extends JRequest {

        @ApiModelProperty(value = "登陆锁定ID")
        private String lockId;

        @ApiModelProperty(value = "设备记录编号（HEX）", name = "fid", required = true)
        private String fid;

        @ApiModelProperty(value = "标题(默认第一个商品名)，不传则默认 临时商品", name = "title")
        private String title;

        @ApiModelProperty(value = "储值金额 (小数点位数不传 默认分)", name = "stored")
        private BigDecimal stored;

        @ApiModelProperty(value = "现金 (小数点位数不传 默认分)", name = "cash")
        private BigDecimal cash;

        @ApiModelProperty(value = "明细数量", name = "count", required = true)
        private Integer count;

        @ApiModelProperty(value = "请求IP 不传默认 127.0.0.1", name = "ip")
        private String ip = YsscaleContents.DEFAULT_IP;

        private List<String> str;

        public String getLockId() {
            return lockId;
        }

        public void setLockId(String lockId) {
            this.lockId = lockId;
        }

        public String getFid() {
            return fid;
        }

        public void setFid(String fid) {
            this.fid = fid;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public BigDecimal getStored() {
            return stored;
        }

        public void setStored(BigDecimal stored) {
            this.stored = stored;
        }

        public BigDecimal getCash() {
            return cash;
        }

        public void setCash(BigDecimal cash) {
            this.cash = cash;
        }

        public Integer getCount() {
            return count;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        public String getIp() {
            return ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public List<String> getStr() {
            return str;
        }

        public void setStr(List<String> str) {
            this.str = str;
        }
    }

    public static class TestSign {

        private String uuid;

        private String type;

        private String action;

        private BigDecimal money;

        // 接口版本 [非必填] 默认1.0
        private String version;

        // 随机字符串 [必填]
        private String nonce_str;

        // 请求时间 [必填] 时间秒数 UNINX 时间数 保证请求有效性
        private Integer timestamp;

        // 签名 [必填] 用于签名验证
        private String sign;

        // 签名类型 [非必填] 默认MD5
        private String sign_type;

        // 时区 [非必填] 默认8时区
        private String time_zone;


        public String bulidSign(String key) {
            Map<String, String> map = this.toMap();
            List<String> list = new ArrayList<>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (Objects.nonNull(entry.getValue())) {
                    list.add(entry.getKey() + "=" + entry.getValue() + "&");
                }
            }
            int size = list.size();
            String[] arrayToSort = list.toArray(new String[size]);
            Arrays.sort(arrayToSort, String.CASE_INSENSITIVE_ORDER);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < size; i++) {
                sb.append(arrayToSort[i]);
            }
            String result = sb.toString() + "key=" + key;
            return MD5Utils.str2MD5(result).toUpperCase();
        }

        /**
         * @description: 对象转Map
         **/
        public Map<String, String> toMap(String... params) {
            boolean cont = false;
            List<String> paramsList = new ArrayList<>();
            if (params != null && params.length > 0) {
                cont = true;
                paramsList = Arrays.asList(params);
            }

            Map<String, String> map = new HashMap<>();
            Field[] fields = getClass().getDeclaredFields();
            for (Field field : fields) {
                if ("sign".equals(field.getName()) || cont && paramsList.contains(field.getName())) continue;
                Object obj;
                try {
                    field.setAccessible(true);
                    obj = field.get(this);
                    if (obj != null) {
                        if (obj instanceof String) {
                            String str = (String) obj;
                            if (StringUtils.isNotEmpty(str)) {
                                map.put(field.getName().replace("_$_", ""), str);
                            }
                        } else {
                            map.put(field.getName(), JSONObject.toJSONString(obj));
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return map;
        }

        public String getUuid() {
            return uuid;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getAction() {
            return action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public BigDecimal getMoney() {
            return money;
        }

        public void setMoney(BigDecimal money) {
            this.money = money;
        }

        public String getVersion() {
            return version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getNonce_str() {
            return nonce_str;
        }

        public void setNonce_str(String nonce_str) {
            this.nonce_str = nonce_str;
        }

        public Integer getTimestamp() {
            return timestamp;
        }

        public void setTimestamp(Integer timestamp) {
            this.timestamp = timestamp;
        }

        public String getSign() {
            return sign;
        }

        public void setSign(String sign) {
            this.sign = sign;
        }

        public String getSign_type() {
            return sign_type;
        }

        public void setSign_type(String sign_type) {
            this.sign_type = sign_type;
        }

        public String getTime_zone() {
            return time_zone;
        }

        public void setTime_zone(String time_zone) {
            this.time_zone = time_zone;
        }
    }
}
