package com.jhscale.test.biz;

import com.alibaba.fastjson.JSONObject;
import com.jhscale.common.exception.GeneralException;
import com.jhscale.common.exception.SignatureException;
import com.jhscale.common.exception.TechnologyException;
import com.jhscale.common.model.http.JRequest;
import com.jhscale.common.utils.MD5Utils;
import com.jhscale.common.utils.RandomUtils;

import java.lang.reflect.Field;
import java.util.*;

/**
 * @author lie_w
 * @title: TestMain
 * @projectName common
 * @description: TODO
 * @date 2020-10-2214:55
 */
public class TestSignatureMain {

    private static final String KEY = "fafdsa21fg884fd2s1f2ds";

    public static void main(String[] args) throws GeneralException {
        exp();
        System.out.println(KEY);

        TestSignature testSignature = new TestSignature();
        testSignature.defaultInit();
        testSignature.setSign_type("MD5");
        testSignature.setAction("test.action");
        testSignature.setType("device");
        testSignature.setUuid("0023F0148E3A");
        testSignature.setSign(testSignature.bulidSign(KEY));

        System.out.println(JSONObject.toJSONString(testSignature));
    }

    public static void testSign() throws SignatureException {
        TestSign sign = new TestSign();
        sign.setVersion("1.0");
        sign.setNonce_str(RandomUtils.getRandomStringByLength(32));
        sign.setTimestamp(Integer.parseInt(String.valueOf(System.currentTimeMillis() / 1000L)));
//        sign.setAction("test.action");
        sign.setType("device");
        sign.setUuid("0023F0148E3A");
        sign.setSign(sign.bulidSign(KEY));

        String DATA = JSONObject.toJSONString(sign);

        System.out.println(DATA);

        TestSignature signature = JSONObject.parseObject(DATA, TestSignature.class);
        System.out.println(JSONObject.toJSONString(signature));

        System.out.println(signature.checkPackage(KEY));
    }

    public static void exp() {
        try {
            test();
        } catch (TechnologyException e) {
            System.out.println(e.getApplication());
            System.out.println(e);
//            String format = String.format(e.getCode(), e.getMsgs().toArray(new String[0]));
//            System.out.println(format);
//            e.getKvModels().forEach(kv -> {
//                String msg = e.getCode().replace(kv.getKey(), kv.getVal());
//                System.out.println(msg);
//            });
//            System.out.println(e.getCode());
        }
    }

    public static void test() throws TechnologyException {
        try {
            int i = 1 / 0;
        } catch (Exception e) {
            throw new TechnologyException(e, "jsl-number_error_%s次/%sms", 4, 20);
        }
    }

    public static class TestSignature extends JRequest {

        private String uuid;

        private String type;

        private String action;

        public String getUuid() {
            return uuid;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getAction() {
            return action;
        }

        public void setAction(String action) {
            this.action = action;
        }
    }

    public static class TestSign {

        private String uuid;

        private String type;

        private String action;

        // 接口版本 [非必填] 默认1.0
        private String version;

        // 随机字符串 [必填]
        private String nonce_str;

        // 请求时间 [必填] 时间秒数 UNINX 时间数 保证请求有效性
        private Integer timestamp;

        // 签名 [必填] 用于签名验证
        private String sign;

        // 签名类型 [非必填] 默认MD5
        private String sign_type;

        // 时区 [非必填] 默认8时区
        private String time_zone;


        public String bulidSign(String key) {
            Map<String, String> map = this.toMap();
            List<String> list = new ArrayList<>();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (Objects.nonNull(entry.getValue())) {
                    list.add(entry.getKey() + "=" + entry.getValue() + "&");
                }
            }
            int size = list.size();
            String[] arrayToSort = list.toArray(new String[size]);
            Arrays.sort(arrayToSort, String.CASE_INSENSITIVE_ORDER);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < size; i++) {
                sb.append(arrayToSort[i]);
            }
            String result = sb.toString() + "key=" + key;
            return MD5Utils.str2MD5(result).toUpperCase();
        }

        /**
         * @description: 对象转Map
         **/
        public Map<String, String> toMap(String... params) {
            boolean cont = false;
            List<String> paramsList = new ArrayList<>();
            if (params != null && params.length > 0) {
                cont = true;
                paramsList = Arrays.asList(params);
            }

            Map<String, String> map = new HashMap<>();
            Field[] fields = getClass().getDeclaredFields();
            for (Field field : fields) {
                if ("sign".equals(field.getName()) || cont && paramsList.contains(field.getName())) continue;
                Object obj;
                try {
                    field.setAccessible(true);
                    obj = field.get(this);
                    if (obj != null) {
                        if (obj instanceof String) {
                            map.put(field.getName().replace("_$_", ""), (String) obj);
                        } else {
                            map.put(field.getName(), JSONObject.toJSONString(obj));
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return map;
        }

        public String getUuid() {
            return uuid;
        }

        public void setUuid(String uuid) {
            this.uuid = uuid;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getAction() {
            return action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getVersion() {
            return version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getNonce_str() {
            return nonce_str;
        }

        public void setNonce_str(String nonce_str) {
            this.nonce_str = nonce_str;
        }

        public Integer getTimestamp() {
            return timestamp;
        }

        public void setTimestamp(Integer timestamp) {
            this.timestamp = timestamp;
        }

        public String getSign() {
            return sign;
        }

        public void setSign(String sign) {
            this.sign = sign;
        }

        public String getSign_type() {
            return sign_type;
        }

        public void setSign_type(String sign_type) {
            this.sign_type = sign_type;
        }

        public String getTime_zone() {
            return time_zone;
        }

        public void setTime_zone(String time_zone) {
            this.time_zone = time_zone;
        }
    }
}
