package com.jhscale.test.data;

import com.jhscale.common.model.device._inner.ServerUnPackageObject;
import com.jhscale.common.model.device.log.DLOGV1;
import com.jhscale.common.utils.DateUtils;
import com.jhscale.common.utils.FileUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

/**
 * @author lie_w
 * @title: DataTest
 * @projectName common
 * @description: TODO
 * @date 2022/12/3012:59
 */
public class DataTest {

//    public static final File reader = new File("F:\\JHScale\\Rely\\common\\resources", "A_000.TMS");
//    public static final File writer = new File("F:\\JHScale\\Rely\\common\\resources", "A_001.TMS");

    public static final File reader = new File("E:\\JHScale\\Rely\\common\\resources", "A_000.TMS");
    public static final File writer = new File("E:\\JHScale\\Rely\\common\\resources", "A_001.TMS");

    public static void main(String[] args) throws IOException {
        // FinalDataTest.Public_File_Test();

        String data = "09B500000155EA652F0100000015000020020089E01188800000000015000020030000000000000001001900000018000000033132333400150000200A00001015000020080A00";
        ServerUnPackageObject serverUnPackageObject = new DLOGV1<>().Server_UnPackage(data);
        DLOGV1 before = (DLOGV1) serverUnPackageObject.getObj();
        before.setTradeTime(new Date());
        System.out.println("加密前时间 " + DateUtils.getFormatDate(before.getTradeTime(), DateUtils.YYYY_MM_DD_HH_MM_SS));

        String server_package = before.Server_Package();
        ServerUnPackageObject afterPackage = new DLOGV1<>().Server_UnPackage(server_package);
        DLOGV1 after = (DLOGV1) afterPackage.getObj();
        System.out.println("解密后时间 " + DateUtils.getFormatDate(after.getTradeTime(), DateUtils.YYYY_MM_DD_HH_MM_SS));
    }

    /**
     * @description: 写入文件
     **/
    public static void write2(String content) throws IOException {
        if (writer.exists()) {
            writer.createNewFile();
        }
        OutputStream outputStream = new FileOutputStream(writer);
        boolean result = FileUtils.write(content, outputStream);
        System.out.println(result);
    }

    private static void write(String content) {
        content = StringUtils.isNotBlank(content) ? content : ("PLU\t1\t苹果\t1\t4.5\r\n"
                + "PLU\t2\t香蕉\t1\t6.5\r\n"
                + "S\t1\t2\r\n"
                + "S\t2\t0\r\n"
                + "T\t1\t设备1\r\n");
        FileUtils.writer(content, reader);
    }

    private static String reader() {
        String content = FileUtils.readerLine(reader);
        System.out.println(content);
        return content;
    }

    //    private int tryParseInt(String toParse, int defaultValue) {
//        try {
//            return Integer.parseInt(toParse, 10);
//        } catch (Exception e) {
//            return defaultValue;
//        }
//    }
//
//    private int tryParseInt(String toParse) {
//        return tryParseInt(toParse, 0);
//    }
//
//    private BigDecimal tryParseTMSDecimal(String toParse) {
//        try {
//            int pos = toParse.indexOf(',');
//            if (pos < 0)
//                return new BigDecimal(Integer.parseInt(toParse, 10));
//            else
//                return new BigDecimal(Integer.parseInt(toParse.substring(0, pos), 10)).movePointLeft(Integer.parseInt(toParse.substring(pos + 1), 10));
//        } catch (Exception e) {
//            return BigDecimal.ZERO;
//        }
//    }
//
//    private String tryParseFromTMSString(String toParse) {
//        return toParse.replace('\013', '\n');
//    }
//
//    private String tryParseToTMSString(String toParse) {
//        return toParse.replace('\n', '\013');
//    }
//
//    public GlobalPara TMS_Receive_SingleLine(String line, boolean isDefault) {
//        try {
//            String[] Seg = line.split("\t", -1);
//            if (Seg[0].equals("BAR")) {
//                DBARCODEV1 data = new DBARCODEV1();
//                data.setNo(tryParseInt(Seg[1]));
//                data.setName(Seg[2]);
//                data.setFormat(tryParseInt(Seg[3]));
//                data.setCheck(tryParseInt(Seg[4]));
//                data.setnConst1(tryParseInt(Seg[5]));
//                data.setnConst2(tryParseInt(Seg[6]));
//                data.setDis(Seg[7]);            //这个不可转义
//                SetBarcode(data, isDefault);
//            } else if (Seg[0].equals("LAT")) {
//                DPRINTFORMATV1 data = new DPRINTFORMATV1();
//                data.setNo(tryParseInt(Seg[1]));
//                data.setName(Seg[2]);
//                data.setPf(Seg[3]);
//                SetPrintFormat(data, isDefault);
//            } else if (Seg[0].equals("TMS")) {
//                setTMS(tryParseInt(Seg[1]), tryParseInt(Seg[2]), isDefault);
//            } else if (Seg[0].equals("TMT")) {
//                setTMT(tryParseInt(Seg[1]), tryParseFromTMSString(Seg[2]));
//            } else if (Seg[0].equals("CLS")) {
//                //分类
////                DCategory data=new DCategoryV1();
////                SetCategory()
//            } else if (Seg[0].equals("PLU")) {
//                //商品
//            } else if (Seg[0].equals("SAL")) {
//                //营业员
//            } else if (Seg[0].equals("BMP")) {
//                //位图
//                //需要立刻发起或延后发起向打印机发送位图
//            } else if (spContentSegs.contains(Seg[0])) {
//                //所有客制的Seg信息统一存放在spContentBuf中
//                int id = tryParseInt(Seg[1]);
//                String content = line.substring(line.indexOf("\t", Seg[0].length() + 1) + 1);
//                if (!spContentBuf.containsKey(Seg[0])) {
//                    spContentBuf.put(Seg[0], new HashMap<Integer, String>());
//                }
//                spContentBuf.get(Seg[0]).put(id, content);
//            } else if (!isDefault) {
//                //什么都不做，剩下部分仅对Default文件生效
//            } else if (Seg[0].equals("#TMS_Max")) {
//                tms_Max.put(tryParseInt(Seg[1]), tryParseInt(Seg[2]));
//            } else if (Seg[0].equals("#TMS_Access")) {
//                tms_Access.put(tryParseInt(Seg[1]), tryParseInt(Seg[2]));
//            } else if (Seg[0].equals("#SpVersion")) {
//                spVersion = tryParseInt(Seg[1]);
//            } else if (Seg[0].equals("#SpSegs")) {
//                spContentSegs = Arrays.asList(Seg[1].split("\\|"));
//            }
//        } catch (Exception exp) {
//
//        }
//
//        return this;
//    }
//
//    public GlobalPara TMS_Receive_MultiLine(String lines, boolean isDefault) {
//        String[] sls = lines.split("\r|\n");
//        for (int loop = 0; loop < sls.length; loop++) {
//            TMS_Receive_SingleLine(sls[loop], isDefault);
//        }
//        return this;
//    }
//
//    public GlobalPara TMS_Receive_MultiLine(String lines) {
//        return TMS_Receive_MultiLine(lines, false);
//    }
//
//    public String TMS_Send(DBARCODEV1 data) {
//        return String.format("BAR\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t",
//                data.getNo().toString(),
//                data.getName(),
//                data.getFormat().toString(),
//                data.getCheck().toString(),
//                data.getnConst1().toString(),
//                data.getnConst2().toString(),
//                data.getDis());
//    }
//
//    public String TMS_Send(DPRINTFORMATV1 data) {
//        return String.format("LAT\t%s\t%s\t%s\t",
//                data.getNo().toString(),
//                data.getName(),
//                data.getPf());
//    }
//
//    public String TMS_Send_TMS(Integer no, Integer value) {
//        return String.format("TMS\t%s\t%s\t",
//                no.toString(),
//                value.toString());
//    }
//
//    public String TMS_Send_TMT(Integer no, String value) {
//        return String.format("TMS\t%s\t%s\t",
//                no.toString(),
//                tryParseToTMSString(value));
//    }

    //    /**
//     * @param class_annotation 类注注解定义
//     * @param field_annotation 字段注解定义
//     * @param val              数据值
//     * @description: 公开 字段内容打包
//     **/
//    default String Public_Field_Content_Package(DataClass class_annotation, PublicField field_annotation, Object val) {
//        StringBuffer buffer = new StringBuffer();
//        switch (field_annotation.type()) {
//            case INT:
//                Integer i = (Integer) (val == null ? this.defaultVal(field_annotation.defaultVal(), Integer.class) : val);
//                if (i != null) buffer.append(i);
//                break;
//            case LNG:
//                Long l = (Long) (val == null ? this.defaultVal(field_annotation.defaultVal(), Long.class) : val);
//                if (l != null) buffer.append(l);
//                break;
//            case LNT:
//                Long lt = (Long) (val == null ? this.defaultVal(field_annotation.defaultVal(), Long.class) : val);
//                if (lt != null) {
//                    String time_space = DateUtils.getFormatDate_YYYY_MM_DD_HH_MM_SS_Space(new Date(lt));
//                    String[] split = time_space.split(" ");
//                    for (int index = 0; index < split.length; index++) {
//                        buffer.append(split[index])
//                                .append((index != (split.length - 1)) ?
//                                        class_annotation.separator() : "");
//                    }
//                }
//                break;
//            case TIM:
//                Date date = (Date) (val == null ? this.defaultVal(field_annotation.defaultVal(), Date.class) : val);
//                if (date != null) {
//                    String time_space = DateUtils.getFormatDate_YYYY_MM_DD_HH_MM_SS_Space(date);
//                    String[] split = time_space.split(" ");
//                    for (int index = 0; index < split.length; index++) {
//                        buffer.append(split[index])
//                                .append((index != (split.length - 1)) ?
//                                        class_annotation.separator() : "");
//                    }
//                }
//                break;
//            case BDL:
//                BigDecimal bigDecimal = (BigDecimal) (val == null ? this.defaultVal(field_annotation.defaultVal(), BigDecimal.class) : val);
//                if (bigDecimal != null) buffer.append(bigDecimal.toString());
//                break;
//            case FML:
//                FieldModel fieldModel = (FieldModel) (val == null ? this.defaultVal(field_annotation.defaultVal(), field_annotation.field_class()) : val);
//                if (fieldModel != null) buffer.append(fieldModel.Public_Package());
//                break;
//            case TXT:
//                String str = (String) (val == null ? this.defaultVal(field_annotation.defaultVal(), String.class) : val);
//                if (StringUtils.isNotBlank(str)) buffer.append(ByteUtils.tryParseToString(str));
//                break;
//            case LST:
//                ((List) val).forEach(oval -> {
//
//                });
//                break;
//            case MAP:
//                break;
//        }
//        return buffer.toString();
//    }
}
