package com.jhscale.test.data;

import com.jhscale.common.em.BarcodeScale;
import com.jhscale.common.model.device.DConstant;
import com.jhscale.common.model.device._inner.*;
import com.jhscale.common.model.device.ai_feature.DAIFeature;
import com.jhscale.common.model.device.ai_feature.DAIFeatureV1;
import com.jhscale.common.model.device.barcode_format.DBarcodeFormat;
import com.jhscale.common.model.device.barcode_format.DBarcodeFormatV1;
import com.jhscale.common.model.device.bitmap.DBitMap;
import com.jhscale.common.model.device.bitmap.DBitMapV1;
import com.jhscale.common.model.device.category.DCategory;
import com.jhscale.common.model.device.category.DCategoryV1;
import com.jhscale.common.model.device.data_parameter.DDataParameterV1;
import com.jhscale.common.model.device.info.DDeviceInfo;
import com.jhscale.common.model.device.info.DDeviceInfoV1;
import com.jhscale.common.model.device.info.DMAC;
import com.jhscale.common.model.device.info.DTIM;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INA;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INF;
import com.jhscale.common.model.device.info.inner.DDeviceInfo_INM;
import com.jhscale.common.model.device.label_format.DLabelFormat;
import com.jhscale.common.model.device.label_format.DLabelFormatV1;
import com.jhscale.common.model.device.log.DLOGV1;
import com.jhscale.common.model.device.log.module.DGoods;
import com.jhscale.common.model.device.log.module.DSource;
import com.jhscale.common.model.device.other.DSpDWLV1;
import com.jhscale.common.model.device.plu.DPLUV5;
import com.jhscale.common.model.device.plu.FDPLU;
import com.jhscale.common.model.device.plu.em.Restriction;
import com.jhscale.common.model.device.plu.inner.DAutoDiscountV2;
import com.jhscale.common.model.device.plu.inner.DManualDiscount;
import com.jhscale.common.model.device.plu.module.*;
import com.jhscale.common.model.device.salejob.DSaleJob;
import com.jhscale.common.model.device.salejob.DSaleJobV1;
import com.jhscale.common.model.device.saleman.DSaleMan;
import com.jhscale.common.model.device.saleman.DSaleManV1;
import com.jhscale.common.model.device.shortkey.DShortKey;
import com.jhscale.common.model.device.shortkey.DShortKeyV1;
import com.jhscale.common.model.device.shortpage.DShortPage;
import com.jhscale.common.model.device.shortpage.DShortPageV1;
import com.jhscale.common.model.device.shortpage_formwork.DShortPageFormwork;
import com.jhscale.common.model.device.shortpage_formwork.DShortPageFormworkV1;
import com.jhscale.common.model.device.text_parameter.DTextParameter;
import com.jhscale.common.model.device.text_parameter.DTextParameterV1;
import com.jhscale.common.model.license.JRSAEncryptDecrypt;
import com.jhscale.common.model.license.RSAEncryptDecrypt;
import com.jhscale.common.utils.*;
import com.jhscale.common.ysscale.UnitEnum;

import java.io.*;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import static com.jhscale.common.model.device.DConstant.*;
import static com.jhscale.test.data.Resource.Tensorflow_Feature_JSON;
import static com.jhscale.test.data.Resource.Tensorflow_Feature_TMX;

/**
 * @author lie_w
 * @title: FinalDataTest
 * @projectName common
 * @description: TODO
 * @date 2023/1/713:26
 */
@SuppressWarnings("all")
public class FinalDataNoReflexTest {

    public static final File reader = new File("F:\\JHScale\\Resources", "A_000.TMS");
    public static final File reader1 = new File("F:\\JHScale\\Resources\\tms", "SPLU.TMS");
    public static final File reader2 = new File("F:\\JHScale\\Resources\\tms", "SPLU (2).TMS");
    public static final File reader3 = new File("F:\\JHScale\\Resources\\tms", "SPLU (3).TMS");
    public static final File reader4 = new File("E:\\JHScale\\Resources\\tms", "Android11.TMS");
    // public static final File reader = new File("F:\\JHScale\\Resources", "1677151733953.txt");
    // public static final File reader = new File("F:\\JHScale\\Resources", "1677202617039.txt");
    public static final File writer = new File("F:\\JHScale\\Resources", "A_001.TMS");

    // public static final File reader_json = new File("F:\\JHScale\\Resources", "1677203420412.txt");
    public static final File reader_json = new File("F:\\JHScale\\Resources", "1677580215168.txt");

    public static final File pic_file = new File("F:\\JHScale\\Resources", "pic.jpg");

    static {
        Map<String, Integer> tms_SpDWL = new HashMap<>();
        tms_SpDWL.put("NU3", 1);
        tms_SpDWL.put("SU2", 1);
        tms_SpDWL.put("IR2", 1);
        DDataExecute dataExecute = new DDataExecute() {
            @Override
            public Integer getSpDWL(String key) {
                return tms_SpDWL.get(key);
            }
        };
        DDataUtils.setDataExecute(dataExecute);
    }

    public static void main(String[] args) throws FileNotFoundException {
        // 方法测试
        // Method_Test();
        // DData Test
        // DDataUtils_Test();
        // 服务 日志 组装 解析
        // Server_LOG_Test();
        // Server_LOG_Test_1();
        // 公开协议测试 数据 文本 参数
        // Public_Data_Txt_Test();
        // 公开协议测试 条码 标签 位图格式
        // Public_Barcode_Label_BitMap_Test();
        // 公开测试 营业员 分类 快捷键 快捷页
        // Public_SalesJob_SalesMan_Category_ShortKey_ShortPage_ShortPageFormwork();
        // 公开协议日志测试
        // Public_Log_Test();
        // 公开协议测试 PLU
        // Public_PLU_Test();
        // 公开协议测试 设备信息
        // Public_INF_MAC_TIM_Test();
        // 公开协议测试 文件创建 与 生成
        // Public_File_Test();
        // 公开协议测试 文件创建 与 生成 JSON测试
        // Public_File_Test_JSON();
        // 公开协议测试 Distribute 文件创建 与 生成 JSON测试
        // Public_File_Test_JSON_Distribute();
        // 公开协议 安卓测试
        // Public_File_Android_Test();
        // 公开协议测试 删除
        // Public_Delete();
        // 公开协议测试AI特征参数
        // Public_Feature_Test();
        // Public_Feature_Test1();
        // 营养表
        // SpDWL_Test();
        // 数据测试
        Data_Test();
    }

    private static void Data_Test() {
        String content = "DWL\tAIF\t\n" +
                "AIF\t8010000002600001\t梨\t1\t2#0#3.9317446~SG00000000010@L,-1.5385408~PLU00000013220@td,-4.182502~PLU00000013221@wwc,-6.809612~PLU00000013255@cz,-7.5973396~PLU00000013139@cj,-7.708309~PLU00000013194@mg,-7.9759383~PLU00000013285@nm,-8.784601~PLU00000013203@qc,-9.846491~PLU00000013224@xhs,-10.057369~PLU00000014967@tg,-10.377375~PLU00000013279@ll,-10.505498~PLU00000013236@xbg,-10.522852~PLU00000013199@ng,-10.850628~PLU00000013185@lo,-11.362586~PLU00000013246@yc,-11.47336~PLU00000013289@pg,-12.0477915~PLU00000013226@xlh,-12.164114~PLU00000013309@xj,-12.600802~PLU00000013282@mht,-12.617043~PLU00000013167@hg,-13.3738575~PLU00000013477@thc,-13.431407~PLU00000013301@sl,-13.433331~PLU00000013152@dg,-13.555759~PLU00000013288@pp,-13.681877~PLU00000013334@jr,-13.7404585~PLU00000013274@jz,-13.744125~PLU00000035128@xxym,-13.911743~PLU00000013147@dbc,-14.063711~PLU00000013263@hmg,-14.4104~PLU00000013243@qz,-14.424593~QT00000000036@NM,-14.559234~PLU00000013216@st,-14.70504~PLU00000013181@kxc,-14.793076~SG00000000025@TZ,-14.939234~PLU00000013223@ws,-15.265938~PLU00000078559@dgy,-15.270512~PLU00000013281@mg,-15.636055~PLU00000013339@tb,-15.777885~PLU00000013258@qz,-15.965713~PLU00000013184@sj,-16.137474~PLU00000013271@ht,-16.271639~PLU00000013345@zd,-16.460737~PLU00000013230@xg,-16.48895~PLU00000013204@qj,-16.718237~PLU00000013179@jxc,-16.784065~PLU00000013149@dst,-16.862652~PLU00000013191@md,-16.968176~PLU00000013165@hc,-17.118425~PLU00000013131@blb,-17.729084~PLU00000013174@jb,-17.883133~PLU00000013275@lm,-17.925129~PLU00000013176@jzg,-17.93189~PLU00000013244@zs,-18.099934~PLU00000013286@nyg,-18.114458~PLU00000013232@xc,-18.287117~PLU00000013161@hlj,-18.301647~SG00000000042@ZPT,-18.325455~PLU00000013315@yz,-18.343546~PLU00000032666@xlg,-18.54145~PLU00000013299@sz,-18.77088~SC00000000014@CT,-18.890146~PLU00000013344@zdg,-19.157127~PLU00000013225@xhl,-19.190773~PLU00000013173@jd,-19.230179~PLU00000013210@sc,-19.272194~PLU00000015223@lpt,-19.358965~PLU00000013357@zx,-19.439415~PLU00000013353@zt,-19.582594~PLU00000013207@qk,-19.609577~PLU00000013202@qc,-19.615095~PLU00000128201@hjz,-19.63498~PLU00000013434@hz,-19.669353~PLU00000013276@lz,-19.7165~PLU00000013170@jmc,-19.728043~PLU00000807699@xz,-19.81287~PLU00000013405@yd,-19.86784~PLU00000013261@fl,-20.049217~PLU00000013341@whr,-20.127235~PLU00000013138@bc,-20.170296~PLU00000105968@ds,-20.252495~SC00000000163@SJD,-20.326904~PLU00000016706@dy,-20.436615~PLU00000013238@ymc,-20.55122~PLU00000013192@mdm,-20.732693~PLU00000013228@xc,-20.857056~PLU00000013280@ly,-20.997562~PLU00000013307@xg,-21.014~PLU00000013245@zgl,-21.153238~PLU00000013150@dsm,-21.220627~PLU00000013346@zed,-21.222483~PLU00000013241@yt,-21.423107~PLU00000013485@bd,-21.621712~PLU00000013359@zx,-21.66298~SC00000000173@SNG,-21.737822~PLU00000013172@jj,-22.078693~PLU00000013187@ls,-22.090548~PLU00000013177@jc,-22.168037~PLU00000020581@wd,-22.182533~PLU00000013163@hs,-22.439024~PLU00000013213@sg,-22.640295~PLU00000013335@lp,-23.058893~PLU00000013348@zg,-23.231297~PLU00000013148@dc,-23.64043~PLU00000013427@my,-23.933949~PLU00000013159@hxg,-24.256783~PLU00000013458@dy,-24.501781~PLU00000013193@mx,-24.60982~PLU00000013360@zy,-24.735779~PLU00000013273@hlg,-25.134274~PLU00000013277@lz,-25.402164~PLU00000013171@jc,-25.645988~PLU00000013336@ljr,-25.671116~PLU00000013178@jh,-25.81274~PLU00000013479@zpg,-26.085464~PLU00000013469@xhy,-26.627705~PLU00000013343@zdc,-26.68533~PLU00000013164@hlb,-26.80688~PLU00000013461@hy,-27.180494~PLU00000013456@cy,-27.389656~PLU00000013384@yz,-28.270039~PLU00000027759@xm,-28.55582~PLU00000013209@sy,-28.903584~PLU00000013342@zby,-28.94687~SC00000000147@YD,-29.577904~PLU00000013160@hld,-30.154902~PLU00000013253@cm,-30.343512~PLU00000013352@zs,-30.886265~PLU00000021817@yjm,-32.908337~PLU00000013180@kg,-35.96569~PLU00000016778@jj\t0\t240507\t\n" +
                "END\tAIF\t";
        UnPackageResponse response = DDataUtils.Public_UnPackage_Lines_Distribute(content, false);
        System.out.println(response);

        for (PublicExecute execute : response.getExecutes()) {
            PublicExecuteModify executeModify = DDataUtils.Public_UnPackage_ModifyCache_To_Modify_No_Reflex((PublicExecuteModifyCache) execute, false);
            System.out.println(executeModify.toJSON());
        }


    }

    /**
     * @description: 营养表解析
     **/
    private static void SpDWL_Test() {
        String SpDWL = "NU3\t1\tTestNU_A\tBBB\t50\tCC\tDD\t100,0\t1,1\t200,0\t2,1\t300,0\t3,1\t400,0\t4,1\t500,0\t5,1\t600,0\t6,1\t700,0\t7,1\t800,0\t8,1\t900,0\t9,1\t1000,0\t1,0\tEE\t1100,0\t11,1\tFF\t1200,0\t12,1\t\t0,0\t0,0\t\t0,0\t0,0\t\t0,0\t0,0\t\t18,0\t0,0\t\t0,0\t0,0\t\t0,0\t0,0\t\t0,0\t0,0\t\t0,0\t0,0\t";
        PublicExecute execute = DDataUtils.Public_UnPackage_Line_Distribute(SpDWL);
        System.out.println(execute.toJSON());
        PublicExecuteModify executeModify = DDataUtils.Public_UnPackage_ModifyCache_To_Modify_No_Reflex((PublicExecuteModifyCache) execute);
        System.out.println(executeModify.toJSON());

        DSpDWLV1 dSpDWLV = (DSpDWLV1) executeModify.getModels().get(0);
        PublicExecuteModify modify = new PublicExecuteModify();
        modify.setType(dSpDWLV.getKey());
        modify.add(dSpDWLV);
        String s = DDataUtils.Public_Package_No_Reflex(modify);
        System.out.println(s);

        String SpDWL1 = "SU2\t1\tTEST_F1\tFFFF1\t";
        PublicExecute execute1 = DDataUtils.Public_UnPackage_Line_Distribute(SpDWL1);
        System.out.println(execute1.toJSON());
        PublicExecuteModify executeModify1 = DDataUtils.Public_UnPackage_ModifyCache_To_Modify_No_Reflex((PublicExecuteModifyCache) execute1);
        System.out.println(executeModify1.toJSON());

        DSpDWLV1 dSpDWLV1 = (DSpDWLV1) executeModify1.getModels().get(0);
        PublicExecuteModify modify1 = new PublicExecuteModify();
        modify1.setType(dSpDWLV1.getKey());
        modify1.add(dSpDWLV1);
        String s1 = DDataUtils.Public_Package_No_Reflex(modify1);
        System.out.println(s1);
    }

    private static void Public_Feature_Test1() {
        // 读取源文件
        String content = FileUtils.reader(Tensorflow_Feature_JSON);
        // System.out.println(content);

        List<DAIFeatureV1> file_features = JSONUtils.jsonToList(content, DAIFeatureV1.class);

        String yyMMdd = DateUtils.getFormatDate(new Date(), "yyMMdd");
        file_features.forEach(feature -> {
            feature.setWeight(new int[feature.getFeature_specials().length]);
            feature.setCounter(new int[feature.getFeature_specials().length]);
            String[] creates = new String[feature.getFeature_specials().length];
            for (int i = 0; i < feature.getFeature_specials().length; i++) {
                creates[i] = yyMMdd;
            }
            feature.setCreates(creates);
            feature.arrayToMap()
                    .mapToArray();
        });

        PublicExecute publicExecute = new PublicExecuteModify(AIF);
        for (DAIFeatureV1 file_feature : file_features) {
            ((PublicExecuteModify) publicExecute).add(file_feature);
        }
        String public_package = DDataUtils.Public_Package(publicExecute);
        FileUtils.writer(public_package, Tensorflow_Feature_TMX);

        List<PublicExecute> publicExecutes = DDataUtils.Public_UnPackage(public_package);
        System.out.println("PublicExecute: " + publicExecute.toJSON().equals(publicExecutes.get(0).toJSON()));
    }

    /**
     * @description: 公开协议测试AI特征参数
     **/
    private static void Public_Feature_Test() throws FileNotFoundException {
        // 读取源文件
        String content = FileUtils.reader(Tensorflow_Feature_JSON);
        // System.out.println(content);

        List<DAIFeatureV1> file_features = JSONUtils.jsonToList(content, DAIFeatureV1.class);

        String yyMMdd = DateUtils.getFormatDate(new Date(), "yyMMdd");
        file_features.forEach(feature -> {
            feature.setWeight(new int[feature.getFeature_specials().length]);
            feature.setCounter(new int[feature.getFeature_specials().length]);
            String[] creates = new String[feature.getFeature_specials().length];
            for (int i = 0; i < feature.getFeature_specials().length; i++) {
                creates[i] = yyMMdd;
            }
            feature.setCreates(creates);
        });

        // System.out.println(JSONUtils.objectToJSON(file_features));

        String Feature_No_Reflex = "";
        for (DAIFeatureV1 file_feature1 : file_features) {
            String Public_Package_1_1 = file_feature1.Public_Package_No_Reflex().toString();
            // System.out.println("DAIFeatureV1 Public_Package_0_1: ---" + Public_Package_1_1);

            String Public_Package_1_2 = file_feature1.Public_Package();
            // System.out.println("DAIFeatureV1 Public_Package_0_2: ---" + Public_Package_1_2);

            // System.out.println("DAIFeature_1: " + Public_Package_1_2.equals(Public_Package_1_1));

            Feature_No_Reflex += Public_Package_1_1;

            DAIFeature file_feature2_1 = new DAIFeatureV1<>().Public_UnPackage_No_Reflex(Public_Package_1_1);
            // System.out.println("DAIFeatureV1 file_feature2_1: ---" + file_feature2_1.toJSON());

            DAIFeature file_feature2_2 = new DAIFeatureV1<>().Public_UnPackage(Public_Package_1_2);
            // System.out.println("DAIFeatureV1 file_feature2_2: ---" + file_feature2_2.toJSON());

            DAIFeature file_feature2_3 = new DAIFeatureV1<>().Public_UnPackage(Public_Package_1_1);
            // System.out.println("DAIFeatureV1 file_feature2_3: ---" + file_feature2_3.toJSON());

            // System.out.println("DAIFeature_2: " + file_feature2_3.toJSON().equals(file_feature2_2.toJSON()));

            // System.out.println("DAIFeature: " + file_feature1.toJSON().equals(file_feature2_1.toJSON()));
        }
        FileUtils.writer(Feature_No_Reflex, Tensorflow_Feature_TMX);
    }

    /**
     * @description: DData Test
     **/
    private static void DDataUtils_Test() {
        String content = "\r\nUPL\tSCG\t\r\nUPL\tSGF\t\r\nUPL\tCLS\t\r\nUPL\tPLU\t\r\n";
        List<PublicExecute> executes = DDataUtils.Public_UnPackage(content);
        System.out.println(JSONUtils.objectToJSON(executes));
    }

    /**
     * @description: 公开协议测试 删除
     **/
    private static void Public_Delete() {
        PublicExecuteDelete executeDelete = new PublicExecuteDelete(PLU);
        executeDelete.add(0, 1, 2, 3, 4);
        String public_package_delete = DDataUtils.Public_Package(executeDelete);
        System.out.println(public_package_delete);

        List<PublicExecute> executes = DDataUtils.Public_UnPackage(public_package_delete);
        System.out.println(JSONUtils.objectToJSON(executes));
        System.out.println();

        PublicExecuteRecovery executeRecovery = new PublicExecuteRecovery(PLU);
        executeRecovery.add(1, 2, 3, 4);
        String public_package_recovery = DDataUtils.Public_Package(executeRecovery);
        System.out.println(public_package_recovery);
    }

    /**
     * @description: 公开协议 安卓测试
     **/
    private static void Public_File_Android_Test() {
        String content = "{\"aiType\":{\"models\":[],\"type\":0},\"category\":17,\"costTrade\":0.0,\"fixedWeight\":0.0,\"indexBar\":\"6922266460531\",\"itemCode\":0,\"name\":\"普通粳米\",\"percentTare\":0.0,\"pictures\":[\"http://jhscale-dev.oss-cn-shanghai.aliyuncs.com/salesPLU/1652415710528905.jpeg\"],\"price\":{\"price\":10.0},\"print\":{},\"saveAsWeight\":0,\"simple\":\"PTJM\",\"state\":2,\"tare\":0.0,\"taxRate\":0,\"taxType\":0,\"text\":{},\"time\":{},\"unit\":3,\"no\":126}";

        DPLUV5 dpluv5 = JSONUtils.jsonToObject(content, DPLUV5.class);

        PublicExecuteModify executeModify = new PublicExecuteModify(PLU);
        executeModify.add(dpluv5);
        String result_content = DDataUtils.Public_Package(executeModify);
        System.out.println(result_content);

    }

    private static void Public_File_Test_JSON_Distribute() throws FileNotFoundException {
        InputStream inputStream = new FileInputStream(reader);
        String content = FileUtils.reader(inputStream);
        // System.out.println(content);

        UnPackageResponse unPackageResponse = DDataUtils.Public_UnPackage_Lines_Distribute(content);

        List<PublicExecute> executes = Optional.ofNullable(unPackageResponse.getExecutes())
                .orElse(Collections.emptyList())
                .stream().map(execute -> {
                    if (execute instanceof PublicExecuteModifyCache) {

                        if (TMT.equalsIgnoreCase(execute.getType())) {
                            System.out.println(execute.getType());
                        }

                        PublicExecuteModify executeModifyNoReflex = DDataUtils.Public_UnPackage_ModifyCache_To_Modify_No_Reflex((PublicExecuteModifyCache) execute);
                        PublicExecuteModify executeModifyReflex = DDataUtils.Public_UnPackage_ModifyCache_To_Modify((PublicExecuteModifyCache) execute);
                        boolean bean_diff = executeModifyNoReflex.toJSON().equals(executeModifyReflex.toJSON());
                        System.out.println("Un_Package Result: " + bean_diff);
                        if (!bean_diff) {
                            System.out.println(executeModifyNoReflex.toJSON());
                            System.out.println(executeModifyReflex.toJSON());
                        }

                        String _package1 = executeModifyNoReflex.Package_No_Reflex();
                        String _package2 = executeModifyReflex.Package();
                        boolean part_diff = _package1.equals(_package2);
                        System.out.println("Package Result: " + part_diff);
                        if (!part_diff) {
                            System.out.println(_package1);
                            System.out.println(_package2);
                        }

                        if (PLU.equalsIgnoreCase(execute.getType())) {
                            List<PublicExecute> r2 = DDataUtils.Public_UnPackage(_package1);
                            String c2 = DDataUtils.Public_Package(r2);

                            UnPackageResponse r1 = DDataUtils.Public_UnPackage_Lines_Distribute(_package1, false);
                            for (PublicExecute publicExecute : r1.getExecutes()) {
                                if (publicExecute instanceof PublicExecuteModifyCache) {
                                    PublicExecuteModify executeModify = DDataUtils.Public_UnPackage_ModifyCache_To_Modify((PublicExecuteModifyCache) publicExecute);
                                    List<PublicExecute> list = new ArrayList<>();
                                    list.add(executeModify);
                                    String c1 = DDataUtils.Public_Package_No_Reflex(list);

                                    boolean c_diff = c1.equals(c1);
                                    System.out.println("c_diff Result: " + c_diff);
                                    if (!c_diff) {
                                        System.out.println("c1: " + _package1);
                                        System.out.println("c2: " + _package2);
                                    }
                                }
                            }
                        }

                        return executeModifyNoReflex;
                    } else {
                        return execute;
                    }
                }).collect(Collectors.toList());

    }

    /**
     * @description: 公开协议测试 文件创建 与 生成 JSON测试
     **/
    private static void Public_File_Test_JSON() throws FileNotFoundException {
        InputStream inputStream = new FileInputStream(reader4);
        String content = FileUtils.reader(inputStream);
        // System.out.println(content);

        List<PublicExecute> executes = DDataUtils.Public_UnPackage(content);
        String result_content = DDataUtils.Public_Package(executes);
        System.out.println(result_content);

        List<PublicExecute> result_executes = DDataUtils.Public_UnPackage(result_content);
        System.out.println(JSONUtils.objectToJSON(result_executes));
    }

    /**
     * @description: 公开协议测试 文件创建 与 生成
     **/
    public static void Public_File_Test() throws FileNotFoundException {
        // 读取源文件
        InputStream inputStream = new FileInputStream(reader);
        String content = FileUtils.reader(inputStream);
        // System.out.println(content);
        // 解析内容
        List<PublicExecute> publicExecutes = DDataUtils.Public_UnPackage(content);
        // 解析内容组装文件内容
        String result_content = DDataUtils.Public_Package(publicExecutes.toArray(new PublicExecute[publicExecutes.size()]));
        // System.out.println(result_content);
        // 文件内容写入文件
        boolean write = FileUtils.write(result_content, new FileOutputStream(writer));
        System.out.println(write);

        // 读取写入的文件
        InputStream writer_inputStream = new FileInputStream(writer);
        String writer_content = FileUtils.reader(writer_inputStream);
        // 解析写入内容
        List<PublicExecute> writer_publicExecutes = DDataUtils.Public_UnPackage(writer_content);
        System.out.println(writer_publicExecutes.size());
    }

    /**
     * @description: 公开协议测试 设备信息
     **/
    private static void Public_INF_MAC_TIM_Test() {
        DDeviceInfo deviceInfo1 = new DDeviceInfoV1<>()
                .setIna(new DDeviceInfo_INA()
                        .setEncoding("GB2312")
                        .setWord_encoding("GB2312")
                        .setRom(0)
                        .setWord_rom(8388608)
                        .setF1(8388608)
                        .setF2(8)
                        .setF3(8))
                .setInm(new DDeviceInfo_INM()
                        .setSign("SCOPAAISG2704A0E126626")
                        .setUnique_sign("0023F0141292")
                        .setLan(1))
                .setInf(new DDeviceInfo_INF()
                        .setStore_name("富百汇生鲜超市（人民街）")
                        .setDevice_name("33")
                        .setDevice_serial(33)
                        .setDevice_version("JB-xA CC138 V3.11D7"));
        String INF_public_package = deviceInfo1.Public_Package();
        System.out.println("INF Public_Package_INF: --- \n" + INF_public_package);


        String s = DDataUtils.Public_Package(new PublicExecuteModify(INF).add(deviceInfo1));
        System.out.println(s);

        DDeviceInfoV1 deviceInfo2 = new DDeviceInfoV1<>().Public_UnPackage(INF_public_package);
        System.out.println("INF Public_UnPackage_INF: --- \n" + deviceInfo2.toJSON());

        DMAC mac1 = new DMAC()
                .setMac("SCOPAAISG2704A0E126626");
        String MAC_public_package = mac1.Public_Package();
        System.out.println("MAC_public_package: --- \n" + MAC_public_package);
        DMAC mac2 = new DMAC<>().Public_UnPackage(MAC_public_package);
        System.out.println("MAC_public_un_package: --- \n" + mac2.toJSON());

        DTIM tim1 = new DTIM()
                .setTime(new Date());
        String TIM_public_package = tim1.Public_Package();
        System.out.println("TIM_public_package: --- \n" + TIM_public_package);
        DTIM tim2 = new DTIM<>().Public_UnPackage(TIM_public_package);
        System.out.println("TIM_public_un_package: --- \n" + tim2.toJSON());
    }

    /**
     * @description: 公开协议 日志
     **/
    private static void Public_Log_Test() {
        DLOGV1 log = Dlog();
        String public_package = log.Public_Package();
        System.out.println("Public_Package: \n" + public_package);
//        FileUtils.writer(public_package, DataTest.file);
        DLOGV1 log2 = new DLOGV1<>().Public_UnPackage(public_package);
        System.out.println(log2.toJSON());
    }

    /**
     * @description: 公开协议测试 PLU
     **/
    public static FDPLU Public_PLU_Test() {
        FDPLU PLU1 = new DPLUV5<>()
                .setNo(23)
                .setItemCode(23)
                .setIndexBar("AAA1111111111")
                .setUnit(2)
                .setPrint(new DPrintWithBitMapV1()
                        .setType1(1)
                        .setBarcode1(1)
                        .setSign1(1)
                        .setType2(2)
                        .setBarcode2(2)
                        .setSign2(2)
                        .setBitmap(3))
                .setCategory(9)
                .setName("青苹果#海天酱油")
                .setText(new DTextV1()
                        .setTexts(Arrays.asList("111", "222", "33")))
                .setTime(new DTimeV2()
                        .setUseDatePS(1)
                        .setUseDatePC(10)
                        .setSaleDatePS(1)
                        .setSaleDatePC(11)
                        .setSaleTimePS(1)
                        .setSaleTimePC(12)
                        .setPackDatePS(1)
                        .setPackDatePC(13)
                        .setPackTimePS(1)
                        .setPackTimePC(14))
                .setPrice(
//                        new DPriceV2()
//                        .setPrice(new BigDecimal("8.6"))
                        new DPriceV2()
                                .setPrice(new BigDecimal("8.63"))
                                .addManualDiscounts(/*new DManualDiscount()
                                                .setRestriction(0)
                                                .setType(2)
                                                .setDiscount(BigDecimal.valueOf(0.78)),*/
                                        new DManualDiscount()
                                                .setRestriction(1)
                                                .setType(1)
                                                .setDiscount(BigDecimal.valueOf(0.56)))
                                .addAutoDiscounts(new DAutoDiscountV2()
                                                .setType(2)
                                                .setDate(127)
                                                .setLower(BigDecimal.valueOf(0.46))
                                                .setUpper(BigDecimal.valueOf(0.78))
                                                .setDiscount(BigDecimal.valueOf(0.55)),
                                        null,
                                        new DAutoDiscountV2()
                                                .setType(3)
                                                .setDate(126)
                                                .setLower(BigDecimal.valueOf(0.56))
                                                .setUpper(BigDecimal.valueOf(0.45))
                                                .setDiscount(BigDecimal.valueOf(0.55)),
                                        null)
                )
                .setSimple("QPGHTJY")
                .setPictures(Arrays.asList("123", "345", "456"))
                .setAiType(
                        new DAIType()
                                .setType(1)
                                .addModels(/*new DAIModel("M-AI-0001", "M-AI-0001-Name"),*/
                                        new DAIModel("M-AI-0002", "M-AI-0002-Name"))
//                                .addOthers(new DAIOther("M-AI-003", 0.45),
//                                        new DAIOther("M-AI-004", 0.40))
                )
                .setIndexBars(Arrays.asList("98765", "QWE12345"))
                .setUnitText("瓶")

                .setSaveAsWeight(1)
                .setTare(new BigDecimal("9998.0"))
                .setPercentTare(new BigDecimal("0.11"))
                .setFixedWeight(new BigDecimal("0.24"))
//                .putOtherTimes(1, new DTimeV2()
//                        .setSaleTimePS(1)
//                        .setSaleDatePC(20)
//                        .setUseDatePS(1)
//                        .setUseDatePC(20))
//                .putOtherTimes(2, new DTimeV2()
//                        .setSaleTimePS(1)
//                        .setSaleDatePC(30)
//                        .setUseDatePS(1)
//                        .setUseDatePC(30))
                .putOtherPrice(3, new DPriceV2()
                        .setPrice(new BigDecimal("3.46"))
                        .addManualDiscounts(new DManualDiscount()
                                        .restriction(Restriction.上限)
                                        .setType(1)
                                        .setDiscount(BigDecimal.valueOf(0.78)),
                                new DManualDiscount()
                                        .restriction(Restriction.下限)
                                        .setType(0)
                                        .setDiscount(BigDecimal.valueOf(0.56)))
                        .addAutoDiscounts(new DAutoDiscountV2()
                                        .setType(2)
                                        .setDate(127)
                                        .setLower(BigDecimal.valueOf(0.46))
                                        .setUpper(BigDecimal.valueOf(0.78))
                                        .setDiscount(BigDecimal.valueOf(0.55)),
                                new DAutoDiscountV2()
                                        .setType(3)
                                        .setDate(126)
                                        .setLower(BigDecimal.valueOf(0.56))
                                        .setUpper(BigDecimal.valueOf(0.45))
                                        .setDiscount(BigDecimal.valueOf(0.55))))
                .putOtherPrice(4, new DPriceV2()
                        .setPrice(new BigDecimal("4.56"))
                        .addManualDiscounts(new DManualDiscount()
                                        .restriction(Restriction.上限)
                                        .setType(0)
                                        .setDiscount(BigDecimal.valueOf(0.78)),
                                new DManualDiscount()
                                        .restriction(Restriction.下限)
                                        .setType(1)
                                        .setDiscount(BigDecimal.valueOf(0.56)))
                        .addAutoDiscounts(1, new DAutoDiscountV2()
                                .setType(2)
                                .setDate(127)
                                .setLower(BigDecimal.valueOf(0.46))
                                .setUpper(BigDecimal.valueOf(0.78))
                                .setDiscount(BigDecimal.valueOf(0.55)))
                        .addAutoDiscounts(3, new DAutoDiscountV2()
                                .setType(3)
                                .setDate(126)
                                .setLower(BigDecimal.valueOf(0.56))
                                .setUpper(BigDecimal.valueOf(0.45))
                                .setDiscount(BigDecimal.valueOf(0.55))));
//                .putText(5, new DTextV1().addTexts("111", "222", "333"))
//                .putText(6, new DTextV1().addTexts("444", "555", "666"));

        System.out.println(PLU1.getAiType().Public_Package_No_Reflex());

        StringBuilder builder = PLU1.Public_Package_No_Reflex();
        System.out.println("FDPLU Public_Package_No_Reflex Public_Package_Data: ---" + builder);

        String PLU_public_package = PLU1.Public_Package();
        System.out.println("FDPLU Public_Package Public_Package_Data: ---" + PLU_public_package);

        System.out.println(builder.toString().equals(PLU_public_package));

        FDPLU PLU2 = new DPLUV5<>().Public_UnPackage(builder.toString());
        String json2 = PLU2.toJSON();
        System.out.println("FDPLU Public_Un_Package_Data: ---" + json2);
        FDPLU PLU3 = new DPLUV5<>().Public_UnPackage_No_Reflex(builder.toString());
        String json3 = PLU3.toJSON();
        System.out.println("FDPLU Public_Un_Package_Data: ---" + json3);
        return PLU1;
    }

    /**
     * @description: 公开测试 营业员 分类 快捷键 快捷页
     **/
    private static void Public_SalesJob_SalesMan_Category_ShortKey_ShortPage_ShortPageFormwork() {
        DSaleJob saleJob1 = new DSaleJobV1<>()
                .setNo(1)
                .setName("职称1")
                .setDescription("职称1描述")
                .setDisPowers(Arrays.asList(3, 6, 8, 15));
        String saleJob_public_package = saleJob1.Public_Package_No_Reflex().toString();
        System.out.println("DSaleJob Public_Package_Data: ---" + saleJob_public_package);
        DSaleJob saleJob2 = new DSaleJobV1<>().Public_UnPackage_No_Reflex(saleJob_public_package);
        System.out.println("DSaleMan: " + saleJob1.toJSON().equals(saleJob2.toJSON()));

        DSaleMan saleMan1 = new DSaleManV1<>()
                .setNo(1)
                .setName("张三")
                .setPassword("123456")
                .setCard("12345")
//                .setPower(4095);
                .setDisPowers(Arrays.asList(1, 2, 33))
                .setJob(0);
//        List powers = saleMan1.powers();
        String saleMan_public_package = saleMan1.Public_Package_No_Reflex().toString();
        System.out.println("DSaleMan Public_Package_Data: ---" + saleMan_public_package);
        DSaleMan saleMan2 = new DSaleManV1<>().Public_UnPackage_No_Reflex(saleMan_public_package);
        System.out.println("DSaleMan: " + saleMan1.toJSON().equals(saleMan2.toJSON()));

        DCategory category1 = new DCategoryV1<>()
                .setNo(10)
                .setName("分类1")
                .setDept(9)
                .setPrint(new DPrintV2()
                        .setType1(1)
                        .setBarcode1(1)
                        .setSign1(1)
                        .setType2(2)
                        .setBarcode2(2)
                        .setSign2(2));
        // .setSerial(11);
        String category_public_package = category1.Public_Package_No_Reflex().toString();
        System.out.println("DCategory Public_Package_Data: ---" + category_public_package);
        DCategoryV1 category2 = new DCategoryV1<>().Public_UnPackage_No_Reflex(category_public_package);
        System.out.println("DCategory: " + category1.toJSON().equals(category2.toJSON()));

        DShortKey shortKey1 = new DShortKeyV1<>()
                .setNo(1)
                .setName("快捷键1")
                .addOrder(2, 271, 45);
        String shortKey_public_package = shortKey1.Public_Package_No_Reflex().toString();
        System.out.println("DShortKey Public_Package_Data: ---" + shortKey_public_package);
        System.out.println("order: " + shortKey1.obtainOrder(2));
        DShortKey shortKey2 = new DShortKeyV1<>().Public_UnPackage_No_Reflex(shortKey_public_package);
        boolean shortKeyResult = shortKey1.toJSON().equals(shortKey2.toJSON());
        System.out.println("DShortKey: " + shortKeyResult);
        if (!shortKeyResult) {
            System.out.println(shortKey1.toJSON());
            System.out.println(shortKey2.toJSON() + " Order: " + shortKey2.obtainOrder(2));
        }

        DShortPage shortPage1 = new DShortPageV1<>()
                .setNo(2)
                .setName("快捷页2")
                .setPluNos(Arrays.asList(1, 2, 3, 4, 5));
        // .setSerial(11);
        String shortPage_public_package = shortPage1.Public_Package_No_Reflex().toString();
        System.out.println("DShortPage Public_Package_Data: ---" + shortPage_public_package);
        DShortPage shortPage2 = new DShortPageV1<>().Public_UnPackage_No_Reflex(shortPage_public_package);
        System.out.println("DShortPage: " + shortPage1.toJSON().equals(shortPage2.toJSON()));

        DShortPageFormwork shortPageFormwork1 = new DShortPageFormworkV1<>()
                .setNo(1)
                .setName("快捷页模板")
                .setShortPages(Arrays.asList(1, 2, 4, 5));
        String shortPageFormwork_public_package = shortPageFormwork1.Public_Package_No_Reflex().toString();
        System.out.println("DShortPageFormwork Public_Package_Data: ---" + shortPageFormwork_public_package);
        DShortPageFormwork shortPageFormwork2 = new DShortPageFormworkV1<>().Public_UnPackage_No_Reflex(shortPageFormwork_public_package);
        System.out.println("DShortPageFormwork: " + shortPageFormwork1.toJSON().equals(shortPageFormwork2.toJSON()));
    }

    /**
     * @description: 公开协议 条码 标签 测试
     **/
    private static void Public_Barcode_Label_BitMap_Test() {
        DBarcodeFormat barcodeFormat1 = new DBarcodeFormatV1<>()
                .setNo(10)
                .setName("B1")
                .setFormat(0)
                .setCheck(0)
                .setnConst1(0)
                .setnConst2(0)
                .setDis("B501L700A000A000A000A000");
        String barcodeFormat_public_package = barcodeFormat1.Public_Package_No_Reflex().toString();
        System.out.println("DBarcodeFormatV1 Public_Package_Data: ---" + barcodeFormat_public_package);
        DBarcodeFormat barcodeFormat2 = new DBarcodeFormatV1<>().Public_UnPackage_No_Reflex(barcodeFormat_public_package);
        System.out.println("DBarcodeFormatV1: " + barcodeFormat1.toJSON().equals(barcodeFormat2.toJSON()));

        DLabelFormat labelFormat1 = new DLabelFormatV1<>()
                .setNo(1)
                .setName("PF-1")
                .setPf("1,1,432,296|5Y2V5Lu3CeWHgOmHjQnmlbDph48J5oC75Lu3CemUgOWUruaXpeacnwnplIDllK7ml7bpl7QJ5pyJ5pWI5pel5pyfCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQ==|0,0,0,0,1,0,5,1,0,88,281,113|1,2,0,0,1,0,5,1,0,240,432,26|2,2,1,0,1,0,5,1,0,266,431,26|3,2,3,0,1,0,5,0,1,220,138,20|4,2,4,0,1,0,5,0,141,220,136,20|5,1,0,6,1,0,5,0,362,0,70,34|6,1,0,0,1,0,5,2,0,0,362,34|7,1,0,1,1,0,5,1,139,60,141,26|8,2,27,0,1,0,5,2,282,60,149,34|9,1,0,4,1,0,5,1,0,60,137,26|10,1,0,15,9,0,5,0,280,220,148,20|11,1,0,16,1,0,5,0,285,94,147,107|12,1,0,24,1,0,4,1,236,34,57,26|13,1,0,25,1,0,4,1,82,34,60,26|14,2,16,0,1,0,4,1,380,34,42,26|15,3,0,0,1,0,6,1,0,34,80,26|16,3,1,0,2,0,6,1,160,34,74,26|17,3,2,0,3,0,6,1,160,34,74,26|18,3,3,0,1,0,6,1,300,34,72,26|19,3,4,0,1,0,5,0,2,202,138,18|20,3,5,0,1,0,5,0,142,202,134,18|21,3,6,0,9,0,5,0,283,202,144,18");
        String labelFormat_public_package = labelFormat1.Public_Package_No_Reflex().toString();
        System.out.println("DLabelFormatV1 Public_Package_Data: ---" + labelFormat_public_package);
        DLabelFormat labelFormat2 = new DLabelFormatV1<>().Public_UnPackage_No_Reflex(labelFormat_public_package);
        System.out.println("DLabelFormatV1: " + labelFormat1.toJSON().equals(labelFormat2.toJSON()));

        DBitMap bitMap1 = new DBitMapV1<>()
                .setNo(1)
                .setName("位图1")
                .setBmp("5Y2V5Lu3CeWHgOmHjQnmlbDph48J5oC75Lu3CemUgOWUruaXpeacnwnplIDllK7ml7bpl7QJ5pyJ5pWI5pel5pyfCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQkJCQ");
        String bitMap_public_package = bitMap1.Public_Package_No_Reflex().toString();
        System.out.println("DBitMapV1 Public_Package_Data: ---" + bitMap_public_package);
        DBitMap bitMap2 = new DBitMapV1<>().Public_UnPackage_No_Reflex(bitMap_public_package);
        System.out.println("DBitMapV1: " + bitMap1.toJSON().equals(bitMap2.toJSON()));
    }

    /**
     * @description: 公开协议组装测试
     **/
    private static void Public_Data_Txt_Test() {
        List<DDataParameterV1> dataParameters = new ArrayList<>();
        dataParameters.add(new DDataParameterV1<>()
                .setNo(0)
                .setValue(1));
        dataParameters.add(new DDataParameterV1<>()
                .setNo(2)
                .setValue(3));
        dataParameters.add(new DDataParameterV1<>()
                .setNo(4)
                .setValue(5));
        dataParameters.add(new DDataParameterV1<>()
                .setNo(6)
                .setValue(7));
        StringBuffer buffer_date = new StringBuffer();
        for (DDataParameterV1 dataParameter : dataParameters) {
            String public_package = dataParameter.Public_Package_No_Reflex().toString();
            System.out.println("Public_Package_Data: ---" + public_package);
            DDataParameterV1 dataParameterUnPackage = new DDataParameterV1<>().Public_UnPackage_No_Reflex(public_package);
            System.out.println("Public_Compare_Result：---" + dataParameter.toJSON().equals(dataParameterUnPackage.toJSON()));

            buffer_date.append(public_package);
        }
        System.out.println("Public_Package_Data_More: \n" + buffer_date.toString());

        List<DTextParameter> textParameters = new ArrayList<>();
        textParameters.add(new DTextParameterV1<>()
                .setNo(1)
                .setValue("Text1"));
        textParameters.add(new DTextParameterV1<>()
                .setNo(2)
                .setValue("Text2"));
        textParameters.add(new DTextParameterV1<>()
                .setNo(3)
                .setValue("Text3"));
        StringBuffer buffer_text = new StringBuffer();
        for (DTextParameter textParameter : textParameters) {
            String public_package = textParameter.Public_Package_No_Reflex().toString();
            System.out.println("Public_Package_Text: ---" + public_package);
            DTextParameter textParameterUnPackage = new DTextParameterV1<>().Public_UnPackage_No_Reflex(public_package);
            System.out.println("Public_Compare_Result：---" + textParameter.toJSON().equals(textParameterUnPackage.toJSON()));

            buffer_text.append(public_package);
        }
        System.out.println("Public_Package_Text_More: \n" + buffer_text.toString());
    }

    /**
     * @description: 方法测试
     **/
    private static void Method_Test() {
        DAIType daiType = new DAIType()
                .setType(1)
//                .addModels(new DAIModel("M-AI-0001", "M-AI-0001-Name"),
//                        new DAIModel("M-AI-0002", "M-AI-0002-Name"))
                .addOthers(new DAIOther("M-AI-003", 0.45),
                        new DAIOther("M-AI-004", 0.40));
        System.out.println(daiType.toPackage());

        String[] arr = ("\t\t\t" + PUBLIC_LINE_SPLIT).split("\t");
        System.out.println(arr.length);

        String[] $s = "1!2".split("!");


        List<Integer> integers = new ArrayList<>();
        integers.add(Integer.parseInt("256"));
        System.out.println(integers.contains(256));


        int[] ints = BarcodeScale.ftBoard(7).order2PageIndex(518);
        System.out.println(ints);
        int i = BarcodeScale.ftBoard(7).pageIndex2Order(ints[0], ints[1]);
        System.out.println(i);

        List<String> stringList = new ArrayList<>();
        stringList.addAll(Arrays.asList("12", "123"));
        System.out.println(stringList);
        stringList.add("1234");
        System.out.println(stringList);
        stringList.remove(0);
        System.out.println(stringList);

        System.out.println(new BigDecimal("2.3").toString());
        System.out.println(new BigDecimal(2.3).toString());
        System.out.println(BigDecimal.valueOf(2.3).toString());

        System.out.println("---------------------方法测试------------------------");
        System.out.println("StringBuffer：" + new StringBuffer().toString());

        String s = ByteUtils.txtToStr("XX发ss@");
        System.out.println(s);
        String s1 = ByteUtils.strToTxt(s);
        System.out.println(s1);

        String amount = ByteUtils.bigDecimalToStr(new BigDecimal("-4.5"));
        System.out.println(amount);
        BigDecimal amount1 = ByteUtils.strToBigDecimal(amount);
        System.out.println(amount1);
        System.out.println("---------------------方法测试------------------------");

        PublicExecuteModify executeModify = new PublicExecuteModify();
        executeModify.setType(PLU);
        executeModify.add(Public_PLU_Test());
        PublicExecute copy_clone = executeModify.clone();
        System.out.println(copy_clone.toJSON());
        PublicExecuteModify copy_fast_json = JSONUtils.objectToObject(executeModify, PublicExecuteModify.class);
        System.out.println(copy_fast_json.toJSON());
        PublicExecuteModify copy_gjson = executeModify.toObject(executeModify.getClass());
        System.out.println(copy_gjson.toJSON());

        RSAEncryptDecrypt rsaEncryptDecrypt = new JRSAEncryptDecrypt();
        String content = "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";
        byte[] decrypt = rsaEncryptDecrypt.decrypt(content.getBytes());
        FileUtils.writer(decrypt, pic_file);
    }

    /**
     * @description: 日志 组装 解析 （服务端 组装|解析）
     **/
    private static void Server_LOG_Test() {
        DLOGV1 log_server_package = Dlog();

        System.out.println("---------------------Server 组包测试------------------------");
        String server_package = log_server_package.Server_Package();
        System.out.println("---------------------Server 组包测试------------------------");

        System.out.println("Server_Package 数据包: " + server_package);

        server_package = "72000000011628FA2C450000004C010010000089E01D88800000000002000010000002004A0100100000000000000300170000004E87010002CCC7000A0000108C0000108C0000100809001D0000001387010003C3A8C9BDCDF5E8D600060000107800001048000010080A001D0000001787010003C9A2B3C6C1E3CAB30006000010C800001078000010080D00";

        DLOGV1<DLOGV1> log_server_un_package = new DLOGV1<>();
        System.out.println("---------------------Server 拆包测试------------------------");
        log_server_un_package.Server_UnPackage(server_package);
        System.out.println("---------------------Server 拆包测试------------------------");

        boolean result = log_server_package.toJSON().equals(log_server_un_package.toJSON());
        System.out.println("前后JSON字符串比对结果：" + result);
        if (!result) {
            System.out.println(log_server_package.toJSON());
            System.out.println();
            System.out.println(log_server_un_package.toJSON());
        }
    }

    private static void Server_LOG_Test_1() {
        System.out.println("---------------------Server 拆包测试------------------------");
        String server_package = "6A00000001D496262D040000002C010010000089E0118880000000002C010010030000000000000001001C0000009396980002796F6768757274000A0000102C0100102C010010080A00";
        DLOGV1<DLOGV1> log_server_un_package = new DLOGV1<>();
        log_server_un_package.Server_UnPackage(server_package);
        System.out.println(log_server_un_package.toJSON());
        System.out.println("---------------------Server 拆包测试------------------------");

        System.out.println();

        System.out.println("---------------------Server 拆包测试------------------------");
        server_package = "8786000001B173FC2C060000000B0000100000C9E011888000000000010000210B000010030000000000000001001D0000007E96980002C1D9CAB1BCC6BCFE000A0000106F0000206F000020080100";
        log_server_un_package = new DLOGV1<>();
        log_server_un_package.Server_UnPackage(server_package);
        System.out.println(log_server_un_package.toJSON());
        System.out.println("---------------------Server 拆包测试------------------------");

        System.out.println();

        System.out.println("---------------------Server 拆包测试------------------------");
        server_package = "88860000012375FC2C0700000058000010000089E01188800000000058000010030000000000000001001D0000007E96980002C1D9CAB1BCC6BCFE000A0000107803002078030020080100";
        log_server_un_package = new DLOGV1<>();
        log_server_un_package.Server_UnPackage(server_package);
        System.out.println(log_server_un_package.toJSON());
        System.out.println("---------------------Server 拆包测试------------------------");

        System.out.println("---------------------Server 拆包测试------------------------");
        server_package = "8788000001C976FC2C08000000010000100000C1E01D88800000000001000021000002000100001000000000000001001D0000007E96980002C1D9CAB1BCC6BCFE000A0000100B0000200B000020080100";
        log_server_un_package = new DLOGV1<>();
        log_server_un_package.Server_UnPackage(server_package);
        System.out.println(log_server_un_package.toJSON());
        System.out.println("---------------------Server 拆包测试------------------------");

        System.out.println("---------------------Server 拆包测试------------------------");
        server_package = "8888000001A67AFC2C09000000010000100000C1E01D88800000000001000021000002000B00002000000000000001001D0000007E96980002C1D9CAB1BCC6BCFE000A0000100B0000200B000020080100";
        log_server_un_package = new DLOGV1<>();
        log_server_un_package.Server_UnPackage(server_package);
        System.out.println(log_server_un_package.toJSON());
        System.out.println("---------------------Server 拆包测试------------------------");


    }

    /**
     * @description: DLOGV1 日志模板
     **/
    private static DLOGV1 Dlog() {
        int type = DConstant.RETRUN, fid = 583, sid = 43;
        DGoods goods1 = new DGoods()
                .setNo(23)
                .setUnit(UnitEnum.计件.val())
                .setName("百岁山矿泉水")
                .setAmount(new BigDecimal(1))
                .setPrice(new BigDecimal(4.5))
                .setItemTotal(new BigDecimal(4.5))
                .setUnitText("瓶")
                .setCategory(9)
                .setDept(9)
                .setText1("xxxxx")
                .setPics(Arrays.asList("xxxx", "yyyy", "zzzz"));

        DGoods goods2 = new DGoods()
                .setNo(25)
                .setUnit(UnitEnum.g500.val())
                .setName("苹果")
                .setAmount(new BigDecimal(1.50))
                .setPrice(new BigDecimal(6.00))
                .setItemTotal(new BigDecimal(9.00))
                .setCategory(9)
                .setDept(9)
                .setText1("MMMMMM")
                .setPics(Arrays.asList("aaaa", "bbbb", "cccc"));

        List<DGoods> goodsList = Arrays.asList(goods1, goods2);
//        System.out.println(JSONUtils.objectToJSON(goodsList));

        Map<String, String> mapStr = new HashMap<>();
        mapStr.put("ABC", "xxx");
        mapStr.put("ABD", "yyy");
        mapStr.put("ABE", "yyy");
//        System.out.println(JSONUtils.objectToJSON(mapStr));

        Map<Integer, DGoods> goodsMap = new HashMap<>();
        goodsMap.put(goods1.no(), goods1);
        goodsMap.put(goods2.no(), goods2);
//        System.out.println(JSONUtils.objectToJSON(goodsMap));

        return new DLOGV1<>()
                .setFid(fid)
                .setKind(DConstant.POS_KIND)
                .setTradeTime(new Date())
                .setSid(sid)
                .setTradeVal(new BigDecimal(4.5))
                .setType(type)
                .setSaleMan(6)
                .setCash(new BigDecimal(4.5))
                .setSource(new DSource()
                        .setNo(763)
                        .setUnique("0023F0148E3A")
                        .setTradeTime(new Date())
                        .setFid(100))
                .setGoodsList(goodsList);
    }
}
