package com.jhscale.test.data;

import com.alibaba.fastjson.JSON;
import com.jhscale.common.exception.ProfessionalException;
import com.jhscale.common.model.device.plu.DPLU;
import com.jhscale.common.model.device.plu.DPLUV2;
import com.jhscale.common.model.device.plu.DPLUV3;
import com.jhscale.common.model.device.plu.DPLUV5;
import com.jhscale.common.model.device.plu.inner.DCategory;
import com.jhscale.common.model.device.plu.inner.DPricture;
import com.jhscale.common.model.device.plu.inner.DUnit;
import com.jhscale.common.model.device.plu.module.DPrice;
import com.jhscale.common.model.device.plu.module.DPriceV2;
import com.jhscale.common.model.device.plu.module.DSpecificationV2;
import com.jhscale.common.model.device.plu.module.DTimeV2;
import com.jhscale.common.model.device.plu.param.CategoryType;
import com.jhscale.common.model.device.plu.param.DPictureConstant;
import com.jhscale.common.model.device.plu.param.PLUState;
import com.jhscale.common.model.device.plu.param.PLUType;
import com.jhscale.common.utils.DPLUUtils;
import com.jhscale.common.utils.FileUtils;
import com.jhscale.common.utils.GZIPUtils;
import com.jhscale.common.utils.JSONUtils;
import com.jhscale.common.ysscale.UnitEnum;

import java.io.File;
import java.math.BigDecimal;
import java.util.*;

/**
 * @title: TestDPLU
 * @projectName: common
 * @description: TODO
 * @author: 刘腾
 * @date: 2021/9/14  15:41
 */
public class TestDPLU {


    public static void main(String[] args) throws ProfessionalException {
        // 生成加密压缩DPLU
//        DPLU();
//        UDPLU();
//        DPLUV3();
//        DPLUV3_1();
//        DPLULV2();
//        DPLUV5();

        DPLUV5_1();

//        System.out.println(JSON.toJSONString(new DPLUV5<>(), SerializerFeature.WriteMapNullValue));
//
//        DPLUV51();
    }

    private static void DPLUV51() {
        String reader = FileUtils.reader(new File("C:\\Users\\lie_w\\Desktop\\gzip.txt"));
        String gunzip = GZIPUtils.uncompress(reader);
        System.out.println(gunzip);
    }

    private static void DPLUV5_1() {
        List<DPLUV5> list = new ArrayList<>();
        DPLUV5 dpluv5 = new DPLUV5();
        DTimeV2 dTimeV2 = new DTimeV2();
        dTimeV2.setUseDatePS(1);
        dpluv5.setTime(dTimeV2);


        Map<Integer, DTimeV2> ot = new HashMap<>();
        ot.put(1, dTimeV2);
        ot.put(2, dTimeV2);
//        dpluv5.setOtherTimes(ot);
        list.add(dpluv5);

        String s = JSONUtils.objectToJSON(list);
        System.out.println(s);
        List<DPLUV5> result = JSONUtils.jsonToList(s, DPLUV5.class);
        System.out.println(result);
    }

    /**
     * @description: DPLU5
     **/
    private static void DPLUV5() {
        List<DPLUV5> dpluv5s = new ArrayList<>();
        DPLUV5 dpluv51 = (DPLUV5) new DPLUV5<>()
                .setNo(1)
//                .setAiNo(45L)
//                .setAiName("苹果")
                .setState(2)
//                .setPluType(3)
//                .setInventory(0)
                .setItemCode(1)
                .setName("精品苹果")
//                .setPicture("http://xxxxx.png")
                .setSimple("JPPG")
                .setIndexBar("12345678912314567890")
                .setUnit(1)
//                .setTare(new BigDecimal("0.32"))
//                .setCategory(10)
                .setPrice(new DPriceV2().setPrice(new BigDecimal("4.5")))
                .putOtherPrice(1, new DPriceV2().setPrice(new BigDecimal("4.8")));
//                .putOtherTimes(1, new DTimeV2().setPackTimePC(1));
//                .setCode(2087000001L)
//                .setLast(System.currentTimeMillis());
        dpluv5s.add(dpluv51);

        String json = dpluv51.toJSON();
        System.out.println(json);

        System.out.println(dpluv51.serialInit().toJSON());

        DPLUV5 dpluv52 = (DPLUV5) new DPLUV5<>()
                .setNo(2)
//                .setAiNo(46L)
//                .setAiName("香蕉")
                .setState(2)
//                .setPluType(3)
//                .setInventory(InventoryType.库存商品.getType())
                .setItemCode(2)
                .setName("精品香蕉")
//                .setPicture("http://yyyyyy.png")
                .setSimple("JPXJ")
                .setIndexBar("12345678912314567891")
                .setUnit(1)
//                .setTare(new BigDecimal("0.22"))
//                .setCategory(10)
                .setPrice(new DPriceV2().setPrice(new BigDecimal("6.5")))
                .putOtherPrice(1, new DPriceV2().setPrice(new BigDecimal("5.5")));
//                .setCode(2087000002L)
//                .setLast(System.currentTimeMillis());
        dpluv5s.add(dpluv52);

        json = JSONUtils.objectToJSON(dpluv5s);

        String gzip = GZIPUtils.compress(json);
        System.out.println(gzip);

        FileUtils.writer(gzip, new File("C:\\Users\\lie_w\\Desktop\\gzip.txt"));

        System.out.println(json.length() + " ====== " + gzip.length());
        System.out.println(json.getBytes().length + " ====== " + gzip.getBytes().length);

        String gunzip = GZIPUtils.uncompress(gzip);
        System.out.println(gunzip);

        System.out.println("++++++++++++++++++++++++++++");

        List<DPLUV5> dpluv5s2 = JSONUtils.jsonToList(gunzip, DPLUV5.class);
        System.out.println(JSONUtils.objectToJSON(dpluv5s2).equals(json));

//        String listStr = "[{\"ab\":{\"a\":4.5},\"ac\":{1:{\"a\":4.8}},\"c\":2,\"d\":3,\"e\":2087000001,\"f\":0,\"g\":1665275482999,\"h\":1,\"i\":1,\"j\":\"精品苹果\",\"k\":\"http://xxxxx.png\",\"l\":\"JPPG\",\"m\":\"12345678912314567890\",\"o\":1},{\"ab\":{\"a\":6.5},\"ac\":{1:{\"a\":5.5}},\"c\":2,\"d\":3,\"e\":2087000002,\"f\":0,\"g\":1665275483190,\"h\":2,\"i\":2,\"j\":\"精品香蕉\",\"k\":\"http://yyyyyy.png\",\"l\":\"JPXJ\",\"m\":\"12345678912314567891\",\"o\":1}]";
//
//        List<DPLUV5> dpluv5s1 = JSONUtils.jsonToList(listStr, DPLUV5.class);
//        System.out.println(JSONUtils.objectToJSON(dpluv5s1));

//        String zip = GZIPUtils.zip(json);
//        System.out.println(zip);
//
//        System.out.println(json.length() + " ====== " + zip.length());
//        System.out.println(json.getBytes().length + " ====== " + zip.getBytes().length);
//
//        String unzip = GZIPUtils.unzip(zip);
//        System.out.println(unzip);

//        String assemble = dpluv5.assemble(false);
//        System.out.println(assemble);
//
//        DPLUV5 parse = new DPLUV5().parse(assemble, false);
//        System.out.println(parse.toJSON());
//
//        System.out.println(assemble.equals(parse.assemble(false)));
    }

    /**
     * @description: PLUV3测试
     **/
    private static void DPLUV3_1() throws ProfessionalException {
        DPLUV3 PLUV3 = new DPLUV3();
        PLUV3.setCode(450001234L)
                .setNo(2)
                .setName("苹果")
                .addPicture(new DPricture()
                        .setUrl("http://xxxxx.png")
                        .setType(DPictureConstant.PRIMARY))
                .setSimple("PG")
                .setState(PLUState.正常.getState())
                .setType(PLUType.普通商品.getType())
                .setCenterCode("PLU000000001")
                .setCenterName("精品苹果")
                .setSort(1)
                .setUnit(new DUnit(UnitEnum.计重, 123456L, UnitEnum.kg.getVal()))
                .addSpecification(
                        new DSpecificationV2()
                                .setCode(8000000L)
                                .setNo(1)
                                .setName("大苹果")
                                .setState(PLUState.正常.getState())
                                .setNumber(1000)
                                .setIndexBar("1000000000001")
                                .setTrae(new BigDecimal("0.5"))
                                .setMasterUnit(new DUnit(UnitEnum.计重, 123456L, UnitEnum.g500.getVal()))
//                                .setRatio("1000/500")
                                .setTaxRate(new BigDecimal("0.15"))
                                .setPrice(new DPrice()
                                                .setPrice(new BigDecimal("32.5"))
//                                        .addManualDiscount(
//                                                new DManualDiscount.DUpperManualDiscount().setDiscount(DManualDiscountConstant.DISCOUNT2, new BigDecimal("0.95")),
//                                                new DManualDiscount.DLowerManualDiscount().setDiscount(DManualDiscountConstant.DISCOUNT2, new BigDecimal("0.90"))
//                                        )
                                )
                                .putOtherPrice(
                                        "2001000000000001",
                                        new DPrice()
                                                .setPrice(new BigDecimal("31.5"))
//                                                .addManualDiscount(
//                                                        new DManualDiscount.DUpperManualDiscount().setDiscount(DManualDiscountConstant.DISCOUNT2, new BigDecimal("0.93")),
//                                                        new DManualDiscount.DLowerManualDiscount().setDiscount(DManualDiscountConstant.DISCOUNT2, new BigDecimal("0.85"))
//                                                )
                                ),
                        new DSpecificationV2()
                                .setCode(8000001L)
                                .setNo(1)
                                .setName("中苹果")
                                .setState(PLUState.正常.getState())
                                .setNumber(1001)
                                .setIndexBar("1000000000002")
                                .setTrae(new BigDecimal("0.5"))
                                .setMasterUnit(new DUnit(UnitEnum.计重, 123456L, UnitEnum.g500.getVal()))
//                                .setRatio("1000/500")
                                .setTaxRate(new BigDecimal("0.15"))
                                .setPrice(new DPrice().setPrice(new BigDecimal("22.5")))
                                .putOtherPrice("2001000000000001", new DPrice().setPrice(new BigDecimal("21.5"))),
                        new DSpecificationV2()
                                .setCode(8000002L)
                                .setNo(1)
                                .setName("小苹果")
                                .setState(PLUState.正常.getState())
                                .setNumber(1002)
                                .setIndexBar("1000000000002")
                                .setTrae(new BigDecimal("0.5"))
                                .setMasterUnit(new DUnit(UnitEnum.计重, 123456L, UnitEnum.g500.getVal()))
//                                .setRatio("1000/500")
                                .setTaxRate(new BigDecimal("0.15"))
                                .setPrice(new DPrice().setPrice(new BigDecimal("12.5")))
                                .putOtherPrice("2001000000000001", new DPrice().setPrice(new BigDecimal("11.5")))
                )
                .setPrice(new DPrice()
//                        .addManualDiscount(
//                                new DManualDiscount.DUpperManualDiscount().setDiscount(DManualDiscountConstant.DISCOUNT2, new BigDecimal("0.98")),
//                                new DManualDiscount.DLowerManualDiscount().setDiscount(DManualDiscountConstant.DISCOUNT2, new BigDecimal("0.95"))
//                        )
                )
                .putOtherPrice(
                        "2001000000000001",
                        new DPrice()
//                                .addManualDiscount(
//                                        new DManualDiscount.DUpperManualDiscount().setDiscount(DManualDiscountConstant.DISCOUNT2, new BigDecimal("0.97")),
//                                        new DManualDiscount.DLowerManualDiscount().setDiscount(DManualDiscountConstant.DISCOUNT2, new BigDecimal("0.92"))
//                                )
                )
                .putText("2001000000000001", "111111", "222222", "333333")
                .setNumber(1000)
                .setIndexBar("1100000000000")
                .addIndexBars("1100000000001", "1100000000002", "1100000000003")
                .setCategory(new DCategory()
                        .setType(CategoryType.普通分类.getType())
                        .setId(2200000000000L)
                        .setNum(1)
                        .setName("水果"))
                .addShortCategories(
                        new DCategory()
                                .setType(CategoryType.快捷分类.getType())
                                .setId(2200000000001L)
                                .setNum(0)
                                .setName("精品水果"),
                        new DCategory()
                                .setType(CategoryType.快捷分类.getType())
                                .setId(2200000000002L)
                                .setNum(1)
                                .setName("当季水果"))
                .putOther("Key1", "Val1");
        String json = PLUV3.toJSON();
        System.out.println(PLUV3.toJSON());
        System.out.println(json.getBytes().length);

        // 数据组装 支持数组
        String assemble = DPLUUtils.assemble(PLUV3);
        System.out.println(assemble);
        System.out.println(assemble.getBytes().length);

        // 数据解析返回List
        List<DPLU> dpluList = DPLUUtils.analyze(assemble);
        DPLU analyze = dpluList.get(0);
        System.out.println(analyze.toJSON());

        String assemble1 = DPLUUtils.assemble(analyze);
        System.out.println(assemble1.equals(assemble));
    }

    /**
     * @description: PLUV3测试
     **/
    private static void DPLUV3() {
        DPLUV3 PLUV3 = new DPLUV3();
        PLUV3.setCode(450001234L)
                .setNo(1)
                .setName("苹果")
                .addPicture(new DPricture()
                        .setUrl("http://xxxxx.png")
                        .setType(DPictureConstant.PRIMARY))
                .setSimple("PG")
                .setState(PLUState.正常.getState())
                .setType(PLUType.普通商品.getType())
                .setCenterCode("PLU000000001")
                .setCenterName("精品苹果")
                .setSort(1)
                .setUnit(new DUnit(UnitEnum.计重, 123456L, UnitEnum.kg.getVal()))
                .addSpecification(
                        new DSpecificationV2()
                                .setCode(8000000L)
                                .setNo(1)
                                .setName("大苹果")
                                .setState(PLUState.正常.getState())
                                .setNumber(1000)
                                .setIndexBar("1000000000001")
                                .setTrae(new BigDecimal("0.5"))
                                .setMasterUnit(new DUnit(UnitEnum.计重, 123456L, UnitEnum.g500.getVal()))
//                                .setRatio("1000/500")
                                .setTaxRate(new BigDecimal("0.15"))
                                .setPrice(new DPrice()
                                                .setPrice(new BigDecimal("32.5"))
//                                        .addManualDiscount(
//                                                new DManualDiscount.DUpperManualDiscount().setDiscount(DManualDiscountConstant.DISCOUNT2, new BigDecimal("0.95")),
//                                                new DManualDiscount.DLowerManualDiscount().setDiscount(DManualDiscountConstant.DISCOUNT2, new BigDecimal("0.90"))
//                                        )
                                )
                                .putOtherPrice(
                                        "2001000000000001",
                                        new DPrice()
                                                .setPrice(new BigDecimal("31.5"))
//                                                .addManualDiscount(
//                                                        new DManualDiscount.DUpperManualDiscount().setDiscount(DManualDiscountConstant.DISCOUNT2, new BigDecimal("0.93")),
//                                                        new DManualDiscount.DLowerManualDiscount().setDiscount(DManualDiscountConstant.DISCOUNT2, new BigDecimal("0.85"))
//                                                )
                                ),
                        new DSpecificationV2()
                                .setCode(8000001L)
                                .setNo(1)
                                .setName("中苹果")
                                .setState(PLUState.正常.getState())
                                .setNumber(1001)
                                .setIndexBar("1000000000002")
                                .setTrae(new BigDecimal("0.5"))
                                .setMasterUnit(new DUnit(UnitEnum.计重, 123456L, UnitEnum.g500.getVal()))
//                                .setRatio("1000/500")
                                .setTaxRate(new BigDecimal("0.15"))
                                .setPrice(new DPrice().setPrice(new BigDecimal("22.5")))
                                .putOtherPrice("2001000000000001", new DPrice().setPrice(new BigDecimal("21.5"))),
                        new DSpecificationV2()
                                .setCode(8000002L)
                                .setNo(1)
                                .setName("小苹果")
                                .setState(PLUState.正常.getState())
                                .setNumber(1002)
                                .setIndexBar("1000000000002")
                                .setTrae(new BigDecimal("0.5"))
                                .setMasterUnit(new DUnit(UnitEnum.计重, 123456L, UnitEnum.g500.getVal()))
//                                .setRatio("1000/500")
                                .setTaxRate(new BigDecimal("0.15"))
                                .setPrice(new DPrice().setPrice(new BigDecimal("12.5")))
                                .putOtherPrice("2001000000000001", new DPrice().setPrice(new BigDecimal("11.5")))
                )
                .setPrice(new DPrice()
//                        .addManualDiscount(
//                                new DManualDiscount.DUpperManualDiscount().setDiscount(DManualDiscountConstant.DISCOUNT2, new BigDecimal("0.98")),
//                                new DManualDiscount.DLowerManualDiscount().setDiscount(DManualDiscountConstant.DISCOUNT2, new BigDecimal("0.95"))
//                        )
                )
                .putOtherPrice(
                        "2001000000000001",
                        new DPrice()
//                                .addManualDiscount(
//                                        new DManualDiscount.DUpperManualDiscount().setDiscount(DManualDiscountConstant.DISCOUNT2, new BigDecimal("0.97")),
//                                        new DManualDiscount.DLowerManualDiscount().setDiscount(DManualDiscountConstant.DISCOUNT2, new BigDecimal("0.92"))
//                                )
                )
                .putText("2001000000000001", "111111", "222222", "333333")
                .setNumber(1000)
                .setIndexBar("1100000000000")
                .addIndexBars("1100000000001", "1100000000002", "1100000000003")
                .setCategory(new DCategory()
                        .setType(CategoryType.普通分类.getType())
                        .setId(2200000000000L)
                        .setNum(1)
                        .setName("水果"))
                .addShortCategories(
                        new DCategory()
                                .setType(CategoryType.快捷分类.getType())
                                .setId(2200000000001L)
                                .setNum(0)
                                .setName("精品水果"),
                        new DCategory()
                                .setType(CategoryType.快捷分类.getType())
                                .setId(2200000000002L)
                                .setNum(1)
                                .setName("当季水果"))
                .putOther("Key1", "Val1");
        String json = PLUV3.toJSON();
        System.out.println(PLUV3.toJSON());
        System.out.println(json.getBytes().length);

        String assemble = PLUV3.assemble();
        System.out.println(assemble);
        System.out.println(assemble.getBytes().length);

        DPLUV3 parse = new DPLUV3().parse(assemble);
        System.out.println(parse.toJSON());

        String assemble1 = parse.assemble();
        System.out.println(assemble1.equals(assemble));
    }

    public static void DPLU() {
        com.jhscale.common.model.device.DPLU PLU = new com.jhscale.common.model.device.DPLU();
        PLU.setPluNo(1L);
        PLU.setPluCode(450001234L);
        PLU.setPluName("测试PLU");
        PLU.setSortOrder(4);
        PLU.setSpecification(new com.jhscale.common.model.device.DPLU.DSpecification()
                .setSpecificationId(45100000123L)
                .setName("测试PLU 规格1")
                .setRatio("1/5"));
        PLU.setPictures("fdafdafsdf;fafdrewrew;fdafdsvfd;");
        PLU.setPrice(new BigDecimal("2.3"));
        PLU.setNumber(4);
        PLU.setIndexBar("FFFADAF54ER1REGSFD");
        PLU.setUsedate(new com.jhscale.common.model.device.DPLU.DUsedate().setVal(45));
        PLU.setCostTrade(new BigDecimal("1.4"));
        PLU.setTrae(new BigDecimal("0.02"));
        PLU.setCategory(new com.jhscale.common.model.device.DPLU.DCategory()
                .setId(55555555L)
                .setName("主要类别")
                .setNum(4));
        PLU.setSecondCategoryIds("45,46,47");
        PLU.setSencondCategorys(Arrays.asList(
                new com.jhscale.common.model.device.DPLU.DCategory().setId(55555560L).setName("次要类别1").setNum(45),
                new com.jhscale.common.model.device.DPLU.DCategory().setId(55555561L).setName("次要类别2").setNum(46),
                new com.jhscale.common.model.device.DPLU.DCategory().setId(55555562L).setName("次要类别3").setNum(47)));
        PLU.setPrintInfo1(new com.jhscale.common.model.device.DPLU.DPrintInfo(new com.jhscale.common.model.device.DPLU.DPrintType().setId(445685L).setName("打印格式1").setNum(21),
                new com.jhscale.common.model.device.DPLU.DPrintBarcode().setId(445686L).setName("打印条码1").setNum(24), 12));
        PLU.setTexts(Arrays.asList("TEXT1", "TEXT2", "TEXT3", "TEXT4"));
        PLU.setTaxrate(new BigDecimal("0.004"));
        PLU.setBitmap(new com.jhscale.common.model.device.DPLU.DBitmap().setId(777777777L).setName("位图1").setNum(4).setContent("fafdafdgsgds"));
        PLU.setManualDiscount("0#1|3#2|3#2");
        PLU.setAutoDiscount1("8#127#5#2#20#");
        PLU.setAutoDiscount2("8#127#5#2#20#");
        PLU.setAutoDiscount3("8#127#5#2#20#");
        PLU.setAutoDiscount4("8#127#5#2#20#");

        String assemble = PLU.assembleZip();
        System.out.println(assemble);
        System.out.println(PLU.toJSON().length());
        System.out.println(assemble.length());
        System.out.println(PLU.assemble().length());

        com.jhscale.common.model.device.DPLU dplu = com.jhscale.common.model.device.DPLU.unzipParse(assemble);

        String assemble1 = dplu.assembleZip();

        System.out.println(assemble1.equals(assemble));
    }


    //    public static final String xxx = "H4sIAAAAAAAAAF1QTUvEMBD9K0vO24+026bt1YuINwVBkaVmSxu3TUObIGXZvxO8etaLCFIkehFEf4Un76ZfsmsYwkzem3kvM5PtbCdQYHv2eELHD6V6vX1/kuoPDQYMeWjh+/u9FxvACOaiSkAEMs5ZZFnXmZFUzCzr2sDUqLOYpllMzDgnjaC4NnFZWFhUVUJxsxy7LZ4UrKziqlneJCTNuMloCuaAZ6K4ojHJQURFns8ntdOGdYo22F72FtFg0Q18CB3ZPn693D08f3ze/7x9y3YRaki2+t027T7d/UJ/HZ8cnR+eaYJsN2AlKOF6utsZGIS6YboagXU65gflSqMogOGojxwvdLZS7RlQsFumQjaEEw1Cz5k2PIQr1aAi1TrV5H8zNecXvo79u7cBAAA=☆H4sIAAAAAAAAAF1QMUvEMBj9K0fma5u016bt6iKHm4KDyFFz5Vpp05ImQznu7wRXZ7uIIEGii5O/wsn1ML22h2f4CF9473vv5ZtJNftTOIQ+HE/kBpHU7w+fL1If0XDAsI8XQXg6e7MFdU64YCmIQcZ5HTvOfWalrLarprEItZosoZssye2kyFtBSWOTqnSIYCylpF2N0w5Py7piCWtXpBKU2zXdgDngmSjvaJIXIKaiKOaT2VVb94YQ7G4PCfGQ0AsDhDypnr/eHrvXbv/08/Et1SKCEEnlSgXtnnX6g8N1cblcnl9LZWhbsBY050bd7QMMRr2YeY3AsT+r1gbFIYpGf+z6EdpJfRJAo36XGkOEJhpCvjcteChX6sFF6m5vyP80DecXhtjslLYBAAA=";
//    public static final String xxx = "H4sIAAAAAAAAAF1QTUvEMBD9K0vO24+026bt1YuINwVBkaVmSxu3TUObIGXZvxO8etaLCFIkehFEf4Un76ZfsmsYwkzem3kvM5PtbCdQYHv2eELHD6V6vX1/kuoPDQYMeWjh+/u9FxvACOaiSkAEMs5ZZFnXmZFUzCzr2sDUqLOYpllMzDgnjaC4NnFZWFhUVUJxsxy7LZ4UrKziqlneJCTNuMloCuaAZ6K4ojHJQURFns8ntdOGdYo22F72FtFg0Q18CB3ZPn693D08f3ze/7x9y3YRaki2+t027T7d/UJ/HZ8cnR+eaYJsN2AlKOF6utsZGIS6YboagXU65gflSqMogOGojxwvdLZS7RlQsFumQjaEEw1Cz5k2PIQr1aAi1TrV5H8zNecXvo79u7cBAAA=☆H4sIAAAAAAAAAF1QMUvEMBj9K0fma5u016bt6iKHm4KDyFFz5Vpp05ImQznu7wRXZ7uIIEGii5O/wsn1ML22h2f4CF9473vv5ZtJNftTOIQ+HE/kBpHU7w+fL1If0XDAsI8XQXg6e7MFdU64YCmIQcZ5HTvOfWalrLarprEItZosoZssye2kyFtBSWOTqnSIYCylpF2N0w5Py7piCWtXpBKU2zXdgDngmSjvaJIXIKaiKOaT2VVb94YQ7G4PCfGQ0AsDhDypnr/eHrvXbv/08/Et1SKCEEnlSgXtnnX6g8N1cblcnl9LZWhbsBY050bd7QMMRr2YeY3AsT+r1gbFIYpGf+z6EdpJfRJAo36XGkOEJhpCvjcteChX6sFF6m5vyP80DecXhtjslLYBAAA=";
    public static final String xxx = "H4sIAAAAAAAAAK1Uv0vDQBj9V8p1LfF+JL20q4WKOAiiopskUfsjSbGNIKH/zu3dLFXBRYscTiJ1dHEVBxcnv0tavbQpdjAc4e7d69f3Pt4XJ/SN5mnXOWp7hhP6fhgYfuh6bcP1zhuOZ3TakVHb3trdY2IiJtzGFk4fws0yFfLma3gtJLGExGJcSBaQeMphnBNuizHBhjomV3Z6xVmZWYDEC9B9X4xvXx4GV3fPk9Hn4zv8nDJzVnxumUVCeVGVT18EF4VcAHMwmoMxwApgZCpW/5+tnc3DjX0xThRjQqb+ygQzJqTmocLLnAsZIzcKGj1URc0mKqHeRceDvbIEJ3WzDk1GVW6TyrSUZVdM1hdy9Po0GL5dfkBTKUv0xIigaoyOol5Ya3SdMAp6AKBFl1BaJ9EcEp0nsRwSM+dZZh5LkTpnEBJUJdTA/RJiq+hckJCnk/2fTkvXCTKhx3E/bay2/R/Zq7V3FdWmppqq7iYyo8D1jhuB56797BJ846BeF5L+ZFdhv0m+1xNLiWllEptOnZbY1kluYuHElofXZkpiZm5VgK2ZlLkVz7zhv6xNJ2+5OfhcUBjMzNBqp9aJkKkNIZNRzYr+BqErLZwABQAA☆H4sIAAAAAAAAAGVQsU7DMBD9FeQZWXZc22lWGFDVAQkBM0qiUpo0EbRIKMrv3M6ICEgsxUInRhS+gomFAeEmbklU6w13vqd3712YpfTq8ia8SGIaZmmazWmaRXFCo/h2GsY0T5b08Hh8eiaghlr7TLL2cT1QHuDzz8MTIJeADMxeA0vSLUdozfUQDKPrrpn47UQLJSRv6C+fb/fVqvp9/H7/AsM9ITdCO8AuNqJdyvhkNDo6twvBFJpx7mwojw8U4M56LEi0nE8XJCCzCdkni7s8tnW1+qht5ybClQf2LCTQPh86Ven7gpWAvQBoA6i+0S0Kkl/bm5LAWi87/841ettQ/YivJRjv/4pt1E43mwC2pgHFOmbf4h9SrXFq4wEAAA==☆H4sIAAAAAAAAAGVQPU/DMBD9K8gzsvzRxCYjVOrCwADsKLGgVdJE0CKhKH/nJiYmKlFGyHCsKL+AnZWJS21oKNYb/O6dz+9eWhZ8dnWTXuSOp2VRlHNelJnLeeZup6njVb7k45Pjs3MNHXTGikj4I80oVoDPX6s1oIwABbR7G1CT8T3aGGmpLnjPoN3Ib/cP69XH46eEViod/7z6BxxCqjBi2HN6OJnQFKrWRkgZ/oyVHBlAwJply/l0wRJG0iXbZ4u7yhF7ennviAXNhusRbc0SY+VBmBNZq6MGcOuXXGjz19cvalZdU14s6Z02A8GbRIoqpBDqgb020KptQn6xAeutA3rPgBZw1+E37zdL9sEBAAA=☆H4sIAAAAAAAAAGVQPU/DMBD9K8gzsuw4iU1WkMrAwAISI0qsUkiaCFokFOXv3M5GxccIGW5EKCsLOysTh21KKqwn6559H+9eXlf8/OwqPy0tz+uqque8qgtb8sJez3LLm3LJ9w4Pjo4VDDBoIxLhj9RxGgE+fa0eAWUCKKDfcqAk7XOU1tJI6AX/YdBLIUzqcu7fX29XH3ef9BYp/Vv5DzgGVYc+46T9k8mEJkDfaiFlmJtGMjauguZhy4rlfLZgGbuYsm22uGksxQ/PbwOx8KNCuEvLs0wbuRNaJcYo0QGuFSMpNpvK1mhZc0muscxp7bxsdzuZSIaFHUJBYC8d9NGfT36zESPTp4BeMqAmbAqMvwHQKmroxwEAAA==☆H4sIAAAAAAAAAGWQu07EMBBFfwW5RpadOLFJC9JSUNCARImSCBYlmwh2kVCU35mejhWPElxMiVBaGnpaKmZtKwSwbuFrz+PM5E3NL86v8tOq5HlT182C101RVrwor+d5ydtqxfcOD46OYxhg0EYkwh+pVRoBPn2tHwFlAijAbjlRkPYxsdbSKLCCbxxYKYRJXcz9++vt+uPuk94iNWb+E05F2aHONGj/ZDajDmA7LaQMfdNIJtJlUD/sWLFazJcsYwR/xrbZ8qYtyT08vw3kwp8O110an2XayJ1QLDEmVj3gyIzELH+zjepYe0l7Y5mj7Sc/DhQVLcpPEZ6De+nBRj+b8rNN3IYc0CMDatIfwG9QW25NyQEAAA==";
//    public static final String xxx = "H4sIAAAAAAAAAG1Ru07DMBT9lcozdew4Jk5WmBADQoI9SqMkbV7CKVIU5Xfuwi8gxAQePKOOqF+CnaQSoVzd4fo+zzmO6xJvMxlHRYLjuizrCpf1JinwJnnO4wQ3xR5f390+PDI4wMEXhJPZKCUUtDq+f4OmHDQBZfrmGmPMA/X2oo6gzJA/pT3COA1ArcakmJJ+4AnCQPVnqc/htIILb5z64/3KntVZ2zah42yztexkm5S4lnIdV2uZRVWaRTmOirzbV7G0DB1pqEqD1KGXBo8rGCM+5yKgeNuk402z9bdThpkBtTx9cw+KWNBWh9GYEJx4oM9o6B5t9lXeohDtUnSB2q5JTPz68XUwr7nC5vDKiI9CX9DgpDNxBR1Aj0JoK4Re/ec9ap7Mh6HQwh0m4Keau2i1FN0lGwpql4KeMIFmlsUSwQ9MUhChKAIAAA==☆H4sIAAAAAAAAAG2RvW6DMBDHXyXyXIyN4+CwtmOGLO2OCAISvlRDJRTlde4pOmRJy+C5ytaqT9JzIFGQap3s8/l8/v3PUVXQbaqjMI9pVBVFVdKi2sQ53cRvWRTTOm/p03r1/CLgDGdfMcnGwTnjYPrf4w8YLsEw6DFvPBNCSOiP36cT9HjJH8JzJqSHebOrDQlSybvYzfYzW9SkTVMHrrtNHd3pJi5opbUTlY5OwzJJw4yGeda1ZaQtv6tRiEYOly/wNU+JhWCewoVu6wQ+D7ayuTcuqUWbPr1aQ8+RwLcqL0MoJRmqRDFqiPjLuWJzMHuyacusIQHZJeSBNF0do//+8XXG3XgiRvcRW0sCX/HltYsIxw9gLo0wthFm9p/tSf2K30ECi3sYwC8zkhpvkms1elM5KGWXgBmgwAgrY4rwB+qw0BEHAgAA☆H4sIAAAAAAAAAG1RvWrDMBB+laC5kS0pthSv7VQylEK7G8fYTvxH5RRCyOvcOxQyZGo1aC4ZS1+gr9BT7JQYehzidHe6+75PSVPRVa6TuExp0lRVU9OqWaYlXaavRZLSttzQu4fF07OAE5yk8gN/MMZ8BtZ8H7/AsgCsDwb7hpoQIgRz/Dm8mW8w+Ez2hZkvAs7ATC5+aQlUeJX9893EDbZ517WR563yqd7qLq1oo/U0qac6j+ssjwsal8V2UyfacfA0ktGIxWMh7uNKKMW4kJLTVZvBx95NttfOFHXgxqsX949gOEKQjurZcFDgh2CRj+ozcj5DScDuyHJTFx2JyDojN6TbtinGh/fPE96GihjCW9SXRFKx+UVKnyu2BztoYZ0WdvKf70j7gr9CIod432M/nw6s5aNmx5OPKaHw6wxsjwuscEzGKH4ByvHjEQ8CAAA=☆H4sIAAAAAAAAAG1RvU7DMBB+lcozdfzTYDcjMDIwAHuURkna/AmnSFXV17mnYGACDzejjggegRfATlLUSJw+Wee78933nZOmouvcJHGZ0qSpqqamVbNKS7pKn4skpW25pTd3tw+PEo5wVJqFbDTOGQe0X6+fgDwEZGBd3ZiTUi7B4vdPA9Y9UkN4wWQoBNjZCUNBqNVZ7A/7mW+Kede1URCs87nZmS6taGPMPKnnJo/rLI8LGpfFblsnxvMPjBNiHI+AX7ppQodKKi6kCum6zeD94DvjOQSjntp09P0VWOkYKK+yN6l1yBSgE6OHiFouNLsE3JPVti46EpFNRi5It2tT57+8fRzdbczI0b12qyWR0nx52iITmh8A+0WgXwTO/sOetE/uO0jk6R76EO9PxxTFpNZrFFM5HOwmAxxIAUovY0rhF9RKJI4HAgAA☆H4sIAAAAAAAAAG2Ru07DMBSGXyXyTBw7zsXNCgMDA0IC5iiNcmluwglSVfV1jngHGJjAg8WIOqJKvAd2k6AWcfTLsn2O7e8/Ttoal7lI4irFSVvXbYPrdplWeJk+FkmKu2rAF9dXt3cMdrALOfHJFJQSCkruX79AUR8UAanrphxjHgX58f38JPcg9bFwTHiE+a4H0po1l/h8cbT7q41lLlZ533eR45S5LdaiT2vcCmEnjS3yuMnyuMBxVayHJhHGgyO0GaFZHBro91weeAEnLgs4LrsM3rfmZnUsGmIDd/r0/eWNxtIIobF6CMa5TxaHIxu0HJqiRxFaZegM9esu1fOXt8+dXk0ZNk3PdUNRFHK6mHtHXE63oCbzyphX1n/aoO5BfwOKDOJ2hD2Mhk65J8XGmHvqQf/BKgM1coFioP5S/ACthRhIAAIAAA==☆H4sIAAAAAAAAAG2Ru07DMBSGX6XyTB1f6iTNCIwMLCDBFqVRLs1NOEGqqr7OmXkABibwYCakqiNCYuQdsJMUtRXWkXXsc/H3H0d1ifNURmER46guy7rCZb2IC7yIH7Moxk3R4cvrq5tbDjvYeT4RZFyUEgpafb18gqYCNAFl8sYY5zMGavvz9P3xDsqUeUNgRrhgAtRkb/sUMScHt3+2ntjGOm3bJnCcPJ3KlWzjEtdSTqNqKtOwStIww2GRrboqklaDI40YaVgc6pr3mO+6ggiXMobzJoG3je2sD40yLFxyAnB/fgfKNQieldov7vuCkr5kjRZdlbUoQMsEnaF21cTGf37d7sxpjPDRvTADRYHn0/l+doT5dAN6FK+teD35z9aoeTDfgIIecTPQ9rvF0+wo2ypjxyIoqGUCegADzUGfYvwC8r7TjAECAAA=☆H4sIAAAAAAAAAG2RvU7DMBDHX6XyTB07rhM3K5VYGFhgYIuSKEmbL+EUqar6OvcELEgMTDSD5yojYmfiBTi3adUiTifL9t35fv9zVJd0nukoLBIa1WVZV7Ss46SgcfKcRwltiiWd3d3ePwjoofcVk2wwzhkH0329f4LhEgyDDvOGmBCTCXS775ef1y10WOYfAhMmpOtBNzr6MUVO+dntydcj+7DJ2rYJHGeejfVKt0lJa63HUTXWWVilWZjTsMhXyyrSVoOjUYxGFod72M9VvivZ1OfSo/Mmhe3GvmzOnQvqIdxl68fZDZIjgm+l7k0oJTnfl6xJvKzylgRkkZIr0q6aBPdvH7seT0NEDNtrHCgJfMWnx9kxV/ENmEG8seLN6D9fk+YJv4EEFnFzgN2vls64F8lWmHupAWe6SMEcuMAIMH8pfgEts8JgAAIAAA==☆H4sIAAAAAAAAAG1Qu07DMBT9lcgzdew4IU5WkFgYWGBgi9IoSZuXcIoURfmd+w0MDEzgwWKsMiJ2/gE7SVFbcXVkXd/nOTeuS7zJRBwVCY7rsqwrXNbrpMDr5DmPE9wUO3x9d3v/wGCE0efEI4tRSigo+f32BYp6oAhIXbfkGHM5yP3PyydI3eTPYZcwz/FBWgfMBV7gHMX+0FtmqMratglte5OtRCfapMS1EKu4WoksqtIsynFU5N2uioXhbwstRGgeNr3U2xzOGQ0Clzsu3jQpfAxmsjqGhw2z082PNyA1/d43IidjnHvUmRp6tN5VeYtCtE3RBWq7JtH+6/t+1L8lwxb3Sp8ShT6nweFqxOF0ADUJV0a4sv5Dj5onfX4UanrDFKHTq5mp0x4j6ex8FOQ2BTVzAsVAnTP4BUaojaf2AQAA☆H4sIAAAAAAAAAG2QvU7DMBDHXyXyTJw4bmonK4wMLCDEFiVRkjZfwilSVfV17ikYGBB48MBUZUTsvAOXj6IWcTpZ9n34fv+Lm4quchVHZUrjpqqamlZNkpY0SZ+KOKVtuaFXN9e3dxx66IV0fXc2xlwGRn+9fIJhPhgXNNbNOc59Afrw/fEKGpvEFF643PckaOvoU4Ef8JPYr++s4VOTd10bOs4qt9VWdWlFG6XsuLZVHtVZHhU0Kovtpo7VwO8oFKKQw2FLnOYFbLHkQniM01Wbwft++NmcekAlkp1PfrgHHSCAGESOxqX0GR8bdiTZ1EVHQrLOyAXptm2K9+e3Q4+vOcPn6yWukoRCsuC4NdeTbA9mFG4G4cb6z3ekfcT1kxDx9mOEjSeSGe+sdJDkneMz0OsMzMQEBmf8JfgBZtppgPYBAAA=☆H4sIAAAAAAAAAG1RvWrDMBB+laC5kSXLsmSvLXTpECjtbhxjO/EflVMIIS/T4d6h0KFLGhc0l4ylT1LJdkJSenyIO92Pvu8U1yVeZCqOigTHdVnWFS7reVLgefKcxwluihW+md09PDI4wEFIwslolBIKuvt5/wZNOWgCnakbc8yTJv582e1e99CZNjEkPMI4o9BNjjiW8MA/uz1hM7GDdda2Teg4i2yq1qpNSlwrNY2rqcqiKs2iHEdFvl5VsbIaHGXEKMPFob7nB0JIl3MiXeHhpkphv7WT9TkoxYEk5PLp+9ktdNQ1HITV2huTklO/79mg+arKWxSiZYquULtuEuO/fXwdTDRm2Ohem42iUEgaHJdHXEm3oEf12qrXk/+wQc2T+QcU9hy3A93+tPy0e1FtpbmXKsyulynogRhoBvovjV9uyQPDAgIAAA==";


    public static void UDPLU() throws ProfessionalException {
//        com.jhscale.common.model.device.DPLU textPLU = com.jhscale.common.model.device.DPLU.unzipParse(xxx);
//        System.out.println(JSON.toJSONString(textPLU));
        List<DPLU> analyze = DPLUUtils.analyze(xxx, true);
        System.out.println("----  " + JSONUtils.objectToJSON(analyze));
        DPLUV3 dplu = (DPLUV3) analyze.get(0);
//        DPrice price = dplu.getSpecifications().get(0).getPrice();
//        DAutoDiscount dAutoDiscount = price.obtainAutoDiscount1();
//        System.out.println(dAutoDiscount.toJSON());
        String str = "{\"autoDiscount1\":\"4#127#0.00#0.00#6#\",\"autoDiscount2\":\"4#127#0.00#0.00#5#\",\"autoDiscount3\":\"4#127#0.00#0.00#4#\",\"autoDiscount4\":\"4#127#0.00#0.00#3.3#\",\"price\":7.0000}";
        DPrice dPrice = JSONUtils.jsonToObject(str, DPrice.class);
        System.out.println(dPrice.toJSON());
//        List<DPLU.DManualDiscount> dManualDiscount = DPLU.getDManualDiscount(textPLU.getManualDiscount());
//        System.out.println(JSONUtils.objectToJSON(dManualDiscount));
//        List<DPLU.DAutoDiscount> autoDiscount = DPLU.getAutoDiscount(textPLU.getAutoDiscount1(), textPLU.getAutoDiscount2(), textPLU.getAutoDiscount3());
//        System.out.println(JSONUtils.objectToJSON(autoDiscount));
    }

    private static void DPLULV2() {
//        DPLU PLU = new DPLU();
//        PLU.setPluNo(1);
//        PLU.setPluCode(450001234L);
//        PLU.setPluName("测试PLU");
//        PLU.setSortOrder(4);
//        PLU.setSpecification(new DPLU.DSpecification()
//                .setSpecificationId(45100000123L)
//                .setName("测试PLU 规格1")
//                .setRatio("1/5"));
//        PLU.setPictures("fdafdafsdf;fafdrewrew;fdafdsvfd;");
////        PLU.setMasterUnit(new Unit(UnitType.计件, 350000000L, "笔"));
////        PLU.setSecondUnit(new Unit(UnitType.计重, 444444444L, "1"));
//        PLU.setPrice(new BigDecimal("2.3"));
//        PLU.setNumber(4);
//        PLU.setIndexBar("FFFADAF54ER1REGSFD");
//        PLU.setUsedate(new DPLU.DUsedate().setVal(45));
//        PLU.setCostTrade(new BigDecimal("1.4"));
//        PLU.setTrae(new BigDecimal("0.02"));
//        PLU.setCategory(new DPLU.DCategory()
//                .setId(55555555L)
//                .setName("主要类别")
//                .setNum(4));
//        PLU.setSecondCategoryIds("45,46,47");
//        PLU.setSencondCategorys(Arrays.asList(
//                new DPLU.DCategory().setId(55555560L).setName("次要类别1").setNum(45),
//                new DPLU.DCategory().setId(55555561L).setName("次要类别2").setNum(46),
//                new DPLU.DCategory().setId(55555562L).setName("次要类别3").setNum(47)));
//        PLU.setPrintInfo1(new DPLU.DPrintInfo(new DPLU.DPrintType().setId(445685L).setName("打印格式1").setNum(21),
//                new DPLU.DPrintBarcode().setId(445686L).setName("打印条码1").setNum(24), 12));
//        PLU.setTexts(Arrays.asList("TEXT1", "TEXT2", "TEXT3", "TEXT4"));
//        PLU.setTaxrate(new BigDecimal("0.004"));
//        PLU.setBitmap(new DPLU.DBitmap().setId(777777777L).setName("位图1").setNum(4).setContent("fafdafdgsgds"));
//        PLU.setDiscountLower(new DPLU.DManualDiscount().setId(44444L).setName("手动折扣下限").setNum(8).setDiscount(new BigDecimal("0.1")));
//        PLU.setAutoDiscount1(new DPLU.DAutoDiscount().setId(999999L).setName("手动折扣上限").setNum(11).setDate(127).setLower(new BigDecimal("0.01")).setUpper(new BigDecimal("0.99")).setDiscount(new BigDecimal("0.5")));
//
//        String assemble = PLU.assembleZip();
//        System.out.println(assemble);
//        System.out.println(PLU.toJSON().length());
//        System.out.println(assemble.length());
//        System.out.println(PLU.assemble().length());
//
//        DPLU dplu = DPLU.unzipParse(assemble);
//
//        String assemble1 = dplu.assembleZip();
//
//        System.out.println(assemble1.equals(assemble));

        String text = "H4sIAAAAAAAAAF1QwUrEMBT8lSXnbZuW1nZ79SLiTUFQZKnZ0sRt05AmSFn2d4JXz3oRQYpEL4Lo\n" +
                "V3jybtptS9cQ8pLMZGbyZqqZTWYIYQCH4XmB0m93H89K73EiGI0UeBBNoMsNYAQJyVMQAywEix3n\n" +
                "BlspZ3ZZVRaiVoUTmuGE2ElOaklRZaOycJDkPKWoXvavHZEWrOQJr5e3KcmwsBnNwBwILItrmpAc\n" +
                "xFTm+XxwO6tZ6wjB9qrLFw75XNcNVPP0/Xr/+PL59fD7/qMaf2EA1UAbdnX6tW45OT2+ODo3BNVs\n" +
                "wEpSIox0a74zaYXMqb9fZ/3+sFwZNIzcxdg/P/S2Su+Za7ftpQ5NsDGiB/1pBL1zUHqdGeI/PUP5\n" +
                "A3aiDGCyAQAA";
        String text1 = "H4sIAAAAAAAAAF1QzUrEMBh8lSXnbZu026bt1YuINwVBkaV2SxO3TUObImXZ1wlePetFBCkS9yKIPoUn76Y/C3ZDCF8y881MvplsZ9ONfejCcQW2F0j1fv/xItUBxx8Y2MULz5sqXG0Ap7GoywSEgAjBQ8u6JUZScrOoKiNmRkUilpKImlFGm5rFlRkXuRXXZZmwuFmO3ZZIcl6UUdks7xKaEmFyloI5EKTOb1hEMxCyOsvme7fzhneOEGyv+4h4iOj4HkK2bJ+/3x6eXj+/Hn93P7JdBBqSrX6HJuzL/1/oj9Ozk8vjC02Q7QasakaFVne6AINRJ6ZvI7BOx/qoWGkU+ygY/bHtBvZWqkkAhbqRKgwR2tMQcu3pnB2pBhep1qkmH2hqzh9bCa86wAEAAA==☆H4sIAAAAAAAAAF2QQWuDMBiG/0rJuWqi1ajXXUbZbYMdxigulerQGGJykNK/E3bdeV7GYMjIdtlpv6KnXctitQMbQkj4nu9933wz1c2mG4fQh+OK3CBS+vPp+03pMyYcCOzjRRBOFe62gOVESJ6CGGRCsNhxHjMr5cyu6toi1KqzhG6yJLeTIm8kJbVNqtIhkvOUkmY1djsiLVnFE96sSCWpsBndgDkQmSwfaJIXIKayKOYns5uG9YYQ7O6PCfGQ0AsDhDzVvf58PLfv7eHl92uvukUEIVKdqzpo99T0B8fj6nq5vLxVncG2YC1pLoy62wcYjHox8xoL//eLam2qOETR6I9dP0I7pScBNOonqjFE6IQh5HvTMbtKDy5KtwcDn2ka5g9S8H14vwEAAA==";
        DPLU textPLU = DPLUV2.unzipParse(text1);
        System.out.println(JSON.toJSONString(textPLU));
    }
}
