package com.jhscale.test.network;

import com.jhscale.common.model.http.JRequest;
import com.jhscale.common.utils.HttpUtils;
import com.jhscale.common.utils.JSONUtils;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

/**
 * @author lie_w
 * @title: GenericInterTest
 * @projectName common
 * @description: TODO
 * @date 2021/4/715:16
 */
public class GenericInterTest {

    private static String KEY = "F2A52664E0A0509BAAF7D0AD87ED4A97";
    private static String GET_DEPPON_ENCODING = "http://192.168.101.120:8998/hw/deppon/get-encoding";
    private static String SUCCESS_DEPPON_ENCODING = "http://192.168.101.120:8998/hw/deppon/successs-encoding";
    private static String AUTH_HEAD = "X-Auth-Sign";


    public static void main(String[] args) {
//        test1();
        GetDepponEncodingRequest();
//        SuccessDepponEncodingRequest();

    }

    private static void SuccessDepponEncodingRequest() {
        Map<String, String> map = new HashMap<>();
        map.put("name", "ys-db");
        map.put("mac", "0023F0148E3A");

        SuccessDepponEncodingRequest request = new SuccessDepponEncodingRequest();
        request.setEncoding("13312202103220000");
        request.setUseMac("0023F0148E3A");
        request.setUseDevice(map);
        request.defaultInit();
        String sign = request.bulidSign(KEY);
        request.setSign(sign);
        Map heads = new HashMap();
        heads.put(AUTH_HEAD, sign);
        String body = JSONUtils.objectToJSON(request);
        System.out.println(JSONUtils.parseJSON(body));
        String result = HttpUtils.post(SUCCESS_DEPPON_ENCODING, body, heads);
        System.out.println(result);
    }

    public static class SuccessDepponEncodingRequest extends JRequest {
        private String encoding;
        private String useMac;
        private Object useDevice;

        public String getEncoding() {
            return encoding;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public String getUseMac() {
            return useMac;
        }

        public void setUseMac(String useMac) {
            this.useMac = useMac;
        }

        public Object getUseDevice() {
            return useDevice;
        }

        public void setUseDevice(Object useDevice) {
            this.useDevice = useDevice;
        }
    }

    private static void GetDepponEncodingRequest() {
        GetDepponEncodingRequest request = new GetDepponEncodingRequest();
        request.setUseMac("0023F0148E3A");
        request.defaultInit();
        String sign = request.bulidSign(KEY);
        request.setSign(sign);
        Map heads = new HashMap();
        heads.put(AUTH_HEAD, sign);
        String body = JSONUtils.objectToJSON(request);
        System.out.println(JSONUtils.parseJSON(body));
        String result = HttpUtils.post(GET_DEPPON_ENCODING, body, heads);
        System.out.println(result);
    }

    public static class GetDepponEncodingRequest extends JRequest {
        private String useMac;

        public String getUseMac() {
            return useMac;
        }

        public void setUseMac(String useMac) {
            this.useMac = useMac;
        }
    }

    private static void test1() {
        GenericInter inter = new GenericInter();
        Type[] parameters = inter.getClass().getTypeParameters();
        for (Type parameter : parameters) {
            if (parameter instanceof Class) {
                System.out.println(parameter);
            }
        }
        Type type = (inter.getClass().getTypeParameters()[0]);
        System.out.println(type);
    }

    public static class Test1 {
    }

    public static class Test2 {
    }

    public static class GenericInter<Test1, Test2> {
    }
}
