package com.jhscale.test.network;

import com.jhscale.common.em.DeviceType;
import com.jhscale.common.model.http.JRequest;
import com.jhscale.common.utils.HttpUtils;
import com.jhscale.common.utils.JSONUtils;
import io.swagger.annotations.ApiModelProperty;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lie_w
 * @title: PaymentTest
 * @projectName common
 * @description: TODO
 * @date 2021/5/1011:53
 */
public class PaymentTest {

    private static final String UNIQUE = "SCOPA1ERA0704A0E126ADE";
    private static final String KEY = "5AD7084DD00601F212103E77795BB031";
//    private static final String KEY = "D3366D3A14DB6FA202BE24AAD7C1FE68";
    private static final String TYPE = DeviceType.Android_Scales.getType();
    private static Map<String, String> map = new HashMap<>();

    static {
        map.put("X-Equipment-Info", "{\"type\":\"" + TYPE + "\",\"unique\":\"" + UNIQUE + "\"}");
        map.put("X-Company", "JHScale 1.0");
    }

    /**
     * @description: 发送请求
     **/
    public static void send(String url, JRequest request) {
        System.out.println(request.toJSON());
        String post = HttpUtils.post(url, request.toJSON(), map);
        System.out.println(JSONUtils.parseJSON(post));
    }

    public static void main(String[] args) {
//        PaymentRequest();
        PretreatementPaymentRequest();
//        QueryPaymentRequest();
//        QueryPaymentRequestVPS();
//        CancelPaymentRequest();
    }

    public static void CancelPaymentRequest() {
        CancelPaymentRequest request = new CancelPaymentRequest();
        request.setOrderno("72ERA07020648342057192011");
        request.setType(TYPE);
        request.setUnique(UNIQUE);
        request.defaultInit();
        request.setSign(request.bulidSign(KEY));
//        send("https://eq.jhscale.net/cp/payment/cancel", request);
        send("http://192.168.101.120:15100/cp/payment/cancel", request);
    }

    public static class CancelPaymentRequest extends JRequest {
        @ApiModelProperty(value = "设备类型(不传默认 Simple_Scales)", name = "type", example = "Simple_Scales|Android_Scales|PC_Scales|BT_Scales|VPS_PC_Scales")
        private String type;

        @ApiModelProperty(value = "设备编号", name = "unique", required = true)
        private String unique;

        @ApiModelProperty(value = "设备记录编号（HEX）[设备记录编号|系统支付单号|三方支付单号 三选一]", name = "fid")
        private String fid;

        @ApiModelProperty(value = "系统支付单号 [设备记录编号|系统支付单号|三方支付单号 三选一]", name = "orderno")
        private String orderno;

        @ApiModelProperty(value = "三方支付单号 [设备记录编号|系统支付单号|三方支付单号 三选一]", name = "tradeno")
        private String tradeno;

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getUnique() {
            return unique;
        }

        public void setUnique(String unique) {
            this.unique = unique;
        }

        public String getFid() {
            return fid;
        }

        public void setFid(String fid) {
            this.fid = fid;
        }

        public String getOrderno() {
            return orderno;
        }

        public void setOrderno(String orderno) {
            this.orderno = orderno;
        }

        public String getTradeno() {
            return tradeno;
        }

        public void setTradeno(String tradeno) {
            this.tradeno = tradeno;
        }
    }

    public static void QueryPaymentRequestVPS() {
        QueryPaymentRequest request = new QueryPaymentRequest();
        request.setOrderno("72ERA07020648342057192011");
        request.setType(TYPE);
        request.setUnique(UNIQUE);
        request.defaultInit();
        request.setSign(request.bulidSign(KEY));
        send("https://eq.jhscale.net/cp/payment/query-svpn", request);
    }

    public static void QueryPaymentRequest() {
        QueryPaymentRequest request = new QueryPaymentRequest();
        request.setOrderno("72ERA07020648342057192011");
        request.setType(TYPE);
        request.setUnique(UNIQUE);
        request.defaultInit();
        request.setSign(request.bulidSign(KEY));
        send("https://eq.jhscale.net/cp/payment/query", request);
    }

    public static class QueryPaymentRequest extends JRequest {
        @ApiModelProperty(value = "设备类型(不传默认 Simple_Scales)", name = "type", example = "Simple_Scales|Android_Scales|PC_Scales|BT_Scales|VPS_PC_Scales")
        private String type;

        @ApiModelProperty(value = "设备编号", name = "unique", required = true)
        private String unique;

        @ApiModelProperty(value = "设备记录编号（HEX）[设备记录编号|系统支付单号|三方支付单号 三选一]", name = "fid")
        private String fid;

        @ApiModelProperty(value = "系统支付单号 [设备记录编号|系统支付单号|三方支付单号 三选一]", name = "orderno")
        private String orderno;

        @ApiModelProperty(value = "三方支付单号 [设备记录编号|系统支付单号|三方支付单号 三选一]", name = "tradeno")
        private String tradeno;

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getUnique() {
            return unique;
        }

        public void setUnique(String unique) {
            this.unique = unique;
        }

        public String getFid() {
            return fid;
        }

        public void setFid(String fid) {
            this.fid = fid;
        }

        public String getOrderno() {
            return orderno;
        }

        public void setOrderno(String orderno) {
            this.orderno = orderno;
        }

        public String getTradeno() {
            return tradeno;
        }

        public void setTradeno(String tradeno) {
            this.tradeno = tradeno;
        }
    }

    public static void PretreatementPaymentRequest() {
        PretreatementPaymentRequest request = new PretreatementPaymentRequest();
        request.setOrderno("JHERA07021404230747119171");
        request.setSwepttype(10);
        request.setType(TYPE);
        request.setUnique(UNIQUE);
        request.defaultInit();
        request.setSign(request.bulidSign(KEY));
        send("http://192.168.101.120:15100/cp/payment/payment", request);
    }

    public static class PretreatementPaymentRequest extends JRequest {
        @ApiModelProperty(value = "设备类型(不传默认 Simple_Scales)", name = "type", example = "Simple_Scales|Android_Scales|PC_Scales|BT_Scales|VPS_PC_Scales")
        private String type;

        @ApiModelProperty(value = "设备编号", name = "unique", required = true)
        private String unique;

        @ApiModelProperty(value = "设备记录编号（HEX）", name = "fid", required = true)
        private String fid;

        @ApiModelProperty(value = "系统订单号", name = "orderno", required = true)
        private String orderno;

        @ApiModelProperty(value = "授权码支付码", name = "auth")
        private String auth;

        @ApiModelProperty(value = "业务类型", name = "swepttype", example = "10-支付宝扫码|20-微信扫码|80-QQ扫码|70-云闪付扫码")
        private Integer swepttype;

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getUnique() {
            return unique;
        }

        public void setUnique(String unique) {
            this.unique = unique;
        }

        public String getFid() {
            return fid;
        }

        public void setFid(String fid) {
            this.fid = fid;
        }

        public String getOrderno() {
            return orderno;
        }

        public void setOrderno(String orderno) {
            this.orderno = orderno;
        }

        public String getAuth() {
            return auth;
        }

        public void setAuth(String auth) {
            this.auth = auth;
        }

        public Integer getSwepttype() {
            return swepttype;
        }

        public void setSwepttype(Integer swepttype) {
            this.swepttype = swepttype;
        }
    }

    public static void PaymentRequest() {
        PaymentRequest request = new PaymentRequest();
        request.setAmount(1);
        request.setBiztype("ALL");
        request.setCount(1);
        request.setFid("11");
//        request.setPaytype(72);
        request.setPonit(2);
        request.setTitle("生产支付测试");

        request.setType(TYPE);
        request.setUnique(UNIQUE);
        request.defaultInit();
        request.setSign(request.bulidSign(KEY));
        send("http://192.168.101.120:15100/cp/payment/sys-pretreatment", request);
    }

    public static class PaymentRequest extends JRequest {

        @ApiModelProperty(value = "设备类型(不传默认 Simple_Scales)", name = "type", example = "Simple_Scales|Android_Scales|PC_Scales|BT_Scales|VPS_PC_Scales")
        private String type;

        @ApiModelProperty(value = "设备编号", name = "unique", required = true)
        private String unique;

        @ApiModelProperty(value = "设备记录编号（HEX）", name = "fid", required = true)
        private String fid;

        @ApiModelProperty(value = "标题(默认第一个商品名)，不传则默认 临时商品", name = "title")
        private String title;

        @ApiModelProperty(value = "明细数量", name = "count", required = true)
        private Integer count;

        @ApiModelProperty(value = "订单支付金额 >0 (小数点位数不传 默认分)", name = "amount", required = true)
        private Integer amount;

        @ApiModelProperty(value = "小数点位数", name = "ponit")
        private Integer ponit = 2;

        @ApiModelProperty(value = "请求IP 不传默认 127.0.0.1", name = "ip")
        private String ip;

        @ApiModelProperty(value = "订单创建时间 (秤上时间 不需要自传时区 不传默认当前时间)（yyyy-MM-dd HH:mm:ss）", name = "start")
        private String start;

        @ApiModelProperty(value = "支付类型 用于生成订单号", name = "paytype", example = "1-支付宝|2-微信|70-云闪付|71-沈阳建行|72-上海邮政", required = true)
        private Integer paytype;

        @ApiModelProperty(value = "业务类型 (主扫|被扫 不需要填充)", name = "biztype", example = "SCAN-主扫|SWEPT-被扫|ALL-全部")
        private String biztype;

        @ApiModelProperty(value = "订单备注信息", name = "remark")
        private String remark;

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getUnique() {
            return unique;
        }

        public void setUnique(String unique) {
            this.unique = unique;
        }

        public String getFid() {
            return fid;
        }

        public void setFid(String fid) {
            this.fid = fid;
        }

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Integer getCount() {
            return count;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        public Integer getAmount() {
            return amount;
        }

        public void setAmount(Integer amount) {
            this.amount = amount;
        }

        public Integer getPonit() {
            return ponit;
        }

        public void setPonit(Integer ponit) {
            this.ponit = ponit;
        }

        public String getIp() {
            return ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public String getStart() {
            return start;
        }

        public void setStart(String start) {
            this.start = start;
        }

        public Integer getPaytype() {
            return paytype;
        }

        public void setPaytype(Integer paytype) {
            this.paytype = paytype;
        }

        public String getBiztype() {
            return biztype;
        }

        public void setBiztype(String biztype) {
            this.biztype = biztype;
        }

        public String getRemark() {
            return remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }
    }
}
