package com.jhscale.test.ploymerzation;

import com.alibaba.fastjson.JSONObject;
import com.jhscale.common.em.SwitchState;
import com.jhscale.common.exception.GeneralException;
import com.jhscale.common.exception.GeneralInternational;
import com.jhscale.common.exception.ProfessionalException;
import com.jhscale.common.exception.TechnologyException;
import com.jhscale.common.model.device.polymerization.cloudpay.*;
import com.jhscale.common.model.device.polymerization.em.*;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.model.device.polymerization.jky.*;
import com.jhscale.common.model.device.polymerization.jky.biz.*;
import com.jhscale.common.model.device.polymerization.jky.trade.*;
import com.jhscale.common.model.device.polymerization.rely.RefreshRequest;
import com.jhscale.common.model.device.polymerization.rely.RefreshResponse;
import com.jhscale.common.model.http.WSAccept;
import com.jhscale.common.model.http.WSSend;
import com.jhscale.common.utils.DateUtils;
import com.jhscale.common.utils.JSONUtils;
import com.jhscale.common.utils.RandomUtils;
import com.jhscale.common.utils.SystemtUtils;
import org.apache.commons.lang3.StringUtils;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;

import static com.jhscale.common.model.device.DConstant.*;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title CloudPayTest
 * @description
 * @create 2024/1/22 17:17
 */
public class PolymerizationTest {

    private static final Integer MASTER_BALANCE_ID = 51569;
    private static final String MASTER_UNIQUE = "SCOPA1ERA0704A0E126ADE";
    // 120
    // private static final String MASTER_AES_KEY = "5AD7084DD00601F212103E77795BB031";
    // 53
    private static final String MASTER_AES_KEY = "3ADA00E788A4A8410425059B5AAE3D3C";

    private static final Integer SLAVE_BALANCE_ID = 48193;
    private static final String SLAVE_UNIQUE = "SCOPAKGT4N704A0E4324BC";
    // 120
    private static final String SLAVE_AES_KEY = "728CB20C8AD49B49E4A04F6123FD5494";

    public static void main(String[] args) throws GeneralException {
        // 基础指令
        entity_test();

        // 刷新缓存
        // refreshCache();

        // 云支付
        // cloudProgram();

        // 吉卡云支付
        // jkyProgram();

        // WebSocket 吉卡云操作
        // jkyWebProgram(MASTER_BALANCE_ID, MASTER_UNIQUE, MASTER_AES_KEY);
        // jkyWebProgram(SLAVE_BALANCE_ID, SLAVE_UNIQUE, SLAVE_AES_KEY);
    }

    /**
     * @description: 吉卡云WebSocket进程
     **/
    private static void jkyWebProgram(Integer balanceId, String unique, String key) throws TechnologyException, ProfessionalException {
        web_socket_build(unique);

        String order_refund = null;

        // wb_login(true, true, unique, key);
        // wb_cancel(unique, key);
        // order_refund = wb_recharge(balanceId, unique, key);
        order_refund = wb_payment(balanceId, unique, key);
        // order_refund = wb_integral(balanceId, unique, key);
        // wb_refund(unique, key, order_refund);
    }

    /**
     * @description: 退款
     **/
    private static void wb_refund(String unique, String key, String order_refund) throws TechnologyException, ProfessionalException {
        JKYRefundRequest refundRequest = new JKYRefundRequest();

        String refund_order = SystemtUtils.scanner("退款订单信息: ");
        refund_order = StringUtils.isNotBlank(refund_order) ? refund_order : order_refund;

        if (StringUtils.isBlank(refund_order)) {
            JKYLoginResponse loginResponse = wb_login(false, false, unique, key);
            refundRequest.setLockId(loginResponse.getLockId());

            String store = SystemtUtils.scanner("储值退款金额: ");
            String cash = SystemtUtils.scanner("现金退款金额: ");
            String integral = SystemtUtils.scanner("积分退款数量: ");

            if (StringUtils.isNotBlank(store)) refundRequest.setStored(new BigDecimal(store));
            if (StringUtils.isNotBlank(cash)) refundRequest.setCash(new BigDecimal(cash));
            if (StringUtils.isNotBlank(integral)) refundRequest.setIntegral(new BigDecimal(integral));

            refundRequest.setTitle("草莓");
            refundRequest.setCount(2);
            refundRequest.setFid(48);
        } else {
            String[] refund_order_arr = refund_order.split("/");
            refundRequest.setBalanceId(Integer.parseInt(refund_order_arr[0]));
            refundRequest.setOriginalOrderFid(Integer.parseInt(refund_order_arr[1]));
            refundRequest.setOriginalOrderNo(refund_order_arr[2]);
            refundRequest.setOriginalOrderTime(DateUtils.timeStrFormat(refund_order_arr[3]));
            refundRequest.setAutoLog(0);
        }

        // refundRequest.setSid(3);
        // refundRequest.setScaleMan(0);
        refundRequest.setRemark(Reason.客户主动退款.getDescription());
        refundRequest.assemble(key);

        WSAccept refundWSAccept = client_send(new WSSend(JKY_REFUND, unique, refundRequest.rxtxData()));

        JKYRefundResponse refundResponse = new JKYRefundResponse(refundWSAccept.acceptObj(RXTXData.class));
        refundResponse.analyse(key);
        System.out.printf("退款响应内容：%s%n", refundResponse.toJSON());

        if (StringUtils.isNotBlank(refundResponse.getLockId())) {
            JKYRefundQueryRequest refundQueryRequest = new JKYRefundQueryRequest();
            refundQueryRequest.setLockId(refundResponse.getLockId());
            refundQueryRequest.assemble(key);

            WSAccept refundQueryWSAccept = client_send(new WSSend(JKY_REFUND_QUERY, unique, refundQueryRequest.rxtxData()));

            JKYRefundResponse refundQueryResponse = new JKYRefundResponse(refundQueryWSAccept.acceptObj(RXTXData.class));
            refundQueryResponse.analyse(key);
            System.out.printf("退款查询响应内容：%s%n", refundQueryResponse.toJSON());
        }

        // 重新登录
        wb_login(false, true, unique, key);
    }

    /**
     * @description: 积分兑换
     */
    private static String wb_integral(Integer balanceId, String unique, String key) throws TechnologyException, ProfessionalException {
        String order_refund = null;

        JKYLoginResponse loginResponse = wb_login(false, false, unique, key);

        String meal = SystemtUtils.scanner("套餐编号: ");
        String count = SystemtUtils.scanner("使用次数: ");
        String integral = SystemtUtils.scanner("使用积分: ");

        JKYIntegralRequest integralRequest = new JKYIntegralRequest();
        integralRequest.setLockId(loginResponse.getLockId());
        integralRequest.setFid(45);
        if (StringUtils.isNotBlank(meal)) {
            integralRequest.setType(IntegralType.套餐兑换.getType());
            integralRequest.setMealVersion(8);
            integralRequest.setMealOrder(Integer.parseInt(meal));
            if (StringUtils.isNotBlank(count)) integralRequest.setCount(Integer.parseInt(count));
        } else {
            integralRequest.setType(IntegralType.自定义兑换.getType());
        }

        if (StringUtils.isNotBlank(integral))
            integralRequest.setIntegral(new BigDecimal(integral));
        integralRequest.setRemark("积分兑换");
        integralRequest.assemble(key);

        WSAccept integralWSAccept = client_send(new WSSend(JKY_INTEGRAL, unique, integralRequest.rxtxData()));

        JKYIntegralResponse integralResponse = new JKYIntegralResponse(integralWSAccept.acceptObj(RXTXData.class));
        integralResponse.analyse(key);
        System.out.printf("积分兑换 响应内容：%s%n", integralResponse.toJSON());

        if (ChannelStatus.交易成功.equals(ChannelStatus.status(integralResponse.getCode()))) {
            order_refund = String.format("%s/%s/%s/%s",
                    balanceId, integralResponse.getFid(),
                    integralResponse.getOrderNo(),
                    DateUtils.getDate_YYYY_MM_DD_HH_MM_SS(integralResponse.getExpire()));
            System.out.printf("积分兑换 退款订单信息：%s%n", order_refund);
        }

        JKYIntegralQueryRequest integralQueryRequest = new JKYIntegralQueryRequest();
        integralQueryRequest.setLockId(loginResponse.getLockId());
        integralQueryRequest.assemble(key);

        WSAccept integralQueryWSAccept = client_send(new WSSend(JKY_INTEGRAL_QUERY, unique, integralQueryRequest.rxtxData()));

        JKYIntegralResponse integralQueryResponse = new JKYIntegralResponse(integralQueryWSAccept.acceptObj(RXTXData.class));
        integralQueryResponse.analyse(key);
        System.out.printf("积分兑换查询 响应内容：%s%n", integralQueryResponse.toJSON());

        // 重新登录
        wb_login(false, true, unique, key);

        return order_refund;
    }

    /**
     * @return
     * @description: 支付
     */
    private static String wb_payment(Integer balanceId, String unique, String key) throws TechnologyException, ProfessionalException {
        String order_refund = null;

        JKYLoginResponse loginResponse = wb_login(false, false, unique, key);

        String store = SystemtUtils.scanner("储值金额: ");
        String cash = SystemtUtils.scanner("现金金额: ");
        String cloud = SystemtUtils.scanner("云支付金额: ");
        String payCode = SystemtUtils.scanner("云支付支付码: ");

        JKYPayRequest paymentRequest = new JKYPayRequest();
        paymentRequest.setLockId(loginResponse.getLockId());
        paymentRequest.setFid(45);
        if (StringUtils.isNotBlank(store)) {
            paymentRequest.setStored(new BigDecimal(store));
        }

        if (StringUtils.isNotBlank(cash)) {
            paymentRequest.setCash(new BigDecimal(cash));
        }

        if (StringUtils.isNotBlank(cloud) && StringUtils.isNotBlank(payCode)) {
            paymentRequest.setCloud(new BigDecimal(cloud));
            paymentRequest.setPaycode(payCode);
        }

        paymentRequest.setTitle("草莓");
        paymentRequest.setCount(2);
        paymentRequest.assemble(key);

        WSAccept paymentWSAccept = client_send(new WSSend(JKY_PAY, unique, paymentRequest.rxtxData()));

        JKYPayResponse paymentResponse = new JKYPayResponse(paymentWSAccept.acceptObj(RXTXData.class));
        paymentResponse.analyse(key);
        System.out.printf("支付 响应内容：%s%n", paymentResponse.toJSON());

        if (ChannelStatus.交易成功.equals(ChannelStatus.status(paymentResponse.getCode()))) {
            order_refund = String.format("%s/%s/%s/%s",
                    balanceId, paymentResponse.getFid(),
                    paymentResponse.getOrderNo(),
                    DateUtils.getDate_YYYY_MM_DD_HH_MM_SS(paymentResponse.getExpire()));
            System.out.printf("支付 退款订单信息：%s%n", order_refund);
        }

        JKYPayQueryRequest paymentQueryRequest = new JKYPayQueryRequest();
        paymentQueryRequest.setLockId(loginResponse.getLockId());
        paymentQueryRequest.assemble(key);

        WSAccept paymentQueryWSAccept = client_send(new WSSend(JKY_PAY_QUERY, unique, paymentQueryRequest.rxtxData()));

        JKYPayResponse paymentQueryResponse = new JKYPayResponse(paymentQueryWSAccept.acceptObj(RXTXData.class));
        paymentQueryResponse.analyse(key);
        System.out.printf("支付查询 响应内容：%s%n", paymentQueryResponse.toJSON());

        // 重新登录
        wb_login(false, true, unique, key);

        return order_refund;
    }

    /**
     * @return
     * @description: 充值
     */
    private static String wb_recharge(Integer balanceId, String unique, String key) throws TechnologyException, ProfessionalException {
        String order_refund = null;

        JKYLoginResponse loginResponse = wb_login(false, false, unique, key);

        String meal = SystemtUtils.scanner("套餐编号: ");
        String cash = SystemtUtils.scanner("现金金额: ");
        String cloud = SystemtUtils.scanner("云支付金额: ");
        String payCode = SystemtUtils.scanner("云充值支付码: ");
        String give = SystemtUtils.scanner("赠送金额: ");

        JKYRechargeRequest rechargeRequest = new JKYRechargeRequest();
        rechargeRequest.setLockId(loginResponse.getLockId());
        rechargeRequest.setFid(45);
        if (StringUtils.isNotBlank(meal)) {
            rechargeRequest.setType(JKYRechargeType.套餐充值.getType());
            rechargeRequest.setMealOrder(Integer.parseInt(meal));
            rechargeRequest.setMealVersion(43);
        } else {
            rechargeRequest.setType(JKYRechargeType.自定义充值.getType());
        }

        if (StringUtils.isNotBlank(cash)) rechargeRequest.setCash(new BigDecimal(cash));
        if (StringUtils.isNotBlank(cloud)) rechargeRequest.setCloud(new BigDecimal(cloud));
        if (StringUtils.isNotBlank(give)) rechargeRequest.setGive(new BigDecimal(give));

        rechargeRequest.setPaycode(payCode);
        rechargeRequest.assemble(key);

        WSAccept rechargeWSAccept = client_send(new WSSend(JKY_RECHARGE, unique, rechargeRequest.rxtxData()));

        JKYRechargeResponse rechargeResponse = new JKYRechargeResponse(rechargeWSAccept.acceptObj(RXTXData.class));
        rechargeResponse.analyse(key);
        System.out.printf("充值 响应内容：%s%n", rechargeResponse.toJSON());

        if (ChannelStatus.交易成功.equals(ChannelStatus.status(rechargeResponse.getCode()))) {
            order_refund = String.format("%s/%s/%s/%s",
                    balanceId, rechargeRequest.getFid(),
                    rechargeResponse.getOrderNo(),
                    DateUtils.getDate_YYYY_MM_DD_HH_MM_SS(rechargeResponse.getExpire()));
            System.out.printf("充值 退款订单信息：%s%n", order_refund);
        }

        JKYRechargeQueryRequest rechargeQueryRequest = new JKYRechargeQueryRequest();
        rechargeQueryRequest.setLockId(loginResponse.getLockId());
        rechargeQueryRequest.assemble(key);

        WSAccept rechargeQueryWSAccept = client_send(new WSSend(JKY_RECHARGE_QUERY, unique, rechargeQueryRequest.rxtxData()));

        JKYRechargeResponse rechargeQueryResponse = new JKYRechargeResponse(rechargeQueryWSAccept.acceptObj(RXTXData.class));
        rechargeQueryResponse.analyse(key);
        System.out.printf("充值查询 响应内容：%s%n", rechargeQueryResponse.toJSON());

        // 重新登录
        wb_login(false, true, unique, key);
        return order_refund;
    }

    /**
     * @description: 注销账号
     **/
    private static void wb_cancel(String unique, String key) throws TechnologyException, ProfessionalException {
        JKYLoginResponse loginResponse = wb_login(false, false, unique, key);

        JKYCancelRequest cancelRequest = new JKYCancelRequest();
        cancelRequest.setLockId(loginResponse.getLockId());
        cancelRequest.setFid(43);
        cancelRequest.setProReset(1);
        cancelRequest.setRemark("用户注销");
        cancelRequest.assemble(key);

        WSAccept cancelWSAccept = client_send(new WSSend(JKY_Cancel, unique, cancelRequest.rxtxData()));

        JKYCancelResponse cancelResponse = new JKYCancelResponse(cancelWSAccept.acceptObj(RXTXData.class));
        cancelResponse.analyse(key);
        System.out.printf("注销账号 响应内容：%s%n", cancelResponse.toJSON());

        JKYCancelQueryRequest cancelQueryRequest = new JKYCancelQueryRequest();
        cancelQueryRequest.setLockId(loginResponse.getLockId());
        cancelQueryRequest.assemble(key);

        WSAccept cancelQueryWSAccept = client_send(new WSSend(JKY_Cancel_QUERY, unique, cancelQueryRequest.rxtxData()));

        JKYCancelResponse cancelQueryResponse = new JKYCancelResponse(cancelQueryWSAccept.acceptObj(RXTXData.class));
        cancelQueryResponse.analyse(key);
        System.out.printf("注销账号查询 响应内容：%s%n", cancelQueryResponse.toJSON());

        // 重新登录
        wb_login(false, true, unique, key);
    }

    /**
     * @description: 登录
     **/
    private static JKYLoginResponse wb_login(boolean query, boolean logout, String unique, String key) throws TechnologyException, ProfessionalException {
        JKYLoginRequest loginRequest = new JKYLoginRequest();

        String loginAccount = SystemtUtils.scanner("请输入登录方式 C.18082350542: ");
        if (StringUtils.isNotBlank(loginAccount) && loginAccount.contains(".")) {
            String[] split = loginAccount.toUpperCase().split("\\.");
            loginRequest.setType(split[0]);
            loginRequest.setText(split[1]);
        } else {
            loginRequest.setType("C");
            loginRequest.setText("18082350542");
        }

        loginRequest.assemble(key);

        WSAccept loginWSAccept = client_send(new WSSend(JKY_LOGIN, unique, loginRequest.rxtxData()));

        JKYLoginResponse loginResponse = new JKYLoginResponse(loginWSAccept.acceptObj(RXTXData.class));
        loginResponse.analyse(key);
        System.out.printf("登录 响应内容：%s%n", loginResponse.toJSON());

        if (query) {
            JKYLoginQueryRequest loginQueryRequest = new JKYLoginQueryRequest();
            loginQueryRequest.setLockId(loginResponse.getLockId());
            loginQueryRequest.assemble(key);

            WSAccept loginQueryWSAccept = client_send(new WSSend(JKY_LOGIN_QUERY, unique, loginQueryRequest.rxtxData()));

            JKYLoginResponse loginQueryResponse = new JKYLoginResponse(loginQueryWSAccept.acceptObj(RXTXData.class));
            loginQueryResponse.analyse(key);
            System.out.printf("登录查询 响应内容：%s%n", loginQueryResponse.toJSON());
        }

        if (logout) {
            JKYLogoutRequest logoutRequest = new JKYLogoutRequest();
            logoutRequest.setLockId(loginResponse.getLockId());
            logoutRequest.assemble(key);

            WSAccept logoutWSAccept = client_send(new WSSend(JKY_LOGOUT, unique, logoutRequest.rxtxData()));

            JKYLogoutResponse logoutResponse = new JKYLogoutResponse(logoutWSAccept.acceptObj(RXTXData.class));
            logoutResponse.analyse(key);
            System.out.printf("登出 响应内容：%s%n", logoutResponse.toJSON());
        }
        return loginResponse;
    }

    /**
     * @description: 接受信息
     **/
    private static final String URL = "ws://192.168.101.120:33574?key=%s";
    private static WebSocketClient client = null;
    private static WSSend send = null;
    private static WSAccept accept = null;

    /**
     * @description: 同步发送数据
     **/
    private static WSAccept client_send(WSSend wss) throws TechnologyException {
        System.out.printf(">>>WebSocket onSend: %s%n", wss.toJSON());

        send = null;
        accept = null;

        send = wss.toObject(WSSend.class);
        client.send(wss.toJSON());

        int count = 0;
        WSAccept wsa = null;
        while (count < 100) {
            if (accept != null) {
                wsa = accept.toObject(WSAccept.class);
                send = null;
                accept = null;
                break;
            } else {
                SystemtUtils.millis_sleep(100);
                count++;
            }
        }
        if (wsa == null) throw new TechnologyException(GeneralInternational.网络接口获取失败);
        return wsa;
    }

    /**
     * @description: WebSocket 构建
     **/
    public static void web_socket_build(String unique) {
        final boolean[] status = {false};
        try {
            client = new WebSocketClient(new URI(String.format(URL, unique))) {
                @Override
                public void onOpen(ServerHandshake serverHandshake) {
                    System.out.println(">>>WebSocket onOpen");
                    status[0] = true;
                }

                @Override
                public void onMessage(String text) {
                    System.out.printf(">>>WebSocket onMessage: %s%n", text);
                    if (send != null) {
                        WSAccept wsa = JSONUtils.jsonToObject(text, WSAccept.class);
                        if (wsa != null && wsa.getCode().equals(2000)) {
                            accept = wsa;
                        }
                    }
                }

                @Override
                public void onClose(int i, String s, boolean b) {
                    System.out.printf(">>>WebSocket onClose: [%s] - [%s] - [%s]%n", i, s, b);
                }

                @Override
                public void onError(Exception e) {
                    System.err.printf(">>>WebSocket onError: %s%n", e.getMessage());
                }
            };
            client.connect();
        } catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }

        int count = 0;
        while (count < 5) {
            if (status[0]) break;
            SystemtUtils.millis_sleep(300);
            count++;
        }
    }

    /**
     * @description: 吉卡云支付
     **/
    private static void jkyProgram() {
        // 获取套餐信息辅助
        // userLikeQuery();
        // settingList();
        // rechargeSetMeal();
        // integralSetMeal();

        // 实体卡操作
        // entityCard();

        // 吉卡云操作
        // jkyLogin();
        // cancel();
        // recharge();
        // payment();
        // integral();
        // refund();
    }

    /**
     * @description: 支付
     **/
    private static void payment() throws ProfessionalException {
        JKYLoginResponse loginResponse = login();
        String store = SystemtUtils.scanner("储值金额: ");
        String cash = SystemtUtils.scanner("现金金额: ");
        String cloud = SystemtUtils.scanner("云支付金额: ");
        String payCode = SystemtUtils.scanner("云支付支付码: ");

        JKYPayRequest payRequest = new JKYPayRequest();
        payRequest.setLockId(loginResponse.getLockId());
        payRequest.setFid(45);
        if (StringUtils.isNotBlank(store)) {
            payRequest.setStored(new BigDecimal(store));
        }

        if (StringUtils.isNotBlank(cash)) {
            payRequest.setCash(new BigDecimal(cash));
        }

        if (StringUtils.isNotBlank(cloud) && StringUtils.isNotBlank(payCode)) {
            payRequest.setCloud(new BigDecimal(cloud));
            payRequest.setPaycode(payCode);
        }

        payRequest.setTitle("草莓");
        payRequest.setCount(2);
        payRequest.assemble(MASTER_AES_KEY);
        RXTXData paymentSend = payRequest.rxtxData();
        System.out.printf("支付 请求内容：%s%n", paymentSend.toJSON());

        String paymentContent = SystemtUtils.scanner("支付 响应Content: ");

        RXTXData paymentAccept = new RXTXData(payRequest.getNid(), paymentContent);
        JKYPayResponse paymentResponse = new JKYPayResponse(paymentAccept);
        paymentResponse.analyse(MASTER_AES_KEY);
        System.out.printf("支付 响应内容：%s%n", paymentResponse.toJSON());

        JKYPayQueryRequest paymentQueryRequest = new JKYPayQueryRequest();
        paymentQueryRequest.setLockId(loginResponse.getLockId());
        paymentQueryRequest.assemble(MASTER_AES_KEY);
        RXTXData paymentQuerySend = paymentQueryRequest.rxtxData();
        System.out.printf("支付查询 请求内容：%s%n", paymentQuerySend.toJSON());
        String paymentQueryContent = SystemtUtils.scanner("支付查询 响应Content: ");

        RXTXData paymentQueryAccept = new RXTXData(paymentQueryRequest.getNid(), paymentQueryContent);
        JKYPayResponse paymentQueryResponse = new JKYPayResponse(paymentQueryAccept);
        paymentQueryResponse.analyse(MASTER_AES_KEY);
        System.out.printf("支付查询 响应内容：%s%n", paymentQueryResponse.toJSON());
    }

    /**
     * @description: 充值
     **/
    private static void recharge() throws ProfessionalException {
        JKYLoginResponse loginResponse = login();

        String meal = SystemtUtils.scanner("套餐编号: ");
        String cash = SystemtUtils.scanner("现金金额: ");
        String cloud = SystemtUtils.scanner("云支付金额: ");
        String payCode = SystemtUtils.scanner("云充值支付码: ");

        JKYRechargeRequest rechargeRequest = new JKYRechargeRequest();
        rechargeRequest.setLockId(loginResponse.getLockId());
        rechargeRequest.setFid(45);
        if (StringUtils.isNotBlank(meal)) {
            rechargeRequest.setType(JKYRechargeType.套餐充值.getType());
            rechargeRequest.setMealOrder(Integer.parseInt(meal));
            rechargeRequest.setMealVersion(43);
        } else {
            rechargeRequest.setType(JKYRechargeType.自定义充值.getType());
        }

        if (StringUtils.isNotBlank(cash)) {
            rechargeRequest.setCash(new BigDecimal(cash));
        }
        if (StringUtils.isNotBlank(cloud)) {
            rechargeRequest.setCloud(new BigDecimal(cloud));
        }

        rechargeRequest.setPaycode(payCode);
        rechargeRequest.assemble(MASTER_AES_KEY);
        RXTXData rechargeSend = rechargeRequest.rxtxData();
        System.out.printf("充值 请求内容：%s%n", rechargeSend.toJSON());

        String rechargeContent = SystemtUtils.scanner("充值 响应Content: ");

        RXTXData rechargeAccept = new RXTXData(rechargeRequest.getNid(), rechargeContent);
        JKYRechargeResponse rechargeResponse = new JKYRechargeResponse(rechargeAccept);
        rechargeResponse.analyse(MASTER_AES_KEY);
        System.out.printf("充值 响应内容：%s%n", rechargeResponse.toJSON());

        JKYRechargeQueryRequest rechargeQueryRequest = new JKYRechargeQueryRequest();
        rechargeQueryRequest.setLockId(loginResponse.getLockId());
        rechargeQueryRequest.assemble(MASTER_AES_KEY);
        RXTXData rechargeQuerySend = rechargeQueryRequest.rxtxData();
        System.out.printf("充值查询 请求内容：%s%n", rechargeQuerySend.toJSON());

        String rechargeQueryContent = SystemtUtils.scanner("充值查询 响应Content: ");

        RXTXData rechargeQueryAccept = new RXTXData(rechargeQueryRequest.getNid(), rechargeQueryContent);
        JKYRechargeResponse rechargeQueryResponse = new JKYRechargeResponse(rechargeQueryAccept);
        rechargeQueryResponse.analyse(MASTER_AES_KEY);
        System.out.printf("充值查询 响应内容：%s%n", rechargeQueryResponse.toJSON());
    }

    /**
     * @description: 积分兑换
     **/
    private static void integral() throws ProfessionalException {
        JKYLoginResponse loginResponse = login();

        String meal = SystemtUtils.scanner("套餐编号: ");
        String count = SystemtUtils.scanner("使用次数: ");
        String integral = SystemtUtils.scanner("使用积分: ");

        JKYIntegralRequest integralRequest = new JKYIntegralRequest();
        integralRequest.setLockId(loginResponse.getLockId());
        integralRequest.setFid(45);
        if (StringUtils.isNotBlank(meal)) {
            integralRequest.setType(IntegralType.套餐兑换.getType());
            integralRequest.setMealVersion(8);
            integralRequest.setMealOrder(Integer.parseInt(meal));
            if (StringUtils.isNotBlank(count)) integralRequest.setCount(Integer.parseInt(count));
        } else {
            integralRequest.setType(IntegralType.自定义兑换.getType());
        }

        if (StringUtils.isNotBlank(integral))
            integralRequest.setIntegral(new BigDecimal(integral));
        integralRequest.setRemark("积分兑换");
        integralRequest.assemble(MASTER_AES_KEY);
        RXTXData integralSend = integralRequest.rxtxData();
        System.out.printf("积分兑换 请求内容：%s%n", integralSend.toJSON());
        String integralContent = SystemtUtils.scanner("积分兑换 响应Content: ");
        RXTXData integralAccept = new RXTXData(integralRequest.getNid(), integralContent);
        JKYIntegralResponse integralResponse = new JKYIntegralResponse(integralAccept);
        integralResponse.analyse(MASTER_AES_KEY);
        System.out.printf("积分兑换 响应内容：%s%n", integralResponse.toJSON());

        JKYIntegralQueryRequest integralQueryRequest = new JKYIntegralQueryRequest();
        integralQueryRequest.setLockId(loginResponse.getLockId());
        integralQueryRequest.assemble(MASTER_AES_KEY);
        RXTXData integralQuerySend = integralQueryRequest.rxtxData();
        System.out.printf("积分兑换查询 请求内容：%s%n", integralQuerySend.toJSON());

        String integralQueryContent = SystemtUtils.scanner("积分兑换查询 响应Content: ");
        RXTXData integralQueryAccept = new RXTXData(integralQueryRequest.getNid(), integralQueryContent);
        JKYIntegralResponse integralQueryResponse = new JKYIntegralResponse(integralQueryAccept);
        integralQueryResponse.analyse(MASTER_AES_KEY);
        System.out.printf("积分兑换查询 响应内容：%s%n", integralQueryResponse.toJSON());
    }

    /**
     * @description: 退款操作
     **/
    private static void refund() throws ProfessionalException {
        JKYRefundRequest refundRequest = new JKYRefundRequest();

        String refund_order = SystemtUtils.scanner("退款订单信息: ");

        if (StringUtils.isBlank(refund_order)) {
            JKYLoginResponse loginResponse = login();
            refundRequest.setLockId(loginResponse.getLockId());

            String store = SystemtUtils.scanner("储值金额: ");
            String cash = SystemtUtils.scanner("现金金额: ");
            String integral = SystemtUtils.scanner("积分: ");

            if (StringUtils.isNotBlank(store)) refundRequest.setStored(new BigDecimal(store));
            if (StringUtils.isNotBlank(cash)) refundRequest.setCash(new BigDecimal(cash));
            if (StringUtils.isNotBlank(integral)) refundRequest.setIntegral(new BigDecimal(integral));

        } else {
            String[] refund_order_arr = refund_order.split(" ");
            refundRequest.setOriginalOrderFid(Integer.parseInt(refund_order_arr[0]));
            refundRequest.setOriginalOrderNo(refund_order_arr[1]);
            refundRequest.setOriginalOrderTime(DateUtils.timeStrFormat(refund_order_arr[2]));
            refundRequest.setAutoLog(1);
        }

        refundRequest.setFid(48);
        refundRequest.setSid(3);
        refundRequest.setScaleMan(0);

        refundRequest.setRemark(Reason.客户主动退款.getDescription());

        refundRequest.assemble(MASTER_AES_KEY);
        RXTXData refundSend = refundRequest.rxtxData();
        System.out.printf("退款发送内容：%s%n", refundSend.toJSON());

        String refundContent = SystemtUtils.scanner("刷退款响应Content: ");

        RXTXData refundAccept = new RXTXData(refundRequest.getNid(), refundContent);

        JKYRefundResponse refundResponse = new JKYRefundResponse(refundAccept);
        refundResponse.analyse(MASTER_AES_KEY);
        System.out.printf("退款响应内容：%s%n", refundResponse.toJSON());

        JKYRefundQueryRequest refundQueryRequest = new JKYRefundQueryRequest();
        refundQueryRequest.setLockId(refundResponse.getLockId());
        refundQueryRequest.assemble(MASTER_AES_KEY);
        RXTXData refundQuerySend = refundQueryRequest.rxtxData();
        System.out.printf("退款查询发送内容：%s%n", refundQuerySend.toJSON());

        String refundQueryContent = SystemtUtils.scanner("支付查询响应Content: ");

        RXTXData refundQueryAccept = new RXTXData(refundQueryRequest.getNid(), refundQueryContent);

        JKYRefundResponse refundQueryResponse = new JKYRefundResponse(refundQueryAccept);
        refundQueryResponse.analyse(MASTER_AES_KEY);
        System.out.printf("退款查询响应内容：%s%n", refundQueryResponse.toJSON());
    }

    /**
     * @description: 注销卡
     **/
    private static void cancel() throws ProfessionalException {
        JKYLoginResponse loginResponse = login();

        JKYCancelRequest cancelRequest = new JKYCancelRequest();
        cancelRequest.setLockId(loginResponse.getLockId());
        cancelRequest.setFid(43);
        cancelRequest.setRemark("用户注销");
        cancelRequest.assemble(MASTER_AES_KEY);
        RXTXData cancelSend = cancelRequest.rxtxData();
        System.out.printf("注销账号 请求内容：%s%n", cancelSend.toJSON());
        String cancelContent = SystemtUtils.scanner("注销账号 响应Content: ");
        RXTXData cancelAccept = new RXTXData(cancelRequest.getNid(), cancelContent);
        JKYCancelResponse cancelResponse = new JKYCancelResponse(cancelAccept);
        cancelResponse.analyse(MASTER_AES_KEY);
        System.out.printf("注销账号 响应内容：%s%n", cancelResponse.toJSON());

        JKYCancelQueryRequest cancelQueryRequest = new JKYCancelQueryRequest();
        cancelQueryRequest.setLockId(loginResponse.getLockId());
        cancelQueryRequest.assemble(MASTER_AES_KEY);
        RXTXData cancelQuerySend = cancelQueryRequest.rxtxData();
        System.out.printf("注销账号查询 请求内容：%s%n", cancelQuerySend.toJSON());
        String cancelQueryContent = SystemtUtils.scanner("注销账号查询 响应Content: ");
        RXTXData cancelQueryAccept = new RXTXData(cancelQueryRequest.getNid(), cancelQueryContent);
        JKYCancelResponse cancelQueryResponse = new JKYCancelResponse(cancelQueryAccept);
        cancelQueryResponse.analyse(MASTER_AES_KEY);
        System.out.printf("注销账号查询 响应内容：%s%n", cancelQueryResponse.toJSON());
    }

    /**
     * @description: 登录获取锁定id
     */
    private static JKYLoginResponse login() throws ProfessionalException {
        JKYLoginRequest loginRequest = new JKYLoginRequest();

        String loginAccount = SystemtUtils.scanner("请输入登录方式 C.18082350542: ");

        if (StringUtils.isNotBlank(loginAccount) && loginAccount.contains(".")) {
            String[] split = loginAccount.toUpperCase().split("\\.");
            loginRequest.setType(split[0]);
            loginRequest.setText(split[1]);
        } else {
            loginRequest.setType("C");
            loginRequest.setText("18082350542");
        }

        System.out.printf("登录账号内容信息：%s%n", loginRequest.toJSON());

        loginRequest.assemble(MASTER_AES_KEY);
        RXTXData loginSend = loginRequest.rxtxData();
        System.out.printf("登录 请求内容：%s%n", loginSend.toJSON());
        String loginContent = SystemtUtils.scanner("登录 响应Content: ");
        RXTXData loginAccept = new RXTXData(loginRequest.getNid(), loginContent);
        JKYLoginResponse loginResponse = new JKYLoginResponse(loginAccept);
        loginResponse.analyse(MASTER_AES_KEY);
        System.out.printf("登录 响应内容：%s%n", loginResponse);
        return loginResponse;
    }

    /**
     * @description: 实体卡
     **/
    private static void entityCard() throws ProfessionalException {
        JKYCardIssuedRequest cardIssuedRequest = new JKYCardIssuedRequest();
        cardIssuedRequest.setInternalCode("0123456789ABCDEF0123456789ABCDEF");
        cardIssuedRequest.setNickName("实体卡WebSocket测试");
        cardIssuedRequest.assemble(MASTER_AES_KEY);
        RXTXData cardIssuedSend = cardIssuedRequest.rxtxData();
        System.out.printf("实体制卡 请求内容：%s%n", cardIssuedSend.toJSON());
        String cardIssuedContent = SystemtUtils.scanner("实体制卡 响应Content: ");

        cardIssuedContent = StringUtils.isNotBlank(cardIssuedContent) ? cardIssuedContent :
                "028120006044BA21DF08341DB2805E8C32D3F6D7B503367A643C80F9534C28F3570BBAF698395EFB071B3079A7F997A6A0F516190DB2E28CD244C43A84B89C92EF3035A3BE99782E37B7AC691780723CC795B138D5A20AA237F44FC0075C8ABD4FB78E6D92EF03";

        RXTXData cardIssuedAccept = new RXTXData(cardIssuedRequest.getNid(), cardIssuedContent);
        JKYCardIssuedResponse cardIssuedResponse = new JKYCardIssuedResponse(cardIssuedAccept);
        cardIssuedResponse.analyse(MASTER_AES_KEY);
        System.out.printf("实体制卡 响应内容：%s%n", cardIssuedResponse.toJSON());

        JKYCardBindAccountCheckRequest cardBindAccountCheckRequest = new JKYCardBindAccountCheckRequest();
        cardBindAccountCheckRequest.setInnerId(cardIssuedResponse.getInnerId());
        cardBindAccountCheckRequest.setOuterId(cardIssuedResponse.getOuterId());
        cardBindAccountCheckRequest.assemble(MASTER_AES_KEY);
        RXTXData cardBindAccountCheckSend = cardBindAccountCheckRequest.rxtxData();
        System.out.printf("实体卡绑定检查 请求内容：%s%n", cardBindAccountCheckSend.toJSON());
        String cardBindAccountCheckContent = SystemtUtils.scanner("实体卡绑定检查 响应Content: ");

        cardBindAccountCheckContent = StringUtils.isNotBlank(cardBindAccountCheckContent) ? cardBindAccountCheckContent :
                "028102007012744A27D8909C77032DAF1150A16D82A0045E31B2BCCF992893E2EE10888C761991C736BA7B4E8CA275BBB082C0418FA5A379583A62859F929947C737379FA295E8F9CC6BEB1BDE00ACB8AF9E4470D0CA1572D1784EC9A60E91893730A37EE523818C26B375DA34D65D7E27EA67263D3803";

        RXTXData cardBindAccountCheckAccept = new RXTXData(cardBindAccountCheckRequest.getNid(), cardBindAccountCheckContent);
        JKYCardBindAccountCheckResponse cardBindAccountCheckResponse = new JKYCardBindAccountCheckResponse(cardBindAccountCheckAccept);
        cardBindAccountCheckResponse.analyse(MASTER_AES_KEY);
        System.out.printf("实体卡绑定检查 响应内容：%s%n", cardBindAccountCheckResponse.toJSON());

        JKYCardBindAccountRequest cardBindAccountRequest = new JKYCardBindAccountRequest();
        cardBindAccountRequest.setInnerId(cardIssuedResponse.getInnerId());
        cardBindAccountRequest.setOuterId(cardIssuedResponse.getOuterId());
        cardBindAccountRequest.setAccount("18082350542");
        cardBindAccountRequest.assemble(MASTER_AES_KEY);
        RXTXData cardBindAccountSend = cardBindAccountRequest.rxtxData();
        System.out.printf("实体卡绑定 请求内容：%s%n", cardBindAccountSend.toJSON());
        String cardBindAccountContent = SystemtUtils.scanner("实体卡绑定 响应Content: ");
        RXTXData cardBindAccountAccept = new RXTXData(cardBindAccountRequest.getNid(), cardBindAccountContent);
        JKYCardBindAccountResponse cardBindAccountResponse = new JKYCardBindAccountResponse(cardBindAccountAccept);
        cardBindAccountResponse.analyse(MASTER_AES_KEY);
        System.out.printf("实体卡绑定 响应内容：%s%n", cardBindAccountResponse.toJSON());

    }

    private static void userLikeQuery() throws ProfessionalException {
        JKYUserQueryRequest userQueryRequest = new JKYUserQueryRequest();
        userQueryRequest.setText("1808");
        userQueryRequest.assemble(MASTER_AES_KEY);
        RXTXData userQuerySend = userQueryRequest.rxtxData();
        System.out.printf("用户查询 请求内容：%s%n", userQuerySend.toJSON());
        String userQueryContent = SystemtUtils.scanner("用户查询 响应Content: ");
        RXTXData userQueryAccept = new RXTXData(userQueryRequest.getNid(), userQueryContent);
        JKYUserQueryResponse userQueryResponse = new JKYUserQueryResponse(userQueryAccept);
        userQueryResponse.analyse(MASTER_AES_KEY);
        System.out.printf("用户查询 响应内容：%s%n", userQueryResponse.toJSON());
    }

    private static void settingList() throws ProfessionalException {
        String settingListContent = SystemtUtils.scanner("属性设置 响应Content: ");
        RXTXData settingListAccept = new RXTXData(455, settingListContent);
        JKYSettingListResponse settingListResponse = new JKYSettingListResponse(settingListAccept);
        settingListResponse.analyse(MASTER_AES_KEY);
        System.out.printf("属性设置 响应内容：%s%n", settingListResponse.toJSON());
    }

    private static void rechargeSetMeal() throws ProfessionalException {
        String rechargeSetMealContent = SystemtUtils.scanner("充值套餐 响应Content: ");
        RXTXData rechargeSetMealAccept = new RXTXData(455, rechargeSetMealContent);
        JKYRechargeSetMealResponse rechargeSetMealResponse = new JKYRechargeSetMealResponse(rechargeSetMealAccept);
        rechargeSetMealResponse.analyse(MASTER_AES_KEY);
        System.out.printf("充值套餐 响应内容：%s%n", rechargeSetMealResponse.toJSON());
    }

    private static void integralSetMeal() throws ProfessionalException {
        String integralSetMealContent = SystemtUtils.scanner("积分套餐 响应Content: ");
        RXTXData integralSetMealAccept = new RXTXData(455, integralSetMealContent);
        JKYIntegralSetMealResponse integralSetMealResponse = new JKYIntegralSetMealResponse(integralSetMealAccept);
        integralSetMealResponse.analyse(MASTER_AES_KEY);
        System.out.printf("积分套餐 响应内容：%s%n", integralSetMealResponse.toJSON());
    }

    private static void jkyLogin() throws ProfessionalException {
        // 登录
        JKYLoginResponse loginResponse = login();

        int queryCount = 0;
        String lockId = loginResponse.getLockId();
        while (queryCount < 3 && StringUtils.isNotBlank(lockId)) {
            JKYLoginQueryRequest loginQueryRequest = new JKYLoginQueryRequest();
            loginQueryRequest.setLockId(lockId);
            loginQueryRequest.assemble(MASTER_AES_KEY);
            RXTXData loginQuerySend = loginQueryRequest.rxtxData();
            System.out.printf("登录查询内容：%s%n", loginQuerySend.toJSON());

            String loginQueryContent = SystemtUtils.scanner("登录查询响应Content: ");
            RXTXData loginQueryAccept = new RXTXData(loginQueryRequest.getNid(), loginQueryContent);

            JKYLoginResponse loginQueryResponse = new JKYLoginResponse(loginQueryAccept);
            loginQueryResponse.analyse(MASTER_AES_KEY);
            System.out.printf("登录查询响应内容：%s%n", loginQueryResponse.toJSON());

            queryCount++;
            lockId = SystemtUtils.scanner("请输入查询ID: ");
            if ("123".equals(lockId)) {
                break;
            }
        }

        JKYLogoutRequest logoutRequest = new JKYLogoutRequest();
        logoutRequest.setLockId(loginResponse.getLockId());
        logoutRequest.assemble(MASTER_AES_KEY);
        RXTXData loginQuerySend = logoutRequest.rxtxData();
        System.out.printf("登出内容：%s%n", loginQuerySend.toJSON());
        String logoutContent = SystemtUtils.scanner("登出响应Content: ");
        RXTXData logoutAccept = new RXTXData(logoutRequest.getNid(), logoutContent);

        JKYLogoutResponse logoutResponse = new JKYLogoutResponse(logoutAccept);
        logoutResponse.analyse(MASTER_AES_KEY);
        System.out.printf("登出响应内容：%s%n", logoutResponse.toJSON());
    }

    /**
     * @description: 云支付进程
     **/
    private static void cloudProgram() {
        // 云支付预创建完成支付 测试改动
        // cloudPayProgram();
        // cloudPayRemoveProgram();
        // cloudPayScanProgram();

        // 云支付退款操作
        // refundProgram();
    }

    private static void refundProgram() throws ProfessionalException {
        RefundRequest refundRequest = new RefundRequest();
        refundRequest.setOrderFid(28265);
        refundRequest.setOrderNo("JHERA07009545859686183511");
        refundRequest.setOrderTime(new Date());
        refundRequest.setFid(48);
        refundRequest.setSid(3);
        refundRequest.setScaleMan(0);
        refundRequest.setAmount(BigDecimal.valueOf(0.01));
        refundRequest.setRemark("支付完成退款");
        refundRequest.assemble(MASTER_AES_KEY);
        RXTXData send1 = refundRequest.rxtxData();
        System.out.printf("退款发送内容：%s%n", send1.toJSON());

        String content1 = SystemtUtils.scanner("刷退款响应Content: ");

        RXTXData accept1 = new RXTXData(refundRequest.getNid(), content1);

        RefundResponse refundResponse = new RefundResponse(accept1);
        refundResponse.analyse(MASTER_AES_KEY);
        System.out.printf("退款响应内容：%s%n", refundResponse.toJSON());

        String query_type = SystemtUtils.scanner("查询方式: ");

        RefundQueryRequest refundQueryRequest = new RefundQueryRequest();
        refundQueryRequest.setQuery(Integer.parseInt(query_type));
        refundQueryRequest.setFid(refundResponse.getFid());
        refundQueryRequest.setRefundno(refundResponse.getRefundno());
        refundQueryRequest.setRetrunno(refundResponse.getRetrunno());
        refundQueryRequest.assemble(MASTER_AES_KEY);
        RXTXData send3 = refundQueryRequest.rxtxData();
        System.out.printf("退款查询发送内容：%s%n", send3.toJSON());

        String content3 = SystemtUtils.scanner("支付查询响应Content: ");

        RXTXData accept3 = new RXTXData(refundQueryRequest.getNid(), content3);

        RefundResponse paymentQueryResponse = new RefundResponse(accept3);
        paymentQueryResponse.analyse(MASTER_AES_KEY);
        System.out.printf("退款查询响应内容：%s%n", paymentQueryResponse.toJSON());
    }

    private static void refreshCache() throws ProfessionalException {
        RefreshRequest refreshRequest = new RefreshRequest();
        refreshRequest.setUnique(MASTER_UNIQUE);
        refreshRequest.assemble(MASTER_AES_KEY);
        RXTXData send1 = refreshRequest.rxtxData();
        System.out.printf("主扫发送内容：%s%n", send1.toJSON());

        String content1 = SystemtUtils.scanner("刷新响应Content: ");

        RXTXData accept1 = new RXTXData(refreshRequest.getNid(), content1);

        RefreshResponse refreshResponse = new RefreshResponse(accept1);
        refreshResponse.analyse(MASTER_AES_KEY);
        System.out.printf("主扫响应内容：%s%n", refreshResponse.toJSON());
    }

    private static void cloudPayScanProgram() throws ProfessionalException {
        String paycode = SystemtUtils.scanner("支付码：");

        ScanPaymentRequest scanPaymentRequest = new ScanPaymentRequest();
        scanPaymentRequest.setFid(RandomUtils.integer_random(65535));
        scanPaymentRequest.setAmount(BigDecimal.valueOf(0.01));
        scanPaymentRequest.setTitle("测试商品");
        scanPaymentRequest.setCount(1);
        scanPaymentRequest.setRetryCount(0);
        scanPaymentRequest.setAuth(paycode);
        scanPaymentRequest.assemble(MASTER_AES_KEY);
        RXTXData send1 = scanPaymentRequest.rxtxData();
        System.out.printf("主扫发送内容：%s%n", send1.toJSON());

        String content1 = SystemtUtils.scanner("主扫响应Content: ");

        RXTXData accept1 = new RXTXData(scanPaymentRequest.getNid(), content1);

        ResultPaymentResponse paymentResponse = new ResultPaymentResponse(accept1);
        paymentResponse.analyse(MASTER_AES_KEY);
        System.out.printf("主扫响应内容：%s%n", paymentResponse.toJSON());
    }

    private static void cloudPayRemoveProgram() throws ProfessionalException {
        PaymentRequest paymentRequest = new PaymentRequest();
        paymentRequest.setFid(RandomUtils.integer_random(65535));
        paymentRequest.setAmount(BigDecimal.valueOf(0.01));
        paymentRequest.setTitle("测试商品");
        paymentRequest.setCount(1);
        paymentRequest.assemble(MASTER_AES_KEY);
        RXTXData send1 = paymentRequest.rxtxData();
        System.out.printf("预创建发送内容：%s%n", send1.toJSON());

        String content1 = SystemtUtils.scanner("预创建响应Content: ");

        RXTXData accept1 = new RXTXData(paymentRequest.getNid(), content1);

        PretreatmentPaymentResponse pretreatmentPaymentResponse = new PretreatmentPaymentResponse(accept1);
        pretreatmentPaymentResponse.analyse(MASTER_AES_KEY);
        System.out.printf("预创建响应内容：%s%n", pretreatmentPaymentResponse.toJSON());

        EndPaymentRequest endPaymentRequest = new EndPaymentRequest();
        endPaymentRequest.setEnd(ENDState.Remove_Order.getState());
        endPaymentRequest.setFid(paymentRequest.getFid());
        endPaymentRequest.setOrderno(pretreatmentPaymentResponse.getOrderno());
        endPaymentRequest.assemble(MASTER_AES_KEY);
        RXTXData send2 = endPaymentRequest.rxtxData();
        System.out.printf("取消支付发送内容：%s%n", send2.toJSON());

        String content2 = SystemtUtils.scanner("取消支付响应Content: ");

        RXTXData accept2 = new RXTXData(endPaymentRequest.getNid(), content2);

        ResultPaymentResponse paymentResponse = new ResultPaymentResponse(accept2);
        paymentResponse.analyse(MASTER_AES_KEY);
        System.out.printf("支付取消响应内容：%s%n", paymentResponse.toJSON());
    }

    private static void cloudPayProgram() throws ProfessionalException {
        PaymentRequest paymentRequest = new PaymentRequest();
        paymentRequest.setFid(RandomUtils.integer_random(65535));
        paymentRequest.setAmount(BigDecimal.valueOf(0.01));
        paymentRequest.setTitle("测试商品");
        paymentRequest.setCount(1);
        paymentRequest.assemble(MASTER_AES_KEY);
        RXTXData send1 = paymentRequest.rxtxData();
        System.out.printf("预创建发送内容：%s%n", send1.toJSON());

        String content1 = SystemtUtils.scanner("预创建响应Content: ");

        RXTXData accept1 = new RXTXData(paymentRequest.getNid(), content1);

        PretreatmentPaymentResponse pretreatmentPaymentResponse = new PretreatmentPaymentResponse(accept1);
        pretreatmentPaymentResponse.analyse(MASTER_AES_KEY);
        System.out.printf("预创建响应内容：%s%n", pretreatmentPaymentResponse.toJSON());


        String paycode = SystemtUtils.scanner("支付码：");

        PretreatmentPaymentRequest pretreatmentPaymentRequest = new PretreatmentPaymentRequest();
        pretreatmentPaymentRequest.setFid(pretreatmentPaymentResponse.getFid());
        pretreatmentPaymentRequest.setOrderno(pretreatmentPaymentResponse.getOrderno());
        pretreatmentPaymentRequest.setAuth(paycode);
        pretreatmentPaymentRequest.assemble(MASTER_AES_KEY);
        RXTXData send2 = pretreatmentPaymentRequest.rxtxData();
        System.out.printf("扫码支付发送内容：%s%n", send2.toJSON());

        String content2 = SystemtUtils.scanner("扫码支付响应Content: ");

        RXTXData accept2 = new RXTXData(pretreatmentPaymentRequest.getNid(), content2);

        ResultPaymentResponse paymentResponse = new ResultPaymentResponse(accept2);
        paymentResponse.analyse(MASTER_AES_KEY);
        System.out.printf("扫码支付响应内容：%s%n", paymentResponse.toJSON());

        String query_type = SystemtUtils.scanner("查询方式: ");

        PaymentQueryRequest paymentQueryRequest = new PaymentQueryRequest();
        paymentQueryRequest.setQuery(Integer.parseInt(query_type));
        paymentQueryRequest.setFid(paymentRequest.getFid());
        paymentQueryRequest.setOrderno(paymentResponse.getOrderno());
        paymentQueryRequest.setTradeno(paymentResponse.getTradeno());
        paymentQueryRequest.assemble(MASTER_AES_KEY);
        RXTXData send3 = paymentQueryRequest.rxtxData();
        System.out.printf("支付查询发送内容：%s%n", send3.toJSON());

        String content3 = SystemtUtils.scanner("支付查询响应Content: ");

        RXTXData accept3 = new RXTXData(paymentQueryRequest.getNid(), content3);

        ResultPaymentResponse paymentQueryResponse = new ResultPaymentResponse(accept3);
        paymentQueryResponse.analyse(MASTER_AES_KEY);
        System.out.printf("支付查询响应内容：%s%n", paymentQueryResponse.toJSON());
    }

    /**
     * @description: 基础指令
     **/
    private static void entity_test() throws ProfessionalException {
        // 内容头信息
        // Mark();

        // 预创建请求
        // PretreatmentPaymentStartRequest();
        // PretreatmentPaymentFinishRequest();

        // 支付响应
        // PaymentResponse();

        // 预创建响应
        // PretreatmentPaymentResponse();

        // 主扫
        // ScanPayment();

        // 支付查询
        // QueryPayment();

        // 结束支付
        // EndPayment();

        // 会员登录
        // JKYLoginRequest();
        // JKYLoginResponse();

        // 会员支付
        // JKYPaymentRequest();
        // JKYPaymentResponse();
        JKYPaymentResponse1();
        // JKYRechargeRequest();
        // JKYRechargeResponse();
        // JKYRefundRequest();
        // JKYRefundResponse();
        // JKYIntegralRequest();
        // JKYIntegralResponse();
    }

    private static void JKYIntegralResponse() throws ProfessionalException {
        JKYIntegralResponse tx_before = new JKYIntegralResponse();
        tx_before.setLockId("1234567890");
        tx_before.setFid(67);
        tx_before.setCode(23);
        tx_before.setOrderNo("AA4324523143");
        tx_before.setTradeType(JKYTradeType.积分兑换.getType());
        tx_before.setIntegral(BigDecimal.valueOf(56));
        tx_before.setBeforeIntegral(BigDecimal.valueOf(100));
        tx_before.setAfterIntegral(BigDecimal.valueOf(44));
        tx_before.setDescription("111234");
        tx_before.assemble(MASTER_AES_KEY);
        System.out.println(tx_before.toJSON());
        RXTXData rxtxData = tx_before.rxtxData();
        System.out.println(rxtxData.toJSON());

        JKYIntegralResponse tx_after = new JKYIntegralResponse(rxtxData);
        tx_after.analyse(MASTER_AES_KEY);
        System.out.println(tx_after.toJSON());
    }

    private static void JKYIntegralRequest() throws ProfessionalException {
        JKYIntegralRequest tx_before = new JKYIntegralRequest();
        tx_before.setLockId("xx1234567890");
        tx_before.setFid(45);
        tx_before.setIntegral(BigDecimal.valueOf(200));
        tx_before.assemble(MASTER_AES_KEY);
        System.out.println(tx_before.toJSON());
        RXTXData rxtxData = tx_before.rxtxData();
        System.out.println(rxtxData.toJSON());

        JKYIntegralRequest tx_after = new JKYIntegralRequest(rxtxData);
        tx_after.analyse(MASTER_AES_KEY);
        System.out.println(tx_after.toJSON());
    }

    private static void JKYRefundResponse() throws ProfessionalException {
        JKYRefundResponse tx_before = new JKYRefundResponse();
        tx_before.setLockId("1234567890");
        tx_before.setFid(67);
        tx_before.setCode(23);
        tx_before.setRefundNo("4324523143");
        tx_before.setTradeType(JKYTradeType.会员退款.getType());
        tx_before.setStored(BigDecimal.valueOf(-56));
        tx_before.setOther(BigDecimal.valueOf(-88));
        tx_before.setActual(BigDecimal.valueOf(-11));
        tx_before.setBalance(BigDecimal.valueOf(-15));
        tx_before.assemble(MASTER_AES_KEY);
        System.out.println(tx_before.toJSON());
        RXTXData rxtxData = tx_before.rxtxData();
        System.out.println(rxtxData.toJSON());

        JKYRefundResponse tx_after = new JKYRefundResponse(rxtxData);
        tx_after.analyse(MASTER_AES_KEY);
        System.out.println(tx_after.toJSON());
    }

    private static void JKYRefundRequest() throws ProfessionalException {
        JKYRefundRequest tx_before = new JKYRefundRequest();
        tx_before.setLockId("1234567890");
        tx_before.setFid(45);
        tx_before.setStored(BigDecimal.valueOf(-200));
        tx_before.setCash(BigDecimal.valueOf(-500));
        tx_before.assemble(MASTER_AES_KEY);
        System.out.println(tx_before.toJSON());
        RXTXData rxtxData = tx_before.rxtxData();
        System.out.println(rxtxData.toJSON());

        JKYRefundRequest tx_after = new JKYRefundRequest(rxtxData);
        tx_after.analyse(MASTER_AES_KEY);
        System.out.println(tx_after.toJSON());
    }

    private static void JKYRechargeResponse() throws ProfessionalException {
        JKYRechargeResponse tx_before = new JKYRechargeResponse();
        tx_before.setLockId("1234567890");
        tx_before.setFid(67);
        tx_before.setCode(23);
        tx_before.setOrderNo("4324523143");
        tx_before.setBeforeBalance(BigDecimal.valueOf(56));
        tx_before.setAfterBalance(BigDecimal.valueOf(88));
        tx_before.setBeforeGiveMoney(BigDecimal.valueOf(11));
        tx_before.setAfterGiveMoney(BigDecimal.valueOf(15));
        tx_before.assemble(MASTER_AES_KEY);
        System.out.println(tx_before.toJSON());
        RXTXData rxtxData = tx_before.rxtxData();
        System.out.println(rxtxData.toJSON());

        JKYRechargeResponse tx_after = new JKYRechargeResponse(rxtxData);
        tx_after.analyse(MASTER_AES_KEY);
        System.out.println(tx_after.toJSON());
    }

    private static void JKYRechargeRequest() throws ProfessionalException {
        JKYRechargeRequest tx_before = new JKYRechargeRequest();
        tx_before.setLockId("1234567890");
        tx_before.setFid(45);
        tx_before.setType(0);
        tx_before.setMealVersion(1);
        tx_before.setMealOrder(45);
        tx_before.setCash(BigDecimal.valueOf(-45.34));
        tx_before.setGive(BigDecimal.valueOf(-4.34));
        tx_before.setPaycode("434325626PayCode");
        tx_before.assemble(MASTER_AES_KEY);
        System.out.println(tx_before.toJSON());
        RXTXData rxtxData = tx_before.rxtxData();
        System.out.println(rxtxData.toJSON());

        JKYRechargeRequest tx_after = new JKYRechargeRequest(rxtxData);
        tx_after.analyse(MASTER_AES_KEY);
        System.out.println(tx_after.toJSON());
    }

    private static void JKYPaymentResponse1() throws ProfessionalException {
        String JSON = "{\n" +
                "    \"aeskey\": \"3ADA00E788A4A8410425059B5AAE3D3C\",\n" +
                "    \"code\": 2000,\n" +
                "    \"key\": \"000000000001F8DF\",\n" +
                "    \"nonce\": \"1731316481313\",\n" +
                "    \"send\": {\n" +
                "        \"actual\": 0.03,\n" +
                "        \"amount\": 0.02,\n" +
                "        \"balance\": 0.0,\n" +
                "        \"cash\": 0.01,\n" +
                "        \"cloud\": 0.01,\n" +
                "        \"cloudTradeNo\": \"4200002375202411119327576307\",\n" +
                "        \"code\": 16,\n" +
                "        \"expire\": \"2024-11-11 17:14:40\",\n" +
                "        \"fid\": 686,\n" +
                "        \"giveMoney\": 0.01,\n" +
                "        \"integral\": 0,\n" +
                "        \"lockId\": \"881731316448881\",\n" +
                "        \"orderNo\": \"8800000013131647517918111\",\n" +
                "        \"payType\": 2,\n" +
                "        \"payWay\": 2,\n" +
                "        \"stored\": 0.01,\n" +
                "        \"surplusGiveMoney\": 1048.87,\n" +
                "        \"surplusIntegral\": 1584.0,\n" +
                "        \"surplusMoney\": 1144.46,\n" +
                "        \"tradeType\": 8\n" +
                "    },\n" +
                "    \"type\": \"2A01\"\n" +
                "}";

        JSONObject jsonObject = JSONObject.parseObject(JSON);
        JKYPayResponse response = JSONUtils.jsonToObject(jsonObject.getString("send"), JKYPayResponse.class);
        response.setNid(101);
        response.assemble("3ADA00E788A4A8410425059B5AAE3D3C");
        RXTXData rxtxData = response.rxtxData();

        JKYPayResponse tx_after = new JKYPayResponse(rxtxData);
        tx_after.analyse("3ADA00E788A4A8410425059B5AAE3D3C");
        System.out.println(tx_after.toJSON());
    }

    private static void JKYPaymentResponse() throws ProfessionalException {
        JKYPayResponse tx_before = new JKYPayResponse();
        tx_before.setLockId("1234567890");
        tx_before.setCode(23);
        tx_before.setFid(123);
        tx_before.setOrderNo("4324523143");
        tx_before.setTradeType(56);
        tx_before.setStored(BigDecimal.valueOf(34.5));
        tx_before.assemble(MASTER_AES_KEY);
        System.out.println(tx_before.toJSON());
        RXTXData rxtxData = tx_before.rxtxData();
        System.out.println(rxtxData.toJSON());

        JKYPayResponse tx_after = new JKYPayResponse(rxtxData);
        tx_after.analyse(MASTER_AES_KEY);
        System.out.println(tx_after.toJSON());
    }

    private static void JKYPaymentRequest() throws ProfessionalException {
        JKYPayRequest tx_before = new JKYPayRequest();
        tx_before.setLockId("1234567890");
        tx_before.setFid(45);
        tx_before.setStored(BigDecimal.valueOf(23.5));
        tx_before.setTitle("测试商品");
        tx_before.assemble(MASTER_AES_KEY);
        System.out.println(tx_before.toJSON());
        RXTXData rxtxData = tx_before.rxtxData();
        System.out.println(rxtxData.toJSON());

        JKYPayRequest tx_after = new JKYPayRequest(rxtxData);
        tx_after.analyse(MASTER_AES_KEY);
        System.out.println(tx_after.toJSON());
    }

    private static void JKYLoginResponse() throws ProfessionalException {
        JKYLoginResponse tx_before = new JKYLoginResponse();
        tx_before.setLockId("1234567890");
        tx_before.setCode(ChannelStatus.交易等待中.getCode());
        tx_before.setType(LoginType.手机号注册登陆.getType());
        tx_before.setCard("1123214552152663263");
        tx_before.setTradeEnv(1);
        tx_before.setLevel(3);
        tx_before.setSpecialType("A");
        tx_before.setDiscount(BigDecimal.valueOf(0.95));
        tx_before.setBalance(BigDecimal.valueOf(134.32));
        tx_before.setGiveBalance(BigDecimal.valueOf(23.5));
        tx_before.setIntegral(BigDecimal.valueOf(343.00));
        tx_before.setCardKid("JH0000001");
        tx_before.setOperatorMobile("180****0542");
        tx_before.setOperatorPic("http://baidu.com/pic.jpg");
        tx_before.setEnableCash(SwitchState.启用.enable());
        tx_before.setEnableIntegral(SwitchState.启用.enable());
        tx_before.setEnableBlend(SwitchState.不启用.enable());
        tx_before.setEnablePhone(SwitchState.启用.enable());
        tx_before.setPhoneFreePay(BigDecimal.valueOf(150.00));
        tx_before.assemble(MASTER_AES_KEY);
        System.out.println(tx_before.toJSON());
        RXTXData rxtxData = tx_before.rxtxData();
        System.out.println(rxtxData.toJSON());

        JKYLoginResponse tx_after = new JKYLoginResponse(rxtxData);
        tx_after.analyse(MASTER_AES_KEY);
        System.out.println(tx_after.toJSON());
    }

    private static void JKYLoginRequest() throws ProfessionalException {
        JKYLoginRequest tx_before = new JKYLoginRequest();
        tx_before.setType(LoginType.手机号注册登陆.getType());
        tx_before.setText("1123214552152663263");
        tx_before.assemble(MASTER_AES_KEY);
        System.out.println(tx_before.toJSON());
        RXTXData rxtxData = tx_before.rxtxData();
        System.out.println(rxtxData.toJSON());

        JKYLoginRequest tx_after = new JKYLoginRequest(rxtxData);
        tx_after.analyse(MASTER_AES_KEY);
        System.out.println(tx_after.toJSON());
    }

    private static void EndPayment() throws ProfessionalException {
        EndPaymentRequest tx_before = new EndPaymentRequest();
        tx_before.setEnd(1);
        tx_before.setFid(45);
        tx_before.setOrderno("1123214552152663263");
        tx_before.setTradeno("fafdafd4242315gvqw43543");
        tx_before.assemble(MASTER_AES_KEY);
        System.out.println(tx_before.toJSON());
        RXTXData rxtxData = tx_before.rxtxData();
        System.out.println(rxtxData.toJSON());

        EndPaymentRequest tx_after = new EndPaymentRequest(rxtxData);
        tx_after.analyse(MASTER_AES_KEY);
        System.out.println(tx_after.toJSON());
    }

    private static void QueryPayment() throws ProfessionalException {
        PaymentQueryRequest tx_before = new PaymentQueryRequest();
        tx_before.setQuery(1);
        tx_before.setFid(45);
        tx_before.setOrderno("1123214552152663263");
        tx_before.setTradeno("fafdafd4242315gvqw43543");
        tx_before.assemble(MASTER_AES_KEY);
        System.out.println(tx_before.toJSON());
        RXTXData rxtxData = tx_before.rxtxData();
        System.out.println(rxtxData.toJSON());

        PaymentQueryRequest tx_after = new PaymentQueryRequest(rxtxData);
        tx_after.analyse(MASTER_AES_KEY);
        System.out.println(tx_after.toJSON());
    }

    private static void ScanPayment() throws ProfessionalException {
        ScanPaymentRequest tx_before = new ScanPaymentRequest();
        tx_before.setFid(45);
        tx_before.setAmount(BigDecimal.valueOf(0.01));
        tx_before.setTitle("测试商品");
        tx_before.setCount(1);
        tx_before.setRetryCount(0);
        tx_before.setAuth("1123214552152663263");
        tx_before.assemble(MASTER_AES_KEY);
        System.out.println(tx_before.toJSON());
        RXTXData rxtxData = tx_before.rxtxData();
        System.out.println(rxtxData.toJSON());

        ScanPaymentRequest tx_after = new ScanPaymentRequest(rxtxData);
        tx_after.analyse(MASTER_AES_KEY);
        System.out.println(tx_after.toJSON());
    }

    private static void PretreatmentPaymentResponse() throws ProfessionalException {
        PretreatmentPaymentResponse tx_before = new PretreatmentPaymentResponse();
        tx_before.setCode(20);
        tx_before.setFid(54);
        tx_before.setAmount(BigDecimal.valueOf(4.5));
        tx_before.setTitle("测试商品");
        tx_before.setOrderno("123215342fvdasfds");
        tx_before.setPayway(70);
        tx_before.setPaytype(2);
        tx_before.setQrstate(12);
        tx_before.setSysPayUrl("http://baidu.com");
        tx_before.assemble(MASTER_AES_KEY);
        System.out.println(tx_before.toJSON());
        RXTXData rxtxData = tx_before.rxtxData();
        System.out.println(rxtxData.toJSON());

        PretreatmentPaymentResponse tx_after = new PretreatmentPaymentResponse(rxtxData);
        tx_after.analyse(MASTER_AES_KEY);
        System.out.println(tx_after.toJSON());
    }

    private static void PaymentResponse() throws ProfessionalException {
        PaymentResponse tx_before = new PaymentResponse();
        tx_before.setCode(20);
        tx_before.setFid(54);
        tx_before.setAmount(BigDecimal.valueOf(4.5));
        tx_before.setTitle("测试商品");
        tx_before.setOrderno("123215342fvdasfds");
        tx_before.setPayway(70);
        tx_before.setPaytype(2);
        tx_before.assemble(MASTER_AES_KEY);
        System.out.println(tx_before.toJSON());
        RXTXData rxtxData = tx_before.rxtxData();
        System.out.println(rxtxData.toJSON());

        PaymentResponse tx_after = new PaymentResponse(rxtxData);
        tx_after.analyse(MASTER_AES_KEY);
        System.out.println(tx_after.toJSON());
    }

    private static void PretreatmentPaymentFinishRequest() throws ProfessionalException {
        PretreatmentPaymentRequest tx_before = new PretreatmentPaymentRequest();
        tx_before.setFid(45);
        tx_before.setOrderno("");
        tx_before.setRemark("");
        tx_before.setAuth("12345678");
        tx_before.assemble(MASTER_AES_KEY);
        System.out.println(tx_before.toJSON());
        RXTXData rxtxData = tx_before.rxtxData();
        System.out.println(rxtxData.toJSON());

        PretreatmentPaymentRequest tx_after = new PretreatmentPaymentRequest(rxtxData);
        tx_after.analyse(MASTER_AES_KEY);
        System.out.println(tx_after.toJSON());
    }

    private static void PretreatmentPaymentStartRequest() throws ProfessionalException {
        PaymentRequest tx_before = new PaymentRequest();
        tx_before.setFid(45);
        tx_before.setAmount(BigDecimal.valueOf(0.01));
        tx_before.setTitle("测试商品");
        tx_before.setCount(2);
        tx_before.assemble(MASTER_AES_KEY);
        System.out.println(tx_before.toJSON());
        RXTXData rxtxData = tx_before.rxtxData();
        System.out.println(rxtxData.toJSON());

        PaymentRequest tx_after = new PaymentRequest(rxtxData);
        tx_after.analyse(MASTER_AES_KEY);
        System.out.println(tx_after.toJSON());
    }

    private static void Mark() {
        AggregatedMark mark_before = new AggregatedMark(true, true)
                .setLen(4);
        mark_before.assemble(null);
        System.out.println(mark_before.toJSON());

        AggregatedMark mark_after = new AggregatedMark();
        mark_after.setHex(mark_before.getHex());
        mark_after.analyse(null);
        System.out.println(mark_after.toJSON());
    }
}
