package com.jhscale.test.util;

import com.jhscale.common.content.JHContents;
import com.jhscale.common.exception.TechnologyException;
import com.jhscale.common.model.license.*;
import com.jhscale.common.model.simple.JSONModel;
import com.jhscale.common.utils.DateUtils;
import com.jhscale.common.utils.JAESUtil;
import com.jhscale.common.utils.JRSAUtil;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;

/**
 * @author lie_w
 * @title: AESAndRSATest
 * @projectName common
 * @description: TODO
 * @date 2022/2/1716:43
 */
public class AESAndRSATest {

    private static final String unique = "517402B23313";
    private static final String key = "F45EDF349BCD275AE7FC0782AE7C7639CD7CAA02971997B2";

    public static void main(String[] args) throws Exception {
        // String url = "http://jhscale.com/account/auth-ali";
        // System.out.println(URLEncoder.encode(url));
        // AESKey();
        // RSAKey();
        // buildCert();
        certCheck();
        // paramTest();
        // System.out.println(DateUtils.getDate_YYMMDD(new Date()));

        // FileName fileName = new FileName();
        // fileName.addName("46");
        // System.out.println(fileName.toJSON());
        // fileName.addName("fffff.jpg");
        // System.out.println(fileName.toJSON());
        // fileName.project(Project.BASIC_Data)
        //         .setAccount("200000000026");

        // System.out.println(fileName.public_fileName());

        // String s = new FileName()
        //         // .setAccount("26")
        //         .project(Project.LOG_PICTURE)
        //         .public_dir();
        // System.out.println(s);
    }

    /**
     * @description: 参数测试
     **/
    private static void paramTest() {
        SDKParamTest test = new SDKParamTest();
        test.setCAPTURE_WIDTH(640);
        test.setCAPTURE_HEIGHT(480);
        test.setCHECK_BLURY_THRESHOLD(21.0);
        test.setCHECK_BLURY_TIMES(4);

        String content = test.content();
        System.out.println(content);

        SDKParamTest sdkParamTest = new SDKParamTest(content);
        System.out.println(sdkParamTest.toJSON());
    }

    /**
     * @description: 创建证书
     **/
    private static void certCheck() throws TechnologyException {
        RSAEncryptDecrypt rsaEncryptDecrypt = new JRSAEncryptDecrypt();
        String encrypt = "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";

        LicenseContent licenseContent = LicenseContent.decryptByPublicKey(rsaEncryptDecrypt, encrypt);
        System.out.println(licenseContent.toJSON());

    }

    /**
     * @description: 创建证书
     **/
    private static void buildCert() throws TechnologyException {

        String str = "C4osMSJguBFc65eRmP4I6+wjO28GIj2ZnwtiI/Njcj02z2bH4J/eUEi1UcMa6YOQXnt5CurMzLqADV7IB4wIhhrPCD+HynWFAI4GAeDd6pt4GRp3IO4XF/sJzKXWdqEYFxc2s9lMOukIaeFzzzJJSoOkIbLQaqhRW6PmGNpWp2RaUPyQ0dcO8joYOnFzBfkZXaAAsjf4IKVwZJA9Vm0RdDQ1LuuJp/ib2672vXhPvWfxtod90+yIoOcztwInOSuh0GNQiqyItewvOA6AOtUYnzdNX6EWqF8n4rBm+P0XqFuQvlrgMZXILK01ywTKj6NQzuIwFfAN7ljxQUIp1ewz64Q5f3Cc80icbMEJJQHJ3OJQJyxpTuim64IavmNlTVG/40OtHT+5ejrZFZeIA6F9sLJfaNMb9teL6VkOMGydkeptH0CqGMGUpO1rCmWHIGqFYRO6YbMs5QUP6zDky2U9MGwXTpi4muIBJg9RAoC/cpmOjDz0pVCWahXwyOF8y3u5&&MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCM9C/D5avpbY6/UdEKBj8YNJkRVTk/g3xnspn9KG4UzbRqBX9N4XC+QWTyAFQXX4jiA/FqjV2xlHK2SJYT+JJNkgBUz+bsR0jr3EWJKWPDDbBRA8XOZc0KVWupGLTKkq6XCKWkx+bCfTPUwp2DaZMkoDqugZxWfJ0lLVyk8qcz8wIDAQAB";
        System.out.println(str.getBytes(JHContents.UTF_8));

        LicenseContent content = new LicenseContent();
        content.setLicenseHolder(new LicenseHolder());
        content.setSubject(unique + "_cert");
        content.setAlias(unique + "_alias");
        content.setIssuedTime(DateUtils.getDefaultDateTime("2021-01-01 00:00:00"));
        content.setExpiryTime(DateUtils.getDefaultDateTime("2099-12-31 23:59:59"));
        content.setConsumerType("MH");
        content.setConsumerAmount(1);
        content.setDescription("第一份测试RSA证书");

        LicenseParam licenseParam = new LicenseParam();
        licenseParam.setIpAddresses(Arrays.asList("192.168.101.23"));
        licenseParam.setMacAddresses(Arrays.asList("94:D4:31:1E:68:30", "EC:2E:98:D0:62:A9"));
        licenseParam.setCpuSerial("000000000001E683");
        licenseParam.setBoardSerial("zx2100");
        licenseParam.setSystemSerial("Android 7.1.2");
        licenseParam.setMerchant(2000000000000026L);
        licenseParam.setStore(2001000000000002L);
        licenseParam.setUnique(unique);
        licenseParam.setDescription("com.jhscale.common.model.license.LicenseParam");
        content.setLicenseIssuer(new LicenseIssuer());
        System.out.println(content.toJSON());

        RSAEncryptDecrypt rsaEncryptDecrypt = new JRSAEncryptDecrypt();
        RSAKey rsaKey = rsaEncryptDecrypt.genKeyPair();
        System.out.println("Key: " + rsaKey.toJSON());

        String encrypt = content.encryptByPrivateKey(rsaEncryptDecrypt, rsaKey);
        System.out.println("encrypt: " + encrypt);

        encrypt = "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";

        LicenseContent licenseContent = LicenseContent.decryptByPublicKey(rsaEncryptDecrypt, encrypt);
        System.out.println(licenseContent.toJSON());

    }

    private static void RSAKey() throws Exception {
        RSAKey rsaKey = JRSAUtil.genKeyPair();
        System.out.println(rsaKey.toJSON());

        //字符串
        String str = "{'fff':456,'key':'fdahjkfhdkhfjkdhsajkfhkjwqhuryhewhrfeowfdsbnafhdashfjkdhjkafbjkdsabfjkbdsakjv'}";

//        String str = RandomUtils.getRandomStringByLength(10000);

        String encrypt = JRSAUtil.encryptByPublicKey(str, rsaKey.getPublicKey());
        System.out.println(encrypt);
        String data = JRSAUtil.decryptByPrivateKey(encrypt, rsaKey.getPrivateKey());
        System.out.println(data);
        System.out.println(data.equals(str));

        String encrypt1 = JRSAUtil.encryptByPrivateKey(str, rsaKey.getPrivateKey());
        System.out.println(encrypt1);
        String data1 = JRSAUtil.decryptByPublicKey(encrypt1, rsaKey.getPublicKey());
        System.out.println(data1);
        System.out.println(data1.equals(str));
    }

    private static void AESKey() {
        String key = "MIGfMA0GCSqGSIb3";

        //字符串
        String str = "huanzi.qch@qq.com:欢子";
        try {
            //加密
            String encrypt = JAESUtil.encrypt(str, key);
            //解密
            String decrypt = JAESUtil.decrypt(encrypt, key);

            System.out.println("加密前：" + str);
            System.out.println("加密后：" + encrypt);
            System.out.println("解密后：" + decrypt);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class SDKParamTest extends JSONModel {

        // 宽度
        private Integer CAPTURE_WIDTH;

        // 高度
        private Integer CAPTURE_HEIGHT;

        // 模糊检查零界点
        private Double CHECK_BLURY_THRESHOLD;

        // 模糊拍照最大次数
        private Integer CHECK_BLURY_TIMES;

        public SDKParamTest() {
        }

        public SDKParamTest(String content) {
            Map<String, Field> stringFieldMap = this.allAndroidField();
            String[] split = content.split("\r\n");
            if (split != null && split.length > 0) {
                for (String parts : split) {
                    try {
                        if (StringUtils.isNotBlank(parts) && parts.contains("=")) {
                            String[] part = parts.split("=");
                            Field field = stringFieldMap.get(part[0]);
                            field.setAccessible(true);
                            String type = field.getType().toString();
                            if (type.equals(Integer.class.toString())) {
                                field.set(this, Integer.parseInt(part[1]));
                            } else if (type.equals(Double.class.toString())) {
                                field.set(this, Double.parseDouble(part[1]));
                            }
                        }
                    } catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public Integer getCAPTURE_WIDTH() {
            return CAPTURE_WIDTH;
        }

        public void setCAPTURE_WIDTH(Integer CAPTURE_WIDTH) {
            this.CAPTURE_WIDTH = CAPTURE_WIDTH;
        }

        public Integer getCAPTURE_HEIGHT() {
            return CAPTURE_HEIGHT;
        }

        public void setCAPTURE_HEIGHT(Integer CAPTURE_HEIGHT) {
            this.CAPTURE_HEIGHT = CAPTURE_HEIGHT;
        }

        public Double getCHECK_BLURY_THRESHOLD() {
            return CHECK_BLURY_THRESHOLD;
        }

        public void setCHECK_BLURY_THRESHOLD(Double CHECK_BLURY_THRESHOLD) {
            this.CHECK_BLURY_THRESHOLD = CHECK_BLURY_THRESHOLD;
        }

        public Integer getCHECK_BLURY_TIMES() {
            return CHECK_BLURY_TIMES;
        }

        public void setCHECK_BLURY_TIMES(Integer CHECK_BLURY_TIMES) {
            this.CHECK_BLURY_TIMES = CHECK_BLURY_TIMES;
        }

        /**
         * @description: 内容
         **/
        public String content() {
            StringBuilder sb = new StringBuilder();
            Map<String, Field> stringFieldMap = this.allAndroidField();
            for (String keyField : stringFieldMap.keySet()) {
                try {
                    Field field = stringFieldMap.get(keyField);
                    field.setAccessible(true);
                    Object obj = field.get(this);
                    if (obj != null) {
                        sb.append(keyField)
                                .append("=")
                                .append(obj.toString())
                                .append("\r\n");
                    }
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            return sb.toString();
        }
    }
}
