package com.jhscale.test.util;

import com.jhscale.common.utils.ByteUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import java.io.*;
import java.net.MalformedURLException;
import java.net.URL;

/**
 * @author lie_w
 * @title: CopyHTMLPic
 * @projectName common
 * @description: TODO
 * @date 2023/4/618:40
 */
@SuppressWarnings("all")
public class CopyHTMLPic {

    // public static void main(String[] args) throws IOException {
    //     // System.out.println("开始");
    //     // parser();
    //     // System.out.println("结束");

    //     // Copy();
    //     String str = "苹果";
    //     byte[] bytes = str.getBytes("GB2312");
    //     System.out.println(bytes);
    //     String s1 = ByteUtils.toHexString(bytes);
    //     System.out.println(s1);
    // }

    public static void download(String image, String path) {
        try {
            URL url = new URL(image);
            DataInputStream dataInputStream = new DataInputStream(url.openStream());
            //  打开到此 URL 的连接并返回一个用于从该连接读入的 InputStream。
            FileOutputStream fileOutputStream = new FileOutputStream(path);//写入path文件夹
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();//一个输出流，其中的数据被写入一个 byte 数组
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = dataInputStream.read(buffer)) != -1) {//将输入流中数据写入buffer数组
                outputStream.write(buffer, 0, length);// 将 buffer 数组中从偏移量 off 开始的 len 个字节写入此输出流。
            }
            fileOutputStream.write(outputStream.toByteArray());//将数组写入此文件输出流中
            fileOutputStream.close();
            dataInputStream.close();
            outputStream.close();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void download(String image, File file) {
        try {
            URL url = new URL(image);
            DataInputStream dataInputStream = new DataInputStream(url.openStream());
            //  打开到此 URL 的连接并返回一个用于从该连接读入的 InputStream。
            FileOutputStream fileOutputStream = new FileOutputStream(file);//写入path文件夹
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();//一个输出流，其中的数据被写入一个 byte 数组
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = dataInputStream.read(buffer)) != -1) {//将输入流中数据写入buffer数组
                outputStream.write(buffer, 0, length);// 将 buffer 数组中从偏移量 off 开始的 len 个字节写入此输出流。
            }
            fileOutputStream.write(outputStream.toByteArray());//将数组写入此文件输出流中
            fileOutputStream.close();
            dataInputStream.close();
            outputStream.close();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void parser() throws IOException {
        String url = "https://pvp.qq.com/web201605/herolist.shtml";
        String path = "F:\\JHScale\\Resources\\pachong\\";
        int i = 0;
        Document document = Jsoup.connect(url).userAgent("Mozilla/4.0 (compatible;MSIE 9.0 ;Windows NT 6.1;Trident/5.0)").get();
        //获取全部html代码
        Elements selectUL = document.select("[class = herolist clearfix]");//ul标签
        Elements selectLI = selectUL.select("li");
        for (Element e : selectLI) {
            String HeroName = e.select("a").text();//英雄名称
            String heroURL = e.select("a").attr("href");
            String HeroURL = "https://pvp.qq.com/web201605/" + heroURL;//拼接英雄详细信息网页地址
            //在获取该英雄的详细信息网页
            Document doc = Jsoup.connect(HeroURL).userAgent("Mozilla/4.0 (compatible;MSIE 9.0 ;Windows NT 6.1;Trident/5.0)").get();
            Elements div = doc.select("[class=zk-con1 zk-con]");
            String back = div.attr("style");//获取英雄图片地址
            String back2 = back.substring(16, back.length() - 11);//裁剪
            String uri = path + HeroName + ".jpg";//该英雄图片保存地址
            download("Https:" + back2, uri);
            i++;
            if (i > 500)
                break;
        }
    }

    public static void Copy() throws IOException {
        int p = 200;
        String food = "1011233";

        // String food = SystemtUtils.scanner("品名：");
        // String page = SystemtUtils.scanner("页数：");
        // try {
        //     p = Integer.parseInt(page);
        // } catch (Exception e) {
        //     e.printStackTrace();
        // }

        String path = "F:\\JHScale\\Resources\\vcg\\";
        File dir = new File(path, food);
        if (!dir.exists()) dir.mkdirs();
        String format = "https://www.vcg.com/creative-image/%s/?page=%s";
        for (int i = 1; i <= p; i++) {
            String url = String.format(format, food, i);
            Document document = Jsoup.connect(url).userAgent("Mozilla/5.0 (compatible;MSIE 9.0 ;Windows NT 6.1;Trident/5.0)").get();
            Elements lazyload_hk = document.select("[class = lazyload_hk]");//ul标签
            if (lazyload_hk != null && !lazyload_hk.isEmpty()) {
                System.out.println(String.format("品名：[%s] 第[%s]页 共[%s]条", food, i, lazyload_hk.size()));
                for (Element element : lazyload_hk) {
                    String title = element.attr("title");
                    String data_src = "https:" + element.attr("data-src");
                    int index = data_src.lastIndexOf(".");
                    String name = food + "_" + System.currentTimeMillis() + data_src.substring(index);
                    download(data_src, new File(dir, name));
                    try {
                        Thread.sleep(20000);
                    } catch (InterruptedException e) {
                    }
                }
            } else {
                System.err.println(String.format("品名：[%s] 第[%s]页 获取异常", food, i));
                break;
            }

            try {
                Thread.sleep(60000);
            } catch (InterruptedException e) {
            }
        }
    }
}
