package com.jhscale.test.util;

import com.jhscale.common.model.file.ImageSimilar;
import com.jhscale.common.utils.FileUtils;
import com.jhscale.common.utils.HttpUtils;

import java.io.File;
import java.nio.charset.Charset;

/**
 * @author lie_w
 * @title: FileTest
 * @projectName common
 * @description: TODO
 * @date 2022/3/112:06
 */
public class FileTest {

    private static final File FILE = new File("C:\\Users\\lie_w\\Desktop\\Test\\1.bin");
    private static final File CSV_DIR = new File("F:\\JHScale\\Resources\\csv");
    private static final File AI_Source = new File("C:\\Users\\Administrator\\Desktop\\temp\\source_1\\source");
    private static final File AI_Bitmap = new File("C:\\Users\\Administrator\\Desktop\\temp\\source_1\\bitmap");

    public static void main(String[] args) {
        // WriteAndRead();

        // compareImage();

        // String str = "3D8QLN8=";
        // byte[] bytes = Base64.decodeBase64(str);
        // System.out.println(ByteUtils.toHexString(bytes));
        // JRSAEncryptDecrypt jrsaEncryptDecrypt = new JRSAEncryptDecrypt();
        // byte[] decrypt = jrsaEncryptDecrypt.decrypt(str.getBytes());
        // System.out.println(ByteUtils.toHexString(decrypt));

        // download();

        // WriteCSV();

        // AI_SOURCE_DRI();

        // AI_LABEL_READ();

        zip();

    }

    /**
     * @description: ZIP工具测试
     * @date: 2025-05-20 13:42:43
     **/
    private static void zip() {
        File sourceDir = new File("E:\\JHScale\\Resources\\R_290_346_1");
        File zipFile = new File("E:\\JHScale\\Resources\\zip_test.zip");
        FileUtils.zipDirectory(sourceDir, zipFile);

        File destDir = new File("E:\\JHScale\\Resources\\R_290_346_2");
        FileUtils.unzip(zipFile, destDir);
    }

    /**
     * @description: AI标签读取
     * @date: 2025-05-20 13:42:14
     **/
    private static void AI_LABEL_READ() {
        File detect = new File("E:\\JHScale\\Python\\20240618191131\\detect");
        File write = new File("E:\\JHScale\\Resources", "predefined_classes.txt");

        for (File file : detect.listFiles()[0].listFiles()) {
            FileUtils.writer(file.getName() + "\r\n", write, true);
        }

        File[] detects = detect.listFiles();
        for (File detect_dir : detects) {
            File[] label_dirs = detect_dir.listFiles();
            for (File label_dir : label_dirs) {
                File[] images = label_dir.listFiles();
                for (File sourceImage : images) {
                    String name = sourceImage.getName();
                    if (name.contains("×")) {
                        File targetImage = new File(sourceImage.getParentFile(), name.replace("×", "_"));
                        boolean result = sourceImage.renameTo(targetImage);
                        System.out.printf("%s Result: %s%n", name, result);
                    }
                }
            }
        }
        for (File file : detects[0].listFiles()) {
            // FileUtils.writer(file.getName() + "\r\n", write, true);
            File[] images = file.listFiles();
            for (File sourceImage : images) {
                String name = sourceImage.getName();
                if (name.contains("×")) {
                    File targetImage = new File(file, name.replace("×", "_"));
                    boolean result = sourceImage.renameTo(targetImage);
                    System.out.printf("%s Result: %s%n", name, result);
                }
            }
        }
    }

    private static void AI_SOURCE_DRI() {
        File[] files = AI_Source.listFiles();
        for (File file : files) {
            if (!file.getName().contains(".jpg")) continue;
            try {
                String[] split = file.getName().replace(".jpg", "").split("_");
                File bitmap_file_dir = new File(AI_Bitmap, split[0] + "_" + split[1]);
                if (!bitmap_file_dir.exists()) bitmap_file_dir.mkdirs();

                File bitmap_source_file = new File(bitmap_file_dir, split[2] + "_source.jpg");
                FileUtils.copy(file, bitmap_source_file);
            } catch (Exception e) {
                System.err.println(file.getName());
            }
        }
    }

    private static final String Market_Stream_Format = "%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s\n";

    private static void WriteCSV() {
        File file = new File(CSV_DIR, System.currentTimeMillis() + ".csv");
        byte[] bytes = String.format(Market_Stream_Format, "编号", "摊位号", "摊位名", "分区", "主营", "类型", "品名", "单价", "数重量", "单位", "小计", "交易时间")
                .getBytes(Charset.forName("GBK"));
        FileUtils.writer(bytes, file, true);
    }

    private static void download() {
        String url = "https://data.sh.gov.cn/dataserver/dsj-zzk/api/ecert/common/thumbnailFile?thumbnailId=C3B57A4499F044E3B06B70D164B53C0416655782332420&disposition=inline";
        HttpUtils.download(url, new File("C:\\Users\\lie_w\\Desktop\\wl.gif"));
    }

    /**
     * @description: 图片相似测试
     **/
    private static void compareImage() {
        String path1 = "F:\\honey\\HelloWorldApp\\app\\src\\main\\assets\\test1\\1646386780.jpg";
        String path2 = "F:\\honey\\HelloWorldApp\\app\\src\\main\\assets\\test1\\1646386782.jpg";
        for (int i = 0; i < 100; i++) {
            long start = System.currentTimeMillis();
            ImageSimilar imageSimilar = FileUtils.compareImage(path1, path2);
            long end = System.currentTimeMillis();
            System.out.println(imageSimilar.toJSON() + "耗时：" + (end - start));
        }
    }

    /**
     * @description: 读写测试
     **/
    private static void WriteAndRead() {
        String str = "否打狂欢节刻录机JFK老两口放大看零零零零4如若3fdsf";
        FileUtils.writer(str, FILE);

        String reader = FileUtils.reader(FILE);
        System.out.println(reader);
    }
}
