package com.jhscale.test.util;

import com.jhscale.common.c.CMath;
import com.jhscale.common.utils.MathUtils;

/**
 * @author wang lie
 * @version 1.0
 * @projectName common
 * @title MathUtilsTest
 * @description 算法测试
 * @create 2023/8/4 13:43
 */
public class MathUtilsTest {
    public static void main(String[] args) {
        for (int i = 0; i < 100; i++) {
            calculate0(i);
        }
        // System.out.println(CMath.test(4));
    }

    private static void calculate0(int c) {
        float[] f1 = new float[576];
        float[] f2 = new float[576];
        for (int i = 0; i < f1.length; i++) {
            f1[i] = (float) Math.random() * 10;
        }
        for (int i = 0; i < f1.length; i++) {
            f2[i] = (float) Math.random() * 10;
        }

        int method = 4;
        String name = "";
        long start1 = 0L, end1 = 0L, start2 = 0L, end2 = 0L;
        float v1 = 0f, v2 = 0f;

        switch (method) {
            case 0:
                name = "欧几里得距离";
                start1 = System.nanoTime();
                v1 = MathUtils.calculate0(f1, f2);
                end1 = System.nanoTime();

                start2 = System.nanoTime();
                v2 = CMath.calculate0(f1, f2);
                end2 = System.nanoTime();
                break;
            case 1:
                name = "曼哈顿距离";
                start1 = System.nanoTime();
                v1 = MathUtils.calculate1(f1, f2);
                end1 = System.nanoTime();

                start2 = System.nanoTime();
                v2 = CMath.calculate1(f1, f2);
                end2 = System.nanoTime();
                break;
            case 2:
                name = "切比雪夫距离";
                start1 = System.nanoTime();
                v1 = MathUtils.calculate2(f1, f2);
                end1 = System.nanoTime();

                start2 = System.nanoTime();
                v2 = CMath.calculate2(f1, f2);
                end2 = System.nanoTime();
                break;
            case 3:
                name = "余弦相似度";
                start1 = System.nanoTime();
                v1 = MathUtils.calculate3(f1, f2);
                end1 = System.nanoTime();

                start2 = System.nanoTime();
                v2 = CMath.calculate3(f1, f2);
                end2 = System.nanoTime();
                break;
            case 4:
                name = "皮尔逊相关系数";
                start1 = System.nanoTime();
                v1 = MathUtils.calculate4(f1, f2);
                end1 = System.nanoTime();

                start2 = System.nanoTime();
                v2 = CMath.calculate4(f1, f2);
                end2 = System.nanoTime();
                break;
        }

        System.out.printf("%s - Result:[%s] Time:[%s]%n", c + " " + name + " MathUtils.calculate " + method, v1, (end1 - start1));
        System.out.printf("%s - Result:[%s] Time:[%s]%n", c + " " + name + " CMathUtil.calculate " + method, v2, (end2 - start2));
    }
}
