package com.jhscale.test.util;

import com.jhscale.common.exception.TechnologyException;
import com.jhscale.common.utils.FileUtils;
import com.jhscale.common.utils.PictureUtils;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;

/**
 * @author wang lie
 * @title: PictureUtilsTest
 * @projectName common
 * @description: TODO
 * @date 2023/1/2317:48
 */
@SuppressWarnings("all")
public class PictureUtilsTest {

    private static File PIC1 = new File("F:\\JHScale\\Rely\\common\\resources", "PIC1.jpg");
    private static File PHTO = new File("F:\\JHScale\\Rely\\common\\resources", "IMG_6268.JPG");
    private static File PIC2 = new File("F:\\JHScale\\Rely\\common\\resources\\pic_target", "PIC2.jpg");
    private static File PIC3 = new File("F:\\JHScale\\Rely\\common\\resources\\pic_target", "PIC3.jpg");
    private static File PIC4 = new File("F:\\JHScale\\Rely\\common\\resources\\pic_target", "PIC4.jpg");
    private static File PIC5 = new File("F:\\JHScale\\Rely\\common\\resources\\pic_target", "PIC5.jpg");
    private static File PIC6 = new File("F:\\JHScale\\Rely\\common\\resources\\pic_target", "PIC6.jpg");
    private static File PIC7 = new File("F:\\JHScale\\Resources", "nm-1.jpg");
    private static File PIC7_0 = new File("F:\\JHScale\\Resources", "nm-1_0.jpg");
    private static File PIC7_1 = new File("F:\\JHScale\\Resources", "nm-1_1.jpg");
    private static File PIC7_2 = new File("F:\\JHScale\\Resources", "nm-1_2.jpg");

    private static File PIC_Net = new File("F:\\JHScale\\Resources", "biandou_Net.jpeg");
    private static File PIC_Other = new File("F:\\JHScale\\Resources", "kp.jpg");
    private static File PIC_Write = new File("F:\\JHScale\\Resources", "biandou.jpg");

    public static void main(String[] args) throws IOException, TechnologyException {
        // Pic_Test();
        // Photo_Test();
        // Photo_Cut();

         FileUtils.getFile("http://jh-system.oss-cn-shanghai.aliyuncs.com/salesPLU/1655529886385928.jpg", PIC_Net);
        BufferedImage biandou_net = ImageIO.read(PIC_Net);

        BufferedImage biandou_other = ImageIO.read(PIC_Other);

        BufferedImage biandou = ImageIO.read(new URL("http://jh-system.oss-cn-shanghai.aliyuncs.com/salesPLU/1655529886385928.jpg"));
        BufferedImage sijidou = ImageIO.read(new URL("http://jh-system.oss-cn-shanghai.aliyuncs.com/salesPLU/1659082200770664.jpg"));
        PictureUtils.write(biandou, "jpg", PIC_Write);
    }

    private static void Photo_Cut() throws IOException {
        BufferedImage read = ImageIO.read(PIC7);
        PictureUtils.write(read, "jpg", PIC7_0);

        BufferedImage cut1 = PictureUtils.cut(read, 275, 255, 600, 455);
        PictureUtils.write(cut1, "jpg", PIC7_1);
    }

    /**
     * @description: 照片处理
     **/
    private static void Photo_Test() throws IOException {
        BufferedImage read = ImageIO.read(PHTO);

        int jpg_size = PictureUtils.size(read, "jpg");
        System.out.println("jpg_size:" + jpg_size);

        int png_size = PictureUtils.size(read, "png");
        System.out.println("png_size:" + png_size);

        int bmp_size = PictureUtils.size(read, "bmp");
        System.out.println("bmp_size:" + bmp_size);

        int jpeg_size = PictureUtils.size(read, "jpeg");
        System.out.println("jpeg_size:" + jpeg_size);

        BufferedImage rotate = PictureUtils.rotate(read, 90);
        ImageIO.write(rotate, "jpg", PIC2);

        BufferedImage compress = PictureUtils.compress(rotate, 256, 256);
        ImageIO.write(compress, "jpg", PIC3);

        BufferedImage water_mark_position = PictureUtils.water_mark_position(rotate, "JHScale", 3);
        ImageIO.write(water_mark_position, "jpg", PIC4);

        BufferedImage water_mark_oblique = PictureUtils.water_mark_oblique(rotate, "精函信息科技有限公司", -0.2F);
        ImageIO.write(water_mark_oblique, "jpg", PIC5);

        BufferedImage cut = PictureUtils.cut(rotate, 200, 100, 800, 400);
        cut = PictureUtils.water_mark_position(cut, "JHScale", 3);
        ImageIO.write(cut, "jpg", PIC6);
    }

    /**
     * @description: 图片测试  压缩 旋转
     **/
    private static void Pic_Test() throws IOException {
        BufferedImage read = ImageIO.read(PIC1);
        BufferedImage compress = PictureUtils.compress(read, 0.7);
        ImageIO.write(compress, "jpg", PIC2);

        BufferedImage rotate = PictureUtils.rotate(compress, 90);
        ImageIO.write(rotate, "jpg", PIC3);

        BufferedImage water_mark_position = PictureUtils.water_mark_position(rotate, "JHScale", 3);
        ImageIO.write(water_mark_position, "jpg", PIC4);

        BufferedImage water_mark_oblique = PictureUtils.water_mark_oblique(rotate, "精函信息科技有限公司", -0.2F);
        ImageIO.write(water_mark_oblique, "jpg", PIC5);

        BufferedImage cut = PictureUtils.cut(rotate, 200, 100, 800, 400);
        cut = PictureUtils.water_mark_position(cut, "JHScale", 3);
        ImageIO.write(cut, "jpg", PIC6);

    }
}
