/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.em;

import com.jhscale.common.utils.ByteUtils;
import java.util.Objects;

public enum BarcodeScale {
    KA(1, 7, "KA", 63, "08\u7248\u672c\u6761\u7801\u6253\u5370\u79e4", "08's Bar Code Printing Scale"),
    KAB(2, 0, "KAB", 63, "12/15/17\u7248\u672c\u6761\u7801\u6253\u5370\u79e4(\u5e26\u7acb\u6746)", "12's/15's/17's Bar Code Printing Scale(Pole)"),
    KAD(3, 1, "KAD", 40, "12/15\u7248\u672c\u6761\u7801\u6253\u5370\u79e4(\u65e0\u7acb\u6746)", "12's/15's Bar Code Printing Scale(No Pole)"),
    KB(4, 2, "KB", 30, "\u4ef7\u683c\u6807\u7b7e\u79e4(\u6253\u5370\u578b)", "Price Printing Scale"),
    KC(5, 3, "KC", 40, "11/15/19\u7248\u672c\u4ef7\u683c\u6807\u7b7e\u79e4(\u6536\u94f6\u578b)", "11's/15's/19's Cash Register Scale"),
    KCB(6, 8, "KCB", 60, "20\u7248\u672c\u4ef7\u683c\u6807\u7b7e\u79e4(\u6536\u94f6\u578b)", "20's Cash Register Scale"),
    KD(7, 4, "KD", 30, "\u6536\u94f6\u673a", "Cash Register"),
    KE(8, 5, "KE", 10, "A1\u4eea\u8868", "A1 Indicator"),
    KF(9, 6, "KF", 40, "A1+/A2\u4eea\u8868", "A1+/A2 Indicator");

    private int board;
    private int ftBoard;
    private String simName;
    private int size;
    private String chineseName;
    private String englishName;

    private BarcodeScale(int board, int ftBoard, String simName, int size, String chineseName, String englishName) {
        this.board = board;
        this.ftBoard = ftBoard;
        this.simName = simName;
        this.size = size;
        this.chineseName = chineseName;
        this.englishName = englishName;
    }

    public static BarcodeScale board(Integer board) {
        if (Objects.nonNull(board)) {
            for (BarcodeScale barcodeScale : BarcodeScale.values()) {
                if (!board.equals(barcodeScale.getBoard())) continue;
                return barcodeScale;
            }
        }
        return KA;
    }

    public static BarcodeScale ftBoard(Integer ftBoard) {
        if (Objects.nonNull(ftBoard)) {
            for (BarcodeScale barcodeScale : BarcodeScale.values()) {
                if (!ftBoard.equals(barcodeScale.getFtBoard())) continue;
                return barcodeScale;
            }
        }
        return KA;
    }

    public int getBoard() {
        return this.board;
    }

    public String getSimName() {
        return this.simName;
    }

    public int getFtBoard() {
        return this.ftBoard;
    }

    public int getSize() {
        return this.size;
    }

    public String getChineseName() {
        return this.chineseName;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public int[] order2PageIndex(int order) {
        try {
            String hex = ByteUtils.appendFill(Integer.toHexString(order), 4);
            return new int[]{Integer.parseInt(hex.substring(0, 2), 16), Integer.parseInt(hex.substring(2, 4), 16)};
        }
        catch (Exception e) {
            return new int[2];
        }
    }

    public int pageIndex2Order(int page, int index) {
        try {
            String hex = ByteUtils.appendFill(Integer.toHexString(page), 2) + ByteUtils.appendFill(Integer.toHexString(index), 2);
            return Integer.parseInt(hex, 16);
        }
        catch (Exception e) {
            return 0;
        }
    }
}

