/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.em;

import com.jhscale.common.em.ZuulDeviceType;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum DeviceType {
    Simple_Scales("Simple_Scales", "\u666e\u901a\u6536\u94f6\u79e4", "D-info", 0, ZuulDeviceType.\u5f3a\u5f52\u5c5e),
    Android_Scales("Android_Scales", "\u5b89\u5353\u6536\u94f6\u79e4", "Android_Scales", 1, ZuulDeviceType.\u5f3a\u5f52\u5c5e),
    MH_WEB_Scales("MH_WEB_Scales", "\u5546\u6237WEB\u7ec8\u7aef", "MH_WEB_Scales", 7, ZuulDeviceType.\u5f3a\u5f52\u5c5e),
    BT_Crane_Scales("BT_Crane_Scales", "\u84dd\u7259\u540a\u79e4", "BT_Crane_Scales", 2, ZuulDeviceType.\u5f52\u6863\u5728\u6848),
    PC_Scales("PC_Scales", "PC\u6536\u94f6\u79e4", "PC_Scales", 4, ZuulDeviceType.\u5f3a\u5f52\u5c5e),
    BT_Scales("BT_Scales", "\u84dd\u7259\u6536\u94f6\u79e4", "BT_Scales", 5, ZuulDeviceType.\u5f3a\u5f52\u5c5e),
    VPS_PC_Scales("VPS_PC_Scales", "\u4e09\u65b9PC\u6536\u94f6\u79e4", "VPS_PC_Scales", 3, ZuulDeviceType.\u5f3a\u5f52\u5c5e),
    Car_Horizontal_Scales("Car_Horizontal_Scales", "\u6c7d\u8f66\u8861", "Car_Horizontal_Scales", 6, ZuulDeviceType.\u5f52\u6863\u5728\u6848),
    Car_Horizontal_Scales_Display("CHD_Scales", "\u6c7d\u8f66\u8861(\u663e\u793a\u5c4f\u7248\u672c)", "CHD_Scales", 10, ZuulDeviceType.\u5f52\u6863\u5728\u6848),
    Factory_Tool("Factory_Tool", "\u5de5\u5382\u6d4b\u8bd5\u5de5\u5177", "Factory_Tool", 8, ZuulDeviceType.\u6388\u6743),
    BT_Print_Scales("BT_Print_Scales", "\u84dd\u7259\u6253\u5370\u79e4", "BT_Print_Scales", 9, ZuulDeviceType.\u5f52\u6863\u5728\u6848),
    JHSDK("JHSDK", "JHSDK\u5bf9\u63a5", "JHSDK", 10, ZuulDeviceType.\u5f3a\u5f52\u5c5e),
    Other_Device("Other_Device", "\u5176\u4f59\u8bbe\u5907", "Other_Device", 100, ZuulDeviceType.\u5f31\u5f52\u5c5e),
    ZXD_Display("ZXD_Display", "\u663e\u793a\u5c4f\u8bbe\u5907", "ZXD_Display", 101, ZuulDeviceType.\u5f31\u5f52\u5c5e);

    private final String type;
    private final String description;
    private final String sign;
    private final Integer itype;
    private final ZuulDeviceType zuulDeviceType;

    private DeviceType(String type, String description, String sign, Integer itype, ZuulDeviceType zuulDeviceType) {
        this.type = type;
        this.description = description;
        this.sign = sign;
        this.itype = itype;
        this.zuulDeviceType = zuulDeviceType;
    }

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSign() {
        return this.sign;
    }

    public Integer getItype() {
        return this.itype;
    }

    public ZuulDeviceType getZuulDeviceType() {
        return this.zuulDeviceType;
    }

    public static DeviceType deviceType(Integer itype) {
        if (Objects.isNull(itype)) {
            return Simple_Scales;
        }
        for (DeviceType deviceType : DeviceType.values()) {
            if (!deviceType.getItype().equals(itype)) continue;
            return deviceType;
        }
        return null;
    }

    public static DeviceType deviceType(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return Simple_Scales;
        }
        for (DeviceType deviceType : DeviceType.values()) {
            if (!deviceType.getType().equals(type) && !deviceType.getSign().equals(type)) continue;
            return deviceType;
        }
        return null;
    }

    public String toString() {
        return "DeviceType{type='" + this.type + '\'' + ", description='" + this.description + '\'' + ", sign='" + this.sign + '\'' + ", itype=" + this.itype + '}';
    }
}

