/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.em;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum PayType {
    PAY_FAIL(0, "00", "\u652f\u4ed8\u5931\u8d25"),
    ALI_PAY(1, "01", "\u652f\u4ed8\u5b9d\u652f\u4ed8"),
    WECHAT_PAY(2, "02", "\u5fae\u4fe1\u652f\u4ed8"),
    UNION_PAY(3, "03", "\u4e91\u95ea\u4ed8"),
    Special_PAY3(4, "04", "\u7279\u6b8a\u652f\u4ed83"),
    Special_PAY4(5, "05", "\u7279\u6b8a\u652f\u4ed84"),
    Special_PAY5(6, "06", "\u7279\u6b8a\u652f\u4ed85"),
    Special_PAY6(7, "07", "\u7279\u6b8a\u652f\u4ed86"),
    UNKNOWN_PAY(8, "08", "\u672a\u77e5\u652f\u4ed8");

    private int type;
    private String strType;
    private String description;

    private PayType(int type, String strType, String description) {
        this.type = type;
        this.strType = strType;
        this.description = description;
    }

    public Integer getType() {
        return this.type;
    }

    public String getStrType() {
        return this.strType;
    }

    public String getDescription() {
        return this.description;
    }

    public static PayType type(Integer type) {
        if (Objects.nonNull(type)) {
            for (PayType payType : PayType.values()) {
                if (!payType.getType().equals(type)) continue;
                return payType;
            }
        }
        return UNKNOWN_PAY;
    }

    public static PayType type(String strType) {
        if (StringUtils.isNotBlank((CharSequence)strType)) {
            for (PayType payType : PayType.values()) {
                if (!payType.getStrType().equals(strType) && !payType.getType().toString().equals(strType)) continue;
                return payType;
            }
        }
        return UNKNOWN_PAY;
    }
}

