/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.em;

import com.jhscale.common.model.simple.PaySimple;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum PayWay {
    Aggregate_PAY(0, "00", false, "\u805a\u5408\u652f\u4ed8"),
    ALI_PAY(1, "01", true, "\u652f\u4ed8\u5b9d\u652f\u4ed8"),
    WECHAT_PAY(2, "02", true, "\u5fae\u4fe1\u652f\u4ed8"),
    CASH_PAY(3, "03", false, "\u73b0\u91d1\u652f\u4ed8"),
    JK_PAY(4, "04", false, "\u5409\u5361\u4e91\u652f\u4ed8"),
    OTHER_PAY(5, "05", false, "\u5176\u4ed6\u805a\u5408\u652f\u4ed8"),
    WECHAT_OA_PAY(6, "06", false, "\u5fae\u4fe1\u6536\u4ed8\u901a\u652f\u4ed8"),
    UNION_T_PAY(7, "07", false, "\u94f6\u8054\u652f\u4ed8"),
    UNION_PAY(70, "70", true, "\u4e91\u95ea\u4ed8"),
    JH_PAY(71, "71", true, "\u9f99\u652f\u4ed8"),
    YZ_PAY(72, "72", true, "\u90ae\u653f\u652f\u4ed8"),
    ICBC_PAY(74, "74", true, "\u5de5\u884c\u652f\u4ed8"),
    UNION_PAY2(75, "75", true, "\u4e91\u95ea\u4ed8\u5929\u6ee1"),
    FUBEI_PAY(76, "76", true, "\u4ed8\u5457\u652f\u4ed8"),
    SQB_PAY(77, "77", true, "\u6536\u94b1\u5427\u652f\u4ed8"),
    SB_PAY(78, "78", true, "\u626b\u5457\u652f\u4ed8"),
    O_UNION_PAY(700, "700", false, "\u5176\u4ed6\u94f6\u8054\u652f\u4ed8"),
    QQ_PAY(8, "08", true, "QQ\u652f\u4ed8"),
    TOTAL_PAY(10, "10", false, "\u6c47\u603b");

    private final int type;
    private final String strType;
    private final boolean cloudChannel;
    private final String description;

    private PayWay(int type, String strType, boolean cloudChannel, String description) {
        this.type = type;
        this.strType = strType;
        this.cloudChannel = cloudChannel;
        this.description = description;
    }

    public Integer getType() {
        return this.type;
    }

    public String getStrType() {
        return this.strType;
    }

    public boolean isCloudChannel() {
        return this.cloudChannel;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return String.valueOf(this.type);
    }

    public static PayWay orderPay(Integer type) {
        if (Objects.nonNull(type)) {
            for (PayWay payWay : PayWay.values()) {
                if (!payWay.getType().equals(type)) continue;
                return payWay;
            }
        }
        return null;
    }

    public static PayWay orderPay(String type) {
        if (StringUtils.isNotBlank((CharSequence)type)) {
            for (PayWay payWay : PayWay.values()) {
                if (!payWay.getType().toString().equals(type)) continue;
                return payWay;
            }
        }
        return null;
    }

    public static PayWay strType(String type) {
        if (StringUtils.isNotBlank((CharSequence)type)) {
            for (PayWay payWay : PayWay.values()) {
                if (!payWay.getStrType().equals(type)) continue;
                return payWay;
            }
        }
        return null;
    }

    public static List<PaySimple> cloudPayChannel() {
        ArrayList<PaySimple> channels = new ArrayList<PaySimple>();
        for (PayWay value : PayWay.values()) {
            if (!value.cloudChannel) continue;
            channels.add(new PaySimple(value.type, value.strType, value.description));
        }
        return channels;
    }
}

