/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.em;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public enum Version {
    VERSION00(0, "0.0", "VERSION00"),
    VERSION01(1, "1.0", "VERSION01"),
    VERSION02(2, "2.0", "VERSION02"),
    VERSION03(3, "3.0", "VERSION03"),
    VERSION04(4, "4.0", "VERSION04"),
    VERSION05(5, "5.0", "VERSION05"),
    VERSION06(6, "6.0", "VERSION06"),
    VERSION07(7, "7.0", "VERSION07"),
    VERSION08(8, "8.0", "VERSION08"),
    VERSION09(9, "9.0", "VERSION09");

    private Integer version;
    private String versionStr;
    private String description;

    private Version(Integer version, String versionStr, String description) {
        this.version = version;
        this.versionStr = versionStr;
        this.description = description;
    }

    public static Version version(Integer version) {
        if (Objects.nonNull(version)) {
            for (Version v : Version.values()) {
                if (!version.equals(v.getVersion())) continue;
                return v;
            }
        }
        return VERSION00;
    }

    public static Version versionStr(String versionStr) {
        if (StringUtils.isNotBlank((CharSequence)versionStr)) {
            for (Version v : Version.values()) {
                if (!versionStr.equals(v.getVersionStr())) continue;
                return v;
            }
        }
        return VERSION00;
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getVersionStr() {
        return this.versionStr;
    }

    public String getDescription() {
        return this.description;
    }
}

