/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.exception;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jhscale.common.em.ExpParamType;
import com.jhscale.common.em.ServerExp;
import com.jhscale.common.internatonal.ExpInternationalEntity;
import com.jhscale.common.model.exp.ExpKVModel;
import com.jhscale.common.utils.JSONUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public abstract class GeneralException
extends Exception {
    private int type;
    private String code;
    private ExpParamType paramType;
    private String msg;
    private List<String> msgs;
    private List<ExpKVModel> kvModels;

    public abstract String getExpLevel();

    public String getApplication() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getMessage() {
        return this.type == 1 ? new ExpInternationalEntity(this).toString() : JSONObject.toJSONString((Object)new ExpInternationalEntity(this));
    }

    public GeneralException(GeneralException exception) {
        super(exception.getCause());
        this.type = exception.getType();
        this.code = exception.getCode();
        this.paramType = exception.getParamType();
        this.msg = exception.getMsg();
        this.msgs = exception.getMsgs();
        this.kvModels = exception.getKvModels();
    }

    public GeneralException(Throwable cause, String code, ExpParamType paramType, String ... messages) {
        super(cause);
        this.code = code;
        this.paramType = paramType;
        if (ExpParamType.SIMPLE.equals((Object)paramType)) {
            this.msg = messages[0];
        } else if (ExpParamType.STRING.equals((Object)paramType)) {
            this.msgs = Arrays.asList(messages);
        }
    }

    public GeneralException(Throwable cause, String code, ExpKVModel ... models) {
        super(cause);
        this.code = code;
        this.paramType = ExpParamType.MAP;
        this.kvModels = Arrays.asList(models);
    }

    public GeneralException(Throwable cause, String code, String message) {
        this(cause, code, ExpParamType.SIMPLE, message);
    }

    public GeneralException(Throwable cause, String code, String ... messages) {
        this(cause, code, ExpParamType.STRING, messages);
    }

    public GeneralException(Throwable cause, String code, Object ... objects) {
        super(cause);
        this.code = code;
        if (objects != null && objects.length > 0) {
            if (objects.length == 1) {
                Object obj = objects[0];
                if (Objects.nonNull(obj)) {
                    if (obj instanceof ExpKVModel) {
                        this.paramType = ExpParamType.MAP;
                        if (this.kvModels == null) {
                            this.kvModels = new ArrayList<ExpKVModel>();
                        }
                        this.kvModels.add((ExpKVModel)obj);
                    } else {
                        this.paramType = ExpParamType.SIMPLE;
                        this.msg = obj.toString();
                    }
                }
            } else {
                for (Object obj : objects) {
                    if (!Objects.nonNull(obj)) continue;
                    if (obj instanceof ExpKVModel) {
                        if (Objects.isNull(this.kvModels)) {
                            this.kvModels = new ArrayList<ExpKVModel>();
                        }
                        this.kvModels.add((ExpKVModel)obj);
                        continue;
                    }
                    if (Objects.isNull(this.msgs)) {
                        this.msgs = new ArrayList<String>();
                    }
                    this.msgs.add(obj.toString());
                }
                if (this.msgs != null && this.msgs.size() > 1) {
                    this.paramType = ExpParamType.STRING;
                }
                if (this.kvModels != null && !this.kvModels.isEmpty()) {
                    this.paramType = ExpParamType.MAP;
                }
                if (this.msgs != null && this.msgs.size() > 1 && this.kvModels != null && !this.kvModels.isEmpty()) {
                    this.paramType = ExpParamType.ALL;
                }
            }
        }
        if (Objects.isNull((Object)this.paramType)) {
            this.paramType = ExpParamType.SIMPLE;
            this.msg = "\u901a\u7528\u5f02\u5e38";
        }
    }

    public GeneralException(Throwable cause, ServerExp serverExp) {
        this(cause, serverExp.getCode(), serverExp.getMessage());
    }

    public GeneralException(Throwable cause, String message) {
        this(cause, ServerExp.\u7cfb\u7edf\u5f02\u5e38.getCode(), message);
    }

    public GeneralException(Throwable cause, Integer code, String message) {
        this(cause, code.toString(), message);
    }

    public GeneralException(String code, ExpParamType paramType, String ... messages) {
        this.code = code;
        this.paramType = paramType;
        if (ExpParamType.SIMPLE.equals((Object)paramType)) {
            this.msg = messages[0];
        } else {
            this.msgs = Arrays.asList(messages);
        }
    }

    public GeneralException(String code, ExpKVModel ... models) {
        this.code = code;
        this.paramType = ExpParamType.MAP;
        this.kvModels = Arrays.asList(models);
    }

    public GeneralException(String code, String message) {
        this(code, ExpParamType.SIMPLE, message);
    }

    public GeneralException(String code, String ... messages) {
        this(code, ExpParamType.STRING, messages);
    }

    public GeneralException(String code, Object ... objects) {
        this.code = code;
        if (objects != null && objects.length > 0) {
            if (objects.length == 1) {
                Object obj = objects[0];
                if (Objects.nonNull(obj)) {
                    if (obj instanceof ExpKVModel) {
                        this.paramType = ExpParamType.MAP;
                        if (this.kvModels == null) {
                            this.kvModels = new ArrayList<ExpKVModel>();
                        }
                        this.kvModels.add((ExpKVModel)obj);
                    } else {
                        this.paramType = ExpParamType.SIMPLE;
                        this.msg = obj.toString();
                    }
                }
            } else {
                for (Object obj : objects) {
                    if (!Objects.nonNull(obj)) continue;
                    if (obj instanceof ExpKVModel) {
                        if (Objects.isNull(this.kvModels)) {
                            this.kvModels = new ArrayList<ExpKVModel>();
                        }
                        this.kvModels.add((ExpKVModel)obj);
                        continue;
                    }
                    if (Objects.isNull(this.msgs)) {
                        this.msgs = new ArrayList<String>();
                    }
                    this.msgs.add(obj.toString());
                }
                if (this.msgs != null && this.msgs.size() > 1) {
                    this.paramType = ExpParamType.STRING;
                }
                if (this.kvModels != null && !this.kvModels.isEmpty()) {
                    this.paramType = ExpParamType.MAP;
                }
                if (this.msgs != null && this.msgs.size() > 1 && this.kvModels != null && !this.kvModels.isEmpty()) {
                    this.paramType = ExpParamType.ALL;
                }
            }
        }
        if (Objects.isNull((Object)this.paramType)) {
            this.paramType = ExpParamType.SIMPLE;
            this.msg = "\u901a\u7528\u5f02\u5e38";
        }
    }

    public GeneralException(ServerExp serverExp) {
        this(serverExp.getCode(), serverExp.getMessage());
    }

    public GeneralException(String message) {
        this(ServerExp.\u7cfb\u7edf\u5f02\u5e38.getCode(), message);
    }

    public GeneralException(Integer code, String messages) {
        this(code.toString(), messages);
    }

    protected void mapping(String message) {
        try {
            if (JSONUtils.isJSON(message)) {
                JSONObject jsonObject = JSONObject.parseObject((String)message);
                String jsonMessage = jsonObject.getString("message");
                if (StringUtils.isNotBlank((CharSequence)jsonMessage)) {
                    JSONObject jsonObjectObject = JSONObject.parseObject((String)jsonMessage);
                    this.setCode(jsonObjectObject.getString("jsl"));
                    this.setMsg(jsonObjectObject.getString("msg"));
                    this.setParamType(ExpParamType.valueOf(jsonObjectObject.getString("type")));
                    this.mapping(jsonObjectObject);
                } else {
                    this.setCode(jsonObject.getString("jsl"));
                    this.setMsg(jsonObject.getString("msg"));
                    this.setParamType(ExpParamType.valueOf(jsonObject.getString("type")));
                    this.mapping(jsonObject);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void mapping(JSONObject jsonObject) {
        String expVal = jsonObject.getString("expVal");
        if (StringUtils.isNotBlank((CharSequence)expVal)) {
            JSONArray kvModels;
            JSONObject expValObject = JSONObject.parseObject((String)expVal);
            JSONArray msgs = expValObject.getJSONArray("msgs");
            if (msgs != null && msgs.size() > 0) {
                this.setMsgs(JSONObject.parseArray((String)msgs.toJSONString(), String.class));
            }
            if ((kvModels = expValObject.getJSONArray("kvModels")) != null && kvModels.size() > 0) {
                this.setKvModels(JSONObject.parseArray((String)kvModels.toJSONString(), ExpKVModel.class));
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public ExpParamType getParamType() {
        return this.paramType;
    }

    public void setParamType(ExpParamType paramType) {
        this.paramType = paramType;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public List<String> getMsgs() {
        return this.msgs;
    }

    public void setMsgs(List<String> msgs) {
        this.msgs = msgs;
    }

    public List<ExpKVModel> getKvModels() {
        return this.kvModels;
    }

    public void setKvModels(List<ExpKVModel> kvModels) {
        this.kvModels = kvModels;
    }
}

