/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.ai_feature;

import com.jhscale.common.model.device._inner.AIValue;
import com.jhscale.common.model.device._inner.PublicUnPackage;
import com.jhscale.common.model.device._inner.PublicUnPackageArray;
import com.jhscale.common.model.device.plu.param.Prepose;
import com.jhscale.common.model.inter.DataJSONModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public interface DAIFeature<T extends DAIFeature>
extends DataJSONModel<T> {
    @Override
    default public Prepose prepose() {
        if (this.getFeature_specials() == null) {
            this.mapToArray();
        }
        return new Prepose();
    }

    @Override
    default public String package_method(int serial) {
        StringBuffer buffer = new StringBuffer();
        switch (serial) {
            case 0: {
                buffer.append(this.weight());
                break;
            }
            case 1: {
                buffer.append(this.specials());
                break;
            }
            case 2: {
                buffer.append(this.counter());
                break;
            }
            case 3: {
                buffer.append(this.creates());
            }
        }
        return buffer.toString();
    }

    default public String weight() {
        String weightStr = "";
        if (this.getWeight() != null && this.getWeight().length > 0) {
            for (int i = 0; i < this.getWeight().length; ++i) {
                weightStr = weightStr + this.getWeight()[i] + (i != this.getWeight().length - 1 ? "," : "");
            }
        }
        return weightStr;
    }

    default public String specials() {
        String featureStr = "";
        if (this.getFeature_specials() != null && this.getFeature_specials().length > 0) {
            for (int i = 0; i < this.getFeature_specials().length; ++i) {
                featureStr = featureStr + this.getFeature_specials()[i] + (i != this.getFeature_specials().length - 1 ? "|" : "");
            }
        }
        return featureStr;
    }

    default public String counter() {
        String counterStr = "";
        if (this.getCounter() != null && this.getCounter().length > 0) {
            for (int i = 0; i < this.getCounter().length; ++i) {
                counterStr = counterStr + this.getCounter()[i] + (i != this.getCounter().length - 1 ? "," : "");
            }
        }
        return counterStr;
    }

    default public String creates() {
        String createsStr = "";
        if (this.getCreates() != null && this.getCreates().length > 0) {
            for (int i = 0; i < this.getCreates().length; ++i) {
                createsStr = createsStr + this.getCreates()[i] + (i != this.getCreates().length - 1 ? "," : "");
            }
        }
        return createsStr;
    }

    @Override
    default public PublicUnPackage un_package_method(String[] contents, int serial) {
        PublicUnPackage unPackage = new PublicUnPackage(contents);
        switch (serial) {
            case 0: {
                unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 1);
                String[] contents_0 = ((PublicUnPackageArray)unPackage).getContents();
                if (!StringUtils.isNotBlank((CharSequence)contents_0[0])) break;
                this.weight(contents_0[0]);
                break;
            }
            case 1: {
                unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 1);
                String[] contents_1 = ((PublicUnPackageArray)unPackage).getContents();
                if (!StringUtils.isNotBlank((CharSequence)contents_1[0])) break;
                this.feature_specials(contents_1[0]);
                break;
            }
            case 2: {
                unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 1);
                String[] contents_2 = ((PublicUnPackageArray)unPackage).getContents();
                if (!StringUtils.isNotBlank((CharSequence)contents_2[0])) break;
                this.counter(contents_2[0]);
                break;
            }
            case 3: {
                unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 1);
                String[] contents_3 = ((PublicUnPackageArray)unPackage).getContents();
                if (!StringUtils.isNotBlank((CharSequence)contents_3[0])) break;
                this.creates(contents_3[0]);
            }
        }
        return unPackage;
    }

    default public void weight(String weightStr) {
        if (StringUtils.isNotBlank((CharSequence)weightStr)) {
            String[] weightArr = weightStr.split(",");
            int[] weight = new int[weightArr.length];
            for (int i = 0; i < weightArr.length; ++i) {
                weight[i] = Integer.parseInt(weightArr[i]);
            }
            this.setWeight(weight);
        }
    }

    default public void feature_specials(String i_featureStr) {
        if (StringUtils.isNotBlank((CharSequence)i_featureStr)) {
            this.setFeature_specials(i_featureStr.split("\\|"));
        }
    }

    default public void counter(String counterStr) {
        if (StringUtils.isNotBlank((CharSequence)counterStr)) {
            String[] counterArr = counterStr.split(",");
            int[] counter = new int[counterArr.length];
            for (int i = 0; i < counterArr.length; ++i) {
                counter[i] = Integer.parseInt(counterArr[i]);
            }
            this.setCounter(counter);
        }
    }

    default public void creates(String createsStr) {
        if (StringUtils.isNotBlank((CharSequence)createsStr)) {
            String[] createsArr = createsStr.split(",");
            String[] creates = new String[createsArr.length];
            for (int i = 0; i < createsArr.length; ++i) {
                creates[i] = createsArr[i];
            }
            this.setCreates(creates);
        }
    }

    default public String label_str() {
        return String.format("%s_%s", this.getLabel_name(), this.getNick_name());
    }

    default public T mapToArray() {
        String[] species = new String[this.getCounter().length];
        Map<Integer, Map<Integer, List<AIValue>>> self_values = this.getSelf_values();
        if (self_values != null && !self_values.isEmpty()) {
            for (Map.Entry<Integer, Map<Integer, List<AIValue>>> entry : self_values.entrySet()) {
                Integer algorithm_type = entry.getKey();
                Map<Integer, List<AIValue>> value = entry.getValue();
                if (value == null || value.isEmpty()) continue;
                int index = 0;
                for (Map.Entry<Integer, List<AIValue>> innerEntry : value.entrySet()) {
                    Integer serial = innerEntry.getKey();
                    List<AIValue> innerValues = innerEntry.getValue();
                    if (innerValues != null && !innerValues.isEmpty()) {
                        String part = algorithm_type + "#" + serial + "#";
                        for (int i = 0; i < innerValues.size(); ++i) {
                            part = part + innerValues.get(i).part() + (i != innerValues.size() - 1 ? "," : "");
                        }
                        species[index] = part;
                    }
                    ++index;
                }
            }
        }
        this.setFeature_specials(species);
        return (T)this;
    }

    default public T arrayToMap() {
        HashMap<Integer, Map<Integer, List<AIValue>>> self_values = new HashMap<Integer, Map<Integer, List<AIValue>>>();
        String[] specials = this.getFeature_specials();
        if (specials != null && specials.length != 0) {
            for (int i = 0; i < specials.length; ++i) {
                String feature;
                String special = specials[i].replace("[", "").replace("]", "");
                String[] split = special.split("#");
                if (split.length == 0) continue;
                Integer algorithm_type = split.length == 1 ? 1 : Integer.parseInt(split[0]);
                Integer serial = split.length == 1 ? i : Integer.parseInt(split[1]);
                specials[i] = feature = split.length == 1 ? special : split[2];
                HashMap innerMap = (HashMap)self_values.get(algorithm_type);
                if (innerMap == null) {
                    innerMap = new HashMap();
                    self_values.put(algorithm_type, innerMap);
                }
                String[] parts = feature.split(",");
                ArrayList<AIValue> values = new ArrayList<AIValue>();
                for (String part : parts) {
                    values.add(new AIValue(part));
                }
                innerMap.put(serial, values);
            }
        }
        this.setSelf_values(self_values);
        return (T)this;
    }

    public String getLabel_name();

    public T setLabel_name(String var1);

    public String getNick_name();

    public T setNick_name(String var1);

    public int[] getWeight();

    public T setWeight(int[] var1);

    public String[] getFeature_specials();

    public T setFeature_specials(String[] var1);

    public int[] getCounter();

    public T setCounter(int[] var1);

    public String[] getCreates();

    public T setCreates(String[] var1);

    public Map<Integer, Map<Integer, List<AIValue>>> getSelf_values();

    public T setSelf_values(Map<Integer, Map<Integer, List<AIValue>>> var1);

    public Map<Integer, Float> getOther_values();

    public T setOther_values(Map<Integer, Float> var1);
}

