/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.info;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.device._inner.PublicUnPackage;
import com.jhscale.common.model.device._inner.PublicUnPackageArray;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.utils.ByteUtils;
import org.apache.commons.lang3.StringUtils;

@DataClass(mark="MAC")
public class DMAC<T extends DMAC>
implements DataJSONModel<T> {
    @PublicField(index=1, type=100)
    private String mac;

    @Override
    public String package_method(int serial) {
        DataClass annotation = this.getClass().getAnnotation(DataClass.class);
        StringBuffer buffer = new StringBuffer();
        switch (serial) {
            case 0: {
                String mac = StringUtils.isBlank((CharSequence)this.mac) || !ByteUtils.isHex(this.mac) ? "000000" : (this.mac.length() % 2 != 0 ? "0" + this.mac : this.mac);
                int len = mac.length() / 2;
                for (int i = 0; i < len; ++i) {
                    buffer.append(Integer.parseInt(mac.substring(i * 2, i * 2 + 2), 16)).append(i == len - 1 ? "" : annotation.separator());
                }
                break;
            }
        }
        return buffer.toString();
    }

    @Override
    public PublicUnPackage un_package_method(String[] contents, int serial) {
        PublicUnPackage unPackage = new PublicUnPackage(contents);
        switch (serial) {
            case 0: {
                unPackage = this.contents_copyOfRange(contents, contents.length);
                String[] mac_contents = ((PublicUnPackageArray)unPackage).getContents();
                String mac = "";
                for (String mac_content : mac_contents) {
                    mac = mac + ByteUtils.int2Hex(Integer.parseInt(mac_content));
                }
                this.mac = mac;
            }
        }
        return unPackage;
    }

    public String getMac() {
        return this.mac;
    }

    public DMAC<T> setMac(String mac) {
        this.mac = mac;
        return this;
    }
}

