/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.info;

import com.jhscale.common.em.ServerDeviceConfig;
import com.jhscale.common.model.device.info.DInfo;
import com.jhscale.common.model.device.info.DPayment;
import com.jhscale.common.model.device.info.DServerConfig;
import com.jhscale.common.model.inter.GJSONModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DServerInfo
implements GJSONModel {
    private boolean cloud;
    private DInfo store;
    private DInfo market;
    private DInfo erp;
    private DInfo level;
    private List<DPayment> payments;
    private DServerConfig config;
    private DInfo device;

    public String device_info() {
        return Objects.nonNull(this.device) ? "D* " + this.device.info() : "";
    }

    public String store_info() {
        return Objects.nonNull(this.store) ? "S* " + this.store.info() : "";
    }

    public String store_all_info() {
        String info = this.store_info() + "/" + this.level_info();
        if (info.startsWith("/")) {
            info = info.substring(1, info.length());
        }
        if (info.endsWith("/")) {
            info = info.substring(0, info.length() - 1);
        }
        return info;
    }

    public String market_info() {
        return Objects.nonNull(this.market) && StringUtils.isNotBlank((CharSequence)this.market.getNo()) ? "M* " + this.market.info() : "";
    }

    public String erp_info() {
        return Objects.nonNull(this.erp) && StringUtils.isNotBlank((CharSequence)this.erp.getNo()) ? "E* " + this.erp.info() : "";
    }

    public String level_info() {
        return Objects.nonNull(this.level) && StringUtils.isNotBlank((CharSequence)this.level.getNo()) ? "L* " + this.level.info() : "";
    }

    public List<String> payment() {
        ArrayList<String> strs = new ArrayList<String>();
        if (this.config != null && this.config.switchGet(ServerDeviceConfig.\u4e91\u652f\u4ed8).isOpen() && this.payments != null && !this.payments.isEmpty()) {
            for (DPayment payment : this.payments) {
                String info = payment.info();
                if (!StringUtils.isNotBlank((CharSequence)info)) continue;
                strs.add(info);
            }
        }
        return strs;
    }

    public boolean isCloud() {
        return this.cloud;
    }

    public DServerInfo setCloud(boolean cloud) {
        this.cloud = cloud;
        return this;
    }

    public DInfo getStore() {
        return this.store;
    }

    public DServerInfo setStore(DInfo store) {
        this.store = store;
        return this;
    }

    public DInfo getMarket() {
        return this.market;
    }

    public DServerInfo setMarket(DInfo market) {
        this.market = market;
        return this;
    }

    public DInfo getErp() {
        return this.erp;
    }

    public DServerInfo setErp(DInfo erp) {
        this.erp = erp;
        return this;
    }

    public DInfo getLevel() {
        return this.level;
    }

    public DServerInfo setLevel(DInfo level) {
        this.level = level;
        return this;
    }

    public List<DPayment> getPayments() {
        return this.payments;
    }

    public DServerInfo setPayments(List<DPayment> payments) {
        this.payments = payments;
        return this;
    }

    public DServerConfig getConfig() {
        return this.config;
    }

    public DServerInfo setConfig(DServerConfig config) {
        this.config = config;
        return this;
    }

    public DInfo getDevice() {
        return this.device;
    }

    public DServerInfo setDevice(DInfo device) {
        this.device = device;
        return this;
    }
}

