/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.plu;

import com.alibaba.fastjson.annotation.JSONField;
import com.jhscale.common.annotation.BigDecimalToDouble;
import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.annotation.StringToBigDecimal;
import com.jhscale.common.content.JHContents;
import com.jhscale.common.model.device.DConstant;
import com.jhscale.common.model.device.DData;
import com.jhscale.common.model.device.UnitType;
import com.jhscale.common.model.device.plu.FDPLU;
import com.jhscale.common.model.device.plu.em.Restriction;
import com.jhscale.common.model.device.plu.inner.DAutoDiscountV2;
import com.jhscale.common.model.device.plu.inner.DManualDiscount;
import com.jhscale.common.model.device.plu.module.DAIType;
import com.jhscale.common.model.device.plu.module.DPriceV2;
import com.jhscale.common.model.device.plu.module.DPrintWithBitMapV1;
import com.jhscale.common.model.device.plu.module.DTextV1;
import com.jhscale.common.model.device.plu.module.DTimeV2;
import com.jhscale.common.model.device.plu.param.PLUPrepose;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.PinyinUtils;
import com.jhscale.common.ysscale.UnitEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@DataClass(mark="PLU", ask=true)
public class DPLUV5<T extends DPLUV5>
extends DData<T>
implements FDPLU<T> {
    @PublicField(index=2, type=1)
    private Integer itemCode;
    @PublicField(index=3, type=7)
    private String indexBar;
    @PublicField(index=4, type=1)
    private Integer unit;
    @PublicField(index=5, type=100)
    private String field1;
    @PublicField(index=6, type=101)
    private DPrintWithBitMapV1 print;
    @PublicField(index=7, type=1, defaultVal="9")
    private Integer category;
    @PublicField(index=8, type=7)
    private String name;
    @PublicField(index=9, type=102)
    private DTextV1 text;
    @PublicField(index=10, type=103)
    private DTimeV2 time;
    @PublicField(index=11, type=104)
    private DPriceV2 price;
    @PublicField(index=12, type=1, defaultVal="0")
    private Integer taxType;
    @PublicField(index=13, type=1, defaultVal="0")
    private Integer taxRate;
    @PublicField(index=14, type=1, defaultVal="0")
    private Integer sspVale_0;
    @PublicField(index=15, type=1, defaultVal="0")
    private Integer sspVale_1;
    @PublicField(index=16, type=1, defaultVal="0")
    private Integer sspVale_2;
    @PublicField(index=17, type=1, defaultVal="0")
    private Integer sspVale_3;
    @PublicField(index=18, type=70, defaultVal="0")
    private String stype;
    @PublicField(index=19, type=7)
    private String simple;
    @PublicField(index=20, type=105)
    private String field2;
    @PublicField(index=21, type=8, list_type=7)
    private List<String> pictures;
    @PublicField(index=22, type=1, defaultVal="2")
    private Integer state;
    @PublicField(index=23, type=107)
    private DAIType aiType;
    @PublicField(index=24, type=8, list_type=7)
    private List<String> indexBars;
    @Deprecated
    private Map<Integer, DPrintWithBitMapV1> otherPrints;
    @Deprecated
    private Map<Integer, DTimeV2> otherTimes;
    @PublicField(index=27, type=106)
    private Map<Integer, DPriceV2> otherPrices;
    @Deprecated
    private Map<Integer, DTextV1> otherTexts;
    private String unitText;
    @JSONField(serializeUsing=BigDecimalToDouble.class, deserializeUsing=StringToBigDecimal.class)
    private BigDecimal costTrade;
    private Integer saveAsWeight;
    @JSONField(serializeUsing=BigDecimalToDouble.class, deserializeUsing=StringToBigDecimal.class)
    private BigDecimal tare;
    @JSONField(serializeUsing=BigDecimalToDouble.class, deserializeUsing=StringToBigDecimal.class)
    private BigDecimal percentTare;
    @JSONField(serializeUsing=BigDecimalToDouble.class, deserializeUsing=StringToBigDecimal.class)
    private BigDecimal fixedWeight;

    @Override
    public StringBuilder Public_Package_No_Reflex() {
        StringBuilder builder = super.Public_Package_No_Reflex().append(this.to_append("PLU")).append(this.to_append(this.no())).append(this.to_append(this.getItemCode())).append(this.to_append(this.getIndexBar())).append(this.to_append(this.getUnit(), UnitEnum.\u8ba1\u4ef6.val()));
        DPriceV2 price = this.getPrice();
        price = Objects.nonNull(price) ? price : new DPriceV2();
        builder.append(this.to_append(price.price())).append(this.to_append(Objects.nonNull(this.getCostTrade()) ? this.getCostTrade() : BigDecimal.ZERO)).append(this.to_append(this.getTare()));
        DPrintWithBitMapV1 print = this.getPrint();
        print = Objects.nonNull(print) ? print : new DPrintWithBitMapV1();
        builder.append(this.to_append(print.type1())).append(this.to_append(print.barcode1())).append(this.to_append(print.sign1())).append(this.to_append(print.type2())).append(this.to_append(print.barcode2())).append(this.to_append(print.sign2()));
        builder.append(this.to_append(this.getCategory(), DConstant.DEFAULT_CLASS)).append(this.to_append_text(this.getName()));
        DTextV1 text = this.getText();
        text = Objects.nonNull(text) ? text : new DTextV1();
        builder.append(this.to_append_list(text.getTexts(), 7));
        DTimeV2 time = this.getTime();
        time = Objects.nonNull(time) ? time : new DTimeV2();
        builder.append(this.to_append(time.saleDatePS())).append(this.to_append(time.saleTimePS())).append(this.to_append(time.packDatePS())).append(this.to_append(time.packTimePS())).append(this.to_append(time.useDatePS())).append(this.to_append(time.saleDatePC())).append(this.to_append(time.saleTimePC())).append(this.to_append(time.packDatePC())).append(this.to_append(time.packTimePC())).append(this.to_append(time.useDatePC()));
        DManualDiscount upperManualDiscount = price._manualDiscount(Restriction.\u4e0a\u9650.getRestriction());
        DManualDiscount lowerManualDiscount = price._manualDiscount(Restriction.\u4e0b\u9650.getRestriction());
        builder.append(this.to_append(upperManualDiscount != null ? upperManualDiscount.getType() : "")).append(this.to_append(lowerManualDiscount != null ? lowerManualDiscount.getType() : "")).append(this.to_append_bigDecimal(upperManualDiscount != null ? upperManualDiscount.getDiscount() : null)).append(this.to_append_bigDecimal(lowerManualDiscount != null ? lowerManualDiscount.getDiscount() : null));
        for (int i = 0; i < 4; ++i) {
            DAutoDiscountV2 autoDiscount = price._autoDiscount(i);
            if (autoDiscount != null) {
                builder.append(this.to_append(autoDiscount.type())).append(this.to_append(autoDiscount.date())).append(this.to_append(autoDiscount.lower())).append(this.to_append(autoDiscount.upper())).append(this.to_append(autoDiscount.discount()));
                continue;
            }
            builder.append(this.to_append_length(5));
        }
        builder.append(this.to_append(this.getTaxType(), DConstant.DEFAULT_I0)).append(this.to_append(this.getTaxRate(), DConstant.DEFAULT_I0)).append(this.to_append(this.getSspVale_0())).append(this.to_append(this.getSspVale_1())).append(this.to_append(this.getSspVale_2())).append(this.to_append(this.getSspVale_3())).append(this.to_append(this.getStype(), "0")).append(this.to_append(this.getSimple()));
        PLUPrepose prepose = (PLUPrepose)this.prepose();
        builder.append(this.to_append(prepose.getSign())).append(this.to_append(prepose.getSignVal())).append(this.to_append(print.bitmap())).append(this.to_append_list(this.getPictures())).append(this.to_append(this.getState(), DConstant.PLU_State_NORMAL));
        DAIType aiType = this.getAiType();
        if (aiType != null) {
            builder.append(this.to_append(aiType.Public_Package_No_Reflex()));
        } else {
            builder.append(this.to_append(new DAIType().type()));
        }
        builder.append(this.to_append_list(this.getIndexBars())).append(this.to_append(this.to_otherPrices(this.getOtherPrices()))).append("\r\n");
        return builder;
    }

    @Override
    public T Public_UnPackage_No_Reflex(String[] all_fields) {
        try {
            ((DPLUV5)((DPLUV5)((DPLUV5)this.setNo(this.toInteger(all_fields, 0))).setItemCode(this.toInteger(all_fields, 1))).setIndexBar(this.toString(all_fields, 2))).setUnit(this.toInteger(all_fields, 3, UnitEnum.\u8ba1\u4ef6.val()));
            DPriceV2 price = new DPriceV2().setPrice(this.toBigDecimal(all_fields, 4));
            try {
                DManualDiscount upperManualDiscount = new DManualDiscount.DUpperManualDiscount().setType(this.toIntegerDefault(all_fields, 32)).setDiscount(this.toBigDecimal(all_fields, 34));
                if (upperManualDiscount != null) {
                    price.addManualDiscounts(upperManualDiscount);
                }
            }
            catch (Exception upperManualDiscount) {
                // empty catch block
            }
            try {
                DManualDiscount lowerManualDiscount = new DManualDiscount.DLowerManualDiscount().setType(this.toIntegerDefault(all_fields, 33)).setDiscount(this.toBigDecimal(all_fields, 35));
                if (lowerManualDiscount != null) {
                    price.addManualDiscounts(lowerManualDiscount);
                }
            }
            catch (Exception lowerManualDiscount) {
                // empty catch block
            }
            DAutoDiscountV2 autoDiscount0 = null;
            try {
                autoDiscount0 = new DAutoDiscountV2(this.toIntegerDefault(all_fields, 36), this.toIntegerDefault(all_fields, 37), this.toBigDecimal(all_fields, 38), this.toBigDecimal(all_fields, 39), this.toBigDecimal(all_fields, 40));
            }
            catch (Exception exception) {
                // empty catch block
            }
            price.addAutoDiscounts(0, autoDiscount0);
            DAutoDiscountV2 autoDiscount1 = null;
            try {
                autoDiscount1 = new DAutoDiscountV2(this.toIntegerDefault(all_fields, 41), this.toIntegerDefault(all_fields, 42), this.toBigDecimal(all_fields, 43), this.toBigDecimal(all_fields, 44), this.toBigDecimal(all_fields, 45));
            }
            catch (Exception exception) {
                // empty catch block
            }
            price.addAutoDiscounts(1, autoDiscount1);
            DAutoDiscountV2 autoDiscount2 = null;
            try {
                autoDiscount2 = new DAutoDiscountV2(this.toIntegerDefault(all_fields, 46), this.toIntegerDefault(all_fields, 47), this.toBigDecimal(all_fields, 48), this.toBigDecimal(all_fields, 49), this.toBigDecimal(all_fields, 50));
            }
            catch (Exception exception) {
                // empty catch block
            }
            price.addAutoDiscounts(2, autoDiscount2);
            DAutoDiscountV2 autoDiscount3 = null;
            try {
                autoDiscount3 = new DAutoDiscountV2(this.toIntegerDefault(all_fields, 51), this.toIntegerDefault(all_fields, 52), this.toBigDecimal(all_fields, 53), this.toBigDecimal(all_fields, 54), this.toBigDecimal(all_fields, 55));
            }
            catch (Exception exception) {
                // empty catch block
            }
            price.addAutoDiscounts(3, autoDiscount3);
            this.setPrice(price);
            ((DPLUV5)this.setCostTrade(this.toBigDecimal(all_fields, 5))).setTare(this.toBigDecimal(all_fields, 6));
            DPrintWithBitMapV1 print = (DPrintWithBitMapV1)((DPrintWithBitMapV1)((DPrintWithBitMapV1)((DPrintWithBitMapV1)((DPrintWithBitMapV1)((DPrintWithBitMapV1)new DPrintWithBitMapV1().setType1(this.toInteger(all_fields, 7))).setBarcode1(this.toInteger(all_fields, 8))).setSign1(this.toInteger(all_fields, 9))).setType2(this.toInteger(all_fields, 10))).setBarcode2(this.toInteger(all_fields, 11))).setSign2(this.toInteger(all_fields, 12));
            this.setPrint(print);
            ((DPLUV5)this.setCategory(this.toInteger(all_fields, 13, DConstant.DEFAULT_CLASS))).setName(this.toText(all_fields, 14));
            DTextV1 text = new DTextV1().addTexts(this.toText(all_fields, 15)).addTexts(this.toText(all_fields, 16)).addTexts(this.toText(all_fields, 17)).addTexts(this.toText(all_fields, 18)).addTexts(this.toText(all_fields, 19)).addTexts(this.toText(all_fields, 20));
            this.setText(text);
            DTimeV2 time = new DTimeV2().setSaleDatePS(this.toInteger(all_fields, 22)).setSaleTimePS(this.toInteger(all_fields, 23)).setPackDatePS(this.toInteger(all_fields, 24)).setPackTimePS(this.toInteger(all_fields, 25)).setUseDatePS(this.toInteger(all_fields, 26)).setSaleDatePC(this.toInteger(all_fields, 27)).setSaleTimePC(this.toInteger(all_fields, 28)).setPackDatePC(this.toInteger(all_fields, 29)).setPackTimePC(this.toInteger(all_fields, 30)).setUseDatePC(this.toInteger(all_fields, 31));
            this.setTime(time);
            ((DPLUV5)((DPLUV5)((DPLUV5)((DPLUV5)((DPLUV5)((DPLUV5)((DPLUV5)this.setTaxType(this.toInteger(all_fields, 56, DConstant.DEFAULT_I0))).setTaxRate(this.toInteger(all_fields, 57, DConstant.DEFAULT_I0))).setSspVale_0(this.toInteger(all_fields, 58))).setSspVale_1(this.toInteger(all_fields, 59))).setSspVale_2(this.toInteger(all_fields, 60))).setSspVale_3(this.toInteger(all_fields, 61))).setStype(this.toString(all_fields, 62, "0"))).setSimple(this.toString(all_fields, 63));
            String stype = ByteUtils.appendFill(Integer.toBinaryString(Integer.parseInt(all_fields[64])), 4);
            if (UnitType.\u8ba1\u4ef6.equals((Object)UnitEnum.unit(this.getUnit()).getType())) {
                if (stype.charAt(3) == '1') {
                    this.setUnitText(this.toText(all_fields, 21));
                } else {
                    text.addTexts(this.toText(all_fields, 21));
                }
                this.setSaveAsWeight(stype.charAt(2) == '1' ? DConstant.SAVE_WEIGHT_ENABLE : DConstant.SAVE_WEIGHT_DISABLE);
            } else {
                text.addTexts(this.toText(all_fields, 21));
                if (stype.charAt(2) == '1') {
                    this.setFixedWeight(this.toBigDecimal(all_fields, 65));
                }
                if (stype.charAt(3) == '1') {
                    this.setPercentTare(this.toBigDecimal(all_fields, 65));
                }
            }
            print.setBitmap(this.toInteger(all_fields, 66));
            ((DPLUV5)this.setPictures(this.toStringList(all_fields, 67))).setState(this.toInteger(all_fields, 68, DConstant.PLU_State_NORMAL));
            String ai_info = this.toString(all_fields, 69);
            if (StringUtils.isNotBlank((CharSequence)ai_info)) {
                DAIType daiType = (DAIType)new DAIType().Public_UnPackage_No_Reflex(ai_info);
                this.setAiType(daiType);
            }
            this.setIndexBars(this.toStringList(all_fields, 70));
            String otherPrices = this.toString(all_fields, 71);
            if (StringUtils.isNotBlank((CharSequence)otherPrices)) {
                String[] other_prices;
                for (String other_price : other_prices = otherPrices.split("\\|")) {
                    if (!StringUtils.isNotBlank((CharSequence)other_price)) continue;
                    String[] other_price_part = other_price.split(":");
                    this.toOtherPrice(other_price_part);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException price) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)this;
    }

    public Integer itemCode() {
        return Objects.nonNull(this.itemCode) ? this.itemCode : this.no();
    }

    public Integer unit() {
        return Objects.nonNull(this.unit) ? this.unit.intValue() : BigDecimal.ONE.intValue();
    }

    @Override
    public BigDecimal tare() {
        return Objects.nonNull(this.tare) ? this.tare : BigDecimal.ZERO;
    }

    public BigDecimal percentTare() {
        return Objects.nonNull(this.percentTare) ? this.percentTare : BigDecimal.ZERO;
    }

    public BigDecimal fixedWeight() {
        return Objects.nonNull(this.fixedWeight) ? this.fixedWeight : BigDecimal.ZERO;
    }

    @Override
    public BigDecimal costTrade() {
        return Objects.nonNull(this.costTrade) ? this.costTrade : BigDecimal.ZERO;
    }

    public Integer taxType() {
        return Objects.nonNull(this.taxType) ? this.taxType.intValue() : BigDecimal.ZERO.intValue();
    }

    public Integer taxRate() {
        return Objects.nonNull(this.taxRate) ? this.taxRate.intValue() : BigDecimal.ZERO.intValue();
    }

    public Integer state() {
        return Objects.nonNull(this.state) ? this.state.intValue() : BigDecimal.ZERO.intValue();
    }

    public Integer category() {
        return Objects.nonNull(this.category) ? this.category : JHContents.DEFAULT_CATEGORY;
    }

    public Integer _saveAsWeight() {
        return Objects.nonNull(this.saveAsWeight) ? this.saveAsWeight.intValue() : BigDecimal.ZERO.intValue();
    }

    public Integer getItemCode() {
        return this.itemCode;
    }

    public T setItemCode(Integer itemCode) {
        this.itemCode = itemCode;
        return (T)this;
    }

    public String getIndexBar() {
        return this.indexBar;
    }

    public T setIndexBar(String indexBar) {
        this.indexBar = indexBar;
        return (T)this;
    }

    @Override
    public Integer getUnit() {
        return this.unit;
    }

    public T setUnit(Integer unit) {
        this.unit = unit;
        return (T)this;
    }

    @Override
    public DPrintWithBitMapV1 getPrint() {
        return this.print;
    }

    public DPrintWithBitMapV1 print() {
        return Objects.nonNull(this.print) ? this.print : new DPrintWithBitMapV1();
    }

    @Override
    public T setPrint(DPrintWithBitMapV1 print) {
        this.print = print;
        return (T)this;
    }

    public Integer getCategory() {
        return this.category;
    }

    public T setCategory(Integer category) {
        this.category = category;
        return (T)this;
    }

    public String getName() {
        return this.name;
    }

    public T setName(String name) {
        this.name = name;
        return (T)this;
    }

    @Override
    public DTextV1 getText() {
        return this.text;
    }

    @Override
    public T setText(DTextV1 text) {
        this.text = text;
        return (T)this;
    }

    @Override
    public DTimeV2 getTime() {
        return this.time;
    }

    public DTimeV2 time() {
        return Objects.nonNull(this.time) ? this.time : new DTimeV2();
    }

    @Override
    public T setTime(DTimeV2 time) {
        this.time = time;
        return (T)this;
    }

    @Override
    public DPriceV2 getPrice() {
        return this.price;
    }

    @Override
    public T setPrice(DPriceV2 price) {
        this.price = price;
        return (T)this;
    }

    public Integer getTaxType() {
        return this.taxType;
    }

    public T setTaxType(Integer taxType) {
        this.taxType = taxType;
        return (T)this;
    }

    public Integer getTaxRate() {
        return this.taxRate;
    }

    public T setTaxRate(Integer taxRate) {
        this.taxRate = taxRate;
        return (T)this;
    }

    public Integer getSspVale_0() {
        return this.sspVale_0;
    }

    public T setSspVale_0(Integer sspVale_0) {
        this.sspVale_0 = sspVale_0;
        return (T)this;
    }

    public Integer getSspVale_1() {
        return this.sspVale_1;
    }

    public T setSspVale_1(Integer sspVale_1) {
        this.sspVale_1 = sspVale_1;
        return (T)this;
    }

    public Integer getSspVale_2() {
        return this.sspVale_2;
    }

    public T setSspVale_2(Integer sspVale_2) {
        this.sspVale_2 = sspVale_2;
        return (T)this;
    }

    public Integer getSspVale_3() {
        return this.sspVale_3;
    }

    public T setSspVale_3(Integer sspVale_3) {
        this.sspVale_3 = sspVale_3;
        return (T)this;
    }

    public String getStype() {
        return this.stype;
    }

    public T setStype(String stype) {
        this.stype = stype;
        return (T)this;
    }

    public String getSimple() {
        return this.simple;
    }

    public T setSimple(String simple) {
        this.simple = simple;
        return (T)this;
    }

    public List<String> getPictures() {
        return this.pictures;
    }

    public T setPictures(List<String> pictures) {
        this.pictures = pictures;
        return (T)this;
    }

    public Integer getState() {
        return this.state;
    }

    public T setState(Integer state) {
        this.state = state;
        return (T)this;
    }

    @Override
    public DAIType getAiType() {
        return this.aiType;
    }

    @Override
    public T setAiType(DAIType aiType) {
        this.aiType = aiType;
        return (T)this;
    }

    public List<String> getIndexBars() {
        return this.indexBars;
    }

    public T setIndexBars(List<String> indexBars) {
        this.indexBars = indexBars;
        return (T)this;
    }

    @Override
    public String getUnitText() {
        return this.unitText;
    }

    @Override
    public T setUnitText(String unitText) {
        this.unitText = unitText;
        return (T)this;
    }

    @Deprecated
    private Map<Integer, DPrintWithBitMapV1> getOtherPrints() {
        return this.otherPrints;
    }

    @Deprecated
    private T setOtherPrints(Map<Integer, DPrintWithBitMapV1> otherPrints) {
        this.otherPrints = otherPrints;
        return (T)this;
    }

    @Deprecated
    private Map<Integer, DTimeV2> getOtherTimes() {
        return this.otherTimes;
    }

    @Deprecated
    private T setOtherTimes(Map<Integer, DTimeV2> otherTimes) {
        this.otherTimes = otherTimes;
        return (T)this;
    }

    @Override
    public Map<Integer, DPriceV2> getOtherPrices() {
        return this.otherPrices;
    }

    @Override
    public T setOtherPrices(Map<Integer, DPriceV2> otherPrices) {
        this.otherPrices = otherPrices;
        return (T)this;
    }

    @Deprecated
    private Map<Integer, DTextV1> getOtherTexts() {
        return this.otherTexts;
    }

    @Deprecated
    private T setOtherTexts(Map<Integer, DTextV1> otherTexts) {
        this.otherTexts = otherTexts;
        return (T)this;
    }

    @Override
    public BigDecimal getCostTrade() {
        return this.costTrade;
    }

    @Override
    public T setCostTrade(BigDecimal costTrade) {
        this.costTrade = costTrade;
        return (T)this;
    }

    @Override
    public Integer getSaveAsWeight() {
        return this.saveAsWeight;
    }

    @Override
    public T setSaveAsWeight(Integer saveAsWeight) {
        this.saveAsWeight = saveAsWeight;
        return (T)this;
    }

    @Override
    public BigDecimal getTare() {
        return this.tare;
    }

    @Override
    public T setTare(BigDecimal tare) {
        this.tare = tare;
        return (T)this;
    }

    @Override
    public BigDecimal getPercentTare() {
        return this.percentTare;
    }

    @Override
    public T setPercentTare(BigDecimal percentTare) {
        this.percentTare = percentTare;
        return (T)this;
    }

    @Override
    public BigDecimal getFixedWeight() {
        return this.fixedWeight;
    }

    @Override
    public T setFixedWeight(BigDecimal fixedWeight) {
        this.fixedWeight = fixedWeight;
        return (T)this;
    }

    public T addIndexBars(String ... indexBars) {
        if (this.indexBars == null) {
            this.indexBars = new ArrayList<String>();
        }
        if (indexBars != null && indexBars.length != 0) {
            this.indexBars.addAll(Arrays.asList(indexBars));
        }
        return (T)this;
    }

    @Deprecated
    private T putOtherPrint(Integer level, DPrintWithBitMapV1 print) {
        if (this.otherPrints == null) {
            this.otherPrints = new HashMap<Integer, DPrintWithBitMapV1>();
        }
        this.otherPrints.put(level, print);
        return (T)this;
    }

    @Deprecated
    private DPrintWithBitMapV1 print(Integer level) {
        DPrintWithBitMapV1 print = null;
        if (Objects.nonNull(level) && this.otherPrints != null) {
            print = this.otherPrints.get(level);
        }
        return Objects.nonNull(print) ? print : (Objects.nonNull(this.print) ? this.print : new DPrintWithBitMapV1());
    }

    @Deprecated
    private T putOtherTimes(Integer level, DTimeV2 time) {
        if (this.otherTimes == null) {
            this.otherTimes = new HashMap<Integer, DTimeV2>();
        }
        this.otherTimes.put(level, time);
        return (T)this;
    }

    @Deprecated
    private DTimeV2 time(Integer level) {
        DTimeV2 time = null;
        if (Objects.nonNull(level) && this.otherTimes != null) {
            time = this.otherTimes.get(level);
        }
        return Objects.nonNull(time) ? time : (Objects.nonNull(this.time) ? this.time : new DTimeV2());
    }

    public T putOtherPrice(Integer level, DPriceV2 price) {
        if (this.otherPrices == null) {
            this.otherPrices = new HashMap<Integer, DPriceV2>();
        }
        this.otherPrices.put(level, price);
        return (T)this;
    }

    public DPriceV2 price(Integer level) {
        DPriceV2 price = null;
        if (Objects.nonNull(level) && this.otherPrices != null) {
            price = this.otherPrices.get(level);
        }
        return Objects.nonNull(price) ? price : (Objects.nonNull(this.price) ? this.price : new DPriceV2());
    }

    @Deprecated
    private T putText(Integer level, DTextV1 texts) {
        if (this.otherTexts == null) {
            this.otherTexts = new HashMap<Integer, DTextV1>();
        }
        this.otherTexts.put(level, texts);
        return (T)this;
    }

    @Deprecated
    private DTextV1 text(Integer level) {
        DTextV1 text = null;
        if (Objects.nonNull(level) && this.otherTexts != null) {
            text = this.otherTexts.get(level);
        }
        return Objects.nonNull(text) ? text : this.text;
    }

    public T addPinyinSimple() {
        if (StringUtils.isBlank((CharSequence)this.simple) && StringUtils.isNotBlank((CharSequence)this.name)) {
            this.simple = PinyinUtils.getPinYinHeadCharNoMark(this.name).toUpperCase();
        }
        return (T)this;
    }
}

