/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.plu;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.model.device.UnitType;
import com.jhscale.common.model.device._inner.PublicUnPackage;
import com.jhscale.common.model.device._inner.PublicUnPackageArray;
import com.jhscale.common.model.device._inner.PublicUnPackageObject;
import com.jhscale.common.model.device.plu.em.Restriction;
import com.jhscale.common.model.device.plu.inner.DAutoDiscountV2;
import com.jhscale.common.model.device.plu.inner.DManualDiscount;
import com.jhscale.common.model.device.plu.module.DAIType;
import com.jhscale.common.model.device.plu.module.DPriceV2;
import com.jhscale.common.model.device.plu.module.DPrintWithBitMapV1;
import com.jhscale.common.model.device.plu.module.DTextV1;
import com.jhscale.common.model.device.plu.module.DTimeV2;
import com.jhscale.common.model.device.plu.param.PLUPrepose;
import com.jhscale.common.model.device.plu.param.Prepose;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.utils.ArrayUtils;
import com.jhscale.common.utils.BigDecimalUtils;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.ysscale.UnitEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public interface FDPLU<T extends FDPLU>
extends DataJSONModel<T> {
    @Override
    default public Prepose prepose() {
        int sign = 0;
        String signVal = "";
        if (UnitType.\u8ba1\u4ef6.equals((Object)UnitEnum.unit(this.getUnit()).getType())) {
            if (StringUtils.isNotBlank((CharSequence)this.getUnitText())) {
                ++sign;
                DTextV1 text = this.getText();
                if (text == null) {
                    text = new DTextV1();
                    this.setText(text);
                }
                List texts = ArrayUtils.addIndex(text.getTexts(), 6, this.getUnitText());
                text.setTexts(texts);
            } else if (this.getSaveAsWeight() != null && this.saveAsWeight()) {
                sign += 2;
            }
        } else if (Objects.nonNull(this.getFixedWeight())) {
            sign += 2;
            signVal = BigDecimalUtils.bigDecimalToString(this.getFixedWeight());
            this.setTare(null);
        } else if (Objects.nonNull(this.getPercentTare())) {
            sign += 4;
            signVal = BigDecimalUtils.bigDecimalToString(this.getPercentTare());
        }
        return new PLUPrepose(sign, signVal);
    }

    @Override
    default public String package_method(int serial) {
        DataClass annotation = this.getClass().getAnnotation(DataClass.class);
        StringBuffer buffer = new StringBuffer();
        try {
            switch (serial) {
                case 0: {
                    DPriceV2 price_0 = this.getPrice();
                    BigDecimal price_f = Objects.nonNull(price_0) ? price_0.price() : BigDecimal.ZERO;
                    buffer.append(BigDecimalUtils.bigDecimalToString(price_f)).append(annotation.separator()).append(BigDecimalUtils.bigDecimalToString(this.costTrade())).append(annotation.separator()).append(BigDecimalUtils.bigDecimalToString(this.tare()));
                    break;
                }
                case 1: {
                    DPrintWithBitMapV1 print = this.getPrint();
                    buffer.append(Objects.nonNull(print) ? print.type1() : "").append(annotation.separator()).append(Objects.nonNull(print) ? print.barcode1() : "").append(annotation.separator()).append(Objects.nonNull(print) ? print.sign1() : "").append(annotation.separator()).append(Objects.nonNull(print) ? print.type2() : "").append(annotation.separator()).append(Objects.nonNull(print) ? print.barcode2() : "").append(annotation.separator()).append(Objects.nonNull(print) ? print.sign2() : "");
                    break;
                }
                case 2: {
                    DTextV1 text = this.getText();
                    if (text != null && text.getTexts() != null) {
                        for (int i = 0; i < 7; ++i) {
                            if (i < text.getTexts().size() && StringUtils.isNotBlank((CharSequence)text.getTexts().get(i))) {
                                buffer.append(ByteUtils.tryParseToString(ByteUtils.strMaxLength(text.getTexts().get(i), 128)));
                            }
                            if (i == 6) continue;
                            buffer.append(annotation.separator());
                        }
                    } else {
                        for (int i = 0; i < 7; ++i) {
                            buffer.append("").append(i != 6 ? annotation.separator() : "");
                        }
                    }
                    break;
                }
                case 3: {
                    DTimeV2 time = this.getTime();
                    time = time == null ? new DTimeV2() : time;
                    buffer.append(time.Public_Package(annotation.separator()));
                    break;
                }
                case 4: {
                    DPriceV2 price_4 = this.getPrice();
                    price_4 = price_4 == null ? new DPriceV2() : price_4;
                    List<DManualDiscount> manualDiscounts = price_4.getManualDiscounts();
                    if (manualDiscounts != null && !manualDiscounts.isEmpty()) {
                        DManualDiscount upperManualDiscount = price_4._manualDiscount(Restriction.\u4e0a\u9650.getRestriction());
                        DManualDiscount lowerManualDiscount = price_4._manualDiscount(Restriction.\u4e0b\u9650.getRestriction());
                        buffer.append(upperManualDiscount == null || upperManualDiscount.getType() == null ? "" : upperManualDiscount.getType()).append(annotation.separator()).append(lowerManualDiscount == null || lowerManualDiscount.getType() == null ? "" : lowerManualDiscount.getType()).append(annotation.separator()).append(upperManualDiscount == null || upperManualDiscount.getDiscount() == null ? "" : BigDecimalUtils.bigDecimalToString(upperManualDiscount.getDiscount())).append(annotation.separator()).append(lowerManualDiscount == null || lowerManualDiscount.getDiscount() == null ? "" : BigDecimalUtils.bigDecimalToString(lowerManualDiscount.getDiscount())).append(annotation.separator());
                    } else {
                        for (int i = 0; i < 4; ++i) {
                            buffer.append(annotation.separator());
                        }
                    }
                    for (int i = 0; i < 4; ++i) {
                        DAutoDiscountV2 autoDiscount = price_4._autoDiscount(i);
                        if (autoDiscount != null) {
                            buffer.append(autoDiscount.Public_Package(annotation.separator()));
                        } else {
                            for (int j = 0; j < 4; ++j) {
                                buffer.append(annotation.separator());
                            }
                        }
                        if (i == 3) continue;
                        buffer.append(annotation.separator());
                    }
                    break;
                }
                case 5: {
                    DPrintWithBitMapV1 print_b = this.getPrint();
                    PLUPrepose prepose = (PLUPrepose)this.prepose();
                    buffer.append(prepose.getSign()).append(annotation.separator()).append(prepose.getSignVal()).append(annotation.separator()).append(print_b != null ? print_b.bitmap() : "");
                    break;
                }
                case 6: {
                    buffer.append(this.to_otherPrices(this.getOtherPrices()));
                    break;
                }
                case 7: {
                    buffer.append((CharSequence)this.getAiType().Public_Package_No_Reflex());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    default public PublicUnPackage un_package_method(String[] contents, int serial) {
        PublicUnPackage unPackage = new PublicUnPackage(contents);
        try {
            block1 : switch (serial) {
                case 0: {
                    unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 3);
                    String[] contents_0 = ((PublicUnPackageArray)unPackage).getContents();
                    BigDecimal price_f = BigDecimalUtils.stringToBigDecimal(contents_0[0]);
                    DPriceV2 price_0 = this.getPrice();
                    if (price_0 == null) {
                        price_0 = new DPriceV2();
                        this.setPrice(price_0);
                    }
                    price_0.setPrice(price_f != null ? price_f : BigDecimal.ZERO);
                    this.setCostTrade(BigDecimalUtils.stringToBigDecimal(contents_0[1]));
                    this.setTare(BigDecimalUtils.stringToBigDecimal(contents_0[2]));
                    break;
                }
                case 1: {
                    unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 6);
                    String[] contents_1 = ((PublicUnPackageArray)unPackage).getContents();
                    DPrintWithBitMapV1 print = this.getPrint();
                    if (print == null) {
                        print = new DPrintWithBitMapV1();
                        this.setPrint(print);
                    }
                    print.setType1(StringUtils.isNotBlank((CharSequence)contents_1[0]) ? Integer.valueOf(Integer.parseInt(contents_1[0])) : null);
                    print.setBarcode1(StringUtils.isNotBlank((CharSequence)contents_1[1]) ? Integer.valueOf(Integer.parseInt(contents_1[1])) : null);
                    print.setSign1(StringUtils.isNotBlank((CharSequence)contents_1[2]) ? Integer.valueOf(Integer.parseInt(contents_1[2])) : null);
                    print.setType2(StringUtils.isNotBlank((CharSequence)contents_1[3]) ? Integer.valueOf(Integer.parseInt(contents_1[3])) : null);
                    print.setBarcode2(StringUtils.isNotBlank((CharSequence)contents_1[4]) ? Integer.valueOf(Integer.parseInt(contents_1[4])) : null);
                    print.setSign2(StringUtils.isNotBlank((CharSequence)contents_1[5]) ? Integer.valueOf(Integer.parseInt(contents_1[5])) : null);
                    break;
                }
                case 2: {
                    unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 7);
                    this.setText(new DTextV1().setTexts(Arrays.asList(((PublicUnPackageArray)unPackage).getContents())));
                    break;
                }
                case 3: {
                    unPackage = new DTimeV2().Public_UnPackage(unPackage.getSurplusContents());
                    this.setTime((DTimeV2)((PublicUnPackageObject)unPackage).getObj());
                    break;
                }
                case 4: {
                    void var14_19;
                    DPriceV2 price_4 = this.getPrice();
                    if (price_4 == null) {
                        price_4 = new DPriceV2();
                        this.setPrice(price_4);
                    }
                    unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 4);
                    String[] contents_ManualDiscount = ((PublicUnPackageArray)unPackage).getContents();
                    boolean hasManualDiscount = false;
                    String[] stringArray = contents_ManualDiscount;
                    int n = stringArray.length;
                    boolean bl = false;
                    while (var14_19 < n) {
                        String s = stringArray[var14_19];
                        if (StringUtils.isNotBlank((CharSequence)s)) {
                            hasManualDiscount = true;
                            break;
                        }
                        ++var14_19;
                    }
                    if (hasManualDiscount) {
                        price_4.addManualDiscounts(new DManualDiscount(Restriction.\u4e0a\u9650.getRestriction(), (Integer)(StringUtils.isNotBlank((CharSequence)contents_ManualDiscount[0]) ? Integer.parseInt(contents_ManualDiscount[0]) : 0), StringUtils.isNotBlank((CharSequence)contents_ManualDiscount[2]) ? BigDecimalUtils.stringToBigDecimal(contents_ManualDiscount[2]) : null), new DManualDiscount(Restriction.\u4e0b\u9650.getRestriction(), (Integer)(StringUtils.isNotBlank((CharSequence)contents_ManualDiscount[1]) ? Integer.parseInt(contents_ManualDiscount[1]) : 0), StringUtils.isNotBlank((CharSequence)contents_ManualDiscount[3]) ? BigDecimalUtils.stringToBigDecimal(contents_ManualDiscount[3]) : null));
                    }
                    ArrayList<DAutoDiscountV2> list = new ArrayList<DAutoDiscountV2>();
                    for (int i = 0; i < 4; ++i) {
                        unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 5);
                        String[] stringArray2 = ((PublicUnPackageArray)unPackage).getContents();
                        boolean hasAutoDiscount = false;
                        for (String s : stringArray2) {
                            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                            hasAutoDiscount = true;
                            break;
                        }
                        if (hasAutoDiscount) {
                            PublicUnPackageObject unPackageAutoDiscount = new DAutoDiscountV2().Public_UnPackage(stringArray2);
                            list.add((DAutoDiscountV2)unPackageAutoDiscount.getObj());
                            continue;
                        }
                        list.add(null);
                    }
                    for (Object e : list) {
                        if (e == null) continue;
                        price_4.setAutoDiscounts(list);
                        break block1;
                    }
                    break;
                }
                case 5: {
                    unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 3);
                    String[] contents_5 = ((PublicUnPackageArray)unPackage).getContents();
                    DPrintWithBitMapV1 dPrintWithBitMapV1 = this.getPrint();
                    if (dPrintWithBitMapV1 == null) {
                        DPrintWithBitMapV1 print = new DPrintWithBitMapV1();
                        this.setPrint(print);
                    }
                    String sign = ByteUtils.appendFill(Integer.toBinaryString(Integer.parseInt(contents_5[0])), 4);
                    if (UnitType.\u8ba1\u4ef6.equals((Object)UnitEnum.unit(this.getUnit()).getType())) {
                        if (sign.charAt(3) == '1') {
                            this.setUnitText(this.getText().getTexts().get(6));
                        }
                        this.setSaveAsWeight(sign.charAt(2) == '1' ? 1 : 0);
                    } else {
                        if (sign.charAt(2) == '1') {
                            this.setFixedWeight(BigDecimalUtils.stringToBigDecimal(contents_5[1]));
                        }
                        if (sign.charAt(3) == '1') {
                            this.setPercentTare(BigDecimalUtils.stringToBigDecimal(contents_5[1]));
                        }
                    }
                    dPrintWithBitMapV1.setBitmap(StringUtils.isNotBlank((CharSequence)contents_5[2]) ? Integer.valueOf(Integer.parseInt(contents_5[2])) : null);
                    break;
                }
                case 6: {
                    String[] parts;
                    unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 1);
                    String[] contents_6 = ((PublicUnPackageArray)unPackage).getContents();
                    if (contents_6 == null || contents_6.length != 1 || !StringUtils.isNotBlank((CharSequence)contents_6[0])) break;
                    for (String part : parts = contents_6[0].split("\\|")) {
                        String[] fields;
                        if (!StringUtils.isNotBlank((CharSequence)part) || (fields = part.split(":")).length <= 0) continue;
                        this.toOtherPrice(fields);
                    }
                    break;
                }
                case 7: {
                    unPackage = this.contents_copyOfRange(unPackage.getSurplusContents(), 1);
                    String[] contents_7 = ((PublicUnPackageArray)unPackage).getContents();
                    if (contents_7 == null || contents_7.length != 1 || !StringUtils.isNotBlank((CharSequence)contents_7[0])) break;
                    this.setAiType((DAIType)new DAIType().Public_UnPackage_No_Reflex(contents_7[0]));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return unPackage;
    }

    default public String to_otherPrices(Map<Integer, DPriceV2> otherPrices) {
        String content;
        StringBuilder builder = new StringBuilder();
        if (otherPrices != null && !otherPrices.isEmpty()) {
            for (Map.Entry<Integer, DPriceV2> entry : otherPrices.entrySet()) {
                List<DAutoDiscountV2> otherAutoDiscounts;
                List<DManualDiscount> otherManualDiscounts;
                Integer key = entry.getKey();
                DPriceV2 value = entry.getValue();
                if (key == null || value == null) continue;
                BigDecimal price = value.getPrice();
                if (price != null) {
                    builder.append(key).append("P").append(":").append(BigDecimalUtils.bigDecimalToString(price)).append("|");
                }
                if ((otherManualDiscounts = value.getManualDiscounts()) != null && !otherManualDiscounts.isEmpty()) {
                    DManualDiscount upperManualDiscount = value.manualDiscount(Restriction.\u4e0a\u9650.getRestriction());
                    DManualDiscount lowerManualDiscount = value.manualDiscount(Restriction.\u4e0b\u9650.getRestriction());
                    builder.append(key).append("M").append(":").append(lowerManualDiscount.getType()).append(":").append(upperManualDiscount.getType()).append(":").append(BigDecimalUtils.bigDecimalToString(lowerManualDiscount.getDiscount())).append(":").append(BigDecimalUtils.bigDecimalToString(upperManualDiscount.getDiscount())).append("|");
                }
                if ((otherAutoDiscounts = value.getAutoDiscounts()) == null || otherAutoDiscounts.isEmpty()) continue;
                for (int i = 0; i < otherAutoDiscounts.size(); ++i) {
                    DAutoDiscountV2 autoDiscount = otherAutoDiscounts.get(i);
                    if (autoDiscount == null) continue;
                    builder.append(key).append("A" + (i + 1)).append(":").append(autoDiscount.type()).append(":").append(autoDiscount.date()).append(":").append(BigDecimalUtils.bigDecimalToString(autoDiscount.lower())).append(":").append(BigDecimalUtils.bigDecimalToString(autoDiscount.upper())).append(":").append(BigDecimalUtils.bigDecimalToString(autoDiscount.discount())).append("|");
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(content = builder.toString()))) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    default public void toOtherPrice(String[] other_price_part) {
        if (other_price_part[0].contains("P")) {
            int index = other_price_part[0].indexOf("P");
            int level = Integer.parseInt(other_price_part[0].substring(0, index));
            DPriceV2 level_price = this.levelPrice(level);
            level_price.setPrice(BigDecimalUtils.stringToBigDecimal(other_price_part[1]));
        } else if (other_price_part[0].contains("M")) {
            int index = other_price_part[0].indexOf("M");
            int level = Integer.parseInt(other_price_part[0].substring(0, index));
            DPriceV2 level_price = this.levelPrice(level);
            level_price.addManualDiscounts(new DManualDiscount(Restriction.\u4e0a\u9650.getRestriction(), (Integer)(other_price_part.length > 2 && StringUtils.isNotBlank((CharSequence)other_price_part[2]) ? Integer.parseInt(other_price_part[2]) : 0), other_price_part.length > 4 && StringUtils.isNotBlank((CharSequence)other_price_part[4]) ? BigDecimalUtils.stringToBigDecimal(other_price_part[4]) : null), new DManualDiscount(Restriction.\u4e0b\u9650.getRestriction(), (Integer)(other_price_part.length > 1 && StringUtils.isNotBlank((CharSequence)other_price_part[1]) ? Integer.parseInt(other_price_part[1]) : 0), other_price_part.length > 3 && StringUtils.isNotBlank((CharSequence)other_price_part[3]) ? BigDecimalUtils.stringToBigDecimal(other_price_part[3]) : null));
        } else if (other_price_part[0].contains("A")) {
            int index = other_price_part[0].indexOf("A");
            int level = Integer.parseInt(other_price_part[0].substring(0, index));
            int autoSerial = Integer.parseInt(other_price_part[0].substring(index + 1));
            DPriceV2 level_price = this.levelPrice(level);
            level_price.addAutoDiscounts(autoSerial - 1, new DAutoDiscountV2(other_price_part.length > 1 && StringUtils.isNotBlank((CharSequence)other_price_part[1]) ? Integer.parseInt(other_price_part[1]) : 0, other_price_part.length > 2 && StringUtils.isNotBlank((CharSequence)other_price_part[2]) ? Integer.parseInt(other_price_part[2]) : 0, other_price_part.length > 3 && StringUtils.isNotBlank((CharSequence)other_price_part[3]) ? BigDecimalUtils.stringToBigDecimal(other_price_part[3]) : null, other_price_part.length > 4 && StringUtils.isNotBlank((CharSequence)other_price_part[4]) ? BigDecimalUtils.stringToBigDecimal(other_price_part[4]) : null, other_price_part.length > 5 && StringUtils.isNotBlank((CharSequence)other_price_part[5]) ? BigDecimalUtils.stringToBigDecimal(other_price_part[5]) : null));
        }
    }

    public Integer getUnit();

    public DPriceV2 getPrice();

    public T setPrice(DPriceV2 var1);

    public Map<Integer, DPriceV2> getOtherPrices();

    public T setOtherPrices(Map<Integer, DPriceV2> var1);

    default public DPriceV2 levelPrice(Integer level) {
        DPriceV2 price;
        Map<Integer, DPriceV2> otherPrices = this.getOtherPrices();
        if (otherPrices == null) {
            otherPrices = new HashMap<Integer, DPriceV2>();
            this.setOtherPrices(otherPrices);
        }
        if ((price = otherPrices.get(level)) == null) {
            price = new DPriceV2();
            otherPrices.put(level, price);
        }
        return price;
    }

    public BigDecimal costTrade();

    public BigDecimal getCostTrade();

    public T setCostTrade(BigDecimal var1);

    public BigDecimal tare();

    public BigDecimal getTare();

    public T setTare(BigDecimal var1);

    public DPrintWithBitMapV1 getPrint();

    public T setPrint(DPrintWithBitMapV1 var1);

    public DTextV1 getText();

    public T setText(DTextV1 var1);

    public DTimeV2 getTime();

    public T setTime(DTimeV2 var1);

    public DAIType getAiType();

    public T setAiType(DAIType var1);

    public String getUnitText();

    public T setUnitText(String var1);

    public Integer getSaveAsWeight();

    public T setSaveAsWeight(Integer var1);

    default public boolean saveAsWeight() {
        return this.getSaveAsWeight() == null ? false : this.getSaveAsWeight() == 1;
    }

    public BigDecimal getPercentTare();

    public T setPercentTare(BigDecimal var1);

    public BigDecimal getFixedWeight();

    public T setFixedWeight(BigDecimal var1);
}

