/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.plu.module;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.simple.FieldModel;
import org.apache.commons.lang3.StringUtils;

@DataClass(separator=":")
public class DAIModel
extends FieldModel {
    @PublicField(index=1, type=70, defaultVal="M")
    private String model;
    @PublicField(index=2, type=7, defaultVal="M")
    private String name;

    public DAIModel() {
    }

    public DAIModel(String model) {
        int index = model.indexOf(":");
        if (index == -1) {
            this.model = model;
        } else {
            this.model = model.substring(0, index);
            this.name = model.substring(index + 1);
        }
    }

    public String name() {
        return StringUtils.isNotBlank((CharSequence)this.name) ? this.name : "";
    }

    public DAIModel(String model, String name) {
        this.model = model;
        this.name = name;
    }

    public String label_str() {
        return String.format("%s_%s", this.getModel(), this.getName());
    }

    public String getModel() {
        return this.model;
    }

    public DAIModel setModel(String model) {
        this.model = model;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public DAIModel setName(String name) {
        this.name = name;
        return this;
    }
}

