/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.plu.module;

import com.jhscale.common.annotation.DataClass;
import com.jhscale.common.annotation.PublicField;
import com.jhscale.common.model.device.plu.module.DAIModel;
import com.jhscale.common.model.device.plu.module.DAIOther;
import com.jhscale.common.model.inter.DataJSONModel;
import com.jhscale.common.model.simple.FieldModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

@DataClass(separator="#")
public class DAIType
extends FieldModel {
    @PublicField(index=1, type=1, defaultVal="0")
    private Integer type;
    @PublicField(index=2, type=8, list_type=6, list_class=DAIModel.class)
    private List<DAIModel> models;
    @PublicField(index=3, type=8, list_type=6, list_class=DAIOther.class)
    private List<DAIOther> others;

    public DAIType() {
    }

    public DAIType(String content) {
        this.Public_UnPackage_No_Reflex(content);
    }

    public Integer type() {
        return Objects.nonNull(this.type) ? this.type : 0;
    }

    public String toPackage() {
        return this.Public_Package_No_Reflex().toString();
    }

    @Override
    public StringBuilder Public_Package_No_Reflex() {
        StringBuilder builder = super.Public_Package_No_Reflex().append(this.type()).append("#").append((CharSequence)this.models());
        if (this.others != null && !this.others.isEmpty()) {
            builder.append("&").append((CharSequence)this.others());
        }
        return builder;
    }

    @Override
    public DataJSONModel Public_UnPackage_No_Reflex(String content) {
        if (StringUtils.isNotBlank((CharSequence)content)) {
            String[] ps;
            int index = content.indexOf("#");
            if (index == -1 && (index = content.indexOf("&")) == -1) {
                this.type = Integer.parseInt(content);
                return this;
            }
            this.type = Integer.parseInt(content.substring(0, 1));
            if (StringUtils.isNotBlank((CharSequence)(content = content.substring(index + 1))) && (ps = content.split("&")).length > 0) {
                for (String p : ps) {
                    if (!StringUtils.isNotBlank((CharSequence)p)) continue;
                    if (p.contains(":")) {
                        int im = p.indexOf(":");
                        if (im == -1) {
                            this.addModels(new DAIModel(p, null));
                            continue;
                        }
                        this.addModels(new DAIModel(p.substring(0, im), p.substring(im + 1)));
                        continue;
                    }
                    if (p.contains("=")) {
                        String[] ops = p.split("%");
                        if (ops.length <= 0) continue;
                        for (String op : ops) {
                            if (!StringUtils.isNotBlank((CharSequence)op)) continue;
                            int imo = op.indexOf("=");
                            if (imo == -1) {
                                this.addModels(new DAIModel(op, null));
                                continue;
                            }
                            String percent = op.substring(imo + 1);
                            this.addOthers(new DAIOther(op.substring(0, imo), StringUtils.isNotBlank((CharSequence)percent) ? Double.valueOf(Double.parseDouble(percent)) : null));
                        }
                        continue;
                    }
                    this.addModels(new DAIModel(p, null));
                }
            }
        }
        return this;
    }

    public DAIType addModels(DAIModel ... models) {
        if (models != null && models.length > 0) {
            if (this.models == null) {
                this.models = new ArrayList<DAIModel>();
            }
            this.models.addAll(Arrays.asList(models));
        }
        return this;
    }

    public DAIType addOthers(DAIOther ... others) {
        if (others != null && others.length > 0) {
            if (this.others == null) {
                this.others = new ArrayList<DAIOther>();
            }
            this.others.addAll(Arrays.asList(others));
        }
        return this;
    }

    public StringBuilder models() {
        StringBuilder builder = new StringBuilder();
        if (this.models != null && !this.models.isEmpty()) {
            for (int i = 0; i < this.models.size(); ++i) {
                DAIModel daiModel = this.models.get(i);
                if (daiModel == null || !StringUtils.isNotBlank((CharSequence)daiModel.getModel())) continue;
                builder.append(daiModel.getModel()).append(":").append(daiModel.name()).append(i != this.models.size() - 1 ? "&" : "");
            }
        }
        return builder;
    }

    public StringBuilder others() {
        StringBuilder builder = new StringBuilder();
        if (this.others != null && !this.others.isEmpty()) {
            for (int i = 0; i < this.others.size(); ++i) {
                DAIOther daiOther = this.others.get(i);
                if (daiOther == null || !StringUtils.isNotBlank((CharSequence)daiOther.getModel())) continue;
                builder.append(daiOther.getModel()).append("=").append(daiOther.percent()).append("%");
            }
        }
        return builder;
    }

    public Integer getType() {
        return this.type;
    }

    public DAIType setType(Integer type) {
        this.type = type;
        return this;
    }

    public List<DAIModel> getModels() {
        return this.models;
    }

    public DAIType setModels(List<DAIModel> models) {
        this.models = models;
        return this;
    }

    public List<DAIOther> getOthers() {
        return this.others;
    }

    public DAIType setOthers(List<DAIOther> others) {
        this.others = others;
        return this;
    }
}

