/*
 * Decompiled with CFR 0.152.
 */
package com.jhscale.common.model.device.polymerization.cloudpay;

import com.jhscale.common.model.device.polymerization.inner.AggregatedEntity;
import com.jhscale.common.model.device.polymerization.inner.AggregatedMark;
import com.jhscale.common.model.device.polymerization.inner.RXTXData;
import com.jhscale.common.utils.ByteUtils;
import com.jhscale.common.utils.RandomUtils;
import java.math.BigDecimal;

public class PaymentRequest
extends AggregatedEntity {
    private int fid;
    private BigDecimal amount;
    private int random = RandomUtils.integer_random(65535);
    private String title;
    private int count;

    public PaymentRequest() {
        super(new AggregatedMark(true, true));
    }

    public PaymentRequest(RXTXData rxtxData) {
        super(rxtxData);
    }

    @Override
    public StringBuilder inner_assembly() {
        return new StringBuilder().append(ByteUtils.int2HexWithPush(this.fid, 8)).append(ByteUtils.toSPFStrNone(this.amount)).append(ByteUtils.int2HexWithPush(this.random, 4)).append(ByteUtils.a_text(this.title)).append(ByteUtils.int2Hex(this.count));
    }

    @Override
    public String inner_analyse(String innerContent) {
        this.fid = ByteUtils.hex2Ten(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.amount = ByteUtils.convertBigDecimalNone(innerContent.substring(0, 8));
        innerContent = innerContent.substring(8);
        this.random = ByteUtils.hex2Ten(innerContent.substring(0, 4));
        int index = ByteUtils.indexOf(innerContent = innerContent.substring(4), "00");
        if (index != -1) {
            this.title = ByteUtils.p_text(innerContent.substring(0, index + 2));
            innerContent = innerContent.substring(index + 2);
        }
        this.count = ByteUtils.hex2Ten(innerContent.substring(0, 2));
        innerContent = innerContent.substring(2);
        return innerContent;
    }

    public int getFid() {
        return this.fid;
    }

    public void setFid(int fid) {
        this.fid = fid;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public int getRandom() {
        return this.random;
    }

    public void setRandom(int random) {
        this.random = random;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String fid() {
        return ByteUtils.fid(this.fid);
    }
}

